/*
 * Decompiled with CFR 0.152.
 */
package ambience.messages.db;

import ambience.framework.DocumentManager2$;
import ambience.messages.Collections$;
import ambience.messages.db.InboxDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.mongodb.client.result.DeleteResult;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonArray;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Sorts$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class InboxMongoDB
implements InboxDB,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(InboxMongoDB.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;

    public InboxMongoDB(MongoDB mongoDB) {
        this.mongoDB = mongoDB;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public MongoDB mongoDB() {
        return this.mongoDB;
    }

    @Override
    public Task<LogMessage> send(List<Json> messages) {
        if (messages.isEmpty()) {
            return Task$.MODULE$.apply(InboxMongoDB::send$$anonfun$1);
        }
        List docs = messages.map((Function1 & Serializable)m -> Document$.MODULE$.apply(m.noSpaces()));
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.send$$anonfun$2(messages);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Collections$.MODULE$.inboxCltn().insertManyT((Seq)docs).map((Function1 & Serializable)_$1 -> LogMessage.None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(messages){
                private final List messages$4;
                {
                    this.messages$4 = messages$6;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable ex = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable ex = throwable = x;
                    return LogMessage.ErrorEx$.MODULE$.apply("Send MessagesInbox failed to " + this.messages$4.size() + " recipients", ex);
                }
            }).map((Function1 & Serializable)response -> response);
        });
    }

    @Override
    public Task<Either<LogMessage, Object>> unreadCount(String userId) {
        return Collections$.MODULE$.inboxCltn().countDocumentsT(this.unreadFilter(userId)).map((Function1 & Serializable)_$2 -> InboxMongoDB.unreadCount$$anonfun$1(BoxesRunTime.unboxToLong((Object)_$2))).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("failed", ex));
            }
        });
    }

    @Override
    public Task<Either<LogMessage, Seq<Document>>> unread(String userId, int topX) {
        Some some = Some$.MODULE$.apply((Object)Sorts$.MODULE$.descending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"created"})));
        Some some2 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)topX));
        Option option = FindOptions$.MODULE$.$lessinit$greater$default$1();
        Option option2 = FindOptions$.MODULE$.$lessinit$greater$default$3();
        FindOptions opts = FindOptions$.MODULE$.apply(option, (Option)some, option2, (Option)some2);
        return Collections$.MODULE$.inboxCltn().findO(this.unreadFilter(userId), opts).toListL().map((Function1 & Serializable)_$3 -> package$.MODULE$.Right().apply(_$3)).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("failed", ex));
            }
        });
    }

    @Override
    public Task<LogMessage> delete(List<String> messageIds) {
        return Collections$.MODULE$.inboxCltn().deleteManyT(this.whereMessageIds(messageIds)).map((Function1 & Serializable)res -> {
            this.log().info(() -> InboxMongoDB.delete$$anonfun$1$$anonfun$1(res), Line$.MODULE$.apply(55), FullName$.MODULE$.apply("ambience.messages.db.InboxMongoDB.delete"));
            return LogMessage.None$.MODULE$;
        }).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return LogMessage.ErrorEx$.MODULE$.apply(ex.getMessage(), ex);
                }
                return function1.apply((Object)x);
            }
        });
    }

    @Override
    public Task<LogMessage> deleteReadAndDeleted(List<String> messageIds) {
        List<String> list = messageIds;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.now((Object)LogMessage.None$.MODULE$);
        }
        Bson filters = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{this.whereMessageIds(messageIds), Filters$.MODULE$.or((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{this.read(true), Filters$.MODULE$.exists("uniqueKey", false)}))}));
        return Collections$.MODULE$.inboxCltn().deleteManyT(filters).map((Function1 & Serializable)res -> {
            this.log().info(() -> InboxMongoDB.deleteReadAndDeleted$$anonfun$1$$anonfun$1(res), Line$.MODULE$.apply(74), FullName$.MODULE$.apply("ambience.messages.db.InboxMongoDB.deleteReadAndDeleted"));
            return LogMessage.None$.MODULE$;
        }).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return LogMessage.ErrorEx$.MODULE$.apply(ex.getMessage(), ex);
                }
                return function1.apply((Object)x);
            }
        });
    }

    @Override
    public Task<Either<LogMessage, Set<String>>> unreadMessageIds(List<String> messageIds) {
        Bson filters = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager2$.MODULE$.exists("uniqueKey"), this.whereMessageIds(messageIds), this.read(false)}));
        return Collections$.MODULE$.inboxCltn().distinctO("messageId", filters).toListL().map((Function1 & Serializable)res -> package$.MODULE$.Right().apply((Object)res.flatMap((Function1 & Serializable)bv -> {
            if (bv.isString()) {
                return Some$.MODULE$.apply((Object)bv.asString().getValue());
            }
            return None$.MODULE$;
        }).toSet())).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply(ex.getMessage(), ex));
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Set<String> arraysToStringSet(BsonArray ba) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ba).asScala().flatMap((Function1 & Serializable)v -> {
            if (v.isString()) {
                return Some$.MODULE$.apply((Object)v.asString().getValue());
            }
            return None$.MODULE$;
        })).toSet();
    }

    public Bson unreadFilter(String userId) {
        return Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{this.owner(userId), DocumentManager2$.MODULE$.exists("uniqueKey"), this.read(false)}));
    }

    public Bson read(boolean isRead) {
        return Filters$.MODULE$.eq("status.read", (Object)BsonBoolean$.MODULE$.apply(isRead));
    }

    public Bson whereMessageIds(List<String> ids) {
        return Filters$.MODULE$.in("messageId", ids);
    }

    public Bson whereIds(List<String> ids) {
        return Filters$.MODULE$.or((Seq)ids.map((Function1 & Serializable)id -> this.where((String)id)));
    }

    public Bson where(String id) {
        return Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id));
    }

    public Bson owner(String id) {
        return Filters$.MODULE$.eq("owner", (Object)BsonString$.MODULE$.apply(id));
    }

    private static final LogMessage.Error send$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("No messages to send");
    }

    private static final Object send$$anonfun$2$$anonfun$1(List messages$2) {
        return "Sending (" + messages$2.size() + ") messages";
    }

    private final void send$$anonfun$2(List messages$1) {
        this.log().info(() -> InboxMongoDB.send$$anonfun$2$$anonfun$1(messages$1), Line$.MODULE$.apply(24), FullName$.MODULE$.apply("ambience.messages.db.InboxMongoDB.send"));
    }

    private static final /* synthetic */ Right unreadCount$$anonfun$1(long _$2) {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)_$2));
    }

    private static final Object delete$$anonfun$1$$anonfun$1(DeleteResult res$1) {
        return res$1.getDeletedCount() + " Inbox Messages deleted";
    }

    private static final Object deleteReadAndDeleted$$anonfun$1$$anonfun$1(DeleteResult res$2) {
        return res$2.getDeletedCount() + " Inbox Read Messages deleted";
    }
}

