/*
 * Decompiled with CFR 0.152.
 */
package ambience.messages.db;

import ambience.api.BinaryStore;
import ambience.messages.Collections$;
import ambience.messages.db.AggregationBuilder$;
import ambience.messages.db.MessagesDB;
import ambience.messages.db.MessagesDB$DeleteInfo$;
import ambience.messages.store.AttachmentsStore;
import ambience.messages.store.AttachmentsStore$BinStoreInfo$;
import ambience.messages.store.AttachmentsStore$MsgStoreInfo$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.result.DeleteResult;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonArray;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Sorts$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MessagesMongoDB
implements MessagesDB,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MessagesMongoDB.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MessagesMongoDB.class.getDeclaredField("col$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;
    private volatile Object col$lzy1;

    public MessagesMongoDB(MongoDB mongoDB) {
        this.mongoDB = mongoDB;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public MongoDB mongoDB() {
        return this.mongoDB;
    }

    public RichMongoCollection col() {
        Object object = this.col$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.col$lzyINIT1();
    }

    private Object col$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.col$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = Collections$.MODULE$.messagesCltn();
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.col$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Task<LogMessage> send(Json msg) {
        Document doc = Document$.MODULE$.apply(msg.noSpaces());
        return this.col().insertOneT(doc).map((Function1 & Serializable)_$1 -> LogMessage.None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Send Message failed", ex);
            }
        });
    }

    @Override
    public Task<Either<LogMessage, Json>> load(String id) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.load$$anonfun$1(id);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.col().findO(this.where(id)).headOptionL().map((Function1 & Serializable)reply -> {
                Either either = io.circe.parser.package$.MODULE$.parse(Option$.MODULE$.option2Iterable(reply.map((Function1 & Serializable)_$2 -> _$2.toJson())).mkString("[", ",", "]"));
                if (either instanceof Left) {
                    ParsingFailure err = (ParsingFailure)((Left)either).value();
                    return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Error parsing BSON json output: " + err));
                }
                if (either instanceof Right) {
                    Json json = (Json)((Right)either).value();
                    Option option = json.asArray();
                    if (None$.MODULE$.equals(option)) {
                        return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Expected JSON Array"));
                    }
                    if (option instanceof Some) {
                        Vector arr = (Vector)((Some)option).value();
                        Option option2 = arr.headOption();
                        if (option2 instanceof Some) {
                            Json head = (Json)((Some)option2).value();
                            return package$.MODULE$.Right().apply((Object)head);
                        }
                        if (None$.MODULE$.equals(option2)) {
                            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("No Message found with id:" + id));
                        }
                        throw new MatchError((Object)option2);
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError((Object)either);
            }).map((Function1 & Serializable)response -> response);
        });
    }

    @Override
    public Task<Either<LogMessage, Json>> load(List<String> ids) {
        if (ids.isEmpty()) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil())));
        }
        Some some = Some$.MODULE$.apply((Object)Sorts$.MODULE$.descending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"created"})));
        Option option = FindOptions$.MODULE$.$lessinit$greater$default$1();
        Option option2 = FindOptions$.MODULE$.$lessinit$greater$default$3();
        Option option3 = FindOptions$.MODULE$.$lessinit$greater$default$4();
        FindOptions opts = FindOptions$.MODULE$.apply(option, (Option)some, option2, option3);
        return this.col().findO(this.whereIds(ids), opts).toListL().map((Function1 & Serializable)reply -> {
            Either either = io.circe.parser.package$.MODULE$.parse(reply.map((Function1 & Serializable)_$3 -> _$3.toJson()).mkString("[", ",", "]"));
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Error parsing BSON json output: " + err));
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return package$.MODULE$.Right().apply((Object)json);
            }
            throw new MatchError((Object)either);
        });
    }

    @Override
    public Task<Either<LogMessage, List<MessagesDB.DeleteInfo>>> getOlderThan(int minutes) {
        Predef$.MODULE$.require(minutes > 0);
        return this.col().aggregateO(AggregationBuilder$.MODULE$.build(minutes)).map((Function1 & Serializable)doc -> {
            AttachmentsStore.StoreInfo storeInfo = (AttachmentsStore.StoreInfo)doc.get("store", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$4 -> _$4.getValue()).map((Function1 & Serializable)id -> AttachmentsStore$BinStoreInfo$.MODULE$.apply(BinaryStore.LocationId$.MODULE$.apply(id))).getOrElse(MessagesMongoDB::$anonfun$3);
            return doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue()).flatMap((Function1 & Serializable)id -> doc.get("attachments", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).flatMap((Function1 & Serializable)att -> doc.get("forwardedAttachments", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)fatt -> MessagesDB$DeleteInfo$.MODULE$.apply(storeInfo, (String)id, (Set<String>)((Set)this.arraysToStringSet((BsonArray)att).$plus$plus(this.arraysToStringSet((BsonArray)fatt)))))));
        }).toListL().map((Function1 & Serializable)list -> package$.MODULE$.Right().apply(list.flatten(Predef$.MODULE$.$conforms()))).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply(ex.getMessage()));
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Set<String> arraysToStringSet(BsonArray ba) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ba).asScala().flatMap((Function1 & Serializable)v -> {
            if (v.isString()) {
                return Some$.MODULE$.apply((Object)v.asString().getValue());
            }
            return None$.MODULE$;
        })).toSet();
    }

    @Override
    public Task<LogMessage> delete(List<String> ids) {
        List<String> list = ids;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.now((Object)LogMessage.None$.MODULE$);
        }
        return this.col().deleteManyT(this.whereIds(ids)).map((Function1 & Serializable)res -> {
            this.log().info(() -> MessagesMongoDB.delete$$anonfun$1$$anonfun$1(res), Line$.MODULE$.apply(103), FullName$.MODULE$.apply("ambience.messages.db.MessagesMongoDB.delete"));
            return LogMessage.None$.MODULE$;
        }).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return LogMessage.ErrorEx$.MODULE$.apply(ex.getMessage(), ex);
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Bson where(String id) {
        return Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id));
    }

    public Bson whereIds(List<String> ids) {
        return Filters$.MODULE$.or((Seq)ids.map((Function1 & Serializable)id -> this.where((String)id)));
    }

    private static final Object load$$anonfun$1$$anonfun$1(String id$2) {
        return "Loading Message id:" + id$2;
    }

    private final void load$$anonfun$1(String id$1) {
        this.log().debug(() -> MessagesMongoDB.load$$anonfun$1$$anonfun$1(id$1), Line$.MODULE$.apply(35), FullName$.MODULE$.apply("ambience.messages.db.MessagesMongoDB.load"));
    }

    private static final AttachmentsStore.StoreInfo $anonfun$3() {
        return AttachmentsStore$MsgStoreInfo$.MODULE$;
    }

    private static final Object delete$$anonfun$1$$anonfun$1(DeleteResult res$1) {
        return res$1.getDeletedCount() + " Messages deleted";
    }
}

