/*
 * Decompiled with CFR 0.152.
 */
package ambience.workflow.engine;

import ambience.workflow.engine.JsonLenses$;
import elxgraph.NodeId;
import elxgraph.NodeId$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import workflow.model.Start$;
import workflow.model.StateMachine;
import workflow.model.StateMachineId;
import workflow.model.StateMachineId$;
import workflow.model.Workflow;
import workflow.model.WorkflowId;
import workflow.model.WorkflowId$;
import workflow.model.WorkflowInstanceId;
import workflow.model.WorkflowInstanceId$;

public final class JsonUtils$
implements Serializable {
    public static final JsonUtils$ MODULE$ = new JsonUtils$();

    private JsonUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonUtils$.class);
    }

    public Either<String, WorkflowInstanceId> getId(Json json) {
        Option option = JsonLenses$.MODULE$.IdLens().getOption((Object)json);
        if (option instanceof Some) {
            String id = (String)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)new WorkflowInstanceId(WorkflowInstanceId$.MODULE$.apply(id)));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("id not found in " + json));
        }
        throw new MatchError((Object)option);
    }

    public Either<String, WorkflowId> getWorkflowId(Json json) {
        Option option = JsonLenses$.MODULE$.WFIdLens().getOption((Object)json);
        if (option instanceof Some) {
            String id = (String)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)new WorkflowId(WorkflowId$.MODULE$.apply(id)));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("workflowId not found in " + json));
        }
        throw new MatchError((Object)option);
    }

    public Either<String, StateMachineId> getStateMachineId(Json json) {
        Option option = JsonLenses$.MODULE$.SMIdLens().getOption((Object)json);
        if (option instanceof Some) {
            String id = (String)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)new StateMachineId(StateMachineId$.MODULE$.apply(id)));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("stateMachineId not found in " + json));
        }
        throw new MatchError((Object)option);
    }

    public List<Tuple2<StateMachineId, NodeId>> getStartStateNodeIds(Workflow workflow) {
        return workflow.stateMachines().flatMap((Function1 & Serializable)sm -> sm.graph().nodes().find((Function1 & Serializable)_$1 -> _$1.stateType().contains((Object)Start$.MODULE$)).map((Function1 & Serializable)n -> {
            StateMachineId stateMachineId = (StateMachineId)Predef$.MODULE$.ArrowAssoc((Object)new StateMachineId(sm.id()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)stateMachineId, (Object)new NodeId(n.id()));
        }));
    }

    public Either<String, NodeId> getCurrentStateMachineNodeId(Json json, String smId) {
        return this.getStateMachineState(json, smId).flatMap((Function1 & Serializable)state -> MODULE$.getNodeId((Json)state).map((Function1 & Serializable)v1 -> new NodeId(v1 == null ? BoxesRunTime.unboxToInt(null) : ((NodeId)v1).value())));
    }

    public Either<String, Json> getStateMachineState(Json json, String smId) {
        Option option = JsonLenses$.MODULE$.SMStateLens(smId).json().headOption((Object)json);
        if (option instanceof Some) {
            Json json2 = (Json)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)json2);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("StateMachine State not found for smId " + new StateMachineId(smId)));
        }
        throw new MatchError((Object)option);
    }

    public Either<String, Json> getStateMachineStateNyName(Json json, String name) {
        Option option = JsonLenses$.MODULE$.SMStateByNameLens(name).json().headOption((Object)json);
        if (option instanceof Some) {
            Json json2 = (Json)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)json2);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("StateMachine State not found by name " + name));
        }
        throw new MatchError((Object)option);
    }

    public Json modifyStateMachineStates(Json json, Function1<Json, Json> modifyFN) {
        Vector values = (Vector)((StrictOptimizedIterableOps)JsonLenses$.MODULE$.StatesLens().arr().getOption((Object)json).getOrElse(JsonUtils$::$anonfun$1)).map(modifyFN);
        return (Json)JsonLenses$.MODULE$.StatesLens().arr().replace((Object)values).apply((Object)json);
    }

    public Either<String, NodeId> getNodeId(Json json) {
        Option option = JsonLenses$.MODULE$.NodeIdLens().getOption((Object)json);
        if (option instanceof Some) {
            int id = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return package$.MODULE$.Right().apply((Object)new NodeId(NodeId$.MODULE$.apply(id)));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("nodeId not found in " + json));
        }
        throw new MatchError((Object)option);
    }

    public Json cleanForSave(Json wfiState) {
        return wfiState.mapObject((Function1 & Serializable)obj -> obj.remove("elxEvent").remove("_elxIdx"));
    }

    public Json getElxEvent(Json wfiState) {
        return (Json)wfiState.hcursor().downField("elxEvent").focus().getOrElse(JsonUtils$::getElxEvent$$anonfun$1);
    }

    public Json prepareState(Workflow wf, Json wfiState) {
        Json j1 = wfiState.mapObject((Function1 & Serializable)_$2 -> _$2.remove("_elxIdx"));
        return this.augmentStateMachineStates(wf, j1);
    }

    public Json augmentStateMachineStates(Workflow wf, Json wfiState) {
        return this.modifyStateMachineStates(wfiState, (Function1<Json, Json>)(Function1 & Serializable)json -> MODULE$.augumentState(wf, (Json)json));
    }

    public Json augumentState(Workflow wf, Json json) {
        return (Json)this.getStateMachineId(json).toOption().flatMap((Function1 & Serializable)smId -> JsonUtils$.augumentState$$anonfun$1(json, wf, smId == null ? null : ((StateMachineId)smId).value())).getOrElse(() -> JsonUtils$.augumentState$$anonfun$2(json));
    }

    public Json baseState(StateMachine sm, int nId, String nodeName) {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"stateMachineId");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(sm.id()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(sm.name()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"nodeId");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromInt(nId));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"nodeName");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromString(nodeName));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Json timestamp() {
        long ts = System.currentTimeMillis();
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$date");
        Object[] objectArray2 = new Tuple2[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$numberLong");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(String.valueOf(ts)));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final Vector $anonfun$1() {
        return package$.MODULE$.Vector().empty();
    }

    private static final Json getElxEvent$$anonfun$1() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final /* synthetic */ Option augumentState$$anonfun$1$$anonfun$1(Workflow wf$3, String smId$1, int nId) {
        return wf$3.stateMachines().find((Function1 & Serializable)_$3 -> {
            String string = _$3.id();
            String string2 = smId$1;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).flatMap((Function1 & Serializable)sm -> sm.graph().nodes().find((Function1 & Serializable)_$4 -> _$4.id() == nId).map((Function1 & Serializable)n -> MODULE$.baseState((StateMachine)sm, nId, n.label())));
    }

    private static final /* synthetic */ Option augumentState$$anonfun$1(Json json$1, Workflow wf$2, String smId) {
        return MODULE$.getNodeId(json$1).toOption().flatMap((Function1 & Serializable)nId -> JsonUtils$.augumentState$$anonfun$1$$anonfun$1(wf$2, smId, nId == null ? BoxesRunTime.unboxToInt(null) : ((NodeId)nId).value()));
    }

    private static final Json augumentState$$anonfun$2(Json json$2) {
        return json$2;
    }
}

