/*
 * Decompiled with CFR 0.152.
 */
package ambience.workflow.engine.db;

import ambience.workflow.MongoHelper$;
import ambience.workflow.engine.db.WorkflowInstanceDB;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.json.JsonLens$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import elxgraph.NodeId;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonDateTime;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;
import workflow.model.StateMachineId;
import workflow.model.Workflow;
import workflow.model.WorkflowInstanceId;

public class WorkflowInstanceMongoDB
implements WorkflowInstanceDB,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInstanceMongoDB.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInstanceMongoDB.class.getDeclaredField("mongoDB$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object mongoDB$lzy1;

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public MongoDB mongoDB() {
        Object object = this.mongoDB$lzy1;
        if (object instanceof MongoDB) {
            return (MongoDB)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MongoDB)this.mongoDB$lzyINIT1();
    }

    private Object mongoDB$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.mongoDB$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MongoDB mongoDB = null;
                    try {
                        mongoDB = (MongoDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDB.class));
                        object2 = mongoDB == null ? LazyVals.NullValue$.MODULE$ : mongoDB;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.mongoDB$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return mongoDB;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Task<Either<String, Json>> loadById(Workflow wf, String id) {
        return this.getCollection(wf).findO(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id))).firstOptionL().map((Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)doc -> this.toJson((Document)doc)).toRight(() -> WorkflowInstanceMongoDB.loadById$$anonfun$1$$anonfun$2(id)));
    }

    @Override
    public Observable<Document> loadAll(Workflow wf, Option<Bson> filters) {
        Option<Bson> option = filters;
        if (option instanceof Some) {
            Bson fs = (Bson)((Some)option).value();
            return this.getCollection(wf).findO(fs);
        }
        if (None$.MODULE$.equals(option)) {
            return this.getCollection(wf).findO();
        }
        throw new MatchError(option);
    }

    @Override
    public Task<Either<String, Json>> update(Workflow wf, Json json) {
        Either<String, String> either = this.getId(json);
        if (either instanceof Right) {
            String id = (String)((Right)either).value();
            this.log().info(() -> WorkflowInstanceMongoDB.update$$anonfun$1(id), Line$.MODULE$.apply(36), FullName$.MODULE$.apply("ambience.workflow.engine.db.WorkflowInstanceMongoDB.update"));
            BsonDateTime now = BsonDateTime$.MODULE$.apply(System.currentTimeMillis());
            Document doc = (Document)org.mongodb.scala.bson.package$.MODULE$.Document().apply(json.noSpaces()).updated("lastModified", (Object)now, (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return this.getCollection(wf).replaceOneT(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id)), doc).map((Function1 & Serializable)res -> {
                if (res.getModifiedCount() == 0L) {
                    return package$.MODULE$.Left().apply((Object)("Problem updating instance id:" + id));
                }
                return package$.MODULE$.Right().apply((Object)json);
            });
        }
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)msg));
        }
        throw new MatchError(either);
    }

    @Override
    public Task<Either<String, Json>> create(Workflow wf, List<Tuple2<StateMachineId, NodeId>> startNodes) {
        String id = UUID.randomUUID().toString();
        List states = startNodes.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String smId = tuple2._1() == null ? null : ((StateMachineId)tuple2._1()).value();
                int nodeId = tuple2._2() == null ? BoxesRunTime.unboxToInt(null) : ((NodeId)tuple2._2()).value();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"stateMachineId", (Object)Json$.MODULE$.fromString(smId)), Tuple2$.MODULE$.apply((Object)"nodeId", (Object)Json$.MODULE$.fromInt(nodeId))}));
            }
            throw new MatchError((Object)tuple2);
        });
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"_id", (Object)Json$.MODULE$.fromString(id)), Tuple2$.MODULE$.apply((Object)"workflowId", (Object)Json$.MODULE$.fromString(wf._id())), Tuple2$.MODULE$.apply((Object)"states", (Object)Json$.MODULE$.fromValues((Iterable)states))}));
        BsonDateTime now = BsonDateTime$.MODULE$.apply(System.currentTimeMillis());
        Document doc = (Document)org.mongodb.scala.bson.package$.MODULE$.Document().apply(json.noSpaces()).updated("lastModified", (Object)now, (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return this.getCollection(wf).insertOneT(doc).map((Function1 & Serializable)_$2 -> package$.MODULE$.Right().apply((Object)json));
    }

    @Override
    public Task<Object> clean(Workflow wf) {
        return this.getCollection(wf).deleteManyT(Filters$.MODULE$.eq("elxPublic", (Object)BsonDocument$.MODULE$.apply())).map((Function1 & Serializable)reply -> reply.getDeletedCount());
    }

    public RichMongoCollection getCollection(Workflow wf) {
        return MongoHelper$.MODULE$.getCollection(wf.database(), wf.collection());
    }

    public Json toJson(Document doc) {
        return (Json)io.circe.parser.package$.MODULE$.parse(doc.toJson()).getOrElse(WorkflowInstanceMongoDB::toJson$$anonfun$1);
    }

    public Either<String, String> getId(Json json) {
        Option option = JsonLens$.MODULE$.root().selectDynamic("_id").string().getOption((Object)json);
        if (option instanceof Some) {
            String id = (String)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)id);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("id not found in " + json));
        }
        throw new MatchError((Object)option);
    }

    private static final String loadById$$anonfun$1$$anonfun$2(String id$2) {
        return "Id not found: " + new WorkflowInstanceId(id$2);
    }

    private static final Object update$$anonfun$1(String id$3) {
        return "Updating instance id:" + id$3;
    }

    private static final Json toJson$$anonfun$1() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }
}

