/*
 * Decompiled with CFR 0.152.
 */
package ambience.workflow.etl;

import ambience.api.Workflow;
import ambience.bson.BsonETL$;
import ambience.workflow.engine.JsonLenses$;
import com.elixirtech.arch.LogMessage;
import io.circe.Json;
import io.circe.Json$;
import io.circe.parser.package$;
import java.io.Serializable;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Util$
implements Serializable {
    public static final Util$ MODULE$ = new Util$();

    private Util$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Util$.class);
    }

    public Either<LogMessage, Workflow.WorkflowInstanceId> getId(Json json) {
        Option option = JsonLenses$.MODULE$.IdLens().getOption((Object)json);
        if (option instanceof Some) {
            String id = (String)((Some)option).value();
            return scala.package$.MODULE$.Right().apply((Object)new Workflow.WorkflowInstanceId(Workflow.WorkflowInstanceId$.MODULE$.apply(id)));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("id not found in " + json));
        }
        throw new MatchError((Object)option);
    }

    public Either<LogMessage, Workflow.WorkflowId> getWorkflowId(Json json) {
        Option option = JsonLenses$.MODULE$.WFIdLens().getOption((Object)json);
        if (option instanceof Some) {
            String id = (String)((Some)option).value();
            return scala.package$.MODULE$.Right().apply((Object)new Workflow.WorkflowId(Workflow.WorkflowId$.MODULE$.apply(id)));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("workflowId not found in " + json));
        }
        throw new MatchError((Object)option);
    }

    public Json getState(Document doc) {
        return (Json)doc.get("wfiState", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)bsonDoc -> (Json)package$.MODULE$.parse(bsonDoc.toJson()).toOption().getOrElse(Util$::getState$$anonfun$1$$anonfun$1)).getOrElse(Util$::getState$$anonfun$2);
    }

    public Document addToElxPublic(List<String> fields, Document doc) {
        Document elxPublic = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxPublic", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(Util$::$anonfun$1));
        Document elxEvent = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxEvent", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(Util$::$anonfun$2));
        Document result = (Document)fields.foldLeft((Object)elxPublic, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Document holder = (Document)tuple2._1();
                String field = (String)tuple2._2();
                return (Document)BsonETL$.MODULE$.get(elxEvent, field).map((Function1 & Serializable)value -> BsonETL$.MODULE$.put(holder, field, value)).getOrElse(() -> Util$.$anonfun$3$$anonfun$2(holder));
            }
            throw new MatchError((Object)tuple2);
        });
        return (Document)doc.updated("elxPublic", (Object)result, (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
    }

    public Document mergeToElxPublic(List<String> fields, Document doc) {
        Document elxPublic = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxPublic", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(Util$::$anonfun$4));
        Document elxEvent = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxEvent", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(Util$::$anonfun$5));
        Document result = this.mergeFields(fields, elxEvent, elxPublic);
        return (Document)doc.updated("elxPublic", (Object)result, (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
    }

    public Document addToElxPrivate(List<String> fields, Document doc) {
        Document elxPrivate = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxPrivate", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(Util$::$anonfun$6));
        Document elxEvent = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxEvent", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(Util$::$anonfun$7));
        Document result = (Document)fields.foldLeft((Object)elxPrivate, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Document holder = (Document)tuple2._1();
                String field = (String)tuple2._2();
                return (Document)BsonETL$.MODULE$.get(elxEvent, field).map((Function1 & Serializable)value -> BsonETL$.MODULE$.put(holder, field, value)).getOrElse(() -> Util$.$anonfun$8$$anonfun$2(holder));
            }
            throw new MatchError((Object)tuple2);
        });
        return (Document)doc.updated("elxPrivate", (Object)result, (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
    }

    public Document mergeToElxPrivate(List<String> fields, Document doc) {
        Document elxPrivate = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxPrivate", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(Util$::$anonfun$9));
        Document elxEvent = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxEvent", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(Util$::$anonfun$10));
        Document result = this.mergeFields(fields, elxEvent, elxPrivate);
        return (Document)doc.updated("elxPrivate", (Object)result, (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
    }

    public Document getElxParameters(Document doc) {
        return (Document)doc.get("elxParameters", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)_$1 -> ambience.etl.package$.MODULE$.ETLRecord().apply(_$1)).getOrElse(() -> Util$.getElxParameters$$anonfun$2(doc));
    }

    public Document getElxParametersFromRoot(Document doc) {
        List l = (List)new .colon.colon((Object)"_id", (List)new .colon.colon((Object)"workflowId", (List)new .colon.colon((Object)"states", (List)Nil$.MODULE$)));
        return (Document)doc.filterNot((Function1 & Serializable)pair -> this.test$1(l, (Tuple2)pair));
    }

    public Document cleanResult(Document doc) {
        List l = (List)new .colon.colon((Object)"elxPrivate", (List)new .colon.colon((Object)"elxHistory", (List)Nil$.MODULE$));
        return (Document)doc.filterNot((Function1 & Serializable)pair -> this.test$2(l, (Tuple2)pair));
    }

    public Document mergeFields(List<String> fields, Document from, Document to) {
        return (Document)fields.foldLeft((Object)to, (Function2 & Serializable)(x$12, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$12, x$2);
            if (tuple2 != null) {
                Document holder = (Document)tuple2._1();
                String field = (String)tuple2._2();
                return (Document)BsonETL$.MODULE$.get(from, field).map((Function1 & Serializable)x$1 -> {
                    BsonValue bsonValue = x$1;
                    if (bsonValue instanceof BsonDocument) {
                        BsonValue bsonValue2;
                        BsonDocument vdoc = (BsonDocument)bsonValue;
                        Option option = BsonETL$.MODULE$.get(holder, field);
                        if (option instanceof Some && (bsonValue2 = (BsonValue)((Some)option).value()) instanceof BsonDocument) {
                            BsonDocument odoc = (BsonDocument)bsonValue2;
                            return BsonETL$.MODULE$.put(holder, field, (BsonValue)BsonETL$.MODULE$.deepMerge(odoc, vdoc));
                        }
                        return BsonETL$.MODULE$.put(holder, field, (BsonValue)vdoc);
                    }
                    BsonValue value = bsonValue;
                    return BsonETL$.MODULE$.put(holder, field, value);
                }).getOrElse(() -> Util$.mergeFields$$anonfun$1$$anonfun$2(holder));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final Json getState$$anonfun$1$$anonfun$1() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final Json getState$$anonfun$2() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final BsonDocument $anonfun$1() {
        return BsonDocument$.MODULE$.apply();
    }

    private static final BsonDocument $anonfun$2() {
        return BsonDocument$.MODULE$.apply();
    }

    private static final Document $anonfun$3$$anonfun$2(Document holder$2) {
        return holder$2;
    }

    private static final BsonDocument $anonfun$4() {
        return BsonDocument$.MODULE$.apply();
    }

    private static final BsonDocument $anonfun$5() {
        return BsonDocument$.MODULE$.apply();
    }

    private static final BsonDocument $anonfun$6() {
        return BsonDocument$.MODULE$.apply();
    }

    private static final BsonDocument $anonfun$7() {
        return BsonDocument$.MODULE$.apply();
    }

    private static final Document $anonfun$8$$anonfun$2(Document holder$4) {
        return holder$4;
    }

    private static final BsonDocument $anonfun$9() {
        return BsonDocument$.MODULE$.apply();
    }

    private static final BsonDocument $anonfun$10() {
        return BsonDocument$.MODULE$.apply();
    }

    private static final Document getElxParameters$$anonfun$2(Document doc$1) {
        return MODULE$.getElxParametersFromRoot(doc$1);
    }

    private final boolean test$1(List l$1, Tuple2 pair) {
        return l$1.contains(pair._1()) || ((String)pair._1()).startsWith("elx");
    }

    private final boolean test$2(List l$2, Tuple2 pair) {
        return l$2.contains(pair._1());
    }

    private static final Document mergeFields$$anonfun$1$$anonfun$2(Document holder$6) {
        return holder$6;
    }
}

