/*
 * Decompiled with CFR 0.152.
 */
package ambience.workflow.management;

import ambience.arch.Arch$;
import ambience.codex.BulkRoute;
import ambience.framework.ElxFrameJs$;
import ambience.framework.UUIDDocumentManager2;
import ambience.framework.UUIDDocumentRoute2;
import ambience.gravity.GravityHelper$;
import ambience.module.CustomOAuth2Client;
import ambience.module.Module;
import ambience.module.PrivilegeSupplier;
import ambience.module.ProjectConfig;
import ambience.module.RouteHelper$;
import ambience.module.UserDB;
import ambience.workflow.designer.db.FixWorkflow$;
import ambience.workflow.management.ArtifactSupplier$;
import ambience.workflow.management.ConnectionPool$;
import ambience.workflow.management.UploadHandler$;
import ambience.workflow.management.Util$;
import ambience.workflow.management.WorkflowManager;
import ambience.workflow.management.WorkflowModule$StateMachine$;
import ambience.workflow.management.WorkflowModule$WorkflowUploadStructure$;
import ambience.workflow.management.WorkgroupSupport;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.param.Template;
import com.elixirtech.arch.param.Template$;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.webserver.CodeLoader;
import com.elixirtech.webserver.DynamicCodeLoader;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.KeyEncoder$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple6;
import scala.Tuple6$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;
import workflow.model.WorkflowId;
import workflow.model.WorkflowId$;
import workflow.model.WorkflowName;
import workflow.model.WorkflowName$;

public class WorkflowModule
implements Module,
PrivilegeSupplier,
LoggingHelper2 {
    public static final long OFFSET$8 = LazyVals$.MODULE$.getOffsetStatic(WorkflowModule.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(WorkflowModule.class.getDeclaredField("routes$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(WorkflowModule.class.getDeclaredField("route$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(WorkflowModule.class.getDeclaredField("AuditComponent$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(WorkflowModule.class.getDeclaredField("codeLoader$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(WorkflowModule.class.getDeclaredField("codeLoaderOptions$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(WorkflowModule.class.getDeclaredField("docRouteForWorkflows$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(WorkflowModule.class.getDeclaredField("bulkRoute$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WorkflowModule.class.getDeclaredField("workflowManager$lzy1"));
    private volatile Object log$lzy1;
    public final ProjectConfig ambience$workflow$management$WorkflowModule$$projectConfig;
    private final CustomOAuth2Client oAuth2Client;
    private final AuditAPI.AuditAppender auditAppender;
    private final Clock clock;
    private CodexDB codexDB;
    private final MongoDB mongoDB;
    private final String id;
    private final String name;
    private final String url;
    private final Json EmptyArray;
    private final Json EmptyObject;
    private volatile Object workflowManager$lzy1;
    private volatile Object bulkRoute$lzy1;
    private volatile Object docRouteForWorkflows$lzy1;
    private final WorkgroupSupport workgroupSupport;
    private volatile Object codeLoaderOptions$lzy1;
    private volatile Object codeLoader$lzy1;
    private volatile Object AuditComponent$lzy1;
    private final Template JSLogic;
    private volatile Object route$lzy1;
    private volatile Object routes$lzy1;

    public WorkflowModule(ProjectConfig projectConfig, CustomOAuth2Client oAuth2Client, AuditAPI.AuditAppender auditAppender, Clock clock, CodexDB codexDB, MongoDB mongoDB) {
        this.ambience$workflow$management$WorkflowModule$$projectConfig = projectConfig;
        this.oAuth2Client = oAuth2Client;
        this.auditAppender = auditAppender;
        this.clock = clock;
        this.codexDB = codexDB;
        this.mongoDB = mongoDB;
        this.id = "workflows";
        this.name = "Workflows";
        this.url = this.id() + "/index.html";
        this.EmptyArray = Json$.MODULE$.fromValues((Iterable)scala.package$.MODULE$.Nil());
        this.EmptyObject = Json$.MODULE$.fromFields((Iterable)scala.package$.MODULE$.Nil());
        this.workgroupSupport = new WorkgroupSupport(this);
        ArtifactSupplier$.MODULE$.register();
        this.JSLogic = Template$.MODULE$.apply(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |elx = {};\n      |elx.i18n = ${i18n:ui,workflows};\n      |elx.parameters = ${elx-parameters};\n      |$(document).ready(function() { new JSLauncher(); } );\n      |")));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.AuditAppender auditAppender() {
        return this.auditAppender;
    }

    public Clock clock() {
        return this.clock;
    }

    public MongoDB mongoDB() {
        return this.mongoDB;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public Json EmptyArray() {
        return this.EmptyArray;
    }

    public Json EmptyObject() {
        return this.EmptyObject;
    }

    public WorkflowManager workflowManager() {
        Object object = this.workflowManager$lzy1;
        if (object instanceof WorkflowManager) {
            return (WorkflowManager)((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (WorkflowManager)((Object)this.workflowManager$lzyINIT1());
    }

    private Object workflowManager$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.workflowManager$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    WorkflowManager workflowManager = null;
                    try {
                        workflowManager = new WorkflowManager(this);
                        object2 = workflowManager == null ? LazyVals.NullValue$.MODULE$ : workflowManager;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.workflowManager$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return workflowManager;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public BulkRoute bulkRoute() {
        Object object = this.bulkRoute$lzy1;
        if (object instanceof BulkRoute) {
            return (BulkRoute)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BulkRoute)this.bulkRoute$lzyINIT1();
    }

    private Object bulkRoute$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.bulkRoute$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BulkRoute bulkRoute = null;
                    try {
                        bulkRoute = new BulkRoute("workflows", this.codexDB.getCodexCollection("Workflows"));
                        object2 = bulkRoute == null ? LazyVals.NullValue$.MODULE$ : bulkRoute;
                        this.codexDB = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.bulkRoute$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bulkRoute;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public UUIDDocumentRoute2 docRouteForWorkflows() {
        Object object = this.docRouteForWorkflows$lzy1;
        if (object instanceof UUIDDocumentRoute2) {
            return (UUIDDocumentRoute2)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UUIDDocumentRoute2)this.docRouteForWorkflows$lzyINIT1();
    }

    private Object docRouteForWorkflows$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.docRouteForWorkflows$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    UUIDDocumentRoute2 uUIDDocumentRoute2 = null;
                    try {
                        uUIDDocumentRoute2 = new UUIDDocumentRoute2((UUIDDocumentManager2)this.workflowManager(), "mod-workflows-edit");
                        object2 = uUIDDocumentRoute2 == null ? LazyVals.NullValue$.MODULE$ : uUIDDocumentRoute2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.docRouteForWorkflows$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uUIDDocumentRoute2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public WorkgroupSupport workgroupSupport() {
        return this.workgroupSupport;
    }

    public CodeLoader.Options codeLoaderOptions() {
        Object object = this.codeLoaderOptions$lzy1;
        if (object instanceof CodeLoader.Options) {
            return (CodeLoader.Options)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CodeLoader.Options)this.codeLoaderOptions$lzyINIT1();
    }

    private Object codeLoaderOptions$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoaderOptions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CodeLoader.Options options = null;
                    try {
                        options = new CodeLoader.Options(this){
                            private final /* synthetic */ WorkflowModule $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public String WebScript() {
                                return "js/elx-workflow-client-fastopt.js";
                            }

                            public File WebRootDir() {
                                return this.$outer.ambience$workflow$management$WorkflowModule$$projectConfig.WebRootDir();
                            }
                        };
                        object2 = options == null ? LazyVals.NullValue$.MODULE$ : options;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoaderOptions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return options;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DynamicCodeLoader codeLoader() {
        Object object = this.codeLoader$lzy1;
        if (object instanceof DynamicCodeLoader) {
            return (DynamicCodeLoader)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DynamicCodeLoader)this.codeLoader$lzyINIT1();
    }

    private Object codeLoader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DynamicCodeLoader dynamicCodeLoader = null;
                    try {
                        dynamicCodeLoader = new DynamicCodeLoader(this.codeLoaderOptions());
                        object2 = dynamicCodeLoader == null ? LazyVals.NullValue$.MODULE$ : dynamicCodeLoader;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoader$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return dynamicCodeLoader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.Component AuditComponent() {
        Object object = this.AuditComponent$lzy1;
        if (object instanceof AuditAPI.Component) {
            return (AuditAPI.Component)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AuditAPI.Component)this.AuditComponent$lzyINIT1();
    }

    private Object AuditComponent$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.AuditComponent$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AuditAPI.Component component = null;
                    try {
                        component = AuditAPI.Component$.MODULE$.apply(this.id(), "main");
                        object2 = component == null ? LazyVals.NullValue$.MODULE$ : component;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.AuditComponent$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return component;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<PrivilegeSupplier.Privilege> requiredPrivileges() {
        return (List)new .colon.colon((Object)PrivilegeSupplier.Privilege$.MODULE$.apply("mod-workflows-edit", "Allowed to edit workflow metadata (eg. role access)"), (List)Nil$.MODULE$);
    }

    public Task<Json> prepareNewWorkflow(UserDB.User user, String name, String copyFrom, String db, String col, String chainset, String workgroupId) {
        if (copyFrom.isEmpty()) {
            return Task$.MODULE$.now((Object)this.blankWorkflow(user, name, db, col, chainset, workgroupId));
        }
        return this.workflowManager().get(user, copyFrom).map((Function1 & Serializable)reply -> (Json)reply.map(this.copy(user, name, db, col, chainset, workgroupId)).getOrElse(() -> this.prepareNewWorkflow$$anonfun$1$$anonfun$1(copyFrom, user, name, db, col, chainset, workgroupId)));
    }

    public Json blankWorkflow(UserDB.User user, String name, String db, String col, String chainset, String workgroupId) {
        Object[] objectArray = new Tuple2[6];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(name));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(user.id()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"database");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(db));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"collection");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromString(col));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"chainsetId");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Json$.MODULE$.fromString(chainset));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"workgroups");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)this.workgroupArrayJson(workgroupId));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Json ret = Util$.MODULE$.buildDefaultJSON().deepMerge(json);
        this.log().info(() -> WorkflowModule.blankWorkflow$$anonfun$1(ret), Line$.MODULE$.apply(113), FullName$.MODULE$.apply("ambience.workflow.management.WorkflowModule.blankWorkflow"));
        return ret;
    }

    public Json workgroupArrayJson(String workgroupId) {
        return Json$.MODULE$.fromValues((Iterable)Arch$.MODULE$.opts(workgroupId).map((Function1 & Serializable)value -> Json$.MODULE$.fromString(value)).toList());
    }

    public Function1<Json, Json> copy(UserDB.User user, String name, String db, String col, String chainset, String workgroupId) {
        List actions = (List)new .colon.colon((Object)JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("_id")), (List)new .colon.colon((Object)JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "name", Json$.MODULE$.fromString(name)), (List)new .colon.colon((Object)JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "owner", Json$.MODULE$.fromString(user.id())), (List)new .colon.colon((Object)JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "database", Json$.MODULE$.fromString(db)), (List)new .colon.colon((Object)JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "collection", Json$.MODULE$.fromString(col)), (List)new .colon.colon((Object)JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "chainsetId", Json$.MODULE$.fromString(chainset)), (List)new .colon.colon((Object)JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "workgroups", this.workgroupArrayJson(workgroupId)), (List)Nil$.MODULE$)))))));
        return (Function1 & Serializable)json -> JsonProcessor$.MODULE$.run((Seq)actions, json);
    }

    public Template JSLogic() {
        return this.JSLogic;
    }

    public Function1<GravityRequest, Task<GravityResponse>> route() {
        Object object = this.route$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.route$lzyINIT1();
    }

    private Object route$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.route$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Function1 function1 = null;
                    try {
                        function1 = GravitySystem$.MODULE$.fromRoutes(this.routes(), GravitySystem$.MODULE$.fromRoutes$default$2());
                        object2 = function1 == null ? LazyVals.NullValue$.MODULE$ : function1;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.route$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return function1;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<GravityRoute> routes() {
        Object object = this.routes$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.routes$lzyINIT1();
    }

    private Object routes$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.routes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        Object[] objectArray = new GravityRoute[12];
                        DynamicCodeLoader dynamicCodeLoader = this.codeLoader();
                        objectArray[0] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "index.html", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> RouteHelper$.MODULE$.buildIndexHtml((CodeLoader)dynamicCodeLoader, this.id(), user)));
                        DynamicCodeLoader dynamicCodeLoader2 = this.codeLoader();
                        objectArray[1] = GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.GET(), "elx-launcher.js", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> ElxFrameJs$.MODULE$.apply((CodeLoader)dynamicCodeLoader2, this.JSLogic(), user)));
                        objectArray[2] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "data/*", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.getData((UserDB.User)user)));
                        objectArray[3] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "add", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.postAdd((UserDB.User)user)));
                        objectArray[4] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "upload", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> UploadHandler$.MODULE$.postUpload((UserDB.User)user)));
                        objectArray[5] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "upload-zip", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> UploadHandler$.MODULE$.postUploadZip((UserDB.User)user)));
                        objectArray[6] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "dbdef", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.getDatabaseDefinitions((UserDB.User)user)));
                        objectArray[7] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "chainsets", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.getChainsetsForWorkgroup((UserDB.User)user)));
                        objectArray[8] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "*/chainsets", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.getChainsets((UserDB.User)user)));
                        objectArray[9] = GravityRoute$.MODULE$.pathPrefix("bulk", this.bulkRoute().handler());
                        objectArray[10] = this.codeLoader().route();
                        objectArray[11] = GravityRoute$.MODULE$.all(this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.docRouteForWorkflows().route(user).handler()));
                        list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> withModUser(Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> fn) {
        return this.oAuth2Client.approveWithUser((Function1 & Serializable)user -> {
            if (this.isValidGroup((UserDB.User)user)) {
                return (Function1)fn.apply(user);
            }
            this.log().info(() -> WorkflowModule.withModUser$$anonfun$1$$anonfun$1(user), Line$.MODULE$.apply(169), FullName$.MODULE$.apply("ambience.workflow.management.WorkflowModule.withModUser"));
            return Gravity$.MODULE$.ForbiddenHandler();
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> getData(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)uuid -> (Function1 & Serializable)_$1 -> this.workflowManager().get(user, uuid.value()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                return GravityResponse$.MODULE$.json(FixWorkflow$.MODULE$.doFix(json));
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponse();
            }
            throw new MatchError((Object)option);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> postAdd(UserDB.User user) {
        return GravityHelper$.MODULE$.withJsonBody((Function1 & Serializable)json -> (Function1 & Serializable)_$2 -> {
            Tuple6 tuple6;
            Option params = json.hcursor().downField("name").as(Decoder$.MODULE$.decodeString()).toOption().map((Function1 & Serializable)_$3 -> new WorkflowName(WorkflowName$.MODULE$.apply(_$3))).flatMap((Function1 & Serializable)name -> WorkflowModule.$anonfun$2(json, name == null ? null : ((WorkflowName)name).value()));
            Option option = params;
            if (option instanceof Some && (tuple6 = (Tuple6)((Some)option).value()) != null) {
                String name2 = tuple6._1() == null ? null : ((WorkflowName)tuple6._1()).value();
                String copyFrom = tuple6._2() == null ? null : ((WorkflowId)tuple6._2()).value();
                String db = (String)tuple6._3();
                String col = (String)tuple6._4();
                String chainset = (String)tuple6._5();
                String workgroupId = (String)tuple6._6();
                return this.prepareNewWorkflow(user, name2, copyFrom, db, col, chainset, workgroupId).flatMap((Function1 & Serializable)workflowJson -> this.docRouteForWorkflows().save(user, workflowJson));
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> WorkflowModule.postAdd$$anonfun$1$$anonfun$1$$anonfun$2(json), Line$.MODULE$.apply(202), FullName$.MODULE$.apply("ambience.workflow.management.WorkflowModule.postAdd"));
                return Gravity$.MODULE$.BadRequestResponseT();
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> getDatabaseDefinitions(UserDB.User user) {
        return (Function1 & Serializable)_$5 -> {
            Task ts = Task$.MODULE$.sequence((Iterable)ConnectionPool$.MODULE$.getPoolNames().toList().map((Function1 & Serializable)db -> ConnectionPool$.MODULE$.getCollectionNames((String)db).map((Function1 & Serializable)ns -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc(db);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ns.toList());
            })), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)_$6 -> _$6.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return ts.map((Function1 & Serializable)m -> {
                Map map = (Map)package$.MODULE$.EncoderOps(m);
                return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)map, (Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString()))));
            });
        };
    }

    public Function1<GravityRequest, Task<GravityResponse>> getChainsets(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)wfId -> (Function1 & Serializable)_$7 -> this.workflowManager().getChainsetChoices(user, wfId.value()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Map m = (Map)((Right)either).value();
                Map map = (Map)package$.MODULE$.EncoderOps((Object)m);
                return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)map, (Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString())));
            }
            if (either instanceof Left) {
                return Gravity$.MODULE$.BadRequestResponse("fetching chainsets list failed");
            }
            throw new MatchError((Object)either);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getChainsetsForWorkgroup(UserDB.User user) {
        return GravityHelper$.MODULE$.parameter("wg", (Function1 & Serializable)wgId -> (Function1 & Serializable)_$8 -> this.workflowManager().getChainsetChoicesForWorkgroup(user, (String)wgId).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Map m = (Map)((Right)either).value();
                Map map = (Map)package$.MODULE$.EncoderOps((Object)m);
                return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)map, (Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString())));
            }
            if (either instanceof Left) {
                return Gravity$.MODULE$.BadRequestResponse("fetching chainsets list failed");
            }
            throw new MatchError((Object)either);
        }));
    }

    private boolean isValidGroup(UserDB.User user) {
        return user.privileges().contains((Object)"mod-workflows") || user.privileges().contains((Object)"mod-workflows-edit");
    }

    private static final Object prepareNewWorkflow$$anonfun$1$$anonfun$1$$anonfun$1(String copyFrom$3) {
        return "Can't locate workflow " + new WorkflowId(copyFrom$3) + ", using blank";
    }

    private final Json prepareNewWorkflow$$anonfun$1$$anonfun$1(String copyFrom$2, UserDB.User user$2, String name$2, String db$2, String col$2, String chainset$2, String workgroupId$2) {
        this.log().warn(() -> WorkflowModule.prepareNewWorkflow$$anonfun$1$$anonfun$1$$anonfun$1(copyFrom$2), Line$.MODULE$.apply(88), FullName$.MODULE$.apply("ambience.workflow.management.WorkflowModule.prepareNewWorkflow"));
        return this.blankWorkflow(user$2, name$2, db$2, col$2, chainset$2, workgroupId$2);
    }

    private static final Object blankWorkflow$$anonfun$1(Json ret$1) {
        return "Blank Workflow: " + ret$1.spaces2();
    }

    private static final Object withModUser$$anonfun$1$$anonfun$1(UserDB.User user$3) {
        return "User " + user$3.name() + " does not have workflow privileges";
    }

    private static final String $anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final /* synthetic */ Option $anonfun$2$$anonfun$2(Json json$3, String name$3, String copyFrom) {
        return json$3.hcursor().downField("database").as(Decoder$.MODULE$.decodeString()).toOption().flatMap((Function1 & Serializable)db -> json$3.hcursor().downField("collection").as(Decoder$.MODULE$.decodeString()).toOption().flatMap((Function1 & Serializable)col -> json$3.hcursor().downField("chainsetId").as(Decoder$.MODULE$.decodeString()).toOption().flatMap((Function1 & Serializable)chainset -> Some$.MODULE$.apply(json$3.hcursor().downField("workgroupId").as(Decoder$.MODULE$.decodeString()).toOption().getOrElse(WorkflowModule::$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1)).map((Function1 & Serializable)workgroupId -> Tuple6$.MODULE$.apply((Object)new WorkflowName(name$3), (Object)new WorkflowId(copyFrom), db, col, chainset, workgroupId)))));
    }

    private static final /* synthetic */ Option $anonfun$2(Json json$2, String name) {
        return json$2.hcursor().downField("copyFrom").as(Decoder$.MODULE$.decodeString()).toOption().map((Function1 & Serializable)_$4 -> new WorkflowId(WorkflowId$.MODULE$.apply(_$4))).flatMap((Function1 & Serializable)copyFrom -> WorkflowModule.$anonfun$2$$anonfun$2(json$2, name, copyFrom == null ? null : ((WorkflowId)copyFrom).value()));
    }

    private static final Object postAdd$$anonfun$1$$anonfun$1$$anonfun$2(Json json$7) {
        return "Unable to add - bad json: " + json$7.noSpaces();
    }

    public static final class StateMachine
    implements Product,
    Serializable {
        private final String id;
        private final String name;
        private final int initZoom;
        private final Json graph;

        public static StateMachine apply(String string, String string2, int n, Json json) {
            return WorkflowModule$StateMachine$.MODULE$.apply(string, string2, n, json);
        }

        public static StateMachine fromProduct(Product product) {
            return WorkflowModule$StateMachine$.MODULE$.fromProduct(product);
        }

        public static StateMachine unapply(StateMachine stateMachine) {
            return WorkflowModule$StateMachine$.MODULE$.unapply(stateMachine);
        }

        public StateMachine(String id, String name, int initZoom, Json graph) {
            this.id = id;
            this.name = name;
            this.initZoom = initZoom;
            this.graph = graph;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.initZoom());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.graph()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StateMachine)) return false;
            StateMachine stateMachine = (StateMachine)object;
            if (this.initZoom() != stateMachine.initZoom()) return false;
            String string = this.id();
            String string2 = stateMachine.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = stateMachine.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Json json = this.graph();
            Json json2 = stateMachine.graph();
            if (json == null) {
                if (json2 == null) return true;
                return false;
            } else {
                if (!json.equals(json2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StateMachine;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "StateMachine";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "initZoom";
                }
                case 3: {
                    return "graph";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public int initZoom() {
            return this.initZoom;
        }

        public Json graph() {
            return this.graph;
        }

        public StateMachine copy(String id, String name, int initZoom, Json graph) {
            return new StateMachine(id, name, initZoom, graph);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public int copy$default$3() {
            return this.initZoom();
        }

        public Json copy$default$4() {
            return this.graph();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }

        public int _3() {
            return this.initZoom();
        }

        public Json _4() {
            return this.graph();
        }
    }

    public static final class WorkflowUploadStructure
    implements Product,
    Serializable {
        private final String _id;
        private final String version;
        private final String name;
        private final String owner;
        private final Json access;
        private final boolean enabled;
        private final List stateMachines;

        public static WorkflowUploadStructure apply(String string, String string2, String string3, String string4, Json json, boolean bl, List<StateMachine> list) {
            return WorkflowModule$WorkflowUploadStructure$.MODULE$.apply(string, string2, string3, string4, json, bl, list);
        }

        public static WorkflowUploadStructure fromProduct(Product product) {
            return WorkflowModule$WorkflowUploadStructure$.MODULE$.fromProduct(product);
        }

        public static WorkflowUploadStructure unapply(WorkflowUploadStructure workflowUploadStructure) {
            return WorkflowModule$WorkflowUploadStructure$.MODULE$.unapply(workflowUploadStructure);
        }

        public static Json $lessinit$greater$default$5() {
            return WorkflowModule$WorkflowUploadStructure$.MODULE$.$lessinit$greater$default$5();
        }

        public WorkflowUploadStructure(String _id, String version, String name, String owner, Json access, boolean enabled, List<StateMachine> stateMachines) {
            this._id = _id;
            this.version = version;
            this.name = name;
            this.owner = owner;
            this.access = access;
            this.enabled = enabled;
            this.stateMachines = stateMachines;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this._id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.version()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.owner()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.access()));
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.stateMachines()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WorkflowUploadStructure)) return false;
            WorkflowUploadStructure workflowUploadStructure = (WorkflowUploadStructure)object;
            if (this.enabled() != workflowUploadStructure.enabled()) return false;
            String string = this._id();
            String string2 = workflowUploadStructure._id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.version();
            String string4 = workflowUploadStructure.version();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.name();
            String string6 = workflowUploadStructure.name();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.owner();
            String string8 = workflowUploadStructure.owner();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            Json json = this.access();
            Json json2 = workflowUploadStructure.access();
            if (json == null) {
                if (json2 != null) {
                    return false;
                }
            } else if (!json.equals(json2)) return false;
            List<StateMachine> list = this.stateMachines();
            List<StateMachine> list2 = workflowUploadStructure.stateMachines();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WorkflowUploadStructure;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "WorkflowUploadStructure";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean((boolean)this._6());
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "_id";
                }
                case 1: {
                    return "version";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "owner";
                }
                case 4: {
                    return "access";
                }
                case 5: {
                    return "enabled";
                }
                case 6: {
                    return "stateMachines";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String _id() {
            return this._id;
        }

        public String version() {
            return this.version;
        }

        public String name() {
            return this.name;
        }

        public String owner() {
            return this.owner;
        }

        public Json access() {
            return this.access;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public List<StateMachine> stateMachines() {
            return this.stateMachines;
        }

        public WorkflowUploadStructure copy(String _id, String version, String name, String owner, Json access, boolean enabled, List<StateMachine> stateMachines) {
            return new WorkflowUploadStructure(_id, version, name, owner, access, enabled, stateMachines);
        }

        public String copy$default$1() {
            return this._id();
        }

        public String copy$default$2() {
            return this.version();
        }

        public String copy$default$3() {
            return this.name();
        }

        public String copy$default$4() {
            return this.owner();
        }

        public Json copy$default$5() {
            return this.access();
        }

        public boolean copy$default$6() {
            return this.enabled();
        }

        public List<StateMachine> copy$default$7() {
            return this.stateMachines();
        }

        public String _1() {
            return this._id();
        }

        public String _2() {
            return this.version();
        }

        public String _3() {
            return this.name();
        }

        public String _4() {
            return this.owner();
        }

        public Json _5() {
            return this.access();
        }

        public boolean _6() {
            return this.enabled();
        }

        public List<StateMachine> _7() {
            return this.stateMachines();
        }
    }
}

