/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.runtime;

import ambience.api.ChainRunner;
import ambience.etl.BuildError;
import ambience.etl.ChainSetId;
import ambience.etl.ChainSetId$;
import ambience.etl.ChainSetLoader$;
import ambience.etl.ChainSetName;
import ambience.etl.ChainSetName$;
import ambience.etl.DefaultETLLogger$;
import ambience.etl.ETLChain$;
import ambience.etl.ETLChainSet;
import ambience.etl.ETLChainSet$;
import ambience.etl.ETLStep;
import ambience.etl.ETLStep$;
import ambience.etl.ETLStepType$;
import ambience.etl.ImportResolver$;
import ambience.etl.job.ChainBuilder;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexDB;
import java.io.Serializable;
import monix.eval.Task;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ChainRunnerImpl
implements ChainRunner,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ChainRunnerImpl.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;

    public ChainRunnerImpl(CodexDB codexDB) {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Observable<Document> runChain(UserDB.User user, String description, List<ChainRunner.ChainStep> chain, Observable<Document> init) {
        this.log().info(() -> ChainRunnerImpl.runChain$$anonfun$1(description, user), Line$.MODULE$.apply(33), FullName$.MODULE$.apply("ambience.etl.runtime.ChainRunnerImpl.runChain"));
        Vector steps = chain.map((Function1 & Serializable)step -> this.buildStep((ChainRunner.ChainStep)step)).toVector();
        ETLChainSet chainSet = ETLChainSet$.MODULE$.apply(ETLChainSet$.MODULE$.$lessinit$greater$default$1(), ETLChainSet$.MODULE$.$lessinit$greater$default$2(), ETLChainSet$.MODULE$.$lessinit$greater$default$3(), ETLChainSet$.MODULE$.$lessinit$greater$default$4(), ETLChainSet$.MODULE$.$lessinit$greater$default$5(), ETLChainSet$.MODULE$.$lessinit$greater$default$6(), ETLChainSet$.MODULE$.$lessinit$greater$default$7(), ETLChainSet$.MODULE$.$lessinit$greater$default$8(), (List)package$.MODULE$.Nil()).$colon$plus(ETLChain$.MODULE$.apply("ChainRunnerLogic", description, "", "", "", steps, ETLChain$.MODULE$.$lessinit$greater$default$7()));
        ChainBuilder builder = new ChainBuilder(chainSet, DefaultETLLogger$.MODULE$, user);
        Either<BuildError, Function1<Observable<Document>, Observable<Document>>> either = builder.buildChain((Option<String>)None$.MODULE$, "ChainRunnerLogic", (Option<Object>)None$.MODULE$);
        if (either instanceof Right) {
            Function1 flow = (Function1)((Right)either).value();
            return (Observable)flow.apply(init);
        }
        if (either instanceof Left) {
            BuildError err = (BuildError)((Left)either).value();
            String msg = "ChainRunner Error: " + err.msg() + " " + err.step().map((Function1 & Serializable)_$1 -> _$1.name()).getOrElse(ChainRunnerImpl::$anonfun$3) + " " + err.err().map((Function1 & Serializable)_$2 -> _$2.getMessage()).getOrElse(ChainRunnerImpl::$anonfun$5);
            this.log().error(() -> ChainRunnerImpl.runChain$$anonfun$2(msg), Line$.MODULE$.apply(41), FullName$.MODULE$.apply("ambience.etl.runtime.ChainRunnerImpl.runChain"));
            return Observable$.MODULE$.raiseError((Throwable)new RuntimeException(msg));
        }
        throw new MatchError(either);
    }

    public Observable<Document> runChain(UserDB.User user, ChainRunner.ChainSpec chainSpec, Observable<Document> init) {
        return Observable$.MODULE$.fromTask(this.loadChainSet(user, chainSpec)).flatMap((Function1 & Serializable)chainSet -> this.runChain(user, (ETLChainSet)chainSet, chainSpec.chainName(), init));
    }

    public Observable<Document> runChain(UserDB.User user, ETLChainSet chainSet, String chainName, Observable<Document> init) {
        ChainBuilder builder = new ChainBuilder(chainSet, DefaultETLLogger$.MODULE$, user);
        Either<BuildError, Function1<Observable<Document>, Observable<Document>>> either = builder.buildChain((Option<String>)None$.MODULE$, chainName, (Option<Object>)None$.MODULE$);
        if (either instanceof Right) {
            Function1 flow = (Function1)((Right)either).value();
            return (Observable)flow.apply(init);
        }
        if (either instanceof Left) {
            BuildError err = (BuildError)((Left)either).value();
            return Observable$.MODULE$.raiseError((Throwable)new RuntimeException("Error building chain: " + err.msg()));
        }
        throw new MatchError(either);
    }

    public Task<ETLChainSet> loadChainSet(UserDB.User user, ChainRunner.ChainSpec chainSpec) {
        return this.loadRawChainSet(user, chainSpec).flatMap((Function1 & Serializable)cs -> ImportResolver$.MODULE$.apply(user, (ETLChainSet)cs, ImportResolver$.MODULE$.apply$default$3()));
    }

    public Task<ETLChainSet> loadRawChainSet(UserDB.User user, ChainRunner.ChainSpec chainSpec) {
        ChainRunner.ChainSpec chainSpec2 = chainSpec;
        if (chainSpec2 instanceof ChainRunner.ChainNameSpec) {
            ChainRunner.ChainNameSpec spec = (ChainRunner.ChainNameSpec)chainSpec2;
            return this.loadRawChainSetByName(user, ChainSetName$.MODULE$.apply(spec.chainsetName()));
        }
        if (chainSpec2 instanceof ChainRunner.ChainIdSpec) {
            ChainRunner.ChainIdSpec spec = (ChainRunner.ChainIdSpec)chainSpec2;
            return this.loadRawChainSetById(user, ChainSetId$.MODULE$.apply(spec.chainsetId()));
        }
        throw new MatchError((Object)chainSpec2);
    }

    public Task<ETLChainSet> loadRawChainSetByName(UserDB.User user, ChainSetName chainSetName) {
        return ChainSetLoader$.MODULE$.getRawChainSet(user, chainSetName).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ETLChainSet cs = (ETLChainSet)((Some)option).value();
                return cs;
            }
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("ChainSet " + chainSetName + " not found");
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<ETLChainSet> loadRawChainSetById(UserDB.User user, ChainSetId chainSetId) {
        return ChainSetLoader$.MODULE$.getRawChainSet(user, chainSetId).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ETLChainSet cs = (ETLChainSet)((Some)option).value();
                return cs;
            }
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("ChainSetId " + chainSetId + " not found");
            }
            throw new MatchError((Object)option);
        });
    }

    public ETLStep buildStep(ChainRunner.ChainStep step) {
        String string = ETLStepType$.MODULE$.apply(step.stepType());
        String string2 = ETLStep$.MODULE$.$lessinit$greater$default$2();
        String string3 = ETLStep$.MODULE$.$lessinit$greater$default$3();
        String string4 = ETLStep$.MODULE$.$lessinit$greater$default$4();
        String string5 = ETLStep$.MODULE$.$lessinit$greater$default$5();
        boolean bl = ETLStep$.MODULE$.$lessinit$greater$default$7();
        boolean bl2 = ETLStep$.MODULE$.$lessinit$greater$default$8();
        return ETLStep$.MODULE$.apply(string, string2, string3, string4, string5, step.json(), bl, bl2);
    }

    private static final Object runChain$$anonfun$1(String description$2, UserDB.User user$1) {
        return "runChain " + description$2 + " for " + user$1.name();
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final String $anonfun$5() {
        return "";
    }

    private static final Object runChain$$anonfun$2(String msg$1) {
        return msg$1;
    }
}

