/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.runtime;

import ambience.etl.AbstractETLLogger;
import ambience.etl.ETLPosition;
import ambience.module.UserDB;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.BsonUtils$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.subjects.ConcurrentSubject;
import monix.reactive.subjects.ConcurrentSubject$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class DesignerETLLogger2
extends AbstractETLLogger
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DesignerETLLogger2.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final UserDB.User user;
    private final String jobId;
    private final String prefix;
    private final ConcurrentSubject<byte[], byte[]> subject;

    public DesignerETLLogger2(UserDB.User user, String jobId, Clock clock) {
        this.user = user;
        this.jobId = jobId;
        super(clock);
        this.prefix = "[" + user.name() + ":" + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(jobId), 8) + "]";
        this.log().info(() -> this.$init$$$anonfun$1(jobId), Line$.MODULE$.apply(17), FullName$.MODULE$.apply("ambience.etl.runtime.DesignerETLLogger2"));
        this.subject = ConcurrentSubject$.MODULE$.replayLimited(10, Scheduler$.MODULE$.global());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public UserDB.User user() {
        return this.user;
    }

    public String jobId() {
        return this.jobId;
    }

    public String prefix() {
        return this.prefix;
    }

    public Observable<byte[]> observable(Observable<Document> in) {
        ConcurrentSubject<byte[], byte[]> a = this.subject;
        Observable b = in.flatMap((Function1 & Serializable)doc -> this.record((Document)doc));
        Observable both = Observable$.MODULE$.fromIterable((Iterable)new .colon.colon(a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$)));
        Function1 & Serializable intersect = (Function1 & Serializable)x -> (Observable)Predef$.MODULE$.identity(x);
        return both.mergeMap((Function1)intersect, both.mergeMap$default$2((Function1)intersect));
    }

    public Observable<byte[]> record(Document doc) {
        return Observable$.MODULE$.now((Object)BsonUtils$.MODULE$.toByteArray((Document)doc.updated("elxOutputMode", (Object)"Record", (BsonTransformer)BsonTransformer$.MODULE$.TransformString())));
    }

    public Task<BoxedUnit> addLogT(Document doc) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.addLogT$$anonfun$1(doc);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Task<BoxedUnit> initT() {
        return this.addLogT(this.buildDocument("INFO", "Started " + this.jobId()));
    }

    @Override
    public Task<BoxedUnit> closeT() {
        return this.addLogT(this.buildDocument("INFO", "Closed " + this.jobId())).map((Function1)(JProcedure1 & Serializable)_$1 -> this.subject.onComplete());
    }

    @Override
    public Task<BoxedUnit> errorT(ETLPosition pos, Function0<Object> message) {
        return this.addLogT(this.buildDocument("ERROR", pos, message.apply()));
    }

    @Override
    public Task<BoxedUnit> errorT(Function0<Object> message, Throwable t) {
        return this.addLogT(this.buildDocument("ERROR", message.apply(), t));
    }

    @Override
    public Task<BoxedUnit> errorT(ETLPosition pos, Function0<Object> message, Throwable t) {
        return this.addLogT(this.buildDocument("ERROR", pos, message.apply(), t));
    }

    @Override
    public Task<BoxedUnit> warnT(ETLPosition pos, Function0<Object> message) {
        return this.addLogT(this.buildDocument("WARN", pos, message.apply()));
    }

    @Override
    public Task<BoxedUnit> infoT(ETLPosition pos, Function0<Object> message) {
        return this.addLogT(this.buildDocument("INFO", pos, message.apply()));
    }

    @Override
    public Task<BoxedUnit> debugT(ETLPosition pos, Function0<Object> message) {
        return this.addLogT(this.buildDocument("DEBUG", pos, message.apply()));
    }

    @Override
    public Task<BoxedUnit> internalInfoT(Function0<Object> message) {
        return this.addLogT(this.buildDocument("INFO", message.apply()));
    }

    @Override
    public Task<BoxedUnit> internalErrorT(Function0<Object> message) {
        return this.addLogT(this.buildDocument("ERROR", message.apply()));
    }

    @Override
    public Task<BoxedUnit> cancelT() {
        return this.addLogT(this.buildDocument("WARN", "Cancelled"));
    }

    @Override
    public Task<BoxedUnit> completeT() {
        return this.addLogT(this.buildDocument("INFO", "Completed"));
    }

    private final Object $init$$$anonfun$1(String jobId$1) {
        return this.prefix() + " Logger created for " + jobId$1;
    }

    private final void addLogT$$anonfun$1(Document doc$1) {
        this.subject.onNext((Object)BsonUtils$.MODULE$.toByteArray((Document)doc$1.updated("elxOutputMode", (Object)"Log", (BsonTransformer)BsonTransformer$.MODULE$.TransformString())));
    }
}

