/*
 * Decompiled with CFR 0.152.
 */
package ambience.gis.explorer;

import ambience.arch.MongoDBLinkResolver;
import ambience.gis.DatasetHelper$;
import ambience.gis.Model;
import ambience.gis.explorer.ExplorerModule$;
import ambience.gis.explorer.ExplorerModule$Center$;
import ambience.gis.explorer.ExplorerModule$TileConfig$;
import ambience.gis.explorer.GetDatasets$;
import ambience.gis.explorer.db.ExplorerDB;
import ambience.gis.explorer.db.ExplorerMongoDB;
import ambience.gis.explorer.provider.leaflet.IconHelper$;
import ambience.gravity.GravityHelper$;
import ambience.module.Module;
import ambience.module.PrivilegeSupplier;
import ambience.module.ProjectConfig;
import ambience.module.RouteHelper$;
import ambience.module.UserDB;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.param.Template;
import com.elixirtech.coredata.Data$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.webserver.CodeLoader;
import com.elixirtech.webserver.DefaultCodeLoader;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5$;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public class ExplorerModule
implements Module,
PrivilegeSupplier,
LoggingHelper2 {
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(ExplorerModule.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(ExplorerModule.class.getDeclaredField("routes$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(ExplorerModule.class.getDeclaredField("route$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ExplorerModule.class.getDeclaredField("codeLoader$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ExplorerModule.class.getDeclaredField("codeLoaderOptions$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ExplorerModule.class.getDeclaredField("tileConfigList$lzy1"));
    private volatile Object log$lzy1;
    public final ProjectConfig ambience$gis$explorer$ExplorerModule$$projectConfig;
    private final String id;
    private final String name;
    private final String url;
    private final ExplorerDB explorersDB;
    private volatile Object tileConfigList$lzy1;
    private volatile Object codeLoaderOptions$lzy1;
    private volatile Object codeLoader$lzy1;
    private volatile Object route$lzy1;
    private volatile Object routes$lzy1;

    public static Template LeafletLogic() {
        return ExplorerModule$.MODULE$.LeafletLogic();
    }

    public ExplorerModule(ProjectConfig projectConfig) {
        this.ambience$gis$explorer$ExplorerModule$$projectConfig = projectConfig;
        this.id = "gis-explorer";
        this.name = "GIS Explorer";
        this.url = "";
        Elixir$.MODULE$.register(ClassTag$.MODULE$.apply(ExplorerDB.class), ClassTag$.MODULE$.apply(ExplorerMongoDB.class));
        this.explorersDB = (ExplorerDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ExplorerDB.class));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public ExplorerDB explorersDB() {
        return this.explorersDB;
    }

    public List<Option<TileConfig>> tileConfigList() {
        Object object = this.tileConfigList$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.tileConfigList$lzyINIT1();
    }

    private Object tileConfigList$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.tileConfigList$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = ((List)Try$.MODULE$.apply(this::tileConfigList$lzyINIT1$$anonfun$1).getOrElse(ExplorerModule::tileConfigList$lzyINIT1$$anonfun$2)).map((Function1 & Serializable)c -> this.getTileConfig((ConfigValue)c));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.tileConfigList$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CodeLoader.Options codeLoaderOptions() {
        Object object = this.codeLoaderOptions$lzy1;
        if (object instanceof CodeLoader.Options) {
            return (CodeLoader.Options)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CodeLoader.Options)this.codeLoaderOptions$lzyINIT1();
    }

    private Object codeLoaderOptions$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoaderOptions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CodeLoader.Options options = null;
                    try {
                        options = new CodeLoader.Options(this){
                            private final /* synthetic */ ExplorerModule $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public String WebScript() {
                                return "js/elx-gis-explorer-client-fastopt.js";
                            }

                            public File WebRootDir() {
                                return this.$outer.ambience$gis$explorer$ExplorerModule$$projectConfig.WebRootDir();
                            }
                        };
                        object2 = options == null ? LazyVals.NullValue$.MODULE$ : options;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoaderOptions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return options;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DefaultCodeLoader codeLoader() {
        Object object = this.codeLoader$lzy1;
        if (object instanceof DefaultCodeLoader) {
            return (DefaultCodeLoader)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DefaultCodeLoader)this.codeLoader$lzyINIT1();
    }

    private Object codeLoader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DefaultCodeLoader defaultCodeLoader = null;
                    try {
                        defaultCodeLoader = new DefaultCodeLoader(this.codeLoaderOptions());
                        object2 = defaultCodeLoader == null ? LazyVals.NullValue$.MODULE$ : defaultCodeLoader;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoader$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return defaultCodeLoader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<PrivilegeSupplier.Privilege> requiredPrivileges() {
        return (List)new .colon.colon((Object)PrivilegeSupplier.Privilege$.MODULE$.apply("mod-gis-explorer-edit", "Allowed to edit explorer"), (List)Nil$.MODULE$);
    }

    public Function1<GravityRequest, Task<GravityResponse>> route() {
        Object object = this.route$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.route$lzyINIT1();
    }

    private Object route$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.route$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Function1 function1 = null;
                    try {
                        function1 = GravitySystem$.MODULE$.fromRoutes(this.routes(), GravitySystem$.MODULE$.fromRoutes$default$2());
                        object2 = function1 == null ? LazyVals.NullValue$.MODULE$ : function1;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.route$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return function1;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<GravityRoute> routes() {
        Object object = this.routes$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.routes$lzyINIT1();
    }

    private Object routes$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.routes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        Object[] objectArray = new GravityRoute[10];
                        objectArray[0] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "*/index.html", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.buildIndexHtml((UserDB.User)user)));
                        Template template = ExplorerModule$.MODULE$.LeafletLogic();
                        objectArray[1] = GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.GET(), "/*/elx-launcher.js", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.indexLauncher(template, (UserDB.User)user)));
                        objectArray[2] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.getGISExplorer((UserDB.User)user)));
                        objectArray[3] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "layers", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.getLayers((UserDB.User)user)));
                        objectArray[4] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "layer/*", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.getLayerSeg((UserDB.User)user)));
                        objectArray[5] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "feature-props/*", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.getFeaturePropertiesSeg((UserDB.User)user)));
                        objectArray[6] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "save", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.postSave((UserDB.User)user)));
                        objectArray[7] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "dataset/*", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> DatasetHelper$.MODULE$.getDatasetSeg((UserDB.User)user)));
                        objectArray[8] = GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.GET(), "*/datasets", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.getDatasetsForId((UserDB.User)user)));
                        objectArray[9] = this.codeLoader().route();
                        list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> buildIndexHtml(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)explorerId -> (Function1 & Serializable)request -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"explorerId");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)explorerId.value());
            return (Task)RouteHelper$.MODULE$.buildIndexHtml((CodeLoader)this.codeLoader(), "gis-explorer", (PartialFunction)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), user).apply(request);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> indexLauncher(Template template, UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)explorerId -> (Function1 & Serializable)request -> this.extrasT((Gravity.Segment)explorerId).map((Function1 & Serializable)extras -> {
            PartialFunction lookup = extras.orElse(RouteHelper$.MODULE$.lookup((CodeLoader)this.codeLoader(), user, request));
            return GravityResponse$.MODULE$.javascript(template.substitute(lookup.lift()));
        }));
    }

    public Task<Map<String, String>> extrasT(Gravity.Segment explorerId) {
        return IconHelper$.MODULE$.buildIconList().map((Function1 & Serializable)list -> {
            String tileList = this.tileConfigList().map((Function1 & Serializable)_$1 -> {
                Option option = (Option)io.circe.syntax.package$.MODULE$.EncoderOps(_$1);
                String string = "name";
                String string2 = "attribution";
                String string3 = "url";
                String string4 = "center";
                String string5 = "zoom";
                return package.EncoderOps$.MODULE$.asJson$extension((Object)option, Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ExplorerModule::$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))))).noSpaces();
            }).mkString("[", ",", "]");
            String iconList = list.map((Function1 & Serializable)s -> this.quote((String)s)).mkString("[", ",", "]");
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"explorerId");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)explorerId.value());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"iconList");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)iconList);
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tileList");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)tileList);
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> getGISExplorer(UserDB.User user) {
        return (Function1 & Serializable)request -> (Task)request.parameter("id").map((Function1 & Serializable)id -> {
            String name = (String)request.parameter("name").getOrElse(ExplorerModule::$anonfun$4);
            MongoDBLinkResolver.LinkJson link = MongoDBLinkResolver.LinkJson$.MODULE$.apply(id, name);
            return this.explorersDB().load(user, link).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    return Gravity$.MODULE$.BadRequestResponse(msg);
                }
                if (either instanceof Right) {
                    Json explorer = (Json)((Right)either).value();
                    return GravityResponse$.MODULE$.json(explorer);
                }
                throw new MatchError((Object)either);
            });
        }).getOrElse(ExplorerModule::getGISExplorer$$anonfun$1$$anonfun$2);
    }

    public Function1<GravityRequest, Task<GravityResponse>> postSave(UserDB.User user) {
        return GravityHelper$.MODULE$.withJsonBody((Function1 & Serializable)explorer -> (Function1 & Serializable)_$2 -> this.explorersDB().save(user, (Json)explorer).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }
            if (either instanceof Right) {
                return Gravity$.MODULE$.OkResponse();
            }
            throw new MatchError((Object)either);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getDatasetsForId(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)expId -> (Function1 & Serializable)_$3 -> GetDatasets$.MODULE$.apply(user, expId.value()).map((Function1 & Serializable)reply -> {
            Seq seq = (Seq)io.circe.syntax.package$.MODULE$.EncoderOps(this.merge((Seq<Model.DatasetDefinition>)reply));
            String string = "name";
            String string2 = "subset";
            String string3 = "schema";
            String string4 = "isGeo";
            return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)seq, (Encoder)Encoder$.MODULE$.encodeSeq(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ExplorerModule::getDatasetsForId$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))))));
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getLayers(UserDB.User user) {
        return (Function1 & Serializable)_$4 -> this.explorersDB().layerList().map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }
            if (either instanceof Right) {
                List list = (List)((Right)either).value();
                List list2 = (List)io.circe.syntax.package$.MODULE$.EncoderOps((Object)list);
                return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)list2, (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeJson())));
            }
            throw new MatchError((Object)either);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> getLayerSeg(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)id -> (Function1 & Serializable)_$5 -> this.explorersDB().loadLayer(id.value()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return GravityResponse$.MODULE$.json(json);
            }
            throw new MatchError((Object)either);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getFeaturePropertiesSeg(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)layerName -> (Function1 & Serializable)_$6 -> this.explorersDB().loadGeoJsonFeatureProperties(layerName.value()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }
            if (either instanceof Right) {
                Json list = (Json)((Right)either).value();
                return GravityResponse$.MODULE$.json(list);
            }
            throw new MatchError((Object)either);
        }));
    }

    public String quote(String s) {
        return "\"" + s + "\"";
    }

    public Option<TileConfig> getTileConfig(ConfigValue c) {
        String str = c.render(ConfigRenderOptions.concise());
        String string = "name";
        String string2 = "attribution";
        String string3 = "url";
        String string4 = "center";
        String string5 = "zoom";
        int size = 5;
        return io.circe.parser.package$.MODULE$.decode(str, Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("TileConfig", ExplorerModule::getTileConfig$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ExplorerModule::getTileConfig$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ExplorerModule::getTileConfig$$anonfun$3))))).toOption();
    }

    public Seq<Model.DatasetDefinition> merge(Seq<Model.DatasetDefinition> dds) {
        Seq ddPlainNames = (Seq)((IterableOps)dds.map((Function1 & Serializable)_$7 -> _$7.name())).filterNot((Function1 & Serializable)_$8 -> _$8.contains(":"));
        return (Seq)dds.map((Function1 & Serializable)dd -> {
            int idx = dd.name().indexOf(":");
            if (idx >= 0) {
                String dsName = dd.name().substring(0, idx);
                String subsetName = dd.name().substring(idx + 1);
                if (ddPlainNames.contains((Object)dsName)) {
                    return dd.copy(dsName, subsetName, dd.copy$default$3(), dd.copy$default$4());
                }
                return dd;
            }
            return dd;
        });
    }

    private final List tileConfigList$lzyINIT1$$anonfun$1() {
        return CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)this.ambience$gis$explorer$ExplorerModule$$projectConfig.pc().getList("modules.gis-explorer.tiles")).asScala().toList();
    }

    private static final List tileConfigList$lzyINIT1$$anonfun$2() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeDouble();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeDouble();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        void var3_2;
        void var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        String string = "lat";
        String string2 = "lng";
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ExplorerModule::$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        Encoder encoder3 = encodeA = Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeInt());
        return package$.MODULE$.Nil().$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final Task getGISExplorer$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponseT("Missing parameter 'id'");
    }

    /*
     * WARNING - void declaration
     */
    private static final List getDatasetsForId$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Data$.MODULE$.encodeSchema();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeBoolean();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeDouble();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeDouble();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$6() {
        ExplorerModule$Center$ explorerModule$Center$ = ExplorerModule$Center$.MODULE$;
        return (Function1 & Serializable)p -> (Center)explorerModule$Center$.fromProduct((Product)p);
    }

    private static final Product $anonfun$7() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getTileConfig$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var3_2;
        void var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        String string = "lat";
        String string2 = "lng";
        int size = 2;
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Center", ExplorerModule::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), ExplorerModule::$anonfun$6, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ExplorerModule::$anonfun$7)))));
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeInt());
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 getTileConfig$$anonfun$2() {
        ExplorerModule$TileConfig$ explorerModule$TileConfig$ = ExplorerModule$TileConfig$.MODULE$;
        return (Function1 & Serializable)p -> (TileConfig)explorerModule$TileConfig$.fromProduct((Product)p);
    }

    private static final Product getTileConfig$$anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    public static final class Center
    implements Product,
    Serializable {
        private final double lat;
        private final double lng;

        public static Center apply(double d, double d2) {
            return ExplorerModule$Center$.MODULE$.apply(d, d2);
        }

        public static Center fromProduct(Product product) {
            return ExplorerModule$Center$.MODULE$.fromProduct(product);
        }

        public static Center unapply(Center center) {
            return ExplorerModule$Center$.MODULE$.unapply(center);
        }

        public Center(double lat, double lng) {
            this.lat = lat;
            this.lng = lng;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.lat()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.lng()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Center)) return false;
            Center center = (Center)object;
            if (this.lat() != center.lat()) return false;
            if (this.lng() != center.lng()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Center;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Center";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "lat";
            }
            if (1 == n2) {
                return "lng";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double lat() {
            return this.lat;
        }

        public double lng() {
            return this.lng;
        }

        public Center copy(double lat, double lng) {
            return new Center(lat, lng);
        }

        public double copy$default$1() {
            return this.lat();
        }

        public double copy$default$2() {
            return this.lng();
        }

        public double _1() {
            return this.lat();
        }

        public double _2() {
            return this.lng();
        }
    }

    public static final class TileConfig
    implements Product,
    Serializable {
        private final String name;
        private final String attribution;
        private final String url;
        private final Option center;
        private final Option zoom;

        public static TileConfig apply(String string, String string2, String string3, Option<Center> option, Option<Object> option2) {
            return ExplorerModule$TileConfig$.MODULE$.apply(string, string2, string3, option, option2);
        }

        public static TileConfig fromProduct(Product product) {
            return ExplorerModule$TileConfig$.MODULE$.fromProduct(product);
        }

        public static TileConfig unapply(TileConfig tileConfig) {
            return ExplorerModule$TileConfig$.MODULE$.unapply(tileConfig);
        }

        public TileConfig(String name, String attribution, String url, Option<Center> center, Option<Object> zoom) {
            this.name = name;
            this.attribution = attribution;
            this.url = url;
            this.center = center;
            this.zoom = zoom;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TileConfig)) return false;
            TileConfig tileConfig = (TileConfig)object;
            String string = this.name();
            String string2 = tileConfig.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.attribution();
            String string4 = tileConfig.attribution();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.url();
            String string6 = tileConfig.url();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Option<Center> option = this.center();
            Option<Center> option2 = tileConfig.center();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.zoom();
            Option<Object> option4 = tileConfig.zoom();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TileConfig;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "TileConfig";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "attribution";
                }
                case 2: {
                    return "url";
                }
                case 3: {
                    return "center";
                }
                case 4: {
                    return "zoom";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String attribution() {
            return this.attribution;
        }

        public String url() {
            return this.url;
        }

        public Option<Center> center() {
            return this.center;
        }

        public Option<Object> zoom() {
            return this.zoom;
        }

        public TileConfig copy(String name, String attribution, String url, Option<Center> center, Option<Object> zoom) {
            return new TileConfig(name, attribution, url, center, zoom);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.attribution();
        }

        public String copy$default$3() {
            return this.url();
        }

        public Option<Center> copy$default$4() {
            return this.center();
        }

        public Option<Object> copy$default$5() {
            return this.zoom();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.attribution();
        }

        public String _3() {
            return this.url();
        }

        public Option<Center> _4() {
            return this.center();
        }

        public Option<Object> _5() {
            return this.zoom();
        }
    }
}

