/*
 * Decompiled with CFR 0.152.
 */
package ambience.usersettings;

import ambience.gravity.GravityHelper$;
import ambience.module.CustomOAuth2Client;
import ambience.module.UserDB;
import ambience.session.SessionManager;
import ambience.sso.client.ClientModel;
import ambience.sso.client.OAuth2CookieClient$;
import ambience.usersettings.ApprovalCode;
import ambience.usersettings.ApprovalCode$;
import ambience.usersettings.ChangePassword$;
import ambience.usersettings.ChangePassword$Email$;
import ambience.usersettings.ChangePassword$IdentityInfo$;
import ambience.usersettings.ChangePassword$PasswordChange$;
import ambience.usersettings.EmailTemplates$;
import ambience.usersettings.PasswordPolicyChecker$;
import ambience.usersettings.PolicyExplainer$;
import ambience.usersettings.UserSettingsModule;
import ambience.util.SharedCache;
import ambience.util.SharedCache$;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexUpdate;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityCookie;
import com.elixirtech.gravity.GravityCookie$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.identity.HashedString;
import com.elixirtech.identity.HashedString$;
import com.elixirtech.identity.UserManagement$;
import com.elixirtech.mail.MailAPI;
import com.elixirtech.mail.MailSender;
import com.elixirtech.webserver.I18N$;
import com.typesafe.config.Config;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.apache.commons.codec.binary.Base64;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple6$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Either$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ChangePassword
implements LoggingHelper2 {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(ChangePassword.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ChangePassword.class.getDeclaredField("userDB$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ChangePassword.class.getDeclaredField("identitiesT$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ChangePassword.class.getDeclaredField("passwordCacheT$lzy1"));
    private volatile Object log$lzy1;
    private final UserSettingsModule module;
    private CodexDB codexDB;
    private final Scheduler scheduler;
    private volatile Object passwordCacheT$lzy1;
    private volatile Object identitiesT$lzy1;
    private volatile Object userDB$lzy1;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ChangePassword$.class.getDeclaredField("PasswordChangeCacheDuration$lzy1"));

    public ChangePassword(UserSettingsModule module, CodexDB codexDB) {
        this.module = module;
        this.codexDB = codexDB;
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private Task<SharedCache<PasswordChange>> passwordCacheT() {
        Object object = this.passwordCacheT$lzy1;
        if (object instanceof Task) {
            return (Task)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Task)this.passwordCacheT$lzyINIT1();
    }

    private Object passwordCacheT$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.passwordCacheT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Task task = null;
                    try {
                        task = SharedCache$.MODULE$.apply("UserSettingsPasswordCodeMap", ChangePassword$.MODULE$.ambience$usersettings$ChangePassword$$$PasswordChangeCacheDuration()).memoize();
                        object2 = task == null ? LazyVals.NullValue$.MODULE$ : task;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.passwordCacheT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return task;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Task<CodexCollection> identitiesT() {
        Object object = this.identitiesT$lzy1;
        if (object instanceof Task) {
            return (Task)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Task)this.identitiesT$lzyINIT1();
    }

    private Object identitiesT$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.identitiesT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Task task = null;
                    try {
                        task = this.codexDB.getCodexCollection("Identities");
                        object2 = task == null ? LazyVals.NullValue$.MODULE$ : task;
                        this.codexDB = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.identitiesT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return task;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private UserDB userDB() {
        Object object = this.userDB$lzy1;
        if (object instanceof UserDB) {
            return (UserDB)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UserDB)this.userDB$lzyINIT1();
    }

    private Object userDB$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.userDB$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    UserDB userDB = null;
                    try {
                        userDB = (UserDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(UserDB.class));
                        object2 = userDB == null ? LazyVals.NullValue$.MODULE$ : userDB;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.userDB$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return userDB;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<GravityRoute> routes(UserDB.User user) {
        return (List)new .colon.colon((Object)GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "change-password", this.changePassword(user)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "change-password-code", this.changePasswordCode(user)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "test-policy", this.testPolicy(user)), (List)Nil$.MODULE$)));
    }

    public Function1<GravityRequest, Task<GravityResponse>> changePassword(UserDB.User user) {
        return GravityHelper$.MODULE$.formItems("password", "newPassword", (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                String password = (String)tuple2._1();
                String newPassword = (String)tuple2._2();
                return this.changePassword(user, password, newPassword);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> changePasswordCode(UserDB.User user) {
        return GravityHelper$.MODULE$.formItem("approval", (Function1 & Serializable)approval -> (Function1 & Serializable)_$1 -> this.validateApprovalAndGetInfo(user.id(), ApprovalCode$.MODULE$.apply((String)approval)).flatMap((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                PasswordChange info = (PasswordChange)((Some)option).value();
                return this.setPassword(info).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.userDB().getUserById(user.id()).map((Function1 & Serializable)_$2 -> (UserDB.User)_$2.getOrElse(() -> ChangePassword.changePasswordCode$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(user))).flatMap((Function1 & Serializable)user2 -> this.buildNewSession((UserDB.User)user2).map((Function1 & Serializable)cookie -> GravityResponse$.MODULE$.text("complete").withHeader(cookie.asSetCookieHeader())));
                });
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> ChangePassword.changePasswordCode$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(user), Line$.MODULE$.apply(73), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.changePasswordCode"));
                return Task$.MODULE$.apply(ChangePassword::changePasswordCode$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3);
            }
            throw new MatchError((Object)option);
        }));
    }

    public Task<GravityCookie> buildNewSession(UserDB.User user) {
        SessionManager sessionManager = (SessionManager)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(SessionManager.class));
        return sessionManager.createSession(ClientModel.RequestInfo$.MODULE$.apply((Option)None$.MODULE$, "change-password"), user).map((Function1 & Serializable)sessionId -> this.buildNewSession$$anonfun$1(user, sessionId == null ? null : ((SessionManager.SessionId)sessionId).value()));
    }

    public GravityCookie buildCookie(String sessionId, String sub) {
        CustomOAuth2Client.SessionData sessionData = (CustomOAuth2Client.SessionData)package$.MODULE$.EncoderOps((Object)CustomOAuth2Client.SessionData$.MODULE$.apply(sessionId, sub));
        String string = "uuid";
        String string2 = "name";
        String cookieValue = package.EncoderOps$.MODULE$.asJson$extension((Object)sessionData, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ChangePassword::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))).noSpaces();
        this.log().info(() -> ChangePassword.buildCookie$$anonfun$1(cookieValue), Line$.MODULE$.apply(91), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.buildCookie"));
        return this.buildCookie(OAuth2CookieClient$.MODULE$.CookieName(), this.encodeB64(cookieValue), (Option<Object>)None$.MODULE$);
    }

    public GravityCookie buildCookie(String name, String value, Option<Object> optMaxAge) {
        Config config = OAuth2CookieClient$.MODULE$.config();
        String CookieSameSite = config.getString("cookie-same-site");
        boolean CookieSecure = config.getBoolean("cookie-secure");
        String CookieExtensions = config.getString("cookie-extensions");
        this.log().info(() -> ChangePassword.buildCookie$$anonfun$2(name, value, optMaxAge), Line$.MODULE$.apply(101), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.buildCookie"));
        ListBuffer buffer = new ListBuffer();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(CookieSameSite))) {
            buffer.append((Object)("SameSite=" + CookieSameSite));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(CookieExtensions))) {
            buffer.append((Object)CookieExtensions);
        }
        None$ extension = buffer.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)buffer.mkString("; "));
        return GravityCookie$.MODULE$.apply(name, value, optMaxAge, (Option)Some$.MODULE$.apply((Object)"/"), CookieSecure, true, (Option)extension);
    }

    public Option<Object> buildCookie$default$3() {
        return None$.MODULE$;
    }

    public String encodeB64(String str) {
        byte[] bytes = str.getBytes(Crypt$.MODULE$.DEFAULT_ENCODING());
        return new String(Base64.encodeBase64((byte[])bytes, (boolean)false, (boolean)true), Crypt$.MODULE$.DEFAULT_ENCODING());
    }

    public Function1<GravityRequest, Task<GravityResponse>> testPolicy(UserDB.User user) {
        return GravityHelper$.MODULE$.formItem("candidate", (Function1 & Serializable)test -> (Function1 & Serializable)request -> {
            String language = I18N$.MODULE$.getAcceptLanguage(request);
            Task tMessage = PasswordPolicyChecker$.MODULE$.check(user.name(), (String)test).map((Function1 & Serializable)_$3 -> PolicyExplainer$.MODULE$.apply(language, (Either<Object, HashedString>)_$3));
            return tMessage.map((Function1 & Serializable)s -> GravityResponse$.MODULE$.text(s));
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> changePassword(UserDB.User user, String password, String newPassword) {
        return (Function1 & Serializable)_$4 -> {
            Task tCode = PasswordPolicyChecker$.MODULE$.check(user.name(), newPassword).map((Function1 & Serializable)_$5 -> {
                Either either = Either$.MODULE$.MergeableEither(_$5.map((Function1 & Serializable)_$6 -> ChangePassword.$anonfun$3$$anonfun$1(_$6 == null ? null : ((HashedString)_$6).value())));
                return BoxesRunTime.unboxToInt((Object)Either.MergeableEither$.MODULE$.merge$extension(either));
            });
            return tCode.flatMap((Function1 & Serializable)code -> this.changePassword$$anonfun$2$$anonfun$1(user, password, newPassword, BoxesRunTime.unboxToInt((Object)code))).onErrorRecover((PartialFunction)new Serializable(user, this){
                private final UserDB.User user$16;
                private final /* synthetic */ ChangePassword $outer;
                {
                    this.user$16 = user$29;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable ex = throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable ex = throwable;
                        String errorId = "ERR" + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(UUID.randomUUID().toString()), 8);
                        this.$outer.log().error(() -> this.applyOrElse$$anonfun$1(errorId, ex), ex, Line$.MODULE$.apply(153), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.changePassword"));
                        DataBytes msg = DataBytes$.MODULE$.apply("Unable to change password due to internal error. Search server log for " + errorId + " for details.");
                        int n = Gravity.Status$.MODULE$.InternalServerError();
                        Gravity.Headers headers = GravityResponse$.MODULE$.$lessinit$greater$default$2();
                        return GravityResponse$.MODULE$.apply(n, headers, msg);
                    }
                    return function1.apply((Object)x);
                }

                private final Object applyOrElse$$anonfun$1(String errorId$1, Throwable ex$1) {
                    return "changePassword error " + errorId$1 + " for " + this.user$16.name() + ": " + ex$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.String java.lang.Throwable )}, serializedLambda);
                }
            });
        };
    }

    public Task<GravityResponse> changePasswordId(UserDB.User user, String newPassword, IdentityInfo info) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> new ApprovalCode(ChangePassword.changePasswordId$$anonfun$1())).flatMap((Function1 & Serializable)code -> this.changePasswordId$$anonfun$2(user, newPassword, info, code == null ? null : ((ApprovalCode)code).value()));
    }

    public Task<GravityResponse> changePasswordNoCode(UserDB.User user, String newPassword, IdentityInfo info) {
        String newHashPassword = UserManagement$.MODULE$.encrypt(info.identityId(), newPassword);
        PasswordChange pc = ChangePassword$PasswordChange$.MODULE$.apply(System.currentTimeMillis(), user.id(), info.identityId(), info.hashPassword(), newHashPassword, ApprovalCode$.MODULE$.apply("0000"));
        return this.setPassword(pc).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.userDB().getUserById(user.id()).map((Function1 & Serializable)_$7 -> (UserDB.User)_$7.getOrElse(() -> ChangePassword.changePasswordNoCode$$anonfun$1$$anonfun$1$$anonfun$1(user))).flatMap((Function1 & Serializable)user2 -> this.buildNewSession((UserDB.User)user2).map((Function1 & Serializable)cookie -> GravityResponse$.MODULE$.text("complete-no-code").withHeader(cookie.asSetCookieHeader())));
        });
    }

    public Task<BoxedUnit> addToCache(UserDB.User user, String newPassword, IdentityInfo info, String code) {
        String newHashPassword = UserManagement$.MODULE$.encrypt(info.identityId(), newPassword);
        return this.passwordCacheT().flatMap((Function1 & Serializable)passwordCache -> {
            PasswordChange pc = ChangePassword$PasswordChange$.MODULE$.apply(System.currentTimeMillis(), user.id(), info.identityId(), info.hashPassword(), newHashPassword, code);
            String string = "when";
            String string2 = "userid";
            String string3 = "identityId";
            String string4 = "oldHashPassword";
            String string5 = "newHashPassword";
            String string6 = "approvalCode";
            return passwordCache.put(code, (Object)pc, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ChangePassword::addToCache$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        });
    }

    public Task<GravityResponse> failed(UserDB.User user) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.failed$$anonfun$1(user);
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable)_$8 -> GravityResponse$.MODULE$.text("invalid-password"));
    }

    public Task<Option<IdentityInfo>> validatePasswordAndGetIdentityInfo(String username, String password) {
        this.log().info(() -> ChangePassword.validatePasswordAndGetIdentityInfo$$anonfun$1(username), Line$.MODULE$.apply(191), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.validatePasswordAndGetIdentityInfo"));
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(username)), CodexFilter.Eq$.MODULE$.apply("enabled", (BsonValue)BsonBoolean$.MODULE$.apply(true))}));
        return this.identitiesT().flatMap((Function1 & Serializable)_$9 -> _$9.findO((CodexFilter)filter).firstOptionL().map((Function1 & Serializable)optDoc -> {
            Option optInfo = optDoc.flatMap((Function1 & Serializable)doc -> doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).map((Function1 & Serializable)_$10 -> _$10.getValue().toHexString()).flatMap((Function1 & Serializable)identityId -> doc.get("password", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> new HashedString(HashedString$.MODULE$.apply(s.getValue()))).flatMap((Function1 & Serializable)hashPassword -> ChangePassword.$anonfun$4$$anonfun$2$$anonfun$2(doc, identityId, hashPassword == null ? null : ((HashedString)hashPassword).value()))));
            return optInfo.flatMap((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    String identityId = (String)tuple3._1();
                    String hashPassword = tuple3._2() == null ? null : ((HashedString)tuple3._2()).value();
                    String email = tuple3._3() == null ? null : ((Email)tuple3._3()).value();
                    this.log().info(() -> ChangePassword.validatePasswordAndGetIdentityInfo$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(identityId, hashPassword), Line$.MODULE$.apply(201), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.validatePasswordAndGetIdentityInfo"));
                    if (UserManagement$.MODULE$.validate(identityId, password.trim(), hashPassword)) {
                        return Some$.MODULE$.apply((Object)ChangePassword$IdentityInfo$.MODULE$.apply(identityId, hashPassword, email));
                    }
                    return None$.MODULE$;
                }
                throw new MatchError((Object)tuple3);
            });
        }));
    }

    public void sendEmail(UserDB.User user, String email, String code) {
        this.log().info(() -> ChangePassword.sendEmail$$anonfun$1(user, email), Line$.MODULE$.apply(210), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.sendEmail"));
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)user.name());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"email");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)email);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)code);
        Map lookup = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        String subject = EmailTemplates$.MODULE$.ChangePasswordTemplate().subjectTemplate().substitute(lookup.lift());
        String body = EmailTemplates$.MODULE$.ChangePasswordTemplate().bodyTemplate().substitute(lookup.lift());
        List list = (List)new .colon.colon((Object)email, (List)Nil$.MODULE$);
        List list2 = MailAPI.Mail$.MODULE$.$lessinit$greater$default$2();
        List list3 = MailAPI.Mail$.MODULE$.$lessinit$greater$default$3();
        List list4 = MailAPI.Mail$.MODULE$.$lessinit$greater$default$6();
        MailAPI.Mail mail = MailAPI.Mail$.MODULE$.apply(list, list2, list3, subject, body, list4);
        ((MailSender)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MailSender.class))).send(mail);
    }

    public Task<Option<PasswordChange>> validateApprovalAndGetInfo(String userid, String code) {
        return this.passwordCacheT().flatMap((Function1 & Serializable)passwordCache -> {
            String string = "when";
            String string2 = "userid";
            String string3 = "identityId";
            String string4 = "oldHashPassword";
            String string5 = "newHashPassword";
            String string6 = "approvalCode";
            int size = 6;
            return passwordCache.get(code, Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("PasswordChange", ChangePassword::validateApprovalAndGetInfo$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ChangePassword::validateApprovalAndGetInfo$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ChangePassword::validateApprovalAndGetInfo$$anonfun$1$$anonfun$3))))).flatMap((Function1 & Serializable)optInfo -> {
                Task task;
                Option option = optInfo;
                if (option instanceof Some) {
                    PasswordChange info = (PasswordChange)((Some)option).value();
                    String string = info.userid();
                    String string2 = userid;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        task = passwordCache.remove(code).map((Function1 & Serializable)_$11 -> Some$.MODULE$.apply((Object)info));
                        return task.map((Function1 & Serializable)ret -> ret);
                    }
                }
                task = Task$.MODULE$.now((Object)None$.MODULE$);
                return task.map((Function1 & Serializable)ret -> ret);
            });
        });
    }

    public Task<BoxedUnit> setPassword(PasswordChange info) {
        this.log().info(() -> ChangePassword.setPassword$$anonfun$1(info), Line$.MODULE$.apply(231), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.setPassword"));
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.module.maxDifferentPasswordCount()));
        Some some2 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
        CodexUpdate.PushOptions pushOptions = CodexUpdate.PushOptions$.MODULE$.apply((Option)some2, (Option)some);
        CodexUpdate.Combine updates = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("password", (BsonValue)BsonString$.MODULE$.apply(info.newHashPassword())), CodexUpdate.Set$.MODULE$.apply("lastPasswordChange", (BsonValue)BsonDateTime$.MODULE$.apply(System.currentTimeMillis())), CodexUpdate.PushEach$.MODULE$.apply("oldPasswords", pushOptions, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonValue[]{BsonString$.MODULE$.apply(info.oldHashPassword())})), CodexUpdate.Set$.MODULE$.apply("changePassword", (BsonValue)BsonBoolean$.MODULE$.apply(false))}));
        return this.identitiesT().flatMap((Function1 & Serializable)_$12 -> _$12.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonObjectId$.MODULE$.apply(info.identityId())), (CodexUpdate)updates).map((Function1)(JProcedure1 & Serializable)reply -> {
            if (reply.getMatchedCount() == 1L) {
                this.log().info(ChangePassword::setPassword$$anonfun$2$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(241), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.setPassword"));
                return;
            }
            this.log().warn(() -> ChangePassword.setPassword$$anonfun$2$$anonfun$1$$anonfun$2(info, reply), Line$.MODULE$.apply(242), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.setPassword"));
        }));
    }

    private static final UserDB.User changePasswordCode$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$7) {
        return user$7;
    }

    private static final Object changePasswordCode$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(UserDB.User user$8) {
        return "Invalid password approval code for " + user$8.name();
    }

    private static final GravityResponse changePasswordCode$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3() {
        return GravityResponse$.MODULE$.text("invalid-code");
    }

    private static final Object buildNewSession$$anonfun$1$$anonfun$1(UserDB.User user$10, String sessionId$1) {
        return "Created new session for " + user$10.name() + ": " + sessionId$1;
    }

    private final /* synthetic */ GravityCookie buildNewSession$$anonfun$1(UserDB.User user$9, String sessionId) {
        this.log().info(() -> ChangePassword.buildNewSession$$anonfun$1$$anonfun$1(user$9, sessionId), Line$.MODULE$.apply(83), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.buildNewSession"));
        return this.buildCookie(sessionId, user$9.name());
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Object buildCookie$$anonfun$1(String cookieValue$1) {
        return "Cookie: " + cookieValue$1;
    }

    private static final Object buildCookie$$anonfun$2(String name$1, String value$1, Option optMaxAge$1) {
        return "buildCookie " + name$1 + " " + value$1 + " " + optMaxAge$1;
    }

    private static final /* synthetic */ int $anonfun$3$$anonfun$1(String _$6) {
        return 0;
    }

    private final /* synthetic */ Task changePassword$$anonfun$2$$anonfun$1(UserDB.User user$14, String password$2, String newPassword$2, int code) {
        if (code == 0) {
            return this.validatePasswordAndGetIdentityInfo(user$14.name(), password$2).flatMap((Function1 & Serializable)optInfo -> {
                Task<GravityResponse> task;
                Option option = optInfo;
                if (option instanceof Some) {
                    IdentityInfo info = (IdentityInfo)((Some)option).value();
                    task = ChangePassword$.MODULE$.ambience$usersettings$ChangePassword$$$PasswordChangeCacheDuration() == 0 ? this.changePasswordNoCode(user$14, newPassword$2, info) : this.changePasswordId(user$14, newPassword$2, info);
                } else if (None$.MODULE$.equals(option)) {
                    task = this.failed(user$14);
                } else {
                    throw new MatchError((Object)option);
                }
                return task.map((Function1 & Serializable)ret -> ret);
            });
        }
        return Task$.MODULE$.now((Object)GravityResponse$.MODULE$.text("failed-policy: " + code));
    }

    private static final String changePasswordId$$anonfun$1() {
        return ApprovalCode$.MODULE$.generate();
    }

    private final void changePasswordId$$anonfun$2$$anonfun$1$$anonfun$1(UserDB.User user$19, IdentityInfo info$3, String code$2) {
        this.sendEmail(user$19, info$3.email(), code$2);
    }

    private final /* synthetic */ Task changePasswordId$$anonfun$2(UserDB.User user$17, String newPassword$4, IdentityInfo info$1, String code) {
        return this.addToCache(user$17, newPassword$4, info$1, code).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.changePasswordId$$anonfun$2$$anonfun$1$$anonfun$1(user$17, info$1, code);
                return BoxedUnit.UNIT;
            }).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return GravityResponse$.MODULE$.text("get-approval");
            });
        });
    }

    private static final UserDB.User changePasswordNoCode$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$22) {
        return user$22;
    }

    /*
     * WARNING - void declaration
     */
    private static final List addToCache$$anonfun$1$$anonfun$1() {
        Encoder<ApprovalCode> encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeLong();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder<ApprovalCode> encoder4 = encodeA = ApprovalCode$.MODULE$.encoder();
        return scala.package$.MODULE$.Nil().$colon$colon(encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Object failed$$anonfun$1$$anonfun$1(UserDB.User user$25) {
        return "Invalid old password for " + user$25.name();
    }

    private final void failed$$anonfun$1(UserDB.User user$24) {
        this.log().warn(() -> ChangePassword.failed$$anonfun$1$$anonfun$1(user$24), Line$.MODULE$.apply(187), FullName$.MODULE$.apply("ambience.usersettings.ChangePassword.failed"));
    }

    private static final Object validatePasswordAndGetIdentityInfo$$anonfun$1(String username$1) {
        return "Validating password for " + username$1;
    }

    private static final /* synthetic */ Option $anonfun$4$$anonfun$2$$anonfun$2(Document doc$2, String identityId$1, String hashPassword) {
        return doc$2.get("email", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> new Email(ChangePassword$Email$.MODULE$.apply(s.getValue()))).map((Function1 & Serializable)email -> Tuple3$.MODULE$.apply((Object)identityId$1, (Object)new HashedString(hashPassword), (Object)new Email(email == null ? null : ((Email)email).value())));
    }

    private static final Object validatePasswordAndGetIdentityInfo$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(String identityId$3, String hashPassword$2) {
        return "Comparing " + identityId$3 + " with " + new HashedString(hashPassword$2);
    }

    private static final Object sendEmail$$anonfun$1(UserDB.User user$26, String email$1) {
        return "sendEmail(" + user$26 + "," + new Email(email$1) + ".value)";
    }

    /*
     * WARNING - void declaration
     */
    private static final List validateApprovalAndGetInfo$$anonfun$1$$anonfun$1() {
        Decoder<ApprovalCode> decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeLong();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder<ApprovalCode> decoder4 = decodeA = ApprovalCode$.MODULE$.decoder();
        return scala.package$.MODULE$.Nil().$colon$colon(decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 validateApprovalAndGetInfo$$anonfun$1$$anonfun$2() {
        ChangePassword$PasswordChange$ changePassword$PasswordChange$ = ChangePassword$PasswordChange$.MODULE$;
        return (Function1 & Serializable)p -> (PasswordChange)changePassword$PasswordChange$.fromProduct((Product)p);
    }

    private static final Product validateApprovalAndGetInfo$$anonfun$1$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object setPassword$$anonfun$1(PasswordChange info$6) {
        return "Approval received, setting " + info$6.userid() + " with identity " + info$6.identityId() + " to new password";
    }

    private static final Object setPassword$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "Password changed successfully";
    }

    private static final Object setPassword$$anonfun$2$$anonfun$1$$anonfun$2(PasswordChange info$9, CodexDB.UpdateResult reply$1) {
        return "Password change " + info$9.identityId() + " match count=" + reply$1.getMatchedCount();
    }

    public static final class Email
    implements Product,
    Serializable {
        private final String value;

        public static String apply(String string) {
            return ChangePassword$Email$.MODULE$.apply(string);
        }

        public static String unapply(String string) {
            return ChangePassword$Email$.MODULE$.unapply(string);
        }

        public static String _1$extension(String string) {
            return ChangePassword$Email$.MODULE$._1$extension(string);
        }

        public static boolean canEqual$extension(String string, Object object) {
            return ChangePassword$Email$.MODULE$.canEqual$extension(string, object);
        }

        public static String copy$extension(String string, String string2) {
            return ChangePassword$Email$.MODULE$.copy$extension(string, string2);
        }

        public static boolean equals$extension(String string, Object object) {
            return ChangePassword$Email$.MODULE$.equals$extension(string, object);
        }

        public static int hashCode$extension(String string) {
            return ChangePassword$Email$.MODULE$.hashCode$extension(string);
        }

        public static int productArity$extension(String string) {
            return ChangePassword$Email$.MODULE$.productArity$extension(string);
        }

        public static Object productElement$extension(String string, int n) {
            return ChangePassword$Email$.MODULE$.productElement$extension(string, n);
        }

        public static String productElementName$extension(String string, int n) {
            return ChangePassword$Email$.MODULE$.productElementName$extension(string, n);
        }

        public static String productPrefix$extension(String string) {
            return ChangePassword$Email$.MODULE$.productPrefix$extension(string);
        }

        public static String toString$extension(String string) {
            return ChangePassword$Email$.MODULE$.toString$extension(string);
        }

        public static String copy$default$1$extension(String string) {
            return ChangePassword$Email$.MODULE$.copy$default$1$extension(string);
        }

        public Email(String value) {
            this.value = value;
        }

        public int hashCode() {
            return ChangePassword$Email$.MODULE$.hashCode$extension(this.value());
        }

        public boolean equals(Object x$0) {
            return ChangePassword$Email$.MODULE$.equals$extension(this.value(), x$0);
        }

        public String toString() {
            return ChangePassword$Email$.MODULE$.toString$extension(this.value());
        }

        public boolean canEqual(Object that) {
            return ChangePassword$Email$.MODULE$.canEqual$extension(this.value(), that);
        }

        public int productArity() {
            return ChangePassword$Email$.MODULE$.productArity$extension(this.value());
        }

        public String productPrefix() {
            return ChangePassword$Email$.MODULE$.productPrefix$extension(this.value());
        }

        public Object productElement(int n) {
            return ChangePassword$Email$.MODULE$.productElement$extension(this.value(), n);
        }

        public String productElementName(int n) {
            return ChangePassword$Email$.MODULE$.productElementName$extension(this.value(), n);
        }

        public String value() {
            return this.value;
        }

        public String copy(String value) {
            return ChangePassword$Email$.MODULE$.copy$extension(this.value(), value);
        }

        public String copy$default$1() {
            return ChangePassword$Email$.MODULE$.copy$default$1$extension(this.value());
        }

        public String _1() {
            return ChangePassword$Email$.MODULE$._1$extension(this.value());
        }
    }

    public static final class IdentityInfo
    implements Product,
    Serializable {
        private final String identityId;
        private final String hashPassword;
        private final String email;

        public static IdentityInfo apply(String string, String string2, String string3) {
            return ChangePassword$IdentityInfo$.MODULE$.apply(string, string2, string3);
        }

        public static IdentityInfo fromProduct(Product product) {
            return ChangePassword$IdentityInfo$.MODULE$.fromProduct(product);
        }

        public static IdentityInfo unapply(IdentityInfo identityInfo) {
            return ChangePassword$IdentityInfo$.MODULE$.unapply(identityInfo);
        }

        public IdentityInfo(String identityId, String hashPassword, String email) {
            this.identityId = identityId;
            this.hashPassword = hashPassword;
            this.email = email;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IdentityInfo)) return false;
            IdentityInfo identityInfo = (IdentityInfo)object;
            String string = this.identityId();
            String string2 = identityInfo.identityId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.hashPassword();
            String string4 = identityInfo.hashPassword();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.email();
            String string6 = identityInfo.email();
            if (string5 == null) {
                if (string6 == null) return true;
                return false;
            } else {
                if (!string5.equals(string6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IdentityInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "IdentityInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return new Email(this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "identityId";
                }
                case 1: {
                    return "hashPassword";
                }
                case 2: {
                    return "email";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String identityId() {
            return this.identityId;
        }

        public String hashPassword() {
            return this.hashPassword;
        }

        public String email() {
            return this.email;
        }

        public IdentityInfo copy(String identityId, String hashPassword, String email) {
            return new IdentityInfo(identityId, hashPassword, email);
        }

        public String copy$default$1() {
            return this.identityId();
        }

        public String copy$default$2() {
            return this.hashPassword();
        }

        public String copy$default$3() {
            return this.email();
        }

        public String _1() {
            return this.identityId();
        }

        public String _2() {
            return this.hashPassword();
        }

        public String _3() {
            return this.email();
        }
    }

    public static final class PasswordChange
    implements Product,
    Serializable {
        private final long when;
        private final String userid;
        private final String identityId;
        private final String oldHashPassword;
        private final String newHashPassword;
        private final String approvalCode;

        public static PasswordChange apply(long l, String string, String string2, String string3, String string4, String string5) {
            return ChangePassword$PasswordChange$.MODULE$.apply(l, string, string2, string3, string4, string5);
        }

        public static PasswordChange fromProduct(Product product) {
            return ChangePassword$PasswordChange$.MODULE$.fromProduct(product);
        }

        public static PasswordChange unapply(PasswordChange passwordChange) {
            return ChangePassword$PasswordChange$.MODULE$.unapply(passwordChange);
        }

        public PasswordChange(long when, String userid, String identityId, String oldHashPassword, String newHashPassword, String approvalCode) {
            this.when = when;
            this.userid = userid;
            this.identityId = identityId;
            this.oldHashPassword = oldHashPassword;
            this.newHashPassword = newHashPassword;
            this.approvalCode = approvalCode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.when()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.userid()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.identityId()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.oldHashPassword()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.newHashPassword()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new ApprovalCode(this.approvalCode())));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PasswordChange)) return false;
            PasswordChange passwordChange = (PasswordChange)object;
            if (this.when() != passwordChange.when()) return false;
            String string = this.userid();
            String string2 = passwordChange.userid();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.identityId();
            String string4 = passwordChange.identityId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.oldHashPassword();
            String string6 = passwordChange.oldHashPassword();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.newHashPassword();
            String string8 = passwordChange.newHashPassword();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.approvalCode();
            String string10 = passwordChange.approvalCode();
            if (string9 == null) {
                if (string10 == null) return true;
                return false;
            } else {
                if (!string9.equals(string10)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PasswordChange;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "PasswordChange";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return new ApprovalCode(this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "when";
                }
                case 1: {
                    return "userid";
                }
                case 2: {
                    return "identityId";
                }
                case 3: {
                    return "oldHashPassword";
                }
                case 4: {
                    return "newHashPassword";
                }
                case 5: {
                    return "approvalCode";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long when() {
            return this.when;
        }

        public String userid() {
            return this.userid;
        }

        public String identityId() {
            return this.identityId;
        }

        public String oldHashPassword() {
            return this.oldHashPassword;
        }

        public String newHashPassword() {
            return this.newHashPassword;
        }

        public String approvalCode() {
            return this.approvalCode;
        }

        public PasswordChange copy(long when, String userid, String identityId, String oldHashPassword, String newHashPassword, String approvalCode) {
            return new PasswordChange(when, userid, identityId, oldHashPassword, newHashPassword, approvalCode);
        }

        public long copy$default$1() {
            return this.when();
        }

        public String copy$default$2() {
            return this.userid();
        }

        public String copy$default$3() {
            return this.identityId();
        }

        public String copy$default$4() {
            return this.oldHashPassword();
        }

        public String copy$default$5() {
            return this.newHashPassword();
        }

        public String copy$default$6() {
            return this.approvalCode();
        }

        public long _1() {
            return this.when();
        }

        public String _2() {
            return this.userid();
        }

        public String _3() {
            return this.identityId();
        }

        public String _4() {
            return this.oldHashPassword();
        }

        public String _5() {
            return this.newHashPassword();
        }

        public String _6() {
            return this.approvalCode();
        }
    }
}

