/*
 * Decompiled with CFR 0.152.
 */
package ambience.ldapsso;

import ambience.ldapsso.GroupLookup;
import ambience.ldapsso.LDAPBindLookup;
import ambience.ldapsso.LDAPConfigLoader$;
import ambience.ldapsso.LDAPDirectLookup;
import ambience.ldapsso.LDAPFailLookup$;
import ambience.ldapsso.LDAPLookup;
import ambience.ldapsso.LDAPUserDB;
import ambience.simplesso.server.ServerModel;
import ambience.simplesso.server.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.typesafe.config.Config;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichChar$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class LDAPCoreUserDB
implements UserDB,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LDAPCoreUserDB.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Option optLdapConfig;
    private final Option optGroupLookup;
    private final LDAPLookup lookup;

    public LDAPCoreUserDB(Config ldapConfig) {
        LDAPLookup lDAPLookup;
        Option option;
        LDAPCoreUserDB lDAPCoreUserDB = this;
        try {
            option = Option$.MODULE$.apply((Object)LDAPConfigLoader$.MODULE$.load(ldapConfig));
        }
        catch (Throwable ex) {
            this.log().error(() -> LDAPCoreUserDB.$init$$$anonfun$1(ex), ex, Line$.MODULE$.apply(16), FullName$.MODULE$.apply("ambience.ldapsso.LDAPCoreUserDB.optLdapConfig"));
            this.log().error(LDAPCoreUserDB::$init$$$anonfun$2, Line$.MODULE$.apply(17), FullName$.MODULE$.apply("ambience.ldapsso.LDAPCoreUserDB.optLdapConfig"));
            option = None$.MODULE$;
        }
        Option option2 = option;
        LDAPCoreUserDB lDAPCoreUserDB2 = lDAPCoreUserDB;
        lDAPCoreUserDB = null;
        Option option3 = option2;
        option2 = null;
        lDAPCoreUserDB2.optLdapConfig = option3;
        this.optGroupLookup = this.optLdapConfig().map((Function1 & Serializable)_$1 -> new GroupLookup((LDAPUserDB.LDAPConfig)_$1));
        Option<LDAPUserDB.LDAPConfig> option4 = this.optLdapConfig();
        if (option4 instanceof Some) {
            LDAPUserDB.LDAPConfig lDAPConfig = (LDAPUserDB.LDAPConfig)((Some)option4).value();
            LDAPUserDB.LDAPConfig config = lDAPConfig;
            if (config.bind().hasContent()) {
                lDAPLookup = new LDAPBindLookup(config);
            } else {
                LDAPUserDB.LDAPConfig config2 = lDAPConfig;
                lDAPLookup = new LDAPDirectLookup(config2);
            }
        } else if (None$.MODULE$.equals(option4)) {
            lDAPLookup = LDAPFailLookup$.MODULE$;
        } else {
            throw new MatchError(option4);
        }
        this.lookup = lDAPLookup;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<LDAPUserDB.LDAPConfig> optLdapConfig() {
        return this.optLdapConfig;
    }

    public Option<GroupLookup> optGroupLookup() {
        return this.optGroupLookup;
    }

    public LDAPLookup lookup() {
        return this.lookup;
    }

    public Task<Option<ServerModel.UserRecord>> matches(String name, String password, String totp) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(totp.trim()))) {
            this.log().error(LDAPCoreUserDB::matches$$anonfun$1, Line$.MODULE$.apply(32), FullName$.MODULE$.apply("ambience.ldapsso.LDAPCoreUserDB.matches"));
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        Option<ServerModel.Username> option = this.safe(name);
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            String safeName = object == null ? null : ((ServerModel.Username)object).value();
            return this.lookup().matches(safeName, password);
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public List<String> groups(String name) {
        return (List)this.optGroupLookup().map((Function1 & Serializable)_$2 -> _$2.run(name)).getOrElse(LDAPCoreUserDB::groups$$anonfun$2);
    }

    public boolean isAllowedInName(char ch) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(ch)) || ch == '-' || ch == '_' || ch == '@' || ch == '.';
    }

    public Option<ServerModel.Username> safe(String name) {
        String newName;
        String string = newName = ServerModel.Username$.MODULE$.apply(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)ch -> this.$anonfun$1(BoxesRunTime.unboxToChar((Object)ch))));
        String string2 = name;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.log().info(() -> LDAPCoreUserDB.safe$$anonfun$1(name), Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.ldapsso.LDAPCoreUserDB.safe"));
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)new ServerModel.Username(name));
    }

    private static final Object $init$$$anonfun$1(Throwable ex$1) {
        return "Error loading LDAPConfig: " + ex$1;
    }

    private static final Object $init$$$anonfun$2() {
        return "All logins will fail";
    }

    private static final Object matches$$anonfun$1() {
        return "TOTP must be empty for LDAP integration";
    }

    private static final List groups$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final /* synthetic */ boolean $anonfun$1(char ch) {
        return this.isAllowedInName(ch);
    }

    private static final Object safe$$anonfun$1(String name$2) {
        return "Name " + new ServerModel.Username(name$2) + " contains invalid characters";
    }
}

