/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import io.circe.Decoder;
import io.circe.Error;
import io.circe.parser.package$;
import java.io.Serializable;
import java.util.Map;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class ConfigUtil$
implements Serializable {
    private static final ConfigRenderOptions jsonOptions;
    public static final ConfigUtil$ MODULE$;

    private ConfigUtil$() {
    }

    static {
        MODULE$ = new ConfigUtil$();
        jsonOptions = ConfigRenderOptions.defaults().setJson(true).setComments(false).setOriginComments(false);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ConfigUtil$.class);
    }

    public ConfigRenderOptions jsonOptions() {
        return jsonOptions;
    }

    public <T> Either<Error, T> decode(Config config, Decoder<T> decoder) {
        return package$.MODULE$.decode(config.root().render(this.jsonOptions()), decoder);
    }

    public Map<String, String> getStringMap(Config config, String name) {
        Config all = config.getConfig(name);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(config.getObject(name).keySet()).asScala().map((Function1 & Serializable)key -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(key);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)all.getString(key));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Config> getConfigMap(Config config, String name) {
        Config all = config.getConfig(name);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(config.getObject(name).keySet()).asScala().map((Function1 & Serializable)key -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(key);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)all.getConfig(key));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, String> getStringMap(Config config) {
        Set keys = this.collectKeys$1(config.root(), "", Predef$.MODULE$.Set().empty());
        return ((IterableOnceOps)keys.map((Function1 & Serializable)key -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(key);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)config.getString(key));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final Set collectKeys$1(ConfigObject c, String prefix, Set keys) {
        Set result = keys;
        for (Map.Entry entry : c.entrySet()) {
            ConfigValue configValue = (ConfigValue)entry.getValue();
            if (configValue instanceof ConfigObject) {
                ConfigObject o = (ConfigObject)configValue;
                result = (Set)result.$plus$plus((IterableOnce)this.collectKeys$1(o, prefix + entry.getKey() + ".", Predef$.MODULE$.Set().empty()));
                continue;
            }
            if (configValue != null) {
                result = (Set)result.$plus((Object)(prefix + entry.getKey()));
                continue;
            }
            throw new MatchError((Object)configValue);
        }
        return result;
    }
}

