/*
 * Decompiled with CFR 0.152.
 */
package monix.kafka;

import java.io.Serializable;
import java.time.Duration;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.kafka.KafkaConsumerConfig;
import monix.kafka.KafkaConsumerObservable;
import monix.kafka.config.ObservableCommitType;
import monix.kafka.config.ObservableCommitType$Async$;
import monix.kafka.config.ObservableCommitType$Sync$;
import monix.reactive.Observable;
import monix.reactive.Observer;
import monix.reactive.Observer$;
import monix.reactive.observers.Subscriber;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class KafkaConsumerObservableAutoCommit<K, V>
extends Observable<ConsumerRecord<K, V>>
implements KafkaConsumerObservable<K, V, ConsumerRecord<K, V>> {
    private final KafkaConsumerConfig config;
    private final Task consumer;
    private final long pollTimeoutMillis;
    private final boolean shouldCommitBefore;
    private final boolean shouldCommitAfter;

    public KafkaConsumerObservableAutoCommit(KafkaConsumerConfig config, Task<KafkaConsumer<K, V>> consumer) {
        this.config = config;
        this.consumer = consumer;
        this.pollTimeoutMillis = config.fetchMaxWaitTime().toMillis();
        this.shouldCommitBefore = !config.enableAutoCommit() && config.observableCommitOrder().isBefore();
        this.shouldCommitAfter = !config.enableAutoCommit() && config.observableCommitOrder().isAfter();
    }

    @Override
    public KafkaConsumerConfig config() {
        return this.config;
    }

    @Override
    public Task<KafkaConsumer<K, V>> consumer() {
        return this.consumer;
    }

    private void consumerCommit(KafkaConsumer<K, V> consumer) {
        ObservableCommitType observableCommitType = this.config().observableCommitType();
        if (ObservableCommitType$Sync$.MODULE$.equals(observableCommitType)) {
            package$.MODULE$.blocking((Function0 & Serializable)() -> {
                KafkaConsumerObservableAutoCommit.consumerCommit$$anonfun$1(consumer);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ObservableCommitType$Async$.MODULE$.equals(observableCommitType)) {
            package$.MODULE$.blocking((Function0 & Serializable)() -> {
                KafkaConsumerObservableAutoCommit.consumerCommit$$anonfun$2(consumer);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)observableCommitType);
    }

    @Override
    public Task<Ack> ackTask(KafkaConsumer<K, V> consumer, Subscriber<ConsumerRecord<K, V>> out) {
        boolean bl = Task$.MODULE$.create();
        return Task.AsyncBuilder$.CreatePartiallyApplied$.MODULE$.apply$extension(bl, (Function2 & Serializable)(scheduler, cb) -> {
            Scheduler s = scheduler;
            Callback asyncCb = Callback$.MODULE$.forked(cb, (ExecutionContext)s);
            BooleanCancelable cancelable = BooleanCancelable$.MODULE$.apply();
            s.execute(() -> {
                Ack.Stop$ stop$;
                try {
                    KafkaConsumer kafkaConsumer = consumer;
                    synchronized (kafkaConsumer) {
                        Ack.Stop$ stop$2;
                        if (cancelable.isCanceled()) {
                            stop$2 = Ack.Stop$.MODULE$;
                        } else {
                            ConsumerRecords next = (ConsumerRecords)package$.MODULE$.blocking(() -> this.$anonfun$1(consumer));
                            if (this.shouldCommitBefore) {
                                this.consumerCommit(consumer);
                            }
                            stop$2 = Observer$.MODULE$.feed((Observer)out, CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)next).asScala(), out.scheduler());
                        }
                        Ack.Stop$ stop$3 = stop$2;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var7_6
                        stop$ = stop$3;
                    }
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        stop$ = Future$.MODULE$.failed(ex);
                    }
                    throw throwable;
                }
                Ack.Stop$ ackFuture = stop$;
                Future future = Ack$.MODULE$.AckExtensions((Future)ackFuture);
                Ack.AckExtensions$.MODULE$.syncOnComplete$extension(future, (Function1)(JProcedure1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        Ack ack = (Ack)((Success)try_).value();
                        boolean streamErrors = true;
                        try {
                            KafkaConsumer kafkaConsumer = consumer;
                            synchronized (kafkaConsumer) {
                                if (cancelable.isCanceled()) {
                                    streamErrors = false;
                                    asyncCb.onSuccess((Object)Ack.Stop$.MODULE$);
                                    v0 = BoxedUnit.UNIT;
                                } else {
                                    if (this.shouldCommitAfter) {
                                        this.consumerCommit(consumer);
                                    }
                                    streamErrors = false;
                                    asyncCb.onSuccess((Object)ack);
                                    v0 = BoxedUnit.UNIT;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable throwable3;
                                Throwable ex = throwable3 = (Throwable)option.get();
                                if (streamErrors) {
                                    asyncCb.onError((Object)ex);
                                } else {
                                    s.reportFailure(ex);
                                }
                            }
                            throw throwable;
                        }
                        return;
                    }
                    if (try_ instanceof Failure) {
                        Throwable ex = ((Failure)try_).exception();
                        asyncCb.onError((Object)ex);
                        return;
                    }
                    throw new MatchError((Object)try_);
                }, (UncaughtExceptionReporter)s);
            });
            return cancelable;
        }, Task.AsyncBuilder$.MODULE$.forCancelable());
    }

    private static final void consumerCommit$$anonfun$1(KafkaConsumer consumer$1) {
        consumer$1.commitSync();
    }

    private static final void consumerCommit$$anonfun$2(KafkaConsumer consumer$2) {
        consumer$2.commitAsync();
    }

    private final ConsumerRecords $anonfun$1(KafkaConsumer consumer$5) {
        return consumer$5.poll(Duration.ofMillis(this.pollTimeoutMillis));
    }
}

