/*
 * Decompiled with CFR 0.152.
 */
package monix.kafka;

import java.io.Serializable;
import java.time.Duration;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.kafka.Commit;
import monix.kafka.CommittableMessage;
import monix.kafka.CommittableMessage$;
import monix.kafka.CommittableOffset$;
import monix.kafka.KafkaConsumerConfig;
import monix.kafka.KafkaConsumerObservable;
import monix.kafka.KafkaConsumerObservableManualCommit$CommitWithConsumer$;
import monix.reactive.Observable;
import monix.reactive.Observer;
import monix.reactive.Observer$;
import monix.reactive.observers.Subscriber;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class KafkaConsumerObservableManualCommit<K, V>
extends Observable<CommittableMessage<K, V>>
implements KafkaConsumerObservable<K, V, CommittableMessage<K, V>> {
    private final KafkaConsumerConfig config;
    private final Task consumer;
    private final long pollTimeoutMillis;
    public final KafkaConsumerObservableManualCommit$CommitWithConsumer$ CommitWithConsumer$lzy1;

    public KafkaConsumerObservableManualCommit(KafkaConsumerConfig config, Task<KafkaConsumer<K, V>> consumer) {
        this.config = config;
        this.consumer = consumer;
        this.CommitWithConsumer$lzy1 = new KafkaConsumerObservableManualCommit$CommitWithConsumer$(this);
        this.pollTimeoutMillis = config.fetchMaxWaitTime().toMillis();
    }

    @Override
    public KafkaConsumerConfig config() {
        return this.config;
    }

    @Override
    public Task<KafkaConsumer<K, V>> consumer() {
        return this.consumer;
    }

    public final KafkaConsumerObservableManualCommit$CommitWithConsumer$ CommitWithConsumer() {
        return this.CommitWithConsumer$lzy1;
    }

    @Override
    public Task<Ack> ackTask(KafkaConsumer<K, V> consumer, Subscriber<CommittableMessage<K, V>> out) {
        boolean bl = Task$.MODULE$.create();
        return Task.AsyncBuilder$.CreatePartiallyApplied$.MODULE$.apply$extension(bl, (Function2 & Serializable)(scheduler, cb) -> {
            Scheduler s = scheduler;
            Callback asyncCb = Callback$.MODULE$.forked(cb, (ExecutionContext)s);
            BooleanCancelable cancelable = BooleanCancelable$.MODULE$.apply();
            CommitWithConsumer commit = this.CommitWithConsumer().apply(consumer);
            s.execute(() -> {
                Ack.Stop$ stop$;
                try {
                    KafkaConsumer kafkaConsumer = consumer;
                    synchronized (kafkaConsumer) {
                        Ack.Stop$ stop$2;
                        if (cancelable.isCanceled()) {
                            stop$2 = Ack.Stop$.MODULE$;
                        } else {
                            ConsumerRecords next = (ConsumerRecords)package$.MODULE$.blocking(() -> this.$anonfun$1(consumer));
                            Iterable result = (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)next).asScala().map((Function1 & Serializable)record -> CommittableMessage$.MODULE$.apply(record, CommittableOffset$.MODULE$.apply(new TopicPartition(record.topic(), record.partition()), record.offset() + 1L, commit)));
                            stop$2 = Observer$.MODULE$.feed((Observer)out, result, out.scheduler());
                        }
                        Ack.Stop$ stop$3 = stop$2;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var8_7
                        stop$ = stop$3;
                    }
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        stop$ = Future$.MODULE$.failed(ex);
                    }
                    throw throwable;
                }
                Ack.Stop$ ackFuture = stop$;
                Future future = Ack$.MODULE$.AckExtensions((Future)ackFuture);
                Ack.AckExtensions$.MODULE$.syncOnComplete$extension(future, (Function1)(JProcedure1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        Ack ack = (Ack)((Success)try_).value();
                        boolean streamErrors = true;
                        try {
                            if (cancelable.isCanceled()) {
                                streamErrors = false;
                                asyncCb.onSuccess((Object)Ack.Stop$.MODULE$);
                            } else {
                                streamErrors = false;
                                asyncCb.onSuccess((Object)ack);
                            }
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable throwable3;
                                Throwable ex = throwable3 = (Throwable)option.get();
                                if (streamErrors) {
                                    asyncCb.onError((Object)ex);
                                } else {
                                    s.reportFailure(ex);
                                }
                            }
                            throw throwable;
                        }
                        return;
                    }
                    if (try_ instanceof Failure) {
                        Throwable ex = ((Failure)try_).exception();
                        asyncCb.onError((Object)ex);
                        return;
                    }
                    throw new MatchError((Object)try_);
                }, (UncaughtExceptionReporter)s);
            });
            return cancelable;
        }, Task.AsyncBuilder$.MODULE$.forCancelable());
    }

    public static final /* synthetic */ Tuple2 monix$kafka$KafkaConsumerObservableManualCommit$CommitWithConsumer$$_$commitBatchSync$$anonfun$1$$anonfun$1$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            TopicPartition k = (TopicPartition)tuple2._1();
            long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
            TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)new OffsetAndMetadata(v));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 monix$kafka$KafkaConsumerObservableManualCommit$CommitWithConsumer$$_$commitBatchAsync$$anonfun$1$$anonfun$1$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            TopicPartition k = (TopicPartition)tuple2._1();
            long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
            TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)new OffsetAndMetadata(v));
        }
        throw new MatchError((Object)tuple2);
    }

    private final ConsumerRecords $anonfun$1(KafkaConsumer consumer$3) {
        return consumer$3.poll(Duration.ofMillis(this.pollTimeoutMillis));
    }

    public class CommitWithConsumer
    implements Commit,
    Product,
    Serializable {
        private final KafkaConsumer consumer;
        private final /* synthetic */ KafkaConsumerObservableManualCommit $outer;

        public CommitWithConsumer(KafkaConsumerObservableManualCommit $outer, KafkaConsumer<K, V> consumer) {
            this.consumer = consumer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CommitWithConsumer)) return false;
            if (((CommitWithConsumer)object).monix$kafka$KafkaConsumerObservableManualCommit$CommitWithConsumer$$$outer() != this.$outer) return false;
            CommitWithConsumer commitWithConsumer = (CommitWithConsumer)object;
            KafkaConsumer kafkaConsumer = this.consumer();
            KafkaConsumer kafkaConsumer2 = commitWithConsumer.consumer();
            if (kafkaConsumer == null) {
                if (kafkaConsumer2 != null) {
                    return false;
                }
            } else if (!kafkaConsumer.equals(kafkaConsumer2)) return false;
            if (!commitWithConsumer.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CommitWithConsumer;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CommitWithConsumer";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "consumer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KafkaConsumer<K, V> consumer() {
            return this.consumer;
        }

        @Override
        public Task<BoxedUnit> commitBatchSync(scala.collection.immutable.Map<TopicPartition, Object> batch) {
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.commitBatchSync$$anonfun$1(batch);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public Task<BoxedUnit> commitBatchAsync(scala.collection.immutable.Map<TopicPartition, Object> batch, OffsetCommitCallback callback) {
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.commitBatchAsync$$anonfun$1(batch, callback);
                return BoxedUnit.UNIT;
            });
        }

        public CommitWithConsumer copy(KafkaConsumer<K, V> consumer) {
            return new CommitWithConsumer(this.$outer, consumer);
        }

        public KafkaConsumer<K, V> copy$default$1() {
            return this.consumer();
        }

        public KafkaConsumer<K, V> _1() {
            return this.consumer();
        }

        public final /* synthetic */ KafkaConsumerObservableManualCommit monix$kafka$KafkaConsumerObservableManualCommit$CommitWithConsumer$$$outer() {
            return this.$outer;
        }

        private final void commitBatchSync$$anonfun$1$$anonfun$1(scala.collection.immutable.Map batch$2) {
            KafkaConsumer kafkaConsumer = this.consumer();
            synchronized (kafkaConsumer) {
                this.consumer().commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)batch$2.map(KafkaConsumerObservableManualCommit::monix$kafka$KafkaConsumerObservableManualCommit$CommitWithConsumer$$_$commitBatchSync$$anonfun$1$$anonfun$1$$anonfun$1)).asJava());
            }
        }

        private final void commitBatchSync$$anonfun$1(scala.collection.immutable.Map batch$1) {
            package$.MODULE$.blocking((Function0 & Serializable)() -> {
                this.commitBatchSync$$anonfun$1$$anonfun$1(batch$1);
                return BoxedUnit.UNIT;
            });
        }

        private final void commitBatchAsync$$anonfun$1$$anonfun$1(scala.collection.immutable.Map batch$4, OffsetCommitCallback callback$2) {
            KafkaConsumer kafkaConsumer = this.consumer();
            synchronized (kafkaConsumer) {
                this.consumer().commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)batch$4.map(KafkaConsumerObservableManualCommit::monix$kafka$KafkaConsumerObservableManualCommit$CommitWithConsumer$$_$commitBatchAsync$$anonfun$1$$anonfun$1$$anonfun$1)).asJava(), callback$2);
            }
        }

        private final void commitBatchAsync$$anonfun$1(scala.collection.immutable.Map batch$3, OffsetCommitCallback callback$1) {
            package$.MODULE$.blocking((Function0 & Serializable)() -> {
                this.commitBatchAsync$$anonfun$1$$anonfun$1(batch$3, callback$1);
                return BoxedUnit.UNIT;
            });
        }
    }
}

