/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZGD;
import com.aspose.words.zz4k;
import com.aspose.words.zzWXF;
import com.aspose.words.zzXab;
import com.aspose.words.zzXmC;
import com.aspose.words.zzXr2;
import com.aspose.words.zzYm4;
import com.aspose.words.zzZ4d;
import com.aspose.words.zzZYb;
import com.aspose.words.zzh6;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzXmC,
Iterable<V> {
    private Node zzXsN;
    private Node zzvQ;
    private Node zzY84;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzZ4d zzZ4d2 = new zzZ4d(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzZJO(this, true);
            return;
        }
        finally {
            zzZ4d2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzZvt() {
        return this.zzYMC() != null;
    }

    final boolean zzP1() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzYhi() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzYm4) {
                return true;
            }
            CompositeNode compositeNode = zzZGD.zzXkR((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzYhi()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzXsN;
    }

    public Node getLastChild() {
        return this.zzvQ;
    }

    final Node zzYMC() {
        return zzXab.zzZZK(this.getFirstChild(), false);
    }

    final Node zzY1() {
        return zzXab.zzYdB(this.getLastChild(), false);
    }

    final CompositeNode zzXoP() {
        return (CompositeNode)zzXab.zzZZK(this.getFirstChild(), true);
    }

    final CompositeNode zzZ7t() {
        return (CompositeNode)zzXab.zzYdB(this.getLastChild(), true);
    }

    final Node zzYrG() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzXab.zzgC((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzZrG() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzXab.zzgC((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXkR(boolean bl, zzXr2 zzXr22) {
        CompositeNode compositeNode = (CompositeNode)super.zzXkR(bl, zzXr22);
        ((CompositeNode)super.zzXkR(bl, zzXr22)).zzvQ = null;
        compositeNode.zzXsN = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzYRu(node.zzXkR(true, zzXr22));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzOQ(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzOQ(StringBuilder stringBuilder) {
        this.zzYTI(stringBuilder);
        zzZGD.zzYRr(stringBuilder, this.zzZD6());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYRr(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzXab.zzYWM(nodeType);
            Node node2 = node = bl ? this.zzYMC() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzCU() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZYb.zzZJO(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZYb.zzYBq(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzWXF(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzXkR(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzXkR(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzZJO(oldChild, false);
    }

    private <T extends Node> T zzZJO(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = CompositeNode.zzXkR(documentBase, t, this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzWwz() && zzXab.zzZLP(t)) {
            return t;
        }
        CompositeNode.zzXkR(documentBase, nodeChangingArgs);
        if (!bl && zzXab.zzz7(t)) {
            zzXab.zzZFh(t, false);
        }
        T t2 = this.zzZsw(t);
        CompositeNode.zzYRr(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zz4k.zzYY8(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzYRu(Node node) {
        node.getParentNode();
        if (this.zzvQ == null) {
            node.zzYt1(null);
            node.zzYnw(null);
            this.zzXsN = node;
        } else {
            node.zzYt1(this.zzvQ);
            node.zzYnw(null);
            this.zzvQ.zzYnw(node);
        }
        this.zzvQ = node;
        node.zzWp2(this);
        return node;
    }

    final void zzXkR(Node node, Node node2, Node node3) {
        this.zzXkR(node, node2, node3, false);
    }

    final void zzXkR(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzz4(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzYRr(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzYBq(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzXab.zzgC(node3.getNodeType())) continue;
            if (zzXab.zzz4(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZD6().length();
    }

    String zzZD6() {
        return "";
    }

    final String zzWpY() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYTI(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzYTI(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzOQ(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzz4(Node node) {
        return true;
    }

    private static NodeChangingArgs zzXkR(DocumentBase documentBase, Node node, Node node2, Node node3, int n) {
        return documentBase.zzXkR(node, node2, node3, n);
    }

    private static void zzXkR(DocumentBase documentBase, NodeChangingArgs nodeChangingArgs) {
        if (nodeChangingArgs != null) {
            documentBase.zzXkR(nodeChangingArgs);
        }
    }

    private static void zzYRr(DocumentBase documentBase, NodeChangingArgs nodeChangingArgs) {
        if (nodeChangingArgs != null) {
            documentBase.zzYRr(nodeChangingArgs);
        }
    }

    final <T extends Node> T zzXkR(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzWlx(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (t.getNodeType() != 37 && !this.zzz4(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzh6(documentBase);
            try {
                compositeNode.zzZJO(t, true);
            }
            finally {
                ((zzh6)object).dispose();
            }
        }
        object = CompositeNode.zzXkR(documentBase, t, null, this, 0);
        CompositeNode.zzXkR(documentBase, (NodeChangingArgs)object);
        if (this.zzvQ == null) {
            t.zzYt1(null);
            t.zzYnw(null);
            this.zzXsN = t;
            this.zzvQ = t;
        } else if (bl) {
            if (node != null) {
                this.zzYRr(t, node);
            } else {
                this.zzZJO(t, this.zzXsN);
            }
        } else if (node != null) {
            this.zzZJO(t, node);
        } else {
            this.zzYRr(t, this.zzvQ);
        }
        t.zzWp2(this);
        CompositeNode.zzYRr(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzWwz()) {
            zzXab.zzXkR(t, compositeNode, node2);
        }
        return t;
    }

    private void zzYRr(Node node, Node node2) {
        Node node3 = node2.zzpy();
        node.zzYt1(node2);
        node.zzYnw(node3);
        node2.zzYnw(node);
        if (node3 == null) {
            this.zzvQ = node;
            return;
        }
        node3.zzYt1(node);
    }

    private void zzZJO(Node node, Node node2) {
        Node node3 = node2.zzXS9();
        node.zzYt1(node3);
        node.zzYnw(node2);
        node2.zzYt1(node);
        if (node3 == null) {
            this.zzXsN = node;
            return;
        }
        node3.zzYnw(node);
    }

    private <T extends Node> T zzZsw(T t) {
        if (t == this.zzXsN) {
            if (this.zzXsN == this.zzvQ) {
                this.zzXsN = null;
                this.zzvQ = null;
            } else {
                this.zzXsN = t.zzpy();
                this.zzXsN.zzYt1(null);
            }
        } else {
            Node node = t.zzXS9();
            Node node2 = t.zzpy();
            node.zzYnw(node2);
            if (node2 == null) {
                this.zzvQ = node;
            } else {
                node2.zzYt1(node);
            }
        }
        t.zzYnw(null);
        t.zzYt1(null);
        t.zzWp2(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzY84 = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzY84;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

