/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzA;
import com.aspose.words.internal.zzD5;
import com.aspose.words.internal.zzKc;
import com.aspose.words.internal.zzWX;
import com.aspose.words.internal.zzWo;
import com.aspose.words.internal.zzXHZ;
import com.aspose.words.internal.zzXqT;
import com.aspose.words.internal.zzYHM;
import com.aspose.words.internal.zzYOa;
import com.aspose.words.internal.zzYTB;
import com.aspose.words.internal.zzYaE;
import com.aspose.words.internal.zzYpt;
import com.aspose.words.internal.zzZ29;
import com.aspose.words.internal.zzZE6;
import com.aspose.words.internal.zzZGD;
import com.aspose.words.internal.zzZiV;
import com.aspose.words.internal.zzZpU;
import com.aspose.words.internal.zzlj;
import com.aspose.words.zzFn;
import com.aspose.words.zzGU;
import com.aspose.words.zzVVe;
import com.aspose.words.zzVi;
import com.aspose.words.zzW0j;
import com.aspose.words.zzWEy;
import com.aspose.words.zzWH7;
import com.aspose.words.zzWHs;
import com.aspose.words.zzWL2;
import com.aspose.words.zzWLf;
import com.aspose.words.zzWOV;
import com.aspose.words.zzWUI;
import com.aspose.words.zzWXZ;
import com.aspose.words.zzWcZ;
import com.aspose.words.zzWq4;
import com.aspose.words.zzWzY;
import com.aspose.words.zzXFm;
import com.aspose.words.zzXKL;
import com.aspose.words.zzXKk;
import com.aspose.words.zzXab;
import com.aspose.words.zzXgE;
import com.aspose.words.zzXjK;
import com.aspose.words.zzXlF;
import com.aspose.words.zzXsZ;
import com.aspose.words.zzXzc;
import com.aspose.words.zzY0d;
import com.aspose.words.zzY8E;
import com.aspose.words.zzYLb;
import com.aspose.words.zzYVh;
import com.aspose.words.zzYYz;
import com.aspose.words.zzYaS;
import com.aspose.words.zzYsh;
import com.aspose.words.zzZ9h;
import com.aspose.words.zzZR;
import com.aspose.words.zzZcH;
import com.aspose.words.zzZie;
import com.aspose.words.zzZjp;
import com.aspose.words.zzZvb;
import com.aspose.words.zzfp;
import com.aspose.words.zzh6;
import com.aspose.words.zzlG;
import com.aspose.words.zzmO;
import com.aspose.words.zzoV;
import com.aspose.words.zzy5;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzFn,
zzYVh,
zzZcH,
zzZie {
    private Document zzXaG;
    private Node zzcY;
    private Node zzXXY;
    private zzY0d zzYcK;
    private Font zzZT5;
    private zzXHZ<zzY0d> zzZ9F;
    private zzXHZ<zzXFm> zzWS0;
    private zzXHZ<zzXkR> zz8l;
    private zzZvb zzVQ = zzZvb.zzXVh();
    private zzWUI zzWzt = new zzWUI();
    private zzXFm zzKq;
    private RowFormat zzWn2;
    private CellFormat zzWib;
    private ParagraphFormat zzW2r;
    private zzXHZ<zzWq4> zzXmk;
    private int zzXJ2 = 0;
    private int zzZOW = -1;
    private int zziI;
    private boolean zzZq8;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzYdB(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzYdB(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzYdB(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXkR(documentBuilder.getCurrentSection(), zzWEy.zzXUx(headerFooterType), 0, 0);
    }

    private void zzYdB(int n, int n2, int n3, int n4) {
        this.zzXaG.ensureMinimum();
        Section section = (Section)this.zzXaG.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXkR(section, 1, n3, n4);
    }

    private void zzXkR(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzWEy.zzWZN(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = section.appendChild(new HeaderFooter(this.zzXaG, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzXaG));
            }
        }
        this.zzXkR(story, n2, n3);
    }

    private void zzXkR(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXkR((CompositeNode)paragraph2, n3);
    }

    final void zzXkR(Paragraph paragraph, int n) {
        this.zzXkR((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzYmn().zzWYE() ? zzVVe.zzZED(this.zzXaG, fieldName) : zzVVe.zzX29(this.zzYmn(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXkR(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXkR(field, isAfter, false);
    }

    private boolean zzXkR(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzXsZ zzXsZ2 = field.getFormat().zzyS();
        Inline inline = zzXsZ2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXkR(inline.zzZs6(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzYsh.zzXkR(this.zzXaG, bookmarkName) : zzYsh.zzYRr(this.zzXaG, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzVQ0() == 6) {
            this.zzXkR(node.zzEs(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzXab.zzVPK(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXkR((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXkR(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzYRr(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzXkR(structuredDocumentTag);
            return;
        }
        this.zzZJO(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzZ1p(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzXkR((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzVQ0() == 6) {
            this.zzYKn(node);
        } else {
            Node node2 = node;
            if (zzXab.zzgC(node2.getNodeType())) {
                Paragraph paragraph = zzXab.zzVPK(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzYKn(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzVQ0() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzYKn(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zziI = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzW1s();
            return;
        }
        if (!this.zz0H()) {
            this.zzW1s();
        }
    }

    private void zzXkR(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zz0H() {
        Node node = this.zzYmn();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzYmn().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXkR(((StructuredDocumentTag)documentBuilder.zzYmn().getParentNode()).zzYT6(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzYmn(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXkR(inline.zzZs6(), true);
            return true;
        }
        return false;
    }

    private void zzW1s() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXkR(documentBuilder.getCurrentParagraph().zzbd(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZ1p(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzY76() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzYmn().zzWlx(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZLg();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXkR((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzWOV(text, false);
    }

    public void writeln(String text) {
        this.zzWOV(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzYmn() != null && this.zzYmn().zzVQ0() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzYmn().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzZUz();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzh6 zzh62 = new zzh6(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzXaG, this.zzWtR(), this.zzWdc());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzYRr(this.zzYmn(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzh62.dispose();
        }
        if (this.getDocument().zzWwz()) {
            zzXab.zzZJO((zzZ9h)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzVXt());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzXKj() {
        zzY0d zzY0d2;
        Run run;
        Run run2;
        zzZcH zzZcH2;
        this.zzZUz();
        Node node = this.zzYmn();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            zzZcH2 = paragraph;
            run2 = zzZcH2.zzWzW(false);
        } else {
            run2 = run = (Run)node.zzUA(21);
        }
        if (run2 == null && zzZGD.zzWCa(node, paragraph.zzYbO())) {
            run = paragraph.zzYbO();
        }
        if (run != null) {
            zzZcH2 = run.zzZs6();
            zzY0d2 = (zzY0d)((zzGU)((Object)zzZcH2)).zzk2();
        } else {
            zzZcH2 = paragraph.zzbd();
            zzY0d2 = (zzY0d)((zzGU)((Object)zzZcH2)).zzk2();
        }
        zzY0d zzY0d3 = zzY0d2;
        Paragraph paragraph2 = new Paragraph(this.zzXaG, this.zzWtR(), zzY0d3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzh6 zzh62 = new zzh6(this.zzXaG);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzYRr(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzh62.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzZjp.zzZED(this);
    }

    public void insertBreak(int breakType) {
        this.zzXNB(breakType, true);
    }

    final void zzXNB(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzZv9(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzY0F(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zz1n())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzZv9(bl)) {
                        this.zzY0F(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzZv9(bl)) {
                        this.zzYRO(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzZv9(bl)) {
                        this.zzYRO(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzZv9(bl)) {
                        this.zzYRO(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzZv9(bl)) {
                        this.zzYRO(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzZv9(bl)) {
                        this.zzYRO(4);
                    }
                    return;
                }
                case 8: {
                    this.zzY0F(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzYaE.zzZEn(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzZ29.zzYRr("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzZUz();
        return zzXab.zzXkR(fieldType, updateField, this.zzWdc(), this.zzXYQ(), this.zzXuo(), this.zzXuo() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzZUz();
        return zzXab.zzXkR(fieldCode, this.zzWdc(), this.zzXYQ(), this.zzXuo(), this.zzXuo() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzZUz();
        return zzXab.zzXkR(fieldCode, fieldValue, this.zzWdc(), this.zzXYQ(), this.zzXuo(), this.zzXuo() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZGD.zzYRr((Object)displayText, "displayText");
        zzZGD.zzYRr((Object)urlOrBookmark, "hrefOrBookmark");
        zzy5 zzy52 = this.zzYRr(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzy52.zzZJO(documentBuilder.zzZYX(88, true));
        return zzXab.zzXkR(zzy52.getStart(), zzy52.getSeparator(), zzy52.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzY27(70);
        if (zzYaE.zzZEn(name)) {
            this.startBookmark(name);
        }
        this.zzZfR(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzXN(70);
        String string = zzYaE.zzZEn(fieldValue) ? fieldValue : FormField.zzX5W;
        Run run = new Run(this.zzXaG, string, this.zzWdc());
        this.insertNode(run);
        Node node = this.zzZYX(70, true);
        if (zzYaE.zzZEn(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzVWM(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzXkR((CompositeNode)((Paragraph)node.zzEs()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzY27(71);
        if (zzYaE.zzZEn(name)) {
            this.startBookmark(name);
        }
        this.zzZfR(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzZYX(71, false);
        if (zzYaE.zzZEn(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzVWM(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzY27(83);
        if (zzYaE.zzZEn(name)) {
            this.startBookmark(name);
        }
        this.zzZfR(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzZYX(83, false);
        if (zzYaE.zzZEn(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzVWM(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzXaG, footnoteType, !zzYaE.zzZEn(referenceMark), referenceMark, this.zzWdc());
        Style style = this.getDocument().getStyles().zzY2d(zzXab.zzYgw(footnoteType));
        footnote.zzZs6().set(50, style.zzZtR());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzXaG);
        Style style2 = this.getDocument().getStyles().zzY2d(zzXab.zzXhG(footnoteType));
        paragraph.zzW9f().set(1000, style2.zzZtR());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzXaG, '\u0002', new zzY0d()) : new Run(this.zzXaG, footnote.getReferenceMark(), new zzY0d());
        inline.zzZs6().set(50, style.zzZtR());
        paragraph.appendChild(inline);
        if (zzYaE.zzZEn(footnoteText)) {
            Node node = this.zzYmn();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYKn(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzQ(zzlj zzlj2) throws Exception {
        return this.zzXkR(zzlj2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzQ(zzlj.zzYRr(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXkR(zzlj zzlj2, double d, double d2) throws Exception {
        return this.zzXkR(zzlj2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXkR(zzlj.zzYRr(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        try (zzYOa zzYOa2 = new zzYOa();){
            zzWo.zzYRr(image, zzYOa2);
            Shape shape = this.zzXkR(zzYOa2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZGD.zzZJO(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzKc.zzZi1(fileName);
        try {
            Shape shape = this.zzXkR((zzlj)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzlj)object).close();
            }
        }
    }

    private Shape zzXkR(zzlj zzlj2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzlj2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzZGD.zzZED(zzlj2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXkR(zzlj.zzYRr(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXkR(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzXkR(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzZiV.zzYpx(object)) {
            object4 = new zzWo((byte[])object);
            bl2 = true;
            ((zzYTB)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzXaG.getCompatibilityOptions().getMswVersion() > 12 || this.zzXaG.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzXaG, 0);
            object3 = new zzXKk();
            ((zzfp)object3).zzXkR(zzXzc.zzZPq("rect"));
            ((zzXKk)object3).zzXkR(new zzVi());
            ((zzXKk)object3).zzYwH().zzYUX().zzZJO(this.zzXaG);
            object2 = new zzZR();
            ((zzlG)object2).zzYRr(new zzYLb(this.zzXaG.zzWy7(), ""));
            ((zzlG)object2).zzXkR(new zzYYz());
            ((zzWLf)object3).zzXkR((zzlG)object2);
            shape.setShapeType(75);
            shape.zzz4((zzWLf)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzXaG, 75);
        }
        if (zzZiV.zzZgc(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzXkR((byte[])object, new zzWH7(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzWH7(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzZiV.zzZLP((byte[])object2));
                this.zzXkR((zzXKk)shape.zzXVW(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXKk)shape.zzXVW()).zzYwH().zzYUX().zzg0((byte[])object);
            object3 = zzZiV.zzWsx(object);
            object4 = new zzWH7(((zzXqT)object3).getWidthPoints(), ((zzXqT)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzYRr(this.zzWdc());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzZiV.zzYsh(object)) {
            d5 = DocumentBuilder.zzXkR(shape, object);
        }
        shape.zzXkR(d3, d4, (zzWH7)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzXkR(Shape shape, byte[] byArray) throws Exception {
        int n = zzZiV.zzwC(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzXab.zzXQO(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzXab.zzZCx(n);
        return d;
    }

    private void zzXkR(zzXKk zzXKk2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXKk2.zzYwH().zzYUX().getExtensions();
        try (zzYOa zzYOa2 = new zzYOa(byArray);){
            object = zzXab.zzXkR(zzYOa2, this.zzXaG);
            ((zzWHs)object).zzYZ0(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzWHs)object).zz0V();
            byArray2 = ((zzWHs)object).zzXdE(true);
        }
        zzXKk2.zzYwH().zzYUX().setExtensions(new zzYpt<zzXlF>());
        object = zzXlF.zzXkR(byArray2, this.zzXaG);
        zzXKk2.zzYwH().zzYUX().getExtensions().zzZIr(((zzXlF)object).getUri(), (zzXlF)object);
    }

    private Shape zzXkR(zzlj zzlj2, String string, boolean bl, zzlj zzlj3) throws Exception {
        zzYaS zzYaS2 = zzYaS.zzYZe(string);
        Shape shape = this.zzXkR(zzlj3, bl, zzYaS2, null);
        zzmO zzmO2 = zzWzY.zzXkR(zzlj2, string, bl);
        return DocumentBuilder.zzXkR(null, false, shape, zzYaS2.zzW5G, zzmO2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXkR(zzlj.zzYRr(stream), progId, asIcon, zzlj.zzYRr(presentation));
    }

    private Shape zzXkR(String string, boolean bl, boolean bl2, zzlj zzlj2) throws Exception {
        zzYaS zzYaS2 = zzYaS.zzfl(zzZE6.zzZL8(string));
        return this.zzXkR(string, bl, bl2, zzlj2, zzYaS2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXkR(fileName, isLinked, asIcon, zzlj.zzYRr(presentation));
    }

    private Shape zzXkR(String string, String string2, boolean bl, boolean bl2, zzlj zzlj2) throws Exception {
        zzYaS zzYaS2 = zzYaS.zzYZe(string2);
        return this.zzXkR(string, bl, bl2, zzlj2, zzYaS2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXkR(fileName, progId, isLinked, asIcon, zzlj.zzYRr(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYaS zzYaS2 = zzYaS.zzfl(zzZE6.zzZL8(fileName));
        return this.zzXkR(fileName, isLinked, iconFile, iconCaption, zzYaS2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYaS zzYaS2 = zzYaS.zzYZe(progId);
        return this.zzXkR(fileName, isLinked, iconFile, iconCaption, zzYaS2);
    }

    private Shape zzYRr(zzlj zzlj2, String string, String string2, String string3) throws Exception {
        zzYaS zzYaS2 = zzYaS.zzYZe(string);
        Shape shape = this.zzXkR(string2, string3, zzYaS2);
        zzmO zzmO2 = zzWzY.zzXkR(zzlj2, string, true);
        return DocumentBuilder.zzXkR(null, false, shape, zzYaS2.zzW5G, zzmO2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzYRr(zzlj.zzYRr(stream), progId, iconFile, iconCaption);
    }

    final Shape zzXkR(zzXjK zzXjK2, zzlj zzlj2) throws Exception {
        Shape shape = this.zzfO(zzlj2);
        shape.setShapeType(201);
        shape.setShapeAttr(4112, zzXjK2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzZUz();
        if (this.zzZ1()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzox(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzXKL zzXKL2 = zzXab.zzXkR(html, options, this);
        zzXKL2.zzXfe();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzZUz();
        return zzXab.zzXkR(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzZUz();
        return zzXab.zzXkR(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzWXZ zzWXZ2 = new zzWXZ();
        return zzWXZ2.zzXkR(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWcZ(this).zzXkR(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWcZ(this).zzXkR(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzXaG, 75);
        shape.zzYRr(this.zzWdc());
        shape.zzYRN(true);
        shape.getSignatureLine().zzXkR(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYcH(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzYah(this.zzXaG);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzZ1() {
        boolean bl = false;
        if (this.zzYmn().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzYmn().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzox(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzZUz();
        if (this.zzY76() == null) {
            this.startTable();
        }
        if (this.zzY76().zz9i() == 1) {
            this.zzY76().zzYmX();
        }
        if (this.zzY76().zz9i() == 3) {
            this.zzY76().zzYc3();
        }
        return this.zzY76().zzVT3();
    }

    public Table startTable() {
        this.zzXmk.push(new zzWq4(this));
        return this.zzY76().startTable();
    }

    public Table endTable() {
        if (this.zzY76() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzY76().endTable();
        this.zzXmk.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzY76() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzY76().endRow();
        if (this.zzZT5 != null && this.zzZT5.getHidden()) {
            row.zzvF().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXaG, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXaG, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYxL();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXaG, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzW1I();
        bookmarkStart.zzZ3r(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYxL();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzW1I();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXaG, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzXpJ(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzXaG);
        this.zzZOW = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZOW == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXaG, this.zzZOW);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXaG, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZGD.zzYRr((Object)importFormatOptions, "ImportFormatOptions");
        this.zzZUz();
        return zzW0j.zzXkR(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Node insertDocumentInline(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZGD.zzYRr((Object)importFormatOptions, "ImportFormatOptions");
        this.zzZUz();
        importFormatOptions.zzXMp(true);
        Node node = zzW0j.zzXkR(this, srcDoc, importFormatMode, importFormatOptions);
        importFormatOptions.zzXMp(false);
        return node;
    }

    public Document getDocument() {
        return this.zzXaG;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzXaG) {
            return;
        }
        this.zzXaG = value;
        this.zzYKn(null);
        this.zzYcK = new zzY0d();
        this.zzZ9F = null;
        this.zzWS0 = null;
        this.zzZT5 = null;
        this.zzXmk = new zzXHZ();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZT5 == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZT5 = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzZT5;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzW2r == null) {
            DocumentBuilder documentBuilder = this;
            this.zzW2r = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzW2r;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzWn2 == null) {
            this.zzWn2 = new RowFormat(this);
        }
        return this.zzWn2;
    }

    public CellFormat getCellFormat() {
        if (this.zzWib == null) {
            this.zzWib = new CellFormat(this);
        }
        return this.zzWib;
    }

    final void zzRe(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzY0d zzY0d2;
        if (this.getCurrentParagraph() != null) {
            zzY0d zzY0d3 = this.getCurrentParagraph().zzbd();
            zzY0d2 = (zzY0d)zzY0d3.zzk2();
        } else {
            zzY0d2 = this.zzWdc();
        }
        zzY0d zzY0d4 = zzY0d2;
        this.zz6N().push(new zzXkR(this.zzWdc(), zzY0d4));
    }

    public void popFont() {
        zzXHZ<zzXkR> zzXHZ2 = this.zz6N();
        if (zzXHZ2.size() > 0) {
            zzXkR zzXkR2 = (zzXkR)this.zz6N().pop();
            this.zzXkR(zzXkR2.zzZs6(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzRe(zzXkR2.zzvH());
            }
        }
    }

    final void zzYII() {
        this.zzXPu().push(this.zzWdc());
    }

    final void zzZnq() {
        zzXHZ<zzY0d> zzXHZ2 = this.zzXPu();
        if (zzXHZ2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXkR((zzY0d)documentBuilder.zzXPu().pop(), false);
        }
    }

    final void zzAK() {
        this.zzMN().push(this.zzWtR());
    }

    final void zzYa2() {
        zzXHZ<zzXFm> zzXHZ2 = this.zzMN();
        if (zzXHZ2.size() > 0) {
            zzXFm zzXFm2 = (zzXFm)this.zzMN().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXkR(zzXFm2);
            }
        }
    }

    private zzy5 zzYRr(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzY27(88);
        zzXgE zzXgE2 = new zzXgE();
        zzXgE2.setTarget(string2);
        zzXgE2.setScreenTip(string3);
        if (bl) {
            zzXgE2.setSubAddress(string);
        } else {
            zzXgE2.setAddress(zzA.zzVu(string));
            zzXgE2.setSubAddress(zzA.zzZSC(string));
        }
        this.zzZfR(zzXgE2.zzXCr());
        FieldSeparator fieldSeparator = this.zzXN(88);
        return new zzy5(fieldStart, fieldSeparator, null);
    }

    final zzy5 zzYdB(String string, String string2, String string3) {
        boolean bl = zzA.zzY5G(string);
        String string4 = bl ? zzA.zzZSC(string) : string;
        return this.zzYRr(string4, bl, string2, string3);
    }

    final zzy5 zzXkR(zzXgE zzXgE2) {
        FieldStart fieldStart = this.zzY27(88);
        this.zzZfR(zzXgE2.zzXCr());
        FieldSeparator fieldSeparator = this.zzXN(88);
        return new zzy5(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzVZg() {
        return this.zzZYX(88, true);
    }

    final zzY0d zzWdc() {
        zzY0d zzY0d2 = this.zzYcK;
        return (zzY0d)zzY0d2.zzk2();
    }

    final zzXFm zzWtR() {
        zzXFm zzXFm2 = this.zzW9f();
        return (zzXFm)zzXFm2.zzk2();
    }

    final zzZvb zzYKZ() {
        zzZvb zzZvb2 = this.zzvF();
        return (zzZvb)zzZvb2.zzk2();
    }

    final zzWUI zzuG() {
        zzWUI zzWUI2 = this.zzXV6();
        return (zzWUI)zzWUI2.zzk2();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzYmn(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzYmn().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzZq8 && this.zzYmn().getNodeType() == 28;
    }

    private void zzWOV(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzYmn()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzWEy.zzYf6(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzqV(string2.substring(n4, n4 + n2));
                }
                switch (this.zzXJ2) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzY0F(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzqV(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzZUz();
        if (this.zzY76() != null && this.zzY76().zz9i() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzYmn().getParentNode().insertBefore(node, this.zzYmn());
    }

    final void zzhL(int n) {
        this.zzZv9(true);
        this.zzYRO(n);
    }

    private void zzYRO(int n) {
        this.insertParagraph();
        zzh6 zzh62 = new zzh6(this.getDocument());
        try {
            zzWL2 zzWL22 = this.getCurrentSection().zzVW1();
            zzWL2 zzWL23 = (zzWL2)zzWL22.zzk2();
            Section section = new Section(this.zzXaG, zzWL23);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzXaG));
            this.zzXaG.insertAfter(section, this.getCurrentSection());
            section.getBody().zzYRr(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzh62.dispose();
        }
    }

    final FieldStart zzY27(int n) {
        this.zzZUz();
        return zzXab.zzXkR(n, this.zzWdc(), this.zzXYQ(), this.zzXuo(), this.zzXuo() == null);
    }

    final Run zzZfR(String string) {
        return zzXab.zzYRr(string, this.zzWdc(), this.zzXYQ(), this.zzXuo(), this.zzXuo() == null);
    }

    final FieldEnd zzZYX(int n, boolean bl) {
        return zzXab.zzYRr(n, bl, this.zzWdc(), this.zzXYQ(), this.zzXuo(), this.zzXuo() == null);
    }

    final FieldSeparator zzXN(int n) {
        return zzXab.zzYRr(n, this.zzWdc(), this.zzXYQ(), this.zzXuo(), this.zzXuo() == null);
    }

    private FormField zzVWM(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzXaG, new zzY8E(), this.zzWdc());
        CompositeNode compositeNode = node == null ? this.zzXYQ() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzZv9(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzY76() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZ1p(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzqV(String string) {
        if (this.zzY1N(string)) {
            zzD5 zzD52 = new zzD5(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzZpU zzZpU2 : zzD52.zzZHc(this.getParagraphFormat().getBidi())) {
                zzWOV zzWOV2 = zzWOV.zzWRO(zzZpU2.zzYrq());
                zzY0d zzY0d2 = this.zzWdc();
                zzY0d2.zzWpi(265, zzWOV2);
                if (zzZpU2.zzkk()) {
                    zzY0d2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzXaG, zzZpU2.getText(), zzY0d2);
                this.insertNode(run);
            }
            return;
        }
        this.zzY0F(string);
    }

    private boolean zzY1N(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzYHM.zznt(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXkR(zzY0d zzY0d2, boolean bl) {
        zzY0d zzY0d3;
        if (bl) {
            zzY0d zzY0d4 = zzY0d2;
            zzY0d3 = (zzY0d)zzY0d4.zzk2();
        } else {
            zzY0d3 = zzY0d2;
        }
        this.zzYcK = zzY0d3;
    }

    final void zzZph() {
        this.zzYcK.clear();
    }

    final void zzZTo() {
        if (this.zzYxL() != null) {
            zzWUI zzWUI2;
            zzWUI zzWUI3 = zzWUI2 = this.zzYxL().zzXV6();
            this.zzWzt = (zzWUI)zzWUI3.zzk2();
            zzWUI2.zzYRr(this.zzWzt);
        }
    }

    private Shape zzXkR(String string, boolean bl, boolean bl2, zzlj zzlj2, zzYaS zzYaS2) throws Exception {
        if (zzYaS2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzXkR(zzlj2, bl2, zzYaS2, string);
        zzmO zzmO2 = zzWzY.zzXkR(string, bl, bl2, zzYaS2);
        return DocumentBuilder.zzXkR(string, bl, shape, zzYaS2.zzW5G, zzmO2);
    }

    private Shape zzXkR(String string, boolean bl, String string2, String string3, zzYaS zzYaS2) throws Exception {
        if (zzYaS2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzZE6.zzYNG(string);
        }
        Shape shape = string2 != null ? this.zz2M(string2, string3) : this.zzXkR(null, string3, zzYaS2);
        zzmO zzmO2 = zzWzY.zzXkR(string, bl, true, zzYaS2);
        return DocumentBuilder.zzXkR(string, bl, shape, zzYaS2.zzW5G, zzmO2);
    }

    private static Shape zzXkR(String string, boolean bl, Shape shape, String string2, zzmO zzmO2) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzYRr(zzmO2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzXkR(zzlj zzlj2, boolean bl, zzYaS zzYaS2, String string) throws Exception {
        if (zzYaS2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzlj2 != null) {
            return this.zzfO(zzlj2);
        }
        if (!bl) {
            return this.zzWRO(zzWzY.zzYRM().get("normal"));
        }
        String string2 = string != null ? zzZE6.zzYNG(string) : zzWzY.zzXhG(zzYaS2.zzWtB);
        return this.zzXkR(zzYaS2, string2);
    }

    private Shape zzXkR(String string, String string2, zzYaS zzYaS2) throws Exception {
        if (zzYaS2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzWzY.zzXhG(zzYaS2.zzWtB);
        }
        if (string != null) {
            return this.zz2M(string, string2);
        }
        return this.zzXkR(zzYaS2, string2);
    }

    private Shape zzXkR(zzYaS zzYaS2, String string) throws Exception {
        if (zzYaS2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzWzY.zzYgw(zzYaS2.zzWtB);
        zzWX zzWX2 = new zzWX(byArray, null, string, this.getDocument().zzZ1u());
        return this.zzWRO(zzWX2.zzYK5());
    }

    private Shape zz2M(String string, String string2) throws Exception {
        zzWX zzWX2 = new zzWX(string, string2, this.getDocument().zzZ1u());
        return this.zzWRO(zzWX2.zzYK5());
    }

    private Shape zzfO(zzlj zzlj2) throws Exception {
        byte[] byArray = zzZGD.zzZED(zzlj2);
        return this.zzWRO(byArray);
    }

    private Shape zzWRO(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzXaG, 1);
        shape.setShapeType(75);
        shape.zzYRr(this.zzWdc());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYcH(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzXkR(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzYRr(compositeNode, n);
            return;
        }
        this.zzZJO(compositeNode, n);
    }

    private void zzYRr(CompositeNode compositeNode, int n) {
        zzoV zzoV2 = zzoV.zzWOV(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzoV2.zzXkR(null, true, true, true, false, true);
            node = zzoV2.getNode();
            if (zzoV2.zzWzf() && (!node.isComposite() || node.zzVQ0() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzZD6().length() : node.getTextLength();
            if (!zzoV2.zzWzf() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzoV2.zzWzf() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzXkR((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzXkR(null, node);
            this.zziI = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzXkR(StructuredDocumentTag structuredDocumentTag) {
        this.zzYKn(structuredDocumentTag);
        this.zzZq8 = true;
        this.zziI = 0;
        zzY0d zzY0d2 = structuredDocumentTag.zzYT6();
        switch (structuredDocumentTag.zzVQ0()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzZrG(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzY0d2 = ((Inline)node).zzZs6();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzY0d2 = paragraph.zzbd();
                break;
            }
            default: {
                return;
            }
        }
        this.zzXkR(zzY0d2, true);
    }

    private void zzZJO(CompositeNode compositeNode, int n) {
        zzoV zzoV2 = zzoV.zzVVZ(compositeNode);
        while (zzoV2.getNode() != compositeNode || !zzoV2.zzWzf()) {
            int n2;
            Node node = zzoV2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZD6().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzXkR(null, node);
                this.zziI = n;
                return;
            }
            while (zzoV2.zzXkR(null, false, true, true, false, true) && zzoV2.zzWzf() && zzoV2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzZUz() {
        int n = this.zziI;
        if (n == 0) {
            return;
        }
        this.zziI = 0;
        Run run = zzZGD.zzXkR((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzXsx(n);
        }
    }

    private Run zzY0F(String string) {
        Run run = new Run(this.zzXaG, string, this.zzWdc());
        this.insertNode(run);
        return run;
    }

    final boolean zzZLd() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZsp() {
        return this.zzXJ2;
    }

    final void zz29(int n) {
        this.zzXJ2 = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzYmn();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzYmn();
        }
        return (Paragraph)this.zzYmn().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzYmn();
        }
        return (StructuredDocumentTag)this.zzYmn().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzYmn().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzWq4 zzY76() {
        zzXHZ<zzWq4> zzXHZ2 = this.zzXmk;
        if (zzXHZ2.size() > 0) {
            return (zzWq4)this.zzXmk.peek();
        }
        return null;
    }

    private Cell zzYxL() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzXaf();
    }

    private CompositeNode zzXYQ() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzYmn();
        }
        return this.zzYmn().getParentNode();
    }

    private Node zzXuo() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzYmn();
    }

    private zzXHZ<zzY0d> zzXPu() {
        if (this.zzZ9F == null) {
            this.zzZ9F = new zzXHZ();
        }
        return this.zzZ9F;
    }

    private zzXHZ<zzXFm> zzMN() {
        if (this.zzWS0 == null) {
            this.zzWS0 = new zzXHZ();
        }
        return this.zzWS0;
    }

    private zzXHZ<zzXkR> zz6N() {
        if (this.zz8l == null) {
            this.zz8l = new zzXHZ();
        }
        return this.zz8l;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzYcK.zzXFw(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzYcK.zzXLD(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzWtJ(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzWtJ(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzYcK.zzWpi(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWLI()) {
            this.getCurrentParagraph().zzbd().zzWpi(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzYcK.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzYcK.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWLI()) {
            this.getCurrentParagraph().zzbd().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzW9f().zzXFw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzW9f().zzXLD(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzRl(key, 0);
        }
        return this.getDocument().getStyles().zzYQW().zzYBp(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzW9f().zzWpi(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzW9f().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzW9f().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzvF().zzXFw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzvF().zzYBp(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzvF().zzX6L(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzvF().zzWpi(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzvF().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzvF().clear();
        zzZvb.zzXVh().zzYRr(this.zzvF());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXV6().zzXFw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzXV6().zzYBp(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzXV6().zzX6L(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZGD.zzXkR(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzYxL() != null ? this.zzYxL().getCellFormat() : this.getCellFormat();
            border.zzXkR(cellFormat);
        }
        this.zzXV6().zzWpi(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXV6().clear();
    }

    private Node zzYmn() {
        Node node = this.zzcY != null && this.zzcY.getParentNode() == null ? this.zzXXY : this.zzcY;
        if (node != null && node.zzVQ0() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzZq8 = this.zzZq8 && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzYKn(Node node) {
        this.zzcY = node;
        if (this.zzcY != null) {
            this.zzXXY = this.zzcY.getParentNode();
        }
        this.zzZq8 = false;
    }

    private zzXFm zzW9f() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzW9f();
        }
        if (this.zzKq == null) {
            this.zzKq = new zzXFm();
        }
        return this.zzKq;
    }

    private zzZvb zzvF() {
        if (this.zzY76() != null && this.zzY76().zz9i() == 1) {
            return this.zzVQ;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzvF();
        }
        return this.zzVQ;
    }

    private zzWUI zzXV6() {
        if (this.zzY76() != null && this.zzY76().zz9i() != 3) {
            return this.zzWzt;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzXaf().zzXV6();
        }
        return this.zzWzt;
    }

    static final class zzXkR {
        private zzY0d zzYcK;
        private zzY0d zzXGB;

        public zzXkR(zzY0d zzY0d2, zzY0d zzY0d3) {
            this.zzYcK = zzY0d2;
            this.zzXGB = zzY0d3;
        }

        public final zzY0d zzZs6() {
            return this.zzYcK;
        }

        public final zzY0d zzvH() {
            return this.zzXGB;
        }
    }
}

