/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz6f;
import com.aspose.words.internal.zzWTW;
import com.aspose.words.internal.zzXMj;
import com.aspose.words.internal.zzYaE;
import com.aspose.words.internal.zzZGD;
import com.aspose.words.internal.zzlj;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXod;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzXhe = new HashMap();
    private static HashMap<Integer, Integer> zzZpe = new HashMap();
    private static HashMap<Integer, Integer> zzYai = new HashMap();
    private static HashMap<Integer, Integer> zzYod = new HashMap();
    private static HashMap<Integer, Integer> zzY0n = new HashMap();
    private static HashMap<Integer, Integer> zzWly = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZGD.zzZJO(fileName, "fileName");
        try (zz6f zz6f2 = zzZGD.zzYZ0(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZfE(zz6f2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZfE(zzWTW.zzXkR(stream));
    }

    static FileFormatInfo zzZfE(zzlj zzlj2) throws Exception {
        if (zzlj2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzXod zzXod2 = new zzXod();
            zzlj zzlj3 = zzlj2;
            zzXod zzXod3 = zzXod2;
            return zzXod2.zzYRr(zzlj3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZJO(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzb6(zzXMj.zzWfb(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzWy0(zzXMj.zzWfb(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzYaE.zzZEn(string = zzXMj.zzXFe(FileFormatUtil.zzXih(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzb6(FileFormatUtil.zzX2k(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzWy0(FileFormatUtil.zzXih(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXMj.zzXFe(FileFormatUtil.zzX2k(saveFormat));
        if (zzYaE.zzZEn(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzWy0(zzXMj.zzZhH(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXMj.zzXFe(FileFormatUtil.zzY6p(imageType));
    }

    static Exception zzZJO(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzv(int n) {
        return zzXMj.toString(FileFormatUtil.zzX2k(n));
    }

    static int zzWy0(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZGD.zzXkR(zzY0n, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzVYh(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZGD.zzXkR(zzWly, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzX3i(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzXih(int n) {
        return zzZGD.zzXkR(zzXhe, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzX2k(int n) {
        return zzZGD.zzXkR(zzZpe, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzY6p(int n) {
        return zzZGD.zzXkR(zzYai, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzb6(int n) {
        return zzZGD.zzXkR(zzYod, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzZFh(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZGD.zzYRr(zzY0n, Integer.valueOf(n), Integer.valueOf(n2));
            zzZGD.zzYRr(zzZpe, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzYod.containsKey(n)) {
                zzZGD.zzYRr(zzYod, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZGD.zzYRr(zzXhe, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZGD.zzYRr(zzWly, Integer.valueOf(n), Integer.valueOf(n4));
            zzZGD.zzYRr(zzYai, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzZFh(12, 10, 10, 1);
        FileFormatUtil.zzZFh(12, 0, 0, 1);
        FileFormatUtil.zzZFh(13, 11, 11, 1);
        FileFormatUtil.zzZFh(14, 20, 20, 1);
        FileFormatUtil.zzZFh(14, 0, 254, 1);
        FileFormatUtil.zzZFh(15, 21, 21, 1);
        FileFormatUtil.zzZFh(16, 22, 22, 1);
        FileFormatUtil.zzZFh(17, 23, 23, 1);
        FileFormatUtil.zzZFh(19, 24, 24, 1);
        FileFormatUtil.zzZFh(20, 25, 25, 1);
        FileFormatUtil.zzZFh(21, 26, 26, 1);
        FileFormatUtil.zzZFh(22, 27, 27, 1);
        FileFormatUtil.zzZFh(25, 30, 30, 1);
        FileFormatUtil.zzZFh(18, 31, 31, 1);
        FileFormatUtil.zzZFh(26, 50, 50, 1);
        FileFormatUtil.zzZFh(27, 45, 255, 1);
        FileFormatUtil.zzZFh(28, 51, 51, 1);
        FileFormatUtil.zzZFh(29, 54, 52, 1);
        FileFormatUtil.zzZFh(30, 0, 53, 1);
        FileFormatUtil.zzZFh(32, 53, 54, 1);
        FileFormatUtil.zzZFh(23, 60, 60, 1);
        FileFormatUtil.zzZFh(24, 61, 61, 1);
        FileFormatUtil.zzZFh(35, 40, 64, 1);
        FileFormatUtil.zzZFh(42, 47, 255, 1);
        FileFormatUtil.zzZFh(43, 48, 255, 1);
        FileFormatUtil.zzZFh(36, 41, 255, 1);
        FileFormatUtil.zzZFh(37, 46, 255, 1);
        FileFormatUtil.zzZFh(39, 42, 255, 1);
        FileFormatUtil.zzZFh(38, 44, 255, 1);
        FileFormatUtil.zzZFh(31, 52, 55, 1);
        FileFormatUtil.zzZFh(33, 70, 62, 1);
        FileFormatUtil.zzZFh(34, 73, 63, 1);
        FileFormatUtil.zzZFh(40, 71, 255, 1);
        FileFormatUtil.zzZFh(8, 100, 255, 1);
        FileFormatUtil.zzZFh(9, 105, 255, 1);
        FileFormatUtil.zzZFh(6, 101, 255, 6);
        FileFormatUtil.zzZFh(7, 102, 255, 7);
        FileFormatUtil.zzZFh(5, 104, 255, 5);
        FileFormatUtil.zzZFh(4, 0, 255, 4);
        FileFormatUtil.zzZFh(3, 0, 255, 3);
        FileFormatUtil.zzZFh(41, 72, 255, 1);
        FileFormatUtil.zzZFh(2, 103, 255, 2);
        FileFormatUtil.zzZFh(10, 106, 255, 8);
        FileFormatUtil.zzZFh(47, 80, 255, 1);
    }
}

