/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzZXK;
import com.aspose.words.internal.zzlj;
import com.aspose.words.zzqT;
import java.io.InputStream;
import java.io.OutputStream;

public class Merger {
    private Merger() {
    }

    public static void merge(String outputFile, String[] inputFiles) throws Exception {
        Merger.merge(outputFile, inputFiles, SaveOptions.createSaveOptions(outputFile), 1);
    }

    public static void merge(String outputFile, String[] inputFiles, int saveFormat, int mergeFormatMode) throws Exception {
        Merger.merge(outputFile, inputFiles, SaveOptions.createSaveOptions(saveFormat), mergeFormatMode);
    }

    public static void merge(String outputFile, String[] inputFiles, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Document document = Merger.merge(inputFiles, mergeFormatMode);
        if (document.getOriginalLoadFormat() == 64 && !saveOptions.zzXsB()) {
            document.updatePageLayout();
        }
        document.save(outputFile, saveOptions);
    }

    public static Document merge(String[] inputFiles, int mergeFormatMode) throws Exception {
        Document document = null;
        String[] stringArray = inputFiles;
        int n = inputFiles.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (document == null) {
                document = new Document(string);
                continue;
            }
            if (mergeFormatMode == 2) {
                Document[] documentArray = new Document[]{new Document(string)};
                Document document2 = document;
                zzqT.zzXkR(document2, documentArray);
                continue;
            }
            document.appendDocument(new Document(string), Merger.zzXpw(mergeFormatMode));
        }
        return document;
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, int saveFormat) throws Exception {
        int n = saveFormat;
        zzlj[] zzljArray = zzlj.zzXkR(inputStreams);
        zzZXK zzZXK2 = zzlj.zzZJO(outputStream);
        Merger.zzXkR(zzZXK2, zzljArray, n);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        int n = mergeFormatMode;
        SaveOptions saveOptions2 = saveOptions;
        zzlj[] zzljArray = zzlj.zzXkR(inputStreams);
        zzZXK zzZXK2 = zzlj.zzZJO(outputStream);
        Merger.zzXkR(zzZXK2, zzljArray, saveOptions2, n);
    }

    public static Document merge(InputStream[] inputStreams, int mergeFormatMode) throws Exception {
        int n = mergeFormatMode;
        zzlj[] zzljArray = zzlj.zzXkR(inputStreams);
        return Merger.zzXkR(zzljArray, n);
    }

    private static void zzXkR(zzlj zzlj2, zzlj[] zzljArray, int n) throws Exception {
        Merger.zzXkR(zzlj2, zzljArray, SaveOptions.createSaveOptions(n), 1);
    }

    private static void zzXkR(zzlj zzlj2, zzlj[] zzljArray, SaveOptions saveOptions, int n) throws Exception {
        Document document = Merger.zzXkR(zzljArray, n);
        if (document.getOriginalLoadFormat() == 64 && !saveOptions.zzXsB()) {
            document.updatePageLayout();
        }
        document.zzXjS(zzlj2, saveOptions.getSaveFormat());
    }

    private static Document zzXkR(zzlj[] zzljArray, int n) throws Exception {
        Document document = null;
        zzlj[] zzljArray2 = zzljArray;
        int n2 = zzljArray.length;
        for (int i = 0; i < n2; ++i) {
            zzlj zzlj2 = zzljArray2[i];
            if (document == null) {
                document = new Document(zzlj2);
                continue;
            }
            if (n == 2) {
                Document[] documentArray = new Document[]{new Document(zzlj2)};
                Document document2 = document;
                zzqT.zzXkR(document2, documentArray);
                continue;
            }
            document.appendDocument(new Document(zzlj2), Merger.zzXpw(n));
        }
        return document;
    }

    private static int zzXpw(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 1;
    }
}

