/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzXMj;
import com.aspose.words.internal.zzZE6;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzWyO;
    private boolean zzXrs;
    boolean zzi2 = true;
    private boolean zzWdy = true;
    private boolean zzXCz = false;
    private boolean zzXZH;
    private boolean zzY7x = true;
    private boolean zzWJr;
    private String zzWcl;
    private boolean zzQp;
    private boolean zzX94 = false;
    private int zzWJ3 = 1;
    private int zzZCe = 1;
    private int zzZ7f = 0;
    private String zzy3 = "";
    private boolean zzl5 = true;
    private boolean zzeP = true;
    private boolean zzNJ;
    private boolean zzL5;
    private int zzVSQ = 0;
    private boolean zzXXR = true;
    private boolean zzYNs = false;

    protected SaveOptions() {
    }

    final boolean zzZpx() {
        return this.zzXZH;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzY2D() {
        return false;
    }

    boolean zzXsB() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzY7x;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzY7x = value;
    }

    public String getTempFolder() {
        return this.zzWcl;
    }

    public void setTempFolder(String value) {
        this.zzWcl = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWJr;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWJr = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzQp;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzQp = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzX94;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzX94 = value;
    }

    public int getDmlRenderingMode() {
        return this.zzWJ3;
    }

    public void setDmlRenderingMode(int value) {
        this.zzWJ3 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZ7f;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZ7f = value;
    }

    public int getImlRenderingMode() {
        return this.zzZCe;
    }

    public void setImlRenderingMode(int value) {
        this.zzZCe = value;
    }

    public String getDefaultTemplate() {
        return this.zzy3;
    }

    public void setDefaultTemplate(String value) {
        this.zzy3 = value;
    }

    public boolean getUpdateFields() {
        return this.zzl5;
    }

    public void setUpdateFields(boolean value) {
        this.zzl5 = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzNJ;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzNJ = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzL5;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzL5 = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYNs;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYNs = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXCz;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXCz = value;
    }

    final boolean zzY2E() {
        return this.zzeP;
    }

    final boolean zzWFW() {
        return this.zzXXR;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzWy0(zzXMj.zzZhH(zzZE6.zzZL8(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzVSQ;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzVSQ = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzWyO;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzWyO = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzXrs;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzXrs = value;
    }

    final boolean zzXqZ() {
        return this.zzWdy;
    }

    final void zzXK8(boolean bl) {
        this.zzWdy = false;
    }
}

