/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZ29;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzYBq;
import com.aspose.words.net.System.Data.zzz4;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzXtW;
    private final DataTable zzZYO;
    private final AtomicInteger zzWTv;

    ConstraintCollection(DataTable table) {
        this.zzZYO = table;
        this.zzWTv = new AtomicInteger(1);
        this.zzXtW = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zzZ29.zzQQ(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzXtW) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzXtW.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzWVY()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzWVY()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzXkR(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            constraint.setConstraintName(this.zzRX());
        }
        constraint.zzXkR(this);
        this.zzXtW.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzZYO.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzXtW.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzXtW.contains(cc);
    }

    public int getCount() {
        return this.zzXtW.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzXtW.iterator();
    }

    final DataTable getTable() {
        return this.zzZYO;
    }

    final List<ForeignKeyConstraint> zzXcQ() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzXtW) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzXkR(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzXtW) {
            if (constraint instanceof UniqueConstraint) {
                this.zzXkR((UniqueConstraint)constraint, dataRow);
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzXkR((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzXkR(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzXtW) {
            if (constraint2.equals(constraint) || zzZ29.zzZIr(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private String zzRX() {
        return "Constraint" + this.zzWTv.getAndIncrement();
    }

    private void zzXkR(UniqueConstraint uniqueConstraint, DataRow dataRow) throws ConstraintException {
        zzz4 zzz42 = this.zzZYO.zzZ4J().zzYBq(uniqueConstraint.getColumns());
        Map<String, Object> map = zzz42.zzZIr(dataRow);
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringBuilder.append(zzZ29.zzYRr("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
            }
            throw new ConstraintException(stringBuilder.toString());
        }
    }

    private void zzXkR(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzZYO.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzZYO.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        Object object = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(((ConstraintCollection)object).zzZYO.getTableName())) {
            return;
        }
        object = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(((ConstraintCollection)object).zzZYO.getTableName())) {
            return;
        }
        if (!ConstraintCollection.zzYRr(foreignKeyConstraint, dataRow)) {
            DataTable dataTable = foreignKeyConstraint.getRelatedTable();
            DataRow dataRow2 = dataRow;
            DataColumn[] dataColumnArray = foreignKeyConstraint.getColumns();
            DataColumn[] dataColumnArray2 = foreignKeyConstraint.getRelatedColumns();
            object = dataTable;
            if (!zzYBq.zzXkR(dataTable, dataColumnArray2, dataColumnArray, dataRow2)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                    stringBuilder.append(zzZ29.zzYRr("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
                }
                throw new InvalidConstraintException(stringBuilder.toString());
            }
        }
    }

    private static boolean zzYRr(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) {
        boolean bl = false;
        for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
            Object object = dataRow.get(dataColumn);
            if (object == null || object == DBNull.Value) continue;
            bl = true;
            break;
        }
        return !bl;
    }
}

