/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZCN;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzYRr;
import com.aspose.words.net.System.Data.zzZJO;
import com.aspose.words.net.System.Data.zzdC;
import com.aspose.words.net.System.Data.zzz4;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzPw;
    private final DataColumnCollection zzW6E;
    private final ConstraintCollection zzpn;
    private final zzdC zzZdI;
    private ResultSet zzzx;
    private String zzZyS;
    private DataSet zzX30;
    private String zzXZr;
    private UniqueConstraint zzla;
    private boolean zzjh;
    private final List<DataTableEventListener> zzZBC;
    private final Set<DataRow> zz4Z;
    private DataRelationCollection zzZZy;

    public DataTable() {
        this.zzPw = new DataRowCollection(this);
        this.zzW6E = new DataColumnCollection(this);
        this.zzpn = new ConstraintCollection(this);
        this.zzZdI = new zzdC(this);
        this.zzXZr = "";
        this.zzjh = true;
        this.zzZBC = new ArrayList<DataTableEventListener>();
        this.zz4Z = new HashSet<DataRow>();
        this.zzZZy = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzPw = new DataRowCollection(this);
        this.zzW6E = new DataColumnCollection(this);
        this.zzpn = new ConstraintCollection(this);
        this.zzZdI = new zzdC(this);
        this.zzXZr = "";
        this.zzjh = true;
        this.zzZBC = new ArrayList<DataTableEventListener>();
        this.zz4Z = new HashSet<DataRow>();
        this.zzZZy = new DataRelationCollection();
        this.zzZyS = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYRr.zzXkR(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzPw = new DataRowCollection(this);
        this.zzW6E = new DataColumnCollection(this);
        this.zzpn = new ConstraintCollection(this);
        this.zzZdI = new zzdC(this);
        this.zzXZr = "";
        this.zzjh = true;
        this.zzZBC = new ArrayList<DataTableEventListener>();
        this.zz4Z = new HashSet<DataRow>();
        this.zzZZy = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzzx = resultSet;
        this.zzZyS = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzzx != null) {
            if (this.zzzx.getStatement() != null) {
                this.zzzx.getStatement().getConnection().close();
            }
            this.zzzx = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZyS;
    }

    public void setTableName(String tableName) {
        this.zzZyS = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzW6E.getCount();
    }

    public String getColumnName(int index) {
        return this.zzW6E.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzzx;
    }

    public DataSet getDataSet() {
        return this.zzX30;
    }

    final void zzYBq(DataSet dataSet) {
        this.zzX30 = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzX30.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzZZy.add(dataRelation);
        }
        return this.zzZZy;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzX30.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzPw;
    }

    public DataColumnCollection getColumns() {
        return this.zzW6E;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzpn;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzla == null) {
            return new DataColumn[0];
        }
        return this.zzla.getColumns();
    }

    final void zzdC(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzla != null) {
                this.zzla.zzYji(false);
                this.getConstraints().remove(this.zzla);
                this.zzla = null;
            }
            return;
        }
        if (this.zzla != null && DataColumn.areColumnSetsTheSame(value, this.zzla.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXkR(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzla != null) {
            this.zzla.zzYji(false);
            this.getConstraints().remove(this.zzla);
            this.zzla = null;
        }
        UniqueConstraint.zzXkR(this.getConstraints(), uniqueConstraint);
        this.zzla = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzXZr;
    }

    public void setNamespace(String namespace) {
        this.zzXZr = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzjh;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzjh = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zz4Z.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYRr.zzXkR(this.getResultSet(), this);
            zzYRr.zzYRr(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzZCN.zzYBq(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYRr.zzZIr(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzZBC.contains(listener)) {
            this.zzZBC.add(listener);
        }
    }

    public void removeEventListener(zzZJO listener) {
        if (this.zzZBC.contains(listener)) {
            this.zzZBC.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzZBC.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zz4Z.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZBC) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zz4Z.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZBC) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zz4Z.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZBC) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZBC) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZBC) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzz4 zzXkR(zzYRr[] zzYRrArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzYRrArray.length];
        for (int i = 0; i < zzYRrArray.length; ++i) {
            dataColumnArray[i] = zzYRrArray[i].zzYKN();
        }
        DataTable dataTable = this;
        zzz4 zzz42 = dataTable.zzZdI.zzYBq(dataColumnArray);
        if (zzz42 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzz42;
    }

    final zzdC zzZ4J() {
        return this.zzZdI;
    }

    final Set<DataRow> zzWmU() {
        return this.zz4Z;
    }
}

