/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.minifier.js;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import net.logicsquad.minifier.AbstractMinifier;
import net.logicsquad.minifier.MinificationException;

public class JSMinifier
extends AbstractMinifier {
    private static final int EOF = -1;
    private final PushbackReader in;
    private int theA;
    private int theB;

    public JSMinifier(Reader reader) {
        super(reader);
        this.in = new PushbackReader(reader);
    }

    static boolean isAlphanum(int c) {
        return c >= 97 && c <= 122 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c == 95 || c == 36 || c == 92 || c > 126;
    }

    int get() throws IOException {
        int c = this.in.read();
        if (c >= 32 || c == 10 || c == -1) {
            return c;
        }
        if (c == 13) {
            return 10;
        }
        return 32;
    }

    int peek() throws IOException {
        int lookaheadChar = this.in.read();
        this.in.unread(lookaheadChar);
        return lookaheadChar;
    }

    int next() throws IOException, UnterminatedCommentException {
        int c = this.get();
        if (c == 47) {
            switch (this.peek()) {
                case 47: {
                    while ((c = this.get()) > 10) {
                    }
                    return c;
                }
                case 42: {
                    this.get();
                    while (true) {
                        switch (this.get()) {
                            case 42: {
                                if (this.peek() != 47) break;
                                this.get();
                                return 32;
                            }
                            case -1: {
                                throw new UnterminatedCommentException();
                            }
                        }
                    }
                }
            }
            return c;
        }
        return c;
    }

    void action(Action action, Writer out) throws IOException, UnterminatedRegExpLiteralException, UnterminatedCommentException, UnterminatedStringLiteralException {
        switch (action) {
            case OUTPUT_COPY_GET: {
                out.write(this.theA);
            }
            case COPY_GET: {
                this.theA = this.theB;
                if (this.theA == 39 || this.theA == 34) {
                    while (true) {
                        out.write(this.theA);
                        this.theA = this.get();
                        if (this.theA == this.theB) break;
                        if (this.theA <= 10) {
                            throw new UnterminatedStringLiteralException();
                        }
                        if (this.theA != 92) continue;
                        out.write(this.theA);
                        this.theA = this.get();
                    }
                }
            }
            case GET: {
                this.theB = this.next();
                if (this.theB != 47 || this.theA != 40 && this.theA != 44 && this.theA != 61 && this.theA != 58 && this.theA != 91 && this.theA != 33 && this.theA != 38 && this.theA != 124 && this.theA != 63 && this.theA != 123 && this.theA != 125 && this.theA != 59 && this.theA != 10) break;
                out.write(this.theA);
                out.write(this.theB);
                while (true) {
                    this.theA = this.get();
                    if (this.theA == 47) break;
                    if (this.theA == 92) {
                        out.write(this.theA);
                        this.theA = this.get();
                    } else if (this.theA <= 10) {
                        throw new UnterminatedRegExpLiteralException();
                    }
                    out.write(this.theA);
                }
                this.theB = this.next();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown action: " + (Object)((Object)action));
            }
        }
    }

    @Override
    public void minify(Writer writer) throws MinificationException {
        try {
            this.theA = 10;
            this.action(Action.GET, writer);
            block24: while (this.theA != -1) {
                switch (this.theA) {
                    case 32: {
                        if (JSMinifier.isAlphanum(this.theB)) {
                            this.action(Action.OUTPUT_COPY_GET, writer);
                            continue block24;
                        }
                        this.action(Action.COPY_GET, writer);
                        continue block24;
                    }
                    case 10: {
                        switch (this.theB) {
                            case 40: 
                            case 43: 
                            case 45: 
                            case 91: 
                            case 123: {
                                this.action(Action.OUTPUT_COPY_GET, writer);
                                continue block24;
                            }
                            case 32: {
                                this.action(Action.GET, writer);
                                continue block24;
                            }
                        }
                        if (JSMinifier.isAlphanum(this.theB)) {
                            this.action(Action.OUTPUT_COPY_GET, writer);
                            continue block24;
                        }
                        this.action(Action.COPY_GET, writer);
                        continue block24;
                    }
                }
                switch (this.theB) {
                    case 32: {
                        if (JSMinifier.isAlphanum(this.theA)) {
                            this.action(Action.OUTPUT_COPY_GET, writer);
                            continue block24;
                        }
                        this.action(Action.GET, writer);
                        continue block24;
                    }
                    case 10: {
                        switch (this.theA) {
                            case 34: 
                            case 39: 
                            case 41: 
                            case 43: 
                            case 45: 
                            case 93: 
                            case 125: {
                                this.action(Action.OUTPUT_COPY_GET, writer);
                                continue block24;
                            }
                        }
                        if (JSMinifier.isAlphanum(this.theA)) {
                            this.action(Action.OUTPUT_COPY_GET, writer);
                            continue block24;
                        }
                        this.action(Action.GET, writer);
                        continue block24;
                    }
                }
                this.action(Action.OUTPUT_COPY_GET, writer);
            }
        }
        catch (IOException | UnterminatedCommentException | UnterminatedRegExpLiteralException | UnterminatedStringLiteralException e) {
            throw new MinificationException("Minification failed due to Exception.", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new MinificationException("Minification failed due to Exception.", e);
            }
        }
    }

    static class UnterminatedRegExpLiteralException
    extends Exception {
        private static final long serialVersionUID = -5088088141334641219L;

        UnterminatedRegExpLiteralException() {
        }
    }

    static class UnterminatedStringLiteralException
    extends Exception {
        private static final long serialVersionUID = 3813645314180522143L;

        UnterminatedStringLiteralException() {
        }
    }

    static class UnterminatedCommentException
    extends Exception {
        private static final long serialVersionUID = 7971352218559346169L;

        UnterminatedCommentException() {
        }
    }

    private static enum Action {
        OUTPUT_COPY_GET,
        COPY_GET,
        GET;

    }
}

