/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.ProofOfPossessionOptions;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UserAgentUtil;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.identity.BrowserCustomizationOptions;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.HttpPipelineAdapter;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.ImdsRetryStrategy;
import com.azure.identity.implementation.MSIToken;
import com.azure.identity.implementation.PersistentTokenCacheImpl;
import com.azure.identity.implementation.RegionalAuthority;
import com.azure.identity.implementation.models.AzureCliToken;
import com.azure.identity.implementation.util.CertificateUtil;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.LoggingUtil;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.microsoft.aad.msal4j.AppTokenProviderParameters;
import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.HttpMethod;
import com.microsoft.aad.msal4j.IBroker;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentityId;
import com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import com.microsoft.aad.msal4j.OnBehalfOfParameters;
import com.microsoft.aad.msal4j.Prompt;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SystemBrowserOptions;
import com.microsoft.aad.msal4j.TokenProviderResult;
import com.microsoft.aad.msal4j.UserAssertion;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import reactor.core.publisher.Mono;

public abstract class IdentityClientBase {
    static final String WINDOWS_STARTER = "cmd.exe";
    static final String LINUX_MAC_STARTER = "/bin/sh";
    static final String WINDOWS_SWITCHER = "/c";
    static final String LINUX_MAC_SWITCHER = "-c";
    static final Pattern WINDOWS_PROCESS_ERROR_MESSAGE = Pattern.compile("'azd?' is not recognized");
    static final Pattern SH_PROCESS_ERROR_MESSAGE = Pattern.compile("azd?:.*not found");
    static final String DEFAULT_MAC_LINUX_PATH = "/bin/";
    static final Duration REFRESH_OFFSET = Duration.ofMinutes(5L);
    static final String IDENTITY_ENDPOINT_VERSION = "2019-08-01";
    static final String MSI_ENDPOINT_VERSION = "2017-09-01";
    static final String ARC_MANAGED_IDENTITY_ENDPOINT_API_VERSION = "2019-11-01";
    static final String ADFS_TENANT = "adfs";
    static final String HTTP_LOCALHOST = "http://localhost";
    static final String SERVICE_FABRIC_MANAGED_IDENTITY_API_VERSION = "2019-07-01-preview";
    static final ClientLogger LOGGER = new ClientLogger(IdentityClient.class);
    static final Pattern ACCESS_TOKEN_PATTERN = Pattern.compile("\"accessToken\": \"(.*?)(\"|$)");
    static final Pattern TRAILING_FORWARD_SLASHES = Pattern.compile("/+$");
    private static final String AZURE_IDENTITY_PROPERTIES = "azure-identity.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final ClientOptions DEFAULT_CLIENT_OPTIONS = new ClientOptions();
    private static final Map<String, HttpMethod> HTTP_METHOD_HASH_MAP = new HashMap<String, HttpMethod>(8);
    private final Map<String, String> properties = CoreUtils.getProperties((String)"azure-identity.properties");
    final IdentityClientOptions options;
    final String tenantId;
    final String clientId;
    final String resourceId;
    final String objectId;
    final String clientSecret;
    final String clientAssertionFilePath;
    final byte[] certificate;
    final String certificatePath;
    final Supplier<String> clientAssertionSupplier;
    final Function<HttpPipeline, String> clientAssertionSupplierWithHttpPipeline;
    final String certificatePassword;
    HttpPipelineAdapter httpPipelineAdapter;
    String userAgent = "azsdk-java";
    private Class<?> interactiveBrowserBroker;
    private Method getMsalRuntimeBroker;
    HttpPipeline httpPipeline;

    IdentityClientBase(String tenantId, String clientId, String clientSecret, String certificatePath, String clientAssertionFilePath, String resourceId, String objectId, Supplier<String> clientAssertionSupplier, Function<HttpPipeline, String> clientAssertionSupplierWithHttpPipeline, byte[] certificate, String certificatePassword, boolean isSharedTokenCacheCredential, Duration clientAssertionTimeout, IdentityClientOptions options) {
        if (tenantId == null) {
            tenantId = "organizations";
            options.setAdditionallyAllowedTenants(Collections.singletonList("*"));
        }
        if (options == null) {
            options = new IdentityClientOptions();
        }
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.objectId = objectId;
        this.resourceId = resourceId;
        this.clientSecret = clientSecret;
        this.clientAssertionFilePath = clientAssertionFilePath;
        this.certificatePath = certificatePath;
        this.certificate = certificate;
        this.certificatePassword = certificatePassword;
        this.clientAssertionSupplier = clientAssertionSupplier;
        this.clientAssertionSupplierWithHttpPipeline = clientAssertionSupplierWithHttpPipeline;
        this.options = options;
    }

    ConfidentialClientApplication getConfidentialClient(boolean enableCae) {
        IClientSecret credential;
        if (this.clientId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("A non-null value for client ID must be provided for user authentication."));
        }
        String authorityUrl = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        if (this.clientSecret != null) {
            credential = ClientCredentialFactory.createFromSecret((String)this.clientSecret);
        } else if (this.certificate != null || this.certificatePath != null) {
            try {
                byte[] certificateBytes = this.getCertificateBytes();
                if (CertificateUtil.isPem(certificateBytes)) {
                    List<X509Certificate> x509CertificateList = CertificateUtil.publicKeyFromPem(certificateBytes);
                    PrivateKey privateKey = CertificateUtil.privateKeyFromPem(certificateBytes);
                    if (x509CertificateList.size() == 1) {
                        credential = ClientCredentialFactory.createFromCertificate((PrivateKey)privateKey, (X509Certificate)x509CertificateList.get(0));
                    }
                    credential = ClientCredentialFactory.createFromCertificateChain((PrivateKey)privateKey, x509CertificateList);
                }
                try (InputStream pfxCertificateStream = this.getCertificateInputStream();){
                    credential = ClientCredentialFactory.createFromCertificate((InputStream)pfxCertificateStream, (String)this.certificatePassword);
                }
            }
            catch (IOException | GeneralSecurityException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse the certificate for the credential: " + e.getMessage(), e));
            }
        } else if (this.clientAssertionSupplier != null) {
            credential = ClientCredentialFactory.createFromClientAssertion((String)this.clientAssertionSupplier.get());
        } else if (this.clientAssertionSupplierWithHttpPipeline != null) {
            credential = ClientCredentialFactory.createFromClientAssertion((String)this.clientAssertionSupplierWithHttpPipeline.apply(this.getPipeline()));
        } else {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Must provide client secret or client certificate path. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/serviceprincipalauthentication/troubleshoot"));
        }
        ConfidentialClientApplication.Builder applicationBuilder = ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)credential);
        try {
            applicationBuilder = (ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)applicationBuilder.logPii(this.options.isUnsafeSupportLoggingEnabled())).authority(authorityUrl)).instanceDiscovery(this.options.isInstanceDiscoveryEnabled());
            if (!this.options.isInstanceDiscoveryEnabled()) {
                LOGGER.log(LogLevel.VERBOSE, () -> "Instance discovery and authority validation is disabled. In this state, the library will not fetch metadata to validate the specified authority host. As a result, it is crucial to ensure that the configured authority host is valid and trustworthy.");
            }
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
        }
        if (enableCae) {
            HashSet<String> set = new HashSet<String>(1);
            set.add("CP1");
            applicationBuilder.clientCapabilities(set);
        }
        applicationBuilder.sendX5c(this.options.isIncludeX5c());
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            applicationBuilder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            applicationBuilder.executorService(this.options.getExecutorService());
        }
        TokenCachePersistenceOptions tokenCachePersistenceOptions = this.options.getTokenCacheOptions();
        PersistentTokenCacheImpl tokenCache = null;
        if (tokenCachePersistenceOptions != null) {
            try {
                tokenCache = new PersistentTokenCacheImpl(enableCae).setAllowUnencryptedStorage(tokenCachePersistenceOptions.isUnencryptedStorageAllowed()).setName(tokenCachePersistenceOptions.getName());
                applicationBuilder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)tokenCache);
            }
            catch (Throwable t) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException("Shared token cache is unavailable in this environment.", null, t)));
            }
        }
        if (this.options.getRegionalAuthority() != null) {
            if (this.options.getRegionalAuthority() == RegionalAuthority.AUTO_DISCOVER_REGION) {
                applicationBuilder.autoDetectRegion(true);
            } else {
                applicationBuilder.azureRegion(this.options.getRegionalAuthority().toString());
            }
        }
        ConfidentialClientApplication confidentialClientApplication = applicationBuilder.build();
        if (tokenCache != null) {
            tokenCache.registerCache();
        }
        return confidentialClientApplication;
    }

    PublicClientApplication getPublicClient(boolean sharedTokenCacheCredential, boolean enableCae) {
        if (this.clientId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("A non-null value for client ID must be provided for user authentication."));
        }
        String authorityUrl = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        PublicClientApplication.Builder builder = PublicClientApplication.builder((String)this.clientId);
        try {
            builder = (PublicClientApplication.Builder)((PublicClientApplication.Builder)((PublicClientApplication.Builder)builder.logPii(this.options.isUnsafeSupportLoggingEnabled())).authority(authorityUrl)).instanceDiscovery(this.options.isInstanceDiscoveryEnabled());
            if (!this.options.isInstanceDiscoveryEnabled()) {
                LOGGER.log(LogLevel.VERBOSE, () -> "Instance discovery and authority validation is disabled. In this state, the library will not fetch metadata to validate the specified authority host. As a result, it is crucial to ensure that the configured authority host is valid and trustworthy.");
            }
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
        }
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            builder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            builder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            builder.executorService(this.options.getExecutorService());
        }
        if (enableCae) {
            HashSet<String> set = new HashSet<String>(1);
            set.add("CP1");
            builder.clientCapabilities(set);
        }
        if (this.options.isBrokerEnabled()) {
            if (this.interactiveBrowserBroker == null) {
                try {
                    this.interactiveBrowserBroker = Class.forName("com.azure.identity.broker.implementation.InteractiveBrowserBroker");
                }
                catch (ClassNotFoundException e) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Could not load the brokered authentication library. Ensure that the azure-identity-broker library is on the classpath.", e));
                }
                this.getMsalRuntimeBroker = null;
                try {
                    this.getMsalRuntimeBroker = this.interactiveBrowserBroker.getMethod("getMsalRuntimeBroker", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Could not obtain the InteractiveBrowserBroker. Ensure that the azure-identity-broker library is on the classpath.", e));
                }
            }
            try {
                if (this.getMsalRuntimeBroker == null) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Could not obtain the MSAL Broker. Ensure that the azure-identity-broker library is on the classpath.", null));
                }
                builder.broker((IBroker)this.getMsalRuntimeBroker.invoke(null, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Could not invoke the MSAL Broker. Ensure that the azure-identity-broker library is on the classpath.", e));
            }
        }
        TokenCachePersistenceOptions tokenCachePersistenceOptions = this.options.getTokenCacheOptions();
        PersistentTokenCacheImpl tokenCache = null;
        if (tokenCachePersistenceOptions != null) {
            try {
                tokenCache = new PersistentTokenCacheImpl(enableCae).setAllowUnencryptedStorage(tokenCachePersistenceOptions.isUnencryptedStorageAllowed()).setName(tokenCachePersistenceOptions.getName());
                builder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)tokenCache);
            }
            catch (Throwable t) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException("Shared token cache is unavailable in this environment.", null, t)));
            }
        }
        PublicClientApplication publicClientApplication = builder.build();
        if (tokenCache != null) {
            tokenCache.registerCache();
        }
        return publicClientApplication;
    }

    ConfidentialClientApplication getManagedIdentityConfidentialClient() {
        String authorityUrl = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        IClientSecret credential = ClientCredentialFactory.createFromSecret((String)(this.clientSecret != null ? this.clientSecret : "dummy-secret"));
        ConfidentialClientApplication.Builder applicationBuilder = ConfidentialClientApplication.builder((String)(this.clientId == null ? "SYSTEM-ASSIGNED-MANAGED-IDENTITY" : this.clientId), (IClientCredential)credential);
        ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)applicationBuilder.instanceDiscovery(false)).validateAuthority(false)).logPii(this.options.isUnsafeSupportLoggingEnabled());
        try {
            applicationBuilder = (ConfidentialClientApplication.Builder)applicationBuilder.authority(authorityUrl);
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
        }
        if (this.options.getManagedIdentityType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("Managed Identity type not configured, authentication not available.")));
        }
        applicationBuilder.appTokenProvider(appTokenProviderParameters -> {
            TokenRequestContext trc = new TokenRequestContext().setScopes(new ArrayList(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
            Mono<AccessToken> accessTokenAsync = this.getTokenFromTargetManagedIdentity(trc);
            return accessTokenAsync.map(accessToken -> {
                TokenProviderResult result = new TokenProviderResult();
                result.setAccessToken(accessToken.getToken());
                result.setTenantId(trc.getTenantId());
                result.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                if (accessToken.getRefreshAt() != null) {
                    result.setRefreshInSeconds(accessToken.getRefreshAt().toEpochSecond());
                }
                return result;
            }).toFuture();
        });
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            applicationBuilder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            applicationBuilder.executorService(this.options.getExecutorService());
        }
        return applicationBuilder.build();
    }

    ManagedIdentityApplication getManagedIdentityMsalApplication() {
        ManagedIdentityId managedIdentityId = !CoreUtils.isNullOrEmpty((CharSequence)this.clientId) ? ManagedIdentityId.userAssignedClientId((String)this.clientId) : (!CoreUtils.isNullOrEmpty((CharSequence)this.resourceId) ? ManagedIdentityId.userAssignedResourceId((String)this.resourceId) : (!CoreUtils.isNullOrEmpty((CharSequence)this.objectId) ? ManagedIdentityId.userAssignedObjectId((String)this.objectId) : ManagedIdentityId.systemAssigned()));
        ManagedIdentityApplication.Builder miBuilder = (ManagedIdentityApplication.Builder)ManagedIdentityApplication.builder((ManagedIdentityId)managedIdentityId).logPii(this.options.isUnsafeSupportLoggingEnabled());
        ManagedIdentitySourceType managedIdentitySourceType = ManagedIdentityApplication.getManagedIdentitySource();
        if (ManagedIdentitySourceType.DEFAULT_TO_IMDS.equals((Object)managedIdentitySourceType)) {
            this.options.setUseImdsRetryStrategy();
        }
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            miBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            miBuilder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            miBuilder.executorService(this.options.getExecutorService());
        }
        return miBuilder.build();
    }

    ConfidentialClientApplication getWorkloadIdentityConfidentialClient() {
        String authorityUrl = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        IClientSecret credential = ClientCredentialFactory.createFromSecret((String)(this.clientSecret != null ? this.clientSecret : "dummy-secret"));
        ConfidentialClientApplication.Builder applicationBuilder = ConfidentialClientApplication.builder((String)(this.clientId == null ? "SYSTEM-ASSIGNED-MANAGED-IDENTITY" : this.clientId), (IClientCredential)credential);
        try {
            applicationBuilder = (ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)applicationBuilder.authority(authorityUrl)).logPii(this.options.isUnsafeSupportLoggingEnabled())).instanceDiscovery(this.options.isInstanceDiscoveryEnabled());
            if (!this.options.isInstanceDiscoveryEnabled()) {
                LOGGER.log(LogLevel.VERBOSE, () -> "Instance discovery and authority validation is disabled. In this state, the library will not fetch metadata to validate the specified authority host. As a result, it is crucial to ensure that the configured authority host is valid and trustworthy.");
            }
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
        }
        applicationBuilder.appTokenProvider(this.getWorkloadIdentityTokenProvider());
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            applicationBuilder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            applicationBuilder.executorService(this.options.getExecutorService());
        }
        return applicationBuilder.build();
    }

    abstract Function<AppTokenProviderParameters, CompletableFuture<TokenProviderResult>> getWorkloadIdentityTokenProvider();

    DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder buildDeviceCodeFlowParameters(TokenRequestContext request, Consumer<DeviceCodeInfo> deviceCodeConsumer) {
        DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder parametersBuilder = DeviceCodeFlowParameters.builder(new HashSet(request.getScopes()), dc -> deviceCodeConsumer.accept(new DeviceCodeInfo(dc.userCode(), dc.deviceCode(), dc.verificationUri(), OffsetDateTime.now().plusSeconds(dc.expiresIn()), dc.message()))).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest((String)request.getClaims());
            parametersBuilder.claims(claimsRequest);
        }
        return parametersBuilder;
    }

    OnBehalfOfParameters buildOBOFlowParameters(TokenRequestContext request) {
        OnBehalfOfParameters.OnBehalfOfParametersBuilder builder = OnBehalfOfParameters.builder(new HashSet(request.getScopes()), (UserAssertion)this.options.getUserAssertion()).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest((String)request.getClaims());
            builder.claims(claimsRequest);
        }
        return builder.build();
    }

    InteractiveRequestParameters.InteractiveRequestParametersBuilder buildInteractiveRequestParameters(TokenRequestContext request, String loginHint, URI redirectUri) {
        BrowserCustomizationOptions browserCustomizationOptions;
        InteractiveRequestParameters.InteractiveRequestParametersBuilder builder = InteractiveRequestParameters.builder((URI)redirectUri).scopes(new HashSet(request.getScopes())).prompt(Prompt.SELECT_ACCOUNT).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest((String)request.getClaims());
            builder.claims(claimsRequest);
        }
        if (IdentityUtil.browserCustomizationOptionsPresent(browserCustomizationOptions = this.options.getBrowserCustomizationOptions())) {
            SystemBrowserOptions.SystemBrowserOptionsBuilder browserOptionsBuilder = SystemBrowserOptions.builder();
            if (!CoreUtils.isNullOrEmpty((CharSequence)browserCustomizationOptions.getSuccessMessage())) {
                browserOptionsBuilder.htmlMessageSuccess(browserCustomizationOptions.getSuccessMessage());
            }
            if (!CoreUtils.isNullOrEmpty((CharSequence)browserCustomizationOptions.getErrorMessage())) {
                browserOptionsBuilder.htmlMessageError(browserCustomizationOptions.getErrorMessage());
            }
            builder.systemBrowserOptions(browserOptionsBuilder.build());
        }
        if (this.options.isBrokerEnabled()) {
            builder.windowHandle(this.options.getBrokerWindowHandle());
            if (this.options.isMsaPassthroughEnabled()) {
                HashMap<String, String> extraQueryParameters = new HashMap<String, String>();
                extraQueryParameters.put("msal_request_type", "consumer_passthrough");
                builder.extraQueryParameters(extraQueryParameters);
            }
            if (request.getProofOfPossessionOptions() != null) {
                ProofOfPossessionOptions proofOfPossessionOptions = request.getProofOfPossessionOptions();
                try {
                    builder.proofOfPossession(IdentityClientBase.mapToMsalHttpMethod(proofOfPossessionOptions.getRequestMethod().toString()), proofOfPossessionOptions.getRequestUrl().toURI(), proofOfPossessionOptions.getProofOfPossessionNonce());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        if (loginHint != null) {
            builder.loginHint(loginHint);
        }
        return builder;
    }

    static HttpMethod mapToMsalHttpMethod(String methodName) {
        if (HTTP_METHOD_HASH_MAP.containsKey(methodName)) {
            return HTTP_METHOD_HASH_MAP.get(methodName);
        }
        if (HTTP_METHOD_HASH_MAP.size() > 10) {
            HTTP_METHOD_HASH_MAP.clear();
        }
        for (HttpMethod method : HttpMethod.values()) {
            if (!method.methodName.equalsIgnoreCase(methodName)) continue;
            HTTP_METHOD_HASH_MAP.put(methodName, method);
            return method;
        }
        throw new IllegalArgumentException("No enum constant with method name: " + methodName);
    }

    UserNamePasswordParameters.UserNamePasswordParametersBuilder buildUsernamePasswordFlowParameters(TokenRequestContext request, String username, String password) {
        UserNamePasswordParameters.UserNamePasswordParametersBuilder userNamePasswordParametersBuilder = UserNamePasswordParameters.builder(new HashSet(request.getScopes()), (String)username, (char[])password.toCharArray());
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest((String)request.getClaims());
            userNamePasswordParametersBuilder.claims(claimsRequest);
        }
        userNamePasswordParametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        return userNamePasswordParametersBuilder;
    }

    AccessToken getTokenFromAzureCLIAuthentication(StringBuilder azCommand) {
        AccessToken token;
        try {
            String switcher;
            String starter;
            if (IdentityUtil.isWindowsPlatform()) {
                starter = WINDOWS_STARTER;
                switcher = WINDOWS_SWITCHER;
            } else {
                starter = LINUX_MAC_STARTER;
                switcher = LINUX_MAC_SWITCHER;
            }
            ProcessBuilder builder = new ProcessBuilder(starter, switcher, azCommand.toString());
            builder.redirectInput(ProcessBuilder.Redirect.from(IdentityUtil.NULL_FILE));
            String workingDirectory = this.getSafeWorkingDirectory();
            if (workingDirectory == null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("A Safe Working directory could not be found to execute CLI command from. To mitigate this issue, please refer to the troubleshooting  guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
            }
            builder.directory(new File(workingDirectory));
            builder.redirectErrorStream(true);
            Process process = builder.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (WINDOWS_PROCESS_ERROR_MESSAGE.matcher(line).find() || SH_PROCESS_ERROR_MESSAGE.matcher(line).find()) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureCliCredential authentication unavailable. Azure CLI not installed.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
                    }
                    output.append(line);
                }
            }
            String processOutput = output.toString();
            process.waitFor(this.options.getCredentialProcessTimeout().getSeconds(), TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                if (processOutput.length() > 0) {
                    String redactedOutput = this.redactInfo(processOutput);
                    if (redactedOutput.contains("az login") || redactedOutput.contains("az account set")) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureCliCredential authentication unavailable. Please run 'az login' to set up account. To further mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
                    }
                    throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException(redactedOutput, null)));
                }
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException("Failed to invoke Azure CLI ", null)));
            }
            LOGGER.verbose("Azure CLI Authentication => A token response was received from Azure CLI, deserializing the response into an Access Token.");
            try (JsonReader reader = JsonProviders.createReader((String)processOutput);){
                AzureCliToken tokenHolder = AzureCliToken.fromJson(reader);
                String accessToken = tokenHolder.getAccessToken();
                OffsetDateTime tokenExpiration = tokenHolder.getTokenExpiration();
                token = new AccessToken(accessToken, tokenExpiration);
            }
        }
        catch (IOException | InterruptedException e) {
            IllegalStateException ex = new IllegalStateException(this.redactInfo(e.getMessage()));
            ex.setStackTrace(e.getStackTrace());
            throw LOGGER.logExceptionAsError((RuntimeException)ex);
        }
        return token;
    }

    AccessToken getTokenFromAzureDeveloperCLIAuthentication(StringBuilder azdCommand) {
        AccessToken token;
        try {
            String switcher;
            String starter;
            if (IdentityUtil.isWindowsPlatform()) {
                starter = WINDOWS_STARTER;
                switcher = WINDOWS_SWITCHER;
            } else {
                starter = LINUX_MAC_STARTER;
                switcher = LINUX_MAC_SWITCHER;
            }
            ProcessBuilder builder = new ProcessBuilder(starter, switcher, azdCommand.toString());
            builder.redirectInput(ProcessBuilder.Redirect.from(IdentityUtil.NULL_FILE));
            String workingDirectory = this.getSafeWorkingDirectory();
            if (workingDirectory == null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("A Safe Working directory could not be found to execute Azure Developer CLI command from."));
            }
            builder.directory(new File(workingDirectory));
            builder.redirectErrorStream(true);
            Process process = builder.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8.name()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (WINDOWS_PROCESS_ERROR_MESSAGE.matcher(line).find() || SH_PROCESS_ERROR_MESSAGE.matcher(line).find()) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureDeveloperCliCredential authentication unavailable. Azure Developer CLI not installed.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azdevclicredential/troubleshoot"));
                    }
                    output.append(line);
                }
            }
            String processOutput = output.toString();
            process.waitFor(this.options.getCredentialProcessTimeout().getSeconds(), TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                if (processOutput.length() > 0) {
                    String redactedOutput = this.redactInfo(processOutput);
                    if (redactedOutput.contains("azd auth login") || redactedOutput.contains("not logged in")) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureDeveloperCliCredential authentication unavailable. Please run 'azd auth login' to set up account."));
                    }
                    throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException(redactedOutput, null)));
                }
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException("Failed to invoke Azure Developer CLI ", null)));
            }
            LOGGER.verbose("Azure Developer CLI Authentication => A token response was received from Azure Developer CLI, deserializing the response into an Access Token.");
            try (JsonReader reader = JsonProviders.createReader((String)processOutput);){
                reader.nextToken();
                Map objectMap = reader.readMap(JsonReader::getString);
                String accessToken = (String)objectMap.get("token");
                String time = (String)objectMap.get("expiresOn");
                String standardTime = time.substring(0, time.indexOf("Z"));
                OffsetDateTime expiresOn = LocalDateTime.parse(standardTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(ZoneId.of("Z")).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
                token = new AccessToken(accessToken, expiresOn);
            }
        }
        catch (IOException | InterruptedException e) {
            IllegalStateException ex = new IllegalStateException(this.redactInfo(e.getMessage()));
            ex.setStackTrace(e.getStackTrace());
            throw LOGGER.logExceptionAsError((RuntimeException)ex);
        }
        return token;
    }

    AccessToken authenticateWithExchangeTokenHelper(TokenRequestContext request, String assertionToken) throws IOException {
        String authorityUrl = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId + "/oauth2/v2.0/token";
        String urlParams = "client_assertion=" + assertionToken + "&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer&client_id=" + this.clientId + "&grant_type=client_credentials&scope=" + IdentityClientBase.urlEncode((String)request.getScopes().get(0));
        byte[] postData = urlParams.getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        HttpURLConnection connection = null;
        URL url = IdentityClientBase.getUrl(authorityUrl);
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", Integer.toString(postDataLength));
            connection.setRequestProperty("User-Agent", this.userAgent);
            connection.setDoOutput(true);
            try (Object outputStream = new DataOutputStream(connection.getOutputStream());){
                outputStream.write(postData);
            }
            connection.connect();
            outputStream = MSIToken.fromJson(JsonProviders.createReader((InputStream)connection.getInputStream()));
            return outputStream;
        }
        catch (IOException exception) {
            int responseCode;
            if (connection == null) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Could not connect to the authority host: " + url + ".", exception));
            }
            try {
                responseCode = connection.getResponseCode();
            }
            catch (Exception e) {
                throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("WorkloadIdentityCredential authentication unavailable. Connection to the authority host cannot be established, " + e.getMessage() + ".", e));
            }
            if (responseCode == 400) {
                throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("WorkloadIdentityCredential authentication unavailable. The request to the authority host was invalid. Additional details: " + exception.getMessage() + ".", exception));
            }
            throw LOGGER.logExceptionAsError(new RuntimeException("Couldn't acquire access token from Workload Identity.", exception));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    String getSafeWorkingDirectory() {
        if (IdentityUtil.isWindowsPlatform()) {
            String windowsSystemRoot = System.getenv("SystemRoot");
            if (CoreUtils.isNullOrEmpty((CharSequence)windowsSystemRoot)) {
                return null;
            }
            return windowsSystemRoot + "\\system32";
        }
        return DEFAULT_MAC_LINUX_PATH;
    }

    String redactInfo(String input) {
        return ACCESS_TOKEN_PATTERN.matcher(input).replaceAll("****");
    }

    abstract Mono<AccessToken> getTokenFromTargetManagedIdentity(TokenRequestContext var1);

    HttpPipeline setupPipeline() {
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        Configuration buildConfiguration = Configuration.getGlobalConfiguration().clone();
        HttpLogOptions httpLogOptions = this.options.getHttpLogOptions() == null ? new HttpLogOptions() : this.options.getHttpLogOptions();
        ClientOptions localClientOptions = this.options.getClientOptions() != null ? this.options.getClientOptions() : DEFAULT_CLIENT_OPTIONS;
        this.userAgent = UserAgentUtil.toUserAgentString((String)CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)httpLogOptions), (String)clientName, (String)clientVersion, (Configuration)buildConfiguration);
        policies.add(new UserAgentPolicy(this.userAgent));
        ArrayList httpHeaderList = new ArrayList();
        localClientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
        policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        policies.addAll(this.options.getPerCallPolicies());
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        RetryPolicy retryPolicy = this.options.getRetryPolicy();
        if (retryPolicy == null && this.options.getUseImdsRetryStrategy()) {
            retryPolicy = new RetryPolicy((RetryStrategy)new ImdsRetryStrategy());
        }
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)retryPolicy, (RetryOptions)this.options.getRetryOptions()));
        policies.addAll(this.options.getPerRetryPolicies());
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(httpLogOptions));
        return new HttpPipelineBuilder().httpClient(this.options.getHttpClient()).clientOptions(localClientOptions).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }

    void initializeHttpPipelineAdapter() {
        if (this.options.getProxyOptions() == null) {
            this.httpPipelineAdapter = new HttpPipelineAdapter(this.getPipeline(), this.options);
        }
    }

    HttpPipeline getPipeline() {
        if (this.httpPipeline != null) {
            return this.httpPipeline;
        }
        HttpPipeline httpPipeline = this.options.getHttpPipeline();
        if (httpPipeline != null) {
            this.httpPipeline = httpPipeline;
            return this.httpPipeline;
        }
        this.httpPipeline = this.setupPipeline();
        return this.httpPipeline;
    }

    private byte[] getCertificateBytes() throws IOException {
        if (this.certificatePath != null) {
            return Files.readAllBytes(Paths.get(this.certificatePath, new String[0]));
        }
        if (this.certificate != null) {
            return this.certificate;
        }
        return new byte[0];
    }

    private InputStream getCertificateInputStream() throws IOException {
        if (this.certificatePath != null) {
            return new BufferedInputStream(new FileInputStream(this.certificatePath));
        }
        return new ByteArrayInputStream(this.certificate);
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions options) {
        switch (options.getType()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, options.getAddress());
            }
        }
        return new Proxy(Proxy.Type.HTTP, options.getAddress());
    }

    static String urlEncode(String value) throws IOException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
    }

    static URL getUrl(String uri) throws MalformedURLException {
        return new URL(uri);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }
}

