/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chore.sax;

import ambience.etl.chore.ChoreFileObject;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chore.model.Holder;
import com.elixirtech.chore.model.HolderSAX;
import com.elixirtech.chore.model.Job;
import com.elixirtech.chore.model.JobSAX;
import com.elixirtech.chore.model.Task;
import com.elixirtech.chore.sax.ChoreSAXOut;
import com.elixirtech.chore.sax.IJobBuilder;
import com.elixirtech.chore.sax.JobBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;

public class JobLoader {
    public static final String JOB = "Job";
    public static final int VERSION = 1;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JobLoader.class);
    private static final Map<String, IJobBuilder> m_JobBuilders = new HashMap<String, IJobBuilder>();

    public static void registerJobBuilder(String string, IJobBuilder iJobBuilder) {
        m_JobBuilders.put(string, iJobBuilder);
    }

    public static String[] getSupportedExtensions() {
        return m_JobBuilders.keySet().toArray(new String[0]);
    }

    public static Job readJob(ChoreFileObject choreFileObject) throws IOException {
        String string = choreFileObject.getExtension();
        IJobBuilder iJobBuilder = m_JobBuilders.get(string);
        if (iJobBuilder == null) {
            throw new IOException("Unknown job extension: " + string);
        }
        return iJobBuilder.build(choreFileObject);
    }

    public static void close(ChoreFileObject choreFileObject) {
    }

    public static Job deepCopy(Job job) {
        JobSAX jobSAX = new JobSAX();
        ChoreSAXOut.process((ContentHandler)((Object)jobSAX), job, false);
        Job job2 = (Job)jobSAX.getObject();
        job2.loaded();
        return job2;
    }

    public static Task deepCopy(Task task) {
        HolderSAX holderSAX = new HolderSAX();
        Holder holder = new Holder();
        holder.addContent(task);
        ChoreSAXOut.process((ContentHandler)((Object)holderSAX), holder, false);
        Holder holder2 = (Holder)holderSAX.getObject();
        holder2.loaded();
        return (Task)holder2.getContent(0);
    }

    static {
        JobLoader.registerJobBuilder("job", new JobBuilder());
    }
}

