/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chore.JobContext;
import com.elixirtech.chore.model.Script;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.v2.jobengine.job.CompositeRunnable;
import com.elixirtech.v2.jobengine.job.NonRecoverableException;
import com.elixirtech.v2.jobengine.job.RecoverableException;
import com.elixirtech.v2.jobengine.job.ScriptLogger;
import com.elixirtech.v2.jobengine.job.TaskException;
import java.util.List;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptRunnable
extends CompositeRunnable {
    public static final String TYPE = "Script";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ScriptRunnable.class);

    @Override
    public void run(JobContext jobContext) throws TaskException {
        jobContext.debug(TYPE, "Start");
        Script script = (Script)this.m_Task;
        String string = script.getLanguage();
        if ("javascript".equals(string)) {
            String string2 = script.getText();
            string2 = jobContext.substitute(string2);
            JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
            List<ScriptableObject> list = JobContext.asJava(jobContext.getScope());
            for (ScriptableObject scriptableObject : list) {
                javaScriptEngine.pushScope((Scriptable)scriptableObject);
            }
            javaScriptEngine.declareBean("Log", (Object)new ScriptLogger(jobContext));
            try {
                javaScriptEngine.execute(script.getName(), string2);
            }
            catch (ScriptException scriptException) {
                jobContext.error(TYPE, scriptException.getMessage());
                m_Log.error((Object)("Error in script: " + scriptException), (Throwable)scriptException);
                throw new RecoverableException((Exception)((Object)scriptException));
            }
            finally {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    javaScriptEngine.popScope();
                }
            }
        } else {
            String string3 = "Unknown script language: " + string;
            jobContext.warn(TYPE, string3);
            throw new NonRecoverableException(string3);
        }
        jobContext.debug(TYPE, "End");
    }
}

