/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import com.elixirtech.arch.StringUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeUtil {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final DateFormat DEFAULT_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat DEFAULT_TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter JodaDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    public static final DateTimeFormatter JodaTimestampFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final String INTERVAL_PATTERN = "([0-9]+)\\s*(ms|s|m|h|d|sec|secs|second|seconds|min|mins|minute|minutes|hour|hours|day|days)?";
    private static final Map<String, Long> MULTIPLIERS = new HashMap<String, Long>();

    public static long parseInterval(String string) {
        Pattern pattern = Pattern.compile(INTERVAL_PATTERN);
        Matcher matcher = pattern.matcher(string.trim());
        if (matcher.matches()) {
            long l = Long.parseLong(matcher.group(1));
            long l2 = 1L;
            if (StringUtil.notEmpty((String)matcher.group(2))) {
                l2 = MULTIPLIERS.get(matcher.group(2));
            }
            return l * l2;
        }
        throw new RuntimeException("Unable to parse interval=\"" + string + "\"");
    }

    static {
        MULTIPLIERS.put("ms", 1L);
        MULTIPLIERS.put("s", 1000L);
        MULTIPLIERS.put("m", 60000L);
        MULTIPLIERS.put("h", 3600000L);
        MULTIPLIERS.put("d", 86400000L);
        MULTIPLIERS.put("sec", 1000L);
        MULTIPLIERS.put("secs", 1000L);
        MULTIPLIERS.put("second", 1000L);
        MULTIPLIERS.put("seconds", 1000L);
        MULTIPLIERS.put("min", 60000L);
        MULTIPLIERS.put("mins", 60000L);
        MULTIPLIERS.put("minute", 60000L);
        MULTIPLIERS.put("minutes", 60000L);
        MULTIPLIERS.put("hour", 3600000L);
        MULTIPLIERS.put("hours", 3600000L);
        MULTIPLIERS.put("day", 86400000L);
        MULTIPLIERS.put("days", 86400000L);
    }
}

