## SFTP Writer

This step collects the bytes from all incoming records and concatenates them into a single file
which is written to the SFTP Server.

### Structure
N ⇒ 1

### Input

Each incoming record should contain a `bytes` binary field. 

Remember you can convert strings to binary (UTF-8) with Change Field Type.

### Parameters

* `Host` - the SFTP Server

* `Port` - the port to connect to on the SFTP Server

* `Directory` - the SFTP server directory into which the concatenated bytes will be written

* `Filename` - the filename for the created file

* `User` - the user information (from the conf) to use for authentication 

### Output

A single record is output containing:

* `count` - the number of bytes chunks received

* `length` - the total length of bytes written to the SFTP server

* `elapsedTime` - how long the operation took

### Notes

* The filename needs to be fixed in the step, because it cannot be passed with the N records received. What if
it was different for some records? If you need a dynamic filename, then concatenate the bytes separately first 
and use the SFTP Writer (Field) variant.

### See Also

* SFTP Reader

* SFTP Writer (Field)
