/**
NaviFrame.js
Simple JavaScript that enables navigation of a set of pages in different frames
Version: 1.0
*/

//pages array from pageList.js
var thisPage=1; //current Page Number
var lastp = (pages.length-1);

function toggle(id) {
	var e = document.getElementById(id);
	if(e != null)
	{
	    if (e.style.display == 'block')
	    {
	        e.style.display = 'none';
	    } else {
	        e.style.display = 'block';
	    }
	}
}

function toggleToc() {
	toggle('page-index');
	toggle('toc-index');
}

function nextPage(){
	if ((thisPage+1) > lastp)
	{
		//alert('Last Page');
	}
	else
	{
		thisPage = thisPage + 1;
		showPage(thisPage);
	}
}
function previousPage()
	{
	if ((thisPage - 1) < 1)
	{
		//alert('First Page');
	}
	else
	{
		thisPage = thisPage - 1;
		showPage(thisPage);
	}
}

function lastPage()
{
	showPage(lastp);
}

function showPage(num)
{
	//navigates to destination page Number
	if (typeof num == "string")
	{
		num = parseInt(num);
	}
	if (num>lastp)
	{
		num=lastp;
	}
	if (num<1)
	{
		num=1;
	}
	thisPage=num;
	
	//go to that page if all is valid
	window.frames['mainFrame'].document.location.href = pages[thisPage];
	
	
	// set the page number in the pageNumber text field of the NavigationFrame
	document.forms['form1'].pageNumber.value=thisPage;
}

function showAnchor(page, anch)
{
	//loads the anchor link in the main frame and sets the page number
	for (i=0; i<lastp; i++)
	{
		if (page==pages[i])
		{
			num = i;
			break;
		}

		//get page number
	}
	if (num>lastp)
	{
		num=lastp;
	}
	if(num<1)
	{
		num=1;
	}
	thisPage=num;
	
	document.location.href = pages[thisPage] + "#" + anch;
	// set the page number in the pageNumber text field of the NavigationFrame
	document.forms['form1'].pageNumber.value=thisPage;
}

function setNoPages()
{
	//sets the number of pages in the navigation bar
	document.getElementById('noPages').innerHTML=" of " + lastp;
}


function newImage(arg) {
	if (document.images) {
		rslt = new Image();
		rslt.src = arg;
		return rslt;
	}
}

function changeImages() {
	if (document.images && (preloadFlag == true)) {
		for (var i=0; i<changeImages.arguments.length; i+=2) {
			document[changeImages.arguments[i]].src = changeImages.arguments[i+1];
		}
	}
}

var preloadFlag = false;
function preloadImages() {
	if (document.images) {
		nav_first_over = newImage("navImgs/nav_first-over.gif");
		nav_first_down = newImage("navImgs/nav_first-down.gif");
		nav_back_over = newImage("navImgs/nav_back-over.gif");
		nav_back_down = newImage("navImgs/nav_back-down.gif");
		nav_go_over = newImage("navImgs/nav_go-over.gif");
		nav_go_down = newImage("navImgs/nav_go-down.gif");
		nav_next_over = newImage("navImgs/nav_next-over.gif");
		nav_next_down = newImage("navImgs/nav_next-down.gif");
		nav_last_over = newImage("navImgs/nav_last-over.gif");
		nav_last_down = newImage("navImgs/nav_last-down.gif");
		nopages = document.getElementById('noPages');
		setNoPages();
		preloadFlag = true;
	}
}
// end of naviFrame.js
