var Unilever1 = {
    "application": "Elixir Data Mixer",
    "mixer": {
        "columns": [
            {
                "bad": 66,
                "good": 100
            },
            {
                "bad": 66,
                "good": 100
            },
            {
                "bad": 40,
                "good": 100
            }
        ],
        "cutoff": 40,
        "sample": 20,
        "sourcePatches": [
            1,
            2,
            0
        ],
        "targetPatches": [
            1,
            2,
            0
        ]
    },
    "module": "Project",
    "source": {
        "application": "Elixir Data Mixer",
        "definitions": "PREPROCESS (S) SINGAPORE\n\nPREPROCESS 7-11 \"\"\n\nPREPROCESS \"`\" \"\"\nPREPROCESS \".\" \" \"\nPREPROCESS \",\" \" \"\nPREPROCESS \"(\" \" \"\nPREPROCESS \")\" \" \"\nPREPROCESS \"&\" \" \"\n\nALIAS M/M MINIMART\nALIAS MINI-MART MINIMART\nALIAS SMKT SUPERMARKET\nALIAS RD ROAD\nALIAS AVE AVENUE\nALIAS ST STREET\nALIAS JLN JALAN\nALIAS CRESC CRESCENT\nALIAS DR DRIVE\n\nPATTERN \"BLK[ ]*([0-9]+(\\-[0-9]+)?)\" Block \"BLK $1\"\nPATTERN \"BLOCK[ ]*([0-9]+(\\-[0-9]+)?)\" Block \"BLK $1\"\n\nPATTERN \"\\#[ ]*([A-Z]?[0-9]+)[ -]([A-Z]?[0-9]+(/[0-9]+)?)\" Unit \"#$1-$2\"\nPATTERN \"UNIT[ ]*([A-Z]?[0-9]+)[ -]([A-Z]?[0-9]+(/[0-9]+)?)\" Unit \"#$1-$2\"\nPATTERN \"NO[ ]*([A-Z]?[0-9]+)[ -]([A-Z]?[0-9]+(/[0-9]+)?)\" Unit \"#$1-$2\"\n\nPOSTPROCESS \"MINI MART\" MINIMART\n",
        "headers": [
            "DMS.Retailer.name",
            "DMS.Retailer.address",
            "DMS.Retailer.postal"
        ],
        "module": "Dataset",
        "name": "DMSData.csv",
        "records": [
            [
                "7-11 STORE 9.74.0 MARINA BAY CRUISE",
                "NO 61 MARINA COASTAL DRIVE UNIT 02 04  ",
                "18947"
            ],
            [
                "BARRAGE COVE",
                "8 MARINA GARDEN DRIVE UNIT 01-03 MARINA BARRAGE  ",
                "18951"
            ],
            [
                "CAFE CREMA",
                "18 MARINA GARDENS DRIVE ARRIVAL SQUARE GARDENS BY THE BAY ",
                "18953"
            ],
            [
                "STAR BUY - SATAY BY THE BAY",
                "18 MARINE GARDEN DRIVE UNIT 01-27  ",
                "18953"
            ],
            [
                "SINGTEL MOBILE SINGAPORE ",
                "MARINA BAY SANDS BASEMENT 2, HALL D  ",
                "18956"
            ],
            [
                "MARINA BAY SANDS PTE LTD",
                "10 BAY FRONT AVENUE   ",
                "18956"
            ],
            [
                "MARINA BAY SANDS - SKY POOL BAR",
                "10 BAY FRONT AVENUE UNIT 57-00  ",
                "18956"
            ],
            [
                "TRIPLE O`S - MARINA VIEW",
                "8 MARINA VIEW #02-16 ASIA SQUARE 1  ",
                "18960"
            ],
            [
                "GUSTOS PTE LTD - GOOGLE",
                "8 MARINA VIEW ASIA SQUARE TOWER 1 30TH FLR   ",
                "18960"
            ],
            [
                "FOODNATION 4",
                "KILLINEY 12 MARINA VIEW SQUARE TOWER 2 #02-06  ",
                "18961"
            ],
            [
                "CHEERS DOWNTOWN MRT (CCBDTL)(841)",
                "NO. 15 CENTRAL BOULEVARD DOWNTOWN #B1-02 DOWNTOWN DTL MRT STATION  ",
                "18969"
            ],
            [
                "7-11 STORE 581 MBS B2",
                "NO. 1 BAY FRONT AVENUE #B2-01 THE SHOPPES AT MARINA BAY SANDS  ",
                "18971"
            ],
            [
                "7-11 STORE 364 MBS L1",
                "NO. 2 BAYFRONT AVENUE #01-74/76 THE SHOPPES AT MARINA BAY SANDS  ",
                "18972"
            ],
            [
                "KRAZE F&B PTE LTD",
                "KRAZE BURGERS MARINA BAY SANDS 2 BAYFRONT AVE B2-54/55 ",
                "18972"
            ],
            [
                "FOUR SEASONS GOURMET MARKET PTE LTD",
                "8A MARINA BOULEVARD UNIT B2-49 MARINA BAY LINK MALL ",
                "18981"
            ],
            [
                "CONRAD CENTENNIAL SINGAPORE",
                "2 TEMASEK BOULEVARD   ",
                "38982"
            ],
            [
                "GUKSU PTE LTD",
                "3 TEMASEK BLVD #02-385  ",
                "38983"
            ],
            [
                "SARIKA CONNOISSEUR CAFE - SUNTEC",
                "3 TEMASEK BOULEVARD #01-361/362 SUNTEC CITY MALL  ",
                "38983"
            ],
            [
                "SINGAPORE DUCKTOURS PTE LTD",
                "3 TEMASEK BOULVARD UNIT 01-330 SUNTEC CITY MALL  ",
                "38983"
            ],
            [
                "OLIO BITES",
                "9 TEMASEK BLVD SUNTEC TOWER TWO #06-03 ",
                "38989"
            ],
            [
                "7-11 STORE 705 PROMENADE MRT",
                "NO. 2 TEMASEK AVENUE #B1-01 PROMENADE MRT STATION  ",
                "39193"
            ],
            [
                "MEYVE FRUIT SHAKES",
                "1 RAFFLES LINK CITYLINK MALL B1-66  ",
                "39393"
            ],
            [
                "SUNTEC SINGAPORE INTL CONVENTION",
                "1 RAFFLES BOULEVARD SUNTEC CITY  ",
                "39593"
            ],
            [
                "JP FOOD SERVICES -KKONGDON MARINA LINK",
                "6 RAFFLES BOULEVARD #B1-01/02 MARINA LINK  ",
                "39594"
            ],
            [
                "EPIC FOODS & PRODUCTS",
                "06 RAFFLES BLVD #01-18 MARINA SQUARE  ",
                "39594"
            ],
            [
                "MARINA MANDARIN HOTEL",
                "6 RAFFLES BLVD MARINA SQUARE  ",
                "39594"
            ],
            [
                "FOODNATION 1",
                "MARINA SQUARE SHOPPING CENTRE #02-230A RAFFLES BLVD  ",
                "39594"
            ],
            [
                "7-11 STORE 9.71.0 MARINA SQ L1",
                "6 RAFFLES BOULEVARD UNIT 01 -209 MARINA SQ  ",
                "39594"
            ],
            [
                "PIZZA HUT - MARINA SQUARE",
                "NO. 6 RAFFLES BOULEVARD UNIT 03-211 MARINA SQUARE  ",
                "39594"
            ],
            [
                "OBS RESTAURANT SINGAPORE PTE LTD",
                "9 RAFFLES BOULEVARD UNIT 01-114  ",
                "39596"
            ],
            [
                "OUTBACK STEAKHOUSE",
                "9 RAFFLES BLVD TIME SQUARE MILLENIA WALK ",
                "39596"
            ],
            [
                "7-11 STORE 471 SINGAPORE FLYER",
                "38 RAFFLES AVENUE NO 01-08  ",
                "39803"
            ],
            [
                "EACH A CUP - SG FLYER",
                "30 RAFFLES AVENUE UNIT 01-06C SINGAPORE FLYER  ",
                "39803"
            ],
            [
                "CHEERS SUNTEC CITY #01-615 (CSTCML)",
                "3 TEMASEK BOULEVARD, SUNTEC CITY MALL UNIT 01-615  ",
                "39983"
            ],
            [
                "CHEERS - TELOK AYER DTL 843 CTADTL",
                "7 CROSS STREET TELOK AYER TELOK AYER DTL MRT STATION, UNIT B1-02  ",
                "48416"
            ],
            [
                "COUNTRY FOODS - PWC CAFE",
                "8 CROSS STREET PWC BUILDING UNIT 07-00  ",
                "48424"
            ],
            [
                "FORM SUPPLIES (S) PTE LTD - CHINA SQUARE",
                "51 TELOK AYER ST #01-16/17  ",
                "48441"
            ],
            [
                "CHEERS LAU PA SAT (CLPSA)(852)",
                "18 Raffles Quay, Lau Pa Sat No. 66  ",
                "48582"
            ],
            [
                "7-11 STORE 423 ONE RAFFLES QUAY B2",
                "1 RAFFLES QUAY B2 08/09 ONE RAFFLES QUAY  ",
                "48583"
            ],
            [
                "7-11 STORE 727 RAFFLES MRT B2",
                "NO. 5 RAFFES PLACE #B2-01 RAFFLES PLACE MRT STATION  ",
                "48616"
            ],
            [
                "7-11 STORE 721 RAFFLES MRT B1-60/61",
                "NO. 5 RAFFLES PLACE #B1-60/61 RAFFLES PLACE MRT STATION  ",
                "48618"
            ],
            [
                "7-11 STORE 327 RAFFLES MRT B1-53",
                "5 RAFFLES PLACE B1 53 RAFFLES PLACE MRT STN  ",
                "48618"
            ],
            [
                "JUZ BREAD - RAFFLES",
                "1 RAFFLES PLACE SHOPPING  OUB CENTRE B1-36/37 ",
                "48618"
            ],
            [
                "ITOLOGY PTE LTD",
                "5 RAFFLES PLACE  #B1-01 RAFFLES ECHANGE  ",
                "48618"
            ],
            [
                "7-11 STORE 194 CLIFFORD CENTRE",
                "24 RAFFLES PLACE UNIT 01 15 Clifford Centre  ",
                "48621"
            ],
            [
                "CALTEX - CHEVRON HOUSE",
                "30 RAFFLES PL #21-00  ",
                "48622"
            ],
            [
                "7-11 STORE 220 CHINA SQUARE",
                "NO. 3 PICKERING STREET #01-24/25 CHINA SQUARE  ",
                "48660"
            ],
            [
                "LAGUNA NATIONAL GOLF & COUNTRY CLUB",
                "11 LAGUNA GOLF GREEN   ",
                "48804"
            ],
            [
                "SOCKS & PANS",
                "50 MARKET ST GOLDEN SHOE CARPARK #01-23 ",
                "48940"
            ],
            [
                "7-11 STORE 261 GOLDEN SHOE",
                "NO. 50 MARKET STREET #01-24 GOLDEN SHOE CAR PARK  ",
                "48940"
            ],
            [
                "7-11 STORE 774 COLLYER QUAY",
                "16 COLLYER QUAY UNIT 01 09  ",
                "49318"
            ],
            [
                "7-11 STORE 440 CANTON ST",
                "8 CANTON STREET   ",
                "49748"
            ],
            [
                "SAVLA`S EXPRESS MART",
                "NO. 60 BOAT QUAY   ",
                "49848"
            ],
            [
                "MERCHANT COURT PTE LTD",
                "20 MERCHANT ROAD   ",
                "58281"
            ],
            [
                "7-11 STORE 386 RIVERSIDE POINT",
                "30 MERCHANT ROAD 01 01B RIVERSIDE POINT  ",
                "58282"
            ],
            [
                "PARKROYAL ON PICKERING",
                "3 UPPER PICKERING ST   ",
                "58289"
            ],
            [
                "CHEERS PPL PARK CTR (CPPARK)(829)",
                "NO. 101 UPPER CROSS STREET #01-26E/F PEOPLE`S PARK COMPLEX  ",
                "58357"
            ],
            [
                "KWONG ONN HERBAL",
                "16 TRENGGANG ST   ",
                "58470"
            ],
            [
                "7-11 STORE 787 PEOPLE`S PARK CENTRE",
                "NO. 101 UPPER CROSS STREET #01-05H PEOPLE`S PARK CENTRE  ",
                "58588"
            ],
            [
                "7-11 STORE 207 SOUTH BRIDGE RD",
                "15 SOUTH BRIDGE ROAD .  ",
                "58658"
            ],
            [
                "7-11 STORE 9.80.0 SOUTH BRIDGE ROAD",
                "NO. 63 SOUTH BRIDGE ROAD LEVEL 1  ",
                "58693"
            ],
            [
                "7-11 STORE 449 FOCK HAI BLDG",
                "NO.150, SOUTH BRIDGE RD #01-05 FOCK HAI BUILDING  ",
                "58727"
            ],
            [
                "ON TAI GINSENG TRADITIONAL MEDICAL HALL",
                "256 SOUTH BRIDGE ROAD   ",
                "58805"
            ],
            [
                "HOMEMART 247",
                "272 SOUTH BRIDGE ROAD   ",
                "58821"
            ],
            [
                "DAYIPIN RESTAURANT PLACE",
                "277/279 SOUTH BRIDGE ROAD   ",
                "58826"
            ],
            [
                "7-11 STORE 793 SMITH ST",
                "NO. 2 SMITH STREET LEVEL 1  ",
                "58917"
            ],
            [
                "YUET SING SEAFOOD",
                "70 SMITH STREET   ",
                "58968"
            ],
            [
                "CHEERS SAGO LANE 830 CSAGO",
                "12 SAGO STREET 1ST STOREY   ",
                "59014"
            ],
            [
                "7-11 STORE 791 CHINATOWN POINT",
                "NO. 33 NEW BRIDGE ROAD #01-30 CHINATOWN POINT  ",
                "59413"
            ],
            [
                "CHEERS LUCKY CHINATOWN (FRLKCT)(919",
                "NO. 211 NEW BRIDGE ROAD #01-06/07 LUCKY CHINATOWN  ",
                "59432"
            ],
            [
                "7-11 STORE 575 CHINATOWN MRT L1",
                "151 NEW BRIDGE ROAD UNIT 01-01 CHINATOWN NEL MRT  ",
                "59443"
            ],
            [
                "7-11 STORE 454 HONG KONG ST",
                "20 HONGKONG STREET UNIT 01 02  ",
                "59663"
            ],
            [
                "LINDO CAPITAL LLP (YELLOW CUP COFFEE)",
                "20 HAVELOCK ROAD #01-09  ",
                "59765"
            ],
            [
                "7-11 STORE 323 CENTRAL SQUARE",
                "20 HAVELOCK ROAD 01 18 CENTRAL SQUARE  ",
                "59765"
            ],
            [
                "FURAMA HOTEL - CITY CENTRE",
                "60 EU TONG SEN ST NO. 1 JALAN IMBI  ",
                "59804"
            ],
            [
                "7-11 STORE 169 PEARL CTR",
                "100 EU TONG SENG STREET 01 09 PEARL CENTER  ",
                "59812"
            ],
            [
                "TEA CUTTING",
                "150 EU TONG SEN ST NEW BRIDGE RD BUS TERMINAL ",
                "59814"
            ],
            [
                "CHEERS THE CENTRAL (FRCML)(928)",
                "6 EU TONG SEN STREET UNIT 01 05/06/14, THE CENTRAL  ",
                "59817"
            ],
            [
                "BILLY BOMBERS - THE CENTRAL",
                "6 EU TONG SEN STREET UNIT 02-78/91 THE CENTRAL  ",
                "59817"
            ],
            [
                "BIG BOX SINGAPORE PTE LTD",
                "1 Venture Ave   ",
                "68521"
            ],
            [
                "SARNIE PTE LTD",
                "136 TELOK AYER ST   ",
                "68601"
            ],
            [
                "LINDO CAPITAL LLP (YELLOW CUP) - SHENTON",
                "8 SHENTON WAY #B1-02 AXA TOWER  ",
                "68811"
            ],
            [
                "PHOENIX FOOD PTE LTD",
                "8 SHENTON WAY #B1-02 AXA TOWER  ",
                "68811"
            ],
            [
                "ADIDAS - ROBINSON RD",
                "NO. 77 ROBINSON ROAD   ",
                "68896"
            ],
            [
                "CHEERS CPF BLDG (FRCPF)(917)",
                "79 ROBINSON ROAD, CPF BUILDING UNIT 01- 02  ",
                "68897"
            ],
            [
                "7-11 STORE 9.56.0 ROBINSON RD",
                "112 ROBINSON ROAD UNIT 01 03  ",
                "68902"
            ],
            [
                "7-11 STORE 182 MCCALLUM ST",
                "3 MCCALLUM ST .  ",
                "69044"
            ],
            [
                "YUAN CAFE",
                "20 MAXWELL ROAD #01-09 MAXWELL HOUSE ",
                "69113"
            ],
            [
                "7-11 STORE 9.40.0 TANJONG PAGAR MRT",
                "12 MAXWELL ROAD #B1-02 TANJONG PAGAR MRT  ",
                "69119"
            ],
            [
                "7-11 STORE 255 ERSKINE RD",
                "7 ERSKINE ROAD .  ",
                "69320"
            ],
            [
                "7-11 STORE 393 CLUB STREET",
                "50 CLUB STREET .  ",
                "69427"
            ],
            [
                "JONES LANG LASALLE PROPERTY",
                "14th STOREY 158 CECIL STREET 14  ",
                "69545"
            ],
            [
                "CHEERS ORCHID HTL (CORCHID)(826)",
                "NO. 1 TRAS LINK #01-12 ORCHID HOTEL  ",
                "78867"
            ],
            [
                "7-11 STORE 563 ICON VILLAGE",
                "12 GOPENG STREET ICON VILLAGE UNIT 01-17 TO 19  ",
                "78877"
            ],
            [
                "MONETARY AUTHORITY OF SINGAPORE-SHENTON",
                "10 SHENTON WAY MAS BUILDING  ",
                "79117"
            ],
            [
                "TRIPLE O`S - ANSON PLAZA",
                "10 ANSON RD #01-21 INTERNATIONAL PLAZA  ",
                "79903"
            ],
            [
                "7-11 STORE 245 INTL PLAZA",
                "10 ANSON ROAD 01 08 INT L PLAZA  ",
                "79903"
            ],
            [
                "7-11 STORE 301 PHOENIX TOWER",
                "79 ANSON ROAD NO 01-01  ",
                "79906"
            ],
            [
                "7-11 STORE 586",
                "BLK 1 CANTOMENT RD #01-07 PINNACLE @ DUXTON  ",
                "80001"
            ],
            [
                "7-11 STORE 116 TANJONG PAGAR PLAZA",
                "BLK 1 TANJONG PAGAR PLAZA NO 01-32  ",
                "82001"
            ],
            [
                "7-11 STORE 9.32.0 DORSETT RESIDENCE",
                "331 NEW BRIDGE ROAD, DORSETT RESIDENCES UNIT 01-04  ",
                "88764"
            ],
            [
                "CRE8 SINGAPORE PTE LTD",
                "NO.3 NEIL ROAD   ",
                "88805"
            ],
            [
                "7-11 STORE 350 NEIL RD",
                "37 NEIL ROAD .  ",
                "88822"
            ],
            [
                "RESORTS WORLD AT SENTOSA PTE LTD",
                "3 LIM TECK KIM ROAD #10-03  ",
                "88934"
            ],
            [
                "7-11 STORE 340 KEONG SIAK RD",
                "39 KEONG SIAK ROAD .  ",
                "89145"
            ],
            [
                "CHOP HUAT HWEE FOOD SERVICES PTE LTD",
                "83/85 KEONG SAIK ST   ",
                "89168"
            ],
            [
                "7-11 STORE 388 DUXTON RD",
                "38 DUXTON ROAD .  ",
                "89502"
            ],
            [
                "HOME GENERAL PROVISION",
                "BLK 6 TELOK BLANGAH CRESCENT UNIT 01-416  ",
                "90006"
            ],
            [
                "7-11 STORE 288 T.BLANGAH BLK 12",
                "BLK 12 TELOK BLANGAH CRESCENT NO 01-113  ",
                "90012"
            ],
            [
                "NICE MINIMART - TELOK BLANGAH",
                "BLK 12 TELOK BLANGAH CRESCENT UNIT 01-105  ",
                "90012"
            ],
            [
                "ICHIRAN TRADING",
                "BLK 16 TELOK BLANGAH CRESCENT #01-316  ",
                "90016"
            ],
            [
                "7-11 STORE 307 B.PURMEI BLK 109",
                "BLK 109 BUKIT PURMEI ROAD 01 137  ",
                "90109"
            ],
            [
                "THE BUTTER TRADING",
                "BLK 111 #01-K1 BUKIT PURMEI  ",
                "90111"
            ],
            [
                "7-11 STORE 752 SENTOSA PALAWAN BEAC",
                "NO. 52 PALAWAN BEACH WALK PORT OF LOST WONDERS SENTOSA  ",
                "98033"
            ],
            [
                "ZDY INTL GROUP - SENTOSA",
                "26 SENTOSA GATEWAY #01-40/41/42   ",
                "98138"
            ],
            [
                "7-11 STORE 537 SENTOSA RWS L1",
                "NO. 26 SENTOSA GATEWAY #01-081/082 RESORT WORLD  ",
                "98138"
            ],
            [
                "7-11 STORE 777 RWS (FESTIVE)",
                "26 SENTOSA GATEWAY UNIT B1-128 RESORTS WORLD OF SENTOSA (FESTIVE) ",
                "98138"
            ],
            [
                "7-11 STORE 768 SENTOSA USS STAFFSHO",
                "30 SENTOSA GATEWAY UNIT B1-301 RESORTS WORLD OF SENTOSA  ",
                "98140"
            ],
            [
                "CAPELLA HOTEL SINGAPORE",
                "1 THE KNOLLS SENTOSA ISLAND   ",
                "98297"
            ],
            [
                "THE GROCER`S",
                "13 KEPPEL BAY VIEW UNIT B1-99 REFLECTIONS AT KEPPEL BAY ",
                "98409"
            ],
            [
                "EM BY THE MARINA PTE LTD",
                "1 COVE AVE SENTOSA COVE ARRIVING PLAZA #02-14 ",
                "98537"
            ],
            [
                "7-11 STORE 548 SENTOSA COVE ARRIVAL",
                "1 COVE AVENUE UNIT 02-09/10 & 02-11  ",
                "98537"
            ],
            [
                "ONE15 MARINA CLUB",
                "11 COVE DRIVE UNIT 01-011  SENTOSA COVE ",
                "98537"
            ],
            [
                "7-11 STORE 214 VIVO CITY L1",
                "NO 1 HARBOURFRONT WALK #01-23B VIVO CITY  ",
                "98585"
            ],
            [
                "7-11 STORE 421 VIVO CITY L2",
                "1 HARBOUR FRONT WALK 02 31/32 VIVO CITY  ",
                "98585"
            ],
            [
                "7-11 STORE 790 SENTOSA IMBIAH STN",
                "10 BEACH VIEW IMBIAH STATION  ",
                "98588"
            ],
            [
                "CHEERS SENTOSA(CSTOSA)(863)",
                "50 Beach View, #01-01   ",
                "98604"
            ],
            [
                "7-11 STORE 383 SENTOSA PALAWAN STN",
                "NO. 50 BEACH VIEW #01-01 PALAWAN STATION SENTOSA EXPRESS  ",
                "98604"
            ],
            [
                "CHEERS CARIBBEAN (FRKPBAY)(911)",
                "NO. 2 KEPPEL BAY DRIVE UNIT B1 133 CARIBBEAN @ KEPPEL BAY  ",
                "98636"
            ],
            [
                "CHEERS BY FP TELOK BLANGAH (ETB)(63",
                "396 TELOK BLANGAH RD .  ",
                "98837"
            ],
            [
                "7-11 STORE 565 T.BLANGAH FRAGRANCE",
                "400 TELOK BLANGAH ROAD FRAGRANCE HOTEL-ROYAL  ",
                "98838"
            ],
            [
                "7-11 STORE 621 SHELL TELOK BLANGAH",
                "450 TELOK BLANGAH ROAD .  ",
                "98857"
            ],
            [
                "SPC - TELOK BLANGAH",
                "616 TELOK BLANGAH UNIT 01-01  ",
                "98863"
            ],
            [
                "TANJONG BEACH CLUB",
                "120 TANJONG BEACH WALK SENTOSA   ",
                "98942"
            ],
            [
                "ISLAND CUISINE PL",
                "80 Siloso Road Sentosa   ",
                "98969"
            ],
            [
                "UNDERWATER WORLD SINGAPORE - SILOSO",
                "80 SILOSO RD SENTOSA  ",
                "98969"
            ],
            [
                ".",
                "MONORAIL SHOP 80 SILOSO RD  ",
                "98969"
            ],
            [
                "RASA SENTOSA RESORT & SPA",
                "101 SILOSO RD SENTOSA  ",
                "98970"
            ],
            [
                "7-11 STORE 117 SENTOSA SILOSO POINT",
                "81 SILOSO ROAD #01-02 SENTOSA SILOSO POINT STATION  ",
                "98979"
            ],
            [
                "N/A CHANGED CODE ",
                "OCEANSPOON DINING 50 SILOSO BEACH WALK UNIT 01-06 ",
                "99000"
            ],
            [
                "COASTES SENTOSA",
                "50 SILOSO BEACH WALK #01-06  ",
                "99000"
            ],
            [
                "AZZURA RESORTS PTE LTD",
                "46 SILOSO BEACH WALK SENTOSA SENTOSA ISLAND  ",
                "99005"
            ],
            [
                "BORA BORA MARGARITA BAR PTE LTD",
                "43 SILOSO BEACH WALK #01-03 SENTOSA  ",
                "99010"
            ],
            [
                "MOUNT FABER LEISURE GROUP P/L",
                "109 MOUNT FABER ROAD   ",
                "99203"
            ],
            [
                "MOUNT FABER LEISURE-AMBER GALLERIA",
                "109 MOUNT FABER ROAD   ",
                "99203"
            ],
            [
                "7-11 STORE 704 HARBOURFRONT SCC L2",
                "NO. 1 MARITIME SQUARE #02-32 SINGAPORE CRUISE CENTRE HARBOURFRONT  ",
                "99253"
            ],
            [
                "7-11 STORE 584 HARBOURFRONT SCC L1",
                "NO. 1 MARITIME SQUARE #01-18 SINGAPORE CRUISE CENTRE HARBOURFRONT  ",
                "99253"
            ],
            [
                "CHEERS HARBOURFRONT (CHHF)(519)",
                "1 MARITIME SQUARE .  ",
                "99253"
            ],
            [
                "PIZZA HUT - HARBOURFRONT",
                "MARITIME SQUARE UNIT 01-69 HARBOURFRONT CENTRE ",
                "99253"
            ],
            [
                "7-11 STORE 233 SENTOSA LIGHTHOUSE",
                "NO. 70 LIGHTHOUSE BEACH WALK #01-01 SENTOSA  ",
                "99343"
            ],
            [
                "BUTTERFLY PARK & INSECT KINGDOM",
                "51 IMBIAN ROAD SENTOSA   ",
                "99702"
            ],
            [
                "PEZZO SINGAPORE - SENTOSA",
                "51 IMBIAH ROAD SENTOSA  ",
                "99702"
            ],
            [
                "MOUNT FABER LEISURE-CABLE CAR MUSEUM",
                "50 IMBIAH ROAD SENTOSA  ",
                "99706"
            ],
            [
                "MOUNT FABER LEISURE-SENTOSA SHOP@IMBIAH",
                "50 IMBIAH RD SENTOSA   ",
                "99706"
            ],
            [
                "SENTOSA CINEBLAST",
                "51C IMBIAN ROAD SENTOSA  ",
                "99708"
            ],
            [
                "SYED NOORUL ISLAM",
                "BLK 53 TELOK BLANGAH DR UNIT 01-72  ",
                "100053"
            ],
            [
                "TECK GUAN & CO",
                "BLK 77 TELOK BLANGAH DRIVE #01-228  ",
                "100077"
            ],
            [
                "I-ECON - TECK GUAN & CO",
                "BLK 77 TELOK BLANGAH DRIVE UNIT 01-228  ",
                "100077"
            ],
            [
                "7-11 STORE 306 DEPOT RD BLK 108",
                "BLK 108 DEPOT ROAD #01-14  ",
                "100108"
            ],
            [
                "7-11 STORE 185 T.BLANGAH BLK 78A",
                "BLK 78A TELOK BLANGAH ST 32 39821  ",
                "101078"
            ],
            [
                "ZION ROAD COFFEE SHOP PTE LTD",
                "NO 2 YEO`S BUILDING TELOK BLANGAH ST 31  ",
                "108942"
            ],
            [
                "GROCER @ INTERLACE PTE LTD",
                "180 DEPOT ROAD UNIT 01-02 THE INTERLACE  ",
                "109684"
            ],
            [
                "OCEANSPOON - KEPPEL CLUB",
                "OCEANSPOON DINING KEPPEL CLUB 1F SWIMMING POOL ANNEX EXT. BUKIT CHERMIN RD",
                "109918"
            ],
            [
                "THE KEPPEL CLUB - TEE TOP",
                "10 BUKIT CHERMIN RD   ",
                "109918"
            ],
            [
                "NUS CO-OP AT LKCNHM",
                "THE MUSEUM SHOP  2 CONSERVATORY DRIVE  ",
                "117377"
            ],
            [
                "UNILEVER ASIA PTE LTD",
                "Lipton Cafe c/o Dawn Sim 20 Pasir Panjang Rd #06-22 Mapletree Business City ",
                "117439"
            ],
            [
                "FOODNATION 2",
                "KILLINEY PASIR PANJANG 20 PASIR PANJANG #02-17 MAPLE TREE BUSINESS CITY ",
                "117439"
            ],
            [
                "7-11 STORE 722 MBC P.PANJANG",
                "20 PASIR PANJANG ROAD UNIT 02-18/19 MAPLETREE BUSINESS CITY  ",
                "117439"
            ],
            [
                "ASHOKA TANDOOR RESTAURANT",
                "1 SCIENCE PARK ROAD CAPRICON UNIT 01-11  ",
                "117528"
            ],
            [
                "GOLDEN SPOON EATING HOUSE&CATERING-SCIEN",
                "10 SCIENCE RD, SCIENCE PARK 2 THE ALPHA #02-29  ",
                "117684"
            ],
            [
                "E CANTEEN PTE LTD",
                "27 PRINCE GEORGE`S PARK NATIONAL UNIVERSITY OF S`PORE  ",
                "118425"
            ],
            [
                "NANYANG MART PTE LTD",
                "31 PRINCE GEROGE`S PARK ROAD   ",
                "118427"
            ],
            [
                "FOOD JOY - BUONA VISTA",
                "24 SOUTH BUONA VISTA RD   ",
                "118497"
            ],
            [
                "MONETARY AUTHORITY OF SINGAPORE-P.PANJAN",
                "109 PASIR PANJANG RD CURRENCY HOUSE  ",
                "118536"
            ],
            [
                "ASHMI MINIMART PTE LTD",
                "126 PASIR PANJANG ROAD   ",
                "118546"
            ],
            [
                "SPC - PASIR PANJANG",
                "158 PASIR PANJANG UNIT 01-01  ",
                "118555"
            ],
            [
                "7-11 STORE 635 SHELL 168 P.PANJANG",
                "168 PASIR PANJANG ROAD .  ",
                "118556"
            ],
            [
                "CHEERS BY FP PASIR PANJANG (EPPJ)(6",
                "242A PASIR PANJANG RD .  ",
                "118598"
            ],
            [
                "7-11 STORE 646 SHELL 328 P.PANJANG",
                "328 PASIR PANJANG ROAD .  ",
                "118654"
            ],
            [
                "RAINFOREST CULINARY (ROOTS AT ONE NORTH)",
                "ROOTS AT ONE NORTH 3 FUSIONOPOLIS PLACE GALAXIS WORKLOFT #01-50 ",
                "118693"
            ],
            [
                "VILLAGE COFFEE HOUSE PTE LTD",
                "404 PASIR PANJANG ROAD   ",
                "118741"
            ],
            [
                "7-11 STORE 720 PASIR PANJANG RD",
                "418 PASIR PANJANG ROAD UNIT 01-02 (FRAGRANCE HOTEL)  ",
                "118759"
            ],
            [
                "HOT & SPICY NASI LEMAK",
                "438 PASIR PANJANG ROAD   ",
                "118779"
            ],
            [
                "7-11 STORE 778 NUS Y.ISHAK HSE",
                "31 LOWER KENT RIDGE RD UNIT 01 04 YUSOF ISHAK RD  ",
                "119078"
            ],
            [
                "CHEERS NUH HOSPITAL (CNUH)(839)",
                "1 LOWER KENT RIDGE ROAD UNIT 01-28  ",
                "119082"
            ],
            [
                "7-11 STORE 9.29.0 KENT RIDGE",
                "1 LOWER KENT RIDGE ROAD, 0NE @KENT RIDGE UNIT 03-05/06  ",
                "119082"
            ],
            [
                "7-11 STORE 780 NUH MAIN BLDG L1",
                "NO. 5 LOWER KENT RIDGE ROAD #01-02 MAIN BUILDING LOBBY NATIONAL UNIVERSITY HOSPITAL ",
                "119228"
            ],
            [
                "KAMATS RESTAURANTS PTE LTD",
                "10 HYDERBAD RD   ",
                "119579"
            ],
            [
                "UNITED OVERSEAS BANK LIMITED-ALEXANDRA",
                "UOB ALEXANDRA 396 ALEXANDRA RD #17-00  ",
                "119954"
            ],
            [
                "7-11 STORE 254 PULAU BUKOM",
                "Blk 78A 460 ALEXANDRA ROAD,#01-26,27  ",
                "119963"
            ],
            [
                "7-11 STORE 324 ARC ALEXANDRA S.CTR",
                "460 ALEXANDRA ROAD UNIT 01 26 27  ",
                "119963"
            ],
            [
                "LINDO CAPITAL LLP (YELLOW CUP) - ALEXAND",
                "438 ALEXANDRA ROAD #01-K1  ",
                "119967"
            ],
            [
                "GRINDELWALD SUPERMARKET",
                "BLK 108 CLEMENTI ST 11 #01-00  ",
                "120108"
            ],
            [
                "7-11 STORE 9.38.0 CLEMENTI BLK 109",
                "BLK 109 CLEMENTI ST 11 NO 01 15  ",
                "120109"
            ],
            [
                "COLLIN`S GRILLED BENTO - CLEMENTI",
                "308 CLEMENTI AVE 4 #01-335   ",
                "120308"
            ],
            [
                "U STARS SUPERMARKET (CLEMENTI)",
                "345 CLEMENTI AVE 5 #01-78  ",
                "120345"
            ],
            [
                "NUCLEUS STORE",
                "BLK 415 #01-3009 COMMONWEALTH AVE WEST  ",
                "120415"
            ],
            [
                "COLLIN`S GRILLED BENTO - CLEMENTI 431",
                "431 CLEMENTI AVE 3 #01-296   ",
                "120431"
            ],
            [
                "PIZZA HUT - CLEMENTI 451",
                "BLK 451 CLEMENTI AVE 3 UNIT 01-309  ",
                "120451"
            ],
            [
                "COLLIN`S GRILLED BENTO - WEST COAST",
                "BLK 501 WEST COAST DRIVE #01-244  ",
                "120501"
            ],
            [
                "SEE HAI SENG MINIMART",
                "BLK 504 WEST COAST DRIVE  #01-228  ",
                "120504"
            ],
            [
                "I-ECON - SEE HAI SENG MINIMART",
                "BLK 504 WEST COAST DRIVE #01-228  ",
                "120504"
            ],
            [
                "7-11 STORE 114 WEST COAST BLK 505",
                "BLK 505 WEST COAST DRIVE NO 01-216  ",
                "120505"
            ],
            [
                "I-ECON - FANGLI TRADING",
                "BLK 725 CLEMENTI WEST ST 2 UNIT 01-206  ",
                "120725"
            ],
            [
                "FANGLI TRADING",
                "BLK 725 CLEMENTI WEST ST 2 #01-206  ",
                "120725"
            ],
            [
                "7-11 STORE 9.31.0 CLEMENTI BLK 727",
                "BLK 727 CLEMENI WEST ST 2 NO 01 284  ",
                "120727"
            ],
            [
                "7-11 STORE 9.24.0 CLEMENTI BLK 420A",
                "BLK 420A CLEMENTI AVENUE 1 UNIT 01 06  ",
                "121420"
            ],
            [
                "ALL ABOUT ESSENTIALS",
                "67 WEST COAST WAY UNIT 01-31  ",
                "127023"
            ],
            [
                "7-11 STORE 502 WEST COAST PLAZA",
                "154 WEST COAST ROAD B1 54A WEST COAST PLAZA  ",
                "127371"
            ],
            [
                "FAIRPRICE XPRESS WEST COAST (EWCO)(",
                "181 WEST COAST RD .  ",
                "127375"
            ],
            [
                "CAFE GEMINIS",
                "33B WEST COAST PARK UNIT 01-43  ",
                "127728"
            ],
            [
                "SKY MART",
                "31 WEST COAST CRESCENT UNIT 01-32 BLUE HORIZON CONDOMINIUM ",
                "128050"
            ],
            [
                "NICOLE`S CAFE",
                "230 PANDAN LOOP  #01-30  ",
                "128415"
            ],
            [
                "T SPECIALIST INTERNATIONAL (S) PTE lTD",
                "ANGLISS SINGAPORE PTE LTD 232 PANDAN LOOP  ",
                "128420"
            ],
            [
                "EMERSON PROCESS MANAGEMENT ASIA PACIFIC",
                "1 PANDAN CRESCENT   ",
                "128461"
            ],
            [
                "ADIDAS - PANDAN CRESCENT",
                "10 PANDAN CRESCENT UNIT 04-01 UE TECHPARK  ",
                "128466"
            ],
            [
                "7-11 STORE 380 JLN MAS PUTEH",
                "5 JALAN MAS PUTEH .  ",
                "128611"
            ],
            [
                "SUPER MARCHE PREMIERE PTE LTD",
                "BLK 8 JALAN LEMPENG #01-01 PARK WEST  ",
                "128796"
            ],
            [
                "CHEERS BY FP JALAN BUROH (EJBH)(653",
                "253 JALAN BUROH .  ",
                "128828"
            ],
            [
                "7-11 STORE 754 CLEMENTI MRT STN",
                "3150 Commonwealth Avenue West UNIT 02 01 CLEMENTI MRT STATION  ",
                "129580"
            ],
            [
                "7-11 STORE 9.14.0 CLEMENTI MALL",
                "3155 COMMONWEALTH AVENUE WEST UNIT 01 03 CLEMENTI MALL  ",
                "129588"
            ],
            [
                "7-11 STORE 163 CLEMENTI RD",
                "6 CLEMENTI ROAD NO 01 01  ",
                "129741"
            ],
            [
                "BUZZ CLEMENTI",
                "12 CLEMENTI RD   ",
                "129742"
            ],
            [
                "MINISTRY OF DEFENCE 3 - CLEMENTI",
                "Clementi Camp Training Ctr 26 Clementi Loop #02-01  ",
                "129817"
            ],
            [
                "CALTEX - CLEMENTI AVE 2",
                "126 CLEMENTI AVE 2 UNIT 01-01  ",
                "129930"
            ],
            [
                "GARENA ONLINE PTE LTD",
                "1 FUSIONOPOLIS PLACE #17-10 GALAXIS  ",
                "135822"
            ],
            [
                "ATTAP HOUSE PTE LTD",
                "1 FUSIONOPOLIS PLACE GALAXIS #01-14  ",
                "138522"
            ],
            [
                "CHEERS INNOVATION CTR (CBPS)(847)",
                "70 BIOPOLIS ST, SG INNOVATION CENTRE PROTER & GAMBLE BUILDING, UNIT 01-04  ",
                "138547"
            ],
            [
                "THE GROCER BY STERLING",
                "21 MEDIA CENTRE INFINITE STUDIO UNIT 01-06/07  ",
                "138562"
            ],
            [
                "7-11 STORE 9.39.0 THE METROPOLIS",
                "9 NORTH BUONA VISTA DRIVE,THE METROPOLIS UNIT 01-11  ",
                "138588"
            ],
            [
                "SKY CAFE (PLAYTIME RECREATION&CATERING)",
                "11 NORTH BUONA VISTA DRIVE #21-07 THE METROPOLIS TOWER 2  ",
                "138589"
            ],
            [
                "CHEERS U TOWN (FRUTOWN)(926)",
                "UNIT 01-01, CREATE WAY   ",
                "138602"
            ],
            [
                "FAIRPRICE XPRESS NUS (XPNUS)(820)",
                "NO. 2 COLLEGE AVE WEST UNIT 01-05   ",
                "138607"
            ],
            [
                "7-11 STORE 174 THE STAR VISTA",
                "1 Vista Exchange Green UNIT 01 44 The Star Vista  ",
                "138617"
            ],
            [
                "NANDO`S - STAR VISTA",
                "1 VISTA EXCHANGE GREEN UNIT B1-09 THE STAR VISTA  ",
                "138617"
            ],
            [
                "REFRESH!! (OSDEEN PTE LTD)",
                "#01-08 INNOVIS 2 FUSIONOPOLIS WAY  ",
                "138634"
            ],
            [
                "CALI CAFE",
                "31 ROCHESTER DRIVE UNIT 01-02  ",
                "138637"
            ],
            [
                "ROCHESTER MARKET PTE LTD",
                "35 ROCHESTER DRIVE UNIT 02-16  ",
                "138639"
            ],
            [
                "HUANG TAI FOOD SERVICE",
                "11 SLIM BARRACKS RISE NTU@ONE NORTH RAMPUS  ",
                "138664"
            ],
            [
                "LINDO CAPITAL (YELLOW CUP)- NEUROS",
                "8 BIOMEDICAL GROVE #01-14 NEUROS  ",
                "138665"
            ],
            [
                "COOKIES CAFE",
                "11 BIOPOLIS WAY UNIT 01-08 HELIOS  ",
                "138667"
            ],
            [
                "SUPREME CUISINE",
                "30 BIOPOLIS STREET UNIT 01-02  ",
                "138671"
            ],
            [
                "MINISTRY OF EDUCATION",
                "1 NORTH BUONA VISTA DRIVE   ",
                "138675"
            ],
            [
                "SODEXO - INSEAD",
                "1 AYER RAJAH AVENUE UNIT 01-01  ",
                "138676"
            ],
            [
                "7-11 STORE 479 DOVER MRT",
                "200 COMMONWEALTH AVE WEST NO 02-01  ",
                "138677"
            ],
            [
                "CREAMY DUCK - SIT",
                "10 Dover Drive   ",
                "138683"
            ],
            [
                "LIM LEE YONG",
                "9A WHITCHURCH ROAD OFF PORTSDOWN ROAD  ",
                "138817"
            ],
            [
                "WESSEX TAVERN",
                "5B PORTSDOWN ROAD UNIT 01-01  ",
                "139311"
            ],
            [
                "CHEERS B.VISTA MRT (SBVISTA)(915)",
                "100 BUONA VISTA ROAD No. 01-01  ",
                "139345"
            ],
            [
                "SODEXO - UNILEVER FOUR ACRES",
                "FOUR ACRES SINGAPORE 18 NEPAL PARK  ",
                "139407"
            ],
            [
                "TZONE",
                "102 DOVER ROAD   ",
                "139649"
            ],
            [
                "KWAY GUAN HUAT - STALL 11 JOO CHIAT",
                "500 DOVER ROAD FOOUD COURT (KOUFU)  ",
                "139651"
            ],
            [
                "BANG DELI (HILLTOP CAFE T22)",
                "500 DOVER RD   ",
                "139651"
            ],
            [
                "EEZEE VENDING PTE LTD - SING POLY",
                "500 DOVER ROAD   ",
                "139651"
            ],
            [
                "CHEERS SPORE POLY FDCOURT 5",
                "500 DOVER ROAD FC514  ",
                "139651"
            ],
            [
                "CREAMY DUCK - SPORE POLY",
                "500 DOVER RD FOODCOURT 6 SINGAPORE POLYTECHNIC  ",
                "139651"
            ],
            [
                "SODEXO - UNITED WORLD COLLEGE DOVER",
                "1207 DOVER ROAD   ",
                "139654"
            ],
            [
                "PRO 3 INSTITUTIONAL CATERING - AYER RAJA",
                "18 AYER RAJAH CRESCENT #04-00 P+F BUILDING  ",
                "139942"
            ],
            [
                "CHENG HUA S MART",
                "118 COMMONWEALTH CRESCENT UNIT 01-17/19  ",
                "140118"
            ],
            [
                "7-11 STORE 487 MEILING BLK 157",
                "BLK 157 MEI LING ST UNIT 01 54  ",
                "140157"
            ],
            [
                "TAI HUAT & CO",
                "BLK 46-2 COMMONWEALTH DRIVE #01-360  ",
                "140462"
            ],
            [
                "I-ECON - TAI HUAT & CO",
                "BLK 46-2 COMMONWEALTH DR UNIT 01-360  ",
                "140462"
            ],
            [
                "7-11 STORE 258 DAWSON PLACE BLK 57",
                "BLK 57 DAWSON RD 01 13 DAWSON PLACE  ",
                "142057"
            ],
            [
                "7-11 STORE 530 TANGLIN HALT BLK 39",
                "BLK 39 TANGLIN HALT ROAD #01-119  ",
                "143039"
            ],
            [
                "7-11 STORE 244 MDIS STIRLING BLK B",
                "501 STIRLING ROAD BLK B  ",
                "148951"
            ],
            [
                "7-11 STORE 640 SHELL QUEENSWAY",
                "260 QUEENSWAY .  ",
                "149060"
            ],
            [
                "CHEERS BY FP QUEENSWAY B (EQWB)(662",
                "262 QUEENSWAY .  ",
                "149061"
            ],
            [
                "SPC - QUEENSWAY COCO",
                "264 QUEENSWAY UNIT 01-01  ",
                "149062"
            ],
            [
                "CHEERS BY FP QUEENSWAY A (EQWA)(661",
                "622 QUEENSWAY .  ",
                "149067"
            ],
            [
                "7-11 STORE 516 QUEENSTOWN MRT",
                "31 COMMONWEALTH AVENUE No 02-03/04 QUEENSTOWN MRT ST  ",
                "149729"
            ],
            [
                "7-11 STORE 612 SHELL COMMONWEALTH",
                "355 COMMONWEALTH AVENUE .  ",
                "149731"
            ],
            [
                "7-11 STORE 534 COMMONWEALTH MRT",
                "375 COMMONWEALTH AVE UNIT 02-01 COMMONWEALTH MRT STN  ",
                "149735"
            ],
            [
                "SPC - COMMONWEALTH",
                "490 COMMONWEALTH AVENUE UNIT 01-01  ",
                "149736"
            ],
            [
                "7-11 STORE 215 J.B.MERAH BLK 2",
                "BLK 2 JALAN BUKIT MERAH #01-5144  ",
                "150002"
            ],
            [
                "I-ECON - PAO FU TRADING",
                "BLK 58 LENGKOK BAHRU UNIT 01-509  ",
                "150058"
            ],
            [
                "7-11 STORE 166 B.MERAH BLK 116",
                "BLK 116 BUKIT MERAH VIEW NO 01-229  ",
                "150116"
            ],
            [
                "AJ DELIGHTS PTE LTD",
                "BLK 120 BUKIT MERAH LANE 1 #01-82 ALEXANDRA VILLAGE FOOD CENTRE  ",
                "150120"
            ],
            [
                "7-11 STORE 100 B.MERAH BLK 162",
                "BLK 162 BUKIT MERAH CENTRAL NO 01-3547  ",
                "150162"
            ],
            [
                "DREAMS OF CREME",
                "BLK 28 HOY FATT RD #01-30   ",
                "151028"
            ],
            [
                "MEGA BEVERAGES",
                "55 LENGKOK BAHRU #01-387  ",
                "151055"
            ],
            [
                "I-ECON - CHOP CHUAN LEONG",
                "BLK 28 JALAN BT MERAH UNIT 01-4666  ",
                "152025"
            ],
            [
                "7-11 STORE 204-JALAN BUKIT MERAH",
                "BLK 28 JALAN BUKIT MERAH UNIT 01 4470  ",
                "152028"
            ],
            [
                "COZI HUT LLP",
                "BLK 261 WATERLOO STREET UNIT 01-30  ",
                "152063"
            ],
            [
                "FLOWER MINIMART",
                "BLK 63B LENGKOK BAHRU UNIT 01-360  ",
                "152063"
            ],
            [
                "RONG XING PTE LTD",
                "BLK 75D REDHILL ROAD UNIT #01-92  ",
                "154075"
            ],
            [
                "7-11 STORE 360 REDHILL BLK 75D",
                "BLK 75D REDHILL ROAD 01 102  ",
                "154075"
            ],
            [
                "I-ECON - RONG XING PTE LTD",
                "BLK 75D REDHILL ROAD UNIT 01-92  ",
                "154075"
            ],
            [
                "7-11 STORE 629 SHELL TIONG BAHRU",
                "603 TIONG BAHRU ROAD .  ",
                "158788"
            ],
            [
                "7-11 STORE 290 REDHILL MRT",
                "920 TIONG BAHRU ROAD 01 01/03 REDHILL MRT STATION  ",
                "158792"
            ],
            [
                "CHEERS BY FP J.B.MERAH (EJBM)(692)",
                "2991 JALAN BUKIT MERAH .  ",
                "159458"
            ],
            [
                "CALTEX - JLN BT MERAH",
                "3781 JALAN BUKIT MERAH UNIT 01-01  ",
                "159463"
            ],
            [
                "SPC - JALAN BUKIT MERAH",
                "3800 JALAN BUKIT MERAH UNIT 01-01  ",
                "159464"
            ],
            [
                "FUSION BISTRO PTE LTD",
                "2 BUKIT MERH CENTRAL #03-00 PODIUM BLOCK SPRING   ",
                "159835"
            ],
            [
                "7-11 STORE 651 SHELL ALEXANDRA",
                "358 ALEXANDRA ROAD .  ",
                "159950"
            ],
            [
                "CALTEX - ALEXANDRA RD",
                "360 ALEXANDRA ROAD UNIT 01-01  ",
                "159951"
            ],
            [
                "7-11 STORE 282 ANCHORPOINT",
                "BLK 370 ALEXANDRA ROAD 01 39 ANCHORPOINT  ",
                "159953"
            ],
            [
                "PARK HOTEL ALEXANDRA",
                "323 ALEXANDRA ROAD   ",
                "159972"
            ],
            [
                "7-11 STORE 759 HAVELOCK BLK 22",
                "22 HAVELOCK ROAD UNIT 01-707  ",
                "160022"
            ],
            [
                "7-11 STORE 9.51.0 SENG POH BLK 58",
                "58 SENG POH RD .  ",
                "160058"
            ],
            [
                "7-11 STORE 761 J.B.MERAH BLK 111",
                "BLK 111 JALAN BUKIT MERAH UNIT 01-1686  ",
                "160111"
            ],
            [
                "7-11 STORE 144 KIM TIAN BLK 126",
                "BLK 126 KIM TIAN ROAD UNIT 01 02 KIM TIAN GREEN  ",
                "160126"
            ],
            [
                "D & S MINI MART",
                "BLK 133 JALAN BUKIT MERAH UNIT 01-1526  ",
                "160133"
            ],
            [
                "FU MAN MEN HYPERMARKET",
                "BLK 146 JALAN BUKIT MERAH UNIT 01-1072/74  ",
                "160146"
            ],
            [
                "ONG FOOK SENG PROVISION STORE",
                "BLK 78 INDUS ROAD UNIT 01-491  ",
                "161078"
            ],
            [
                "ENG HOE HUAT WINE MERCHANT",
                "BLK 2 JALAN KUKOH #01-147  ",
                "163002"
            ],
            [
                "POH KIM SAN",
                "2 JALAN KUKOH #01-145  ",
                "163002"
            ],
            [
                "I-ECON - ENG HOE HUAT",
                "BLK 2 JALAN KOKOH UNIT 01-147  ",
                "163002"
            ],
            [
                "7-11 STORE 206 J.MEMBINA BLK 18",
                "BLK 18 JALAN MEMBINA NO 01-02  ",
                "164018"
            ],
            [
                "ICELAND AT OUTRAM SECONDARY SCHOOL",
                "3 YORK HILL  STALL 8  ",
                "168622"
            ],
            [
                "7-11 STORE 475 TIONG BAHRU",
                "TIONG BAHRU PLAZA 01 33B  ",
                "168732"
            ],
            [
                "CHEERS LINK HOTEL (CLKH)(571)",
                "NO. 50 TIONG BAHRU ROAD #01-03/04 LINK HOTEL  ",
                "168733"
            ],
            [
                "7-11 STORE 309 HPB HOSPITAL AVE",
                "3 2ND HOSPITAL AVENUE 01-02 HEALTH PROMOTION BOARD  ",
                "168937"
            ],
            [
                "7-11 STORE 661 SHELL OUTRAM",
                "305 OUTRAM ROAD .  ",
                "169072"
            ],
            [
                "LEE TAI FU - DEREK N FRIENDS",
                "16 KIM TIAN ROAD   ",
                "169245"
            ],
            [
                "7-11 STORE 9.49.0 KIM TIAN BLK 8",
                "8 KIM TIAN ROAD .  ",
                "169247"
            ],
            [
                "CHEERS KAMPONG B. (CKPBRU)(824)",
                "71 KAMPONG BAHRU ROAD   ",
                "169373"
            ],
            [
                "7-11 STORE 381 KAMPONG BAHRU",
                "77 KAMPONG BAHRU ROAD .  ",
                "169376"
            ],
            [
                "7-11 STORE 9.28.0 SGH HOSPITAL BLK",
                "BLK 4 LEVEL 1 SINGAPORE GENERAL HOSPITAL OUTRAM ROAD  ",
                "169608"
            ],
            [
                "SHS - NATIONAL HEART CENTRE SINGAPORE",
                "LEVEL 7 TUTORIAL ROOM (USE LIFT A) 5 HOSPITAL DRIVE  ",
                "169609"
            ],
            [
                "SPC - HAVELOCK",
                "397 HAVELOCK ROAD UNIT 01-01  ",
                "169630"
            ],
            [
                "7-11 STORE 669 SHELL HAVELOCK",
                "548 HAVELOCK ROAD .  ",
                "169637"
            ],
            [
                "GRAND COPTHORNE WATERFRONT HOTEL",
                "392 HAVELOCK RD   ",
                "169663"
            ],
            [
                "CHEERS ENG HOON (CEHOON)(587)",
                "NO.1 ENG HOON STREET UNIT 01-02  ",
                "169753"
            ],
            [
                "THE SOUTH BEACH",
                "30 BEACH ROAD   ",
                "169763"
            ],
            [
                "RC HOTEL PTE LTD - TUCKSHOP",
                "2 STAMFORD RD TUCKSHOP  ",
                "178882"
            ],
            [
                "CHEERS STAMFORD CT (FRSFC)(922)",
                "61 STAMFORD COURT 39816  ",
                "178892"
            ],
            [
                "BREADTALK - 1933",
                "13 STAMFORD ROAD #01-83  ",
                "178905"
            ],
            [
                "STORY OF CHEN",
                "3E RIVER VALLEY RD #01-08  ",
                "179024"
            ],
            [
                "MEIDI-YA SINGAPORE CO PTE LTD",
                "177 RIVER VALLEY RD   ",
                "179030"
            ],
            [
                "7-11 STORE 472 LIANG COURT",
                "177 RIVER VALLEY ROAD 01 11 LIANG COURT  ",
                "179030"
            ],
            [
                "7-11 STORE 772 NORTH BRIDGE RD",
                "109 North Bridge Road UNIT 01 19  ",
                "179097"
            ],
            [
                "PIZZA HUT - FUNAN",
                "109 NORTH BRIDGE ROAD UNIT 03-05/06 FUNAN DIGITAL LIFE MALL ",
                "179097"
            ],
            [
                "7-11 STORE 9.42.0 PENINSULA PLAZA",
                "111 NORTH BRIDGE RD 01 36/37 PENINSULA PLAZA  ",
                "179098"
            ],
            [
                "YWCA FORT CANNING LODGE",
                "6 FORT CANNING UNIT 01-61  ",
                "179494"
            ],
            [
                "BATTLEBOX VISITOR CENTRE",
                "2 COX TERRACE (NEAR CARPARK B)   ",
                "179622"
            ],
            [
                "PADANG PALACE RESTAURANT PTE LTD",
                "B CONNAUGHT DRIVE LEVEL 2 SINGAPORE RECREATION CLUB  ",
                "179682"
            ],
            [
                "CHEERS B.BASAH CMPLX (FRBB)(921)",
                "BLK 231 BAIN ST NO 01 21 BRAS BASAH  ",
                "180231"
            ],
            [
                "7-11 STORE 289 VICTORIA HOTEL",
                "89 VICTORIA STREET .  ",
                "188017"
            ],
            [
                "NANDO`S - BUGIS JUNCTION",
                "200 VICTORIA STREET UNIT 01-85/87  BUGIS JUNCTION ",
                "188021"
            ],
            [
                "NYDC - BUGIS JUNCTION",
                "200 VICTORIA STREET UNIT 02-47/48 BUGIS JUNCTION  ",
                "188021"
            ],
            [
                "7-11 STORE 122 BUGIS VILLAGE",
                "245 VICTORIA STREET .  ",
                "188032"
            ],
            [
                "ALI & ZEENATH (S) PTE LTD",
                "NO. 390 VICTORIA STREET UNIT 01-32  ",
                "188061"
            ],
            [
                "7-11 STORE 164 ILUMA",
                "201 VICTORIA STREET UNIT 01 01A ILUMA  ",
                "188067"
            ],
            [
                "7-11 STORE 226 PARADIZ CTR",
                "1 SELEGIE ROAD 01 06 PARADIZ CTR  ",
                "188306"
            ],
            [
                "7-11 STORE 390 SELEGIE FRAGRANCE HT",
                "183 SELEGIE RD No.01-02/03 FRAGRANCE HOTEL  ",
                "188329"
            ],
            [
                "HAWA GOURMET SEAFOOD RESTAURANT",
                "213 SELEGIE ROAD   ",
                "188335"
            ],
            [
                "CHEERS BUGIS MRT (CBGISDTL)(844)",
                "NO. 191 ROCHOR ROAD BUGIS #B2-07 BUGIS MRT STATION  ",
                "188476"
            ],
            [
                "JIAN WEI PTE LTD",
                "19 PURVIS ST   ",
                "188597"
            ],
            [
                "CHEERS PRINSEP ST (FRPSS)(938)",
                "30 PRINSEP STREET UNIT 01-03  ",
                "188647"
            ],
            [
                "7-11 STORE 241 LUBRITRADE BLDG",
                "408 NORTH BRIDGE ROAD 01 01 LUBRITRADE BLDG  ",
                "188725"
            ],
            [
                "7-11 STORE 507 NAM PENG BLDG",
                "452 NORTH BRIDGE ROAD No 01-00 NAM PENG BUILDING  ",
                "188733"
            ],
            [
                "I-TEC - NORTH BRIDGE RD 676",
                "676 NORTH BRIDGE RD   ",
                "188805"
            ],
            [
                "7-11 STORE 590 BUGIS FRAGRANCE HTL",
                "No 33 Middle Road #01-02  ",
                "188942"
            ],
            [
                "SARIKA CONNOISSEUR CAFE - TCC BUGIS",
                "80 MIDLE ROAD  #01-92-96 BUGIS JUNCTION  ",
                "188966"
            ],
            [
                "7-11 STORE 342 FORTUNE CTR",
                "190 MIDDLE ROAD 01 03 FORTUNE CTR  ",
                "188979"
            ],
            [
                "ROTARY F&B PTE LTD",
                "NO. 190 MIDDLE ROAD UNIT 01-37  ",
                "188979"
            ],
            [
                "CHEERS BIG HTL (FRPRCT)(925)",
                "200 MIDDLE ROAD UNIT 01-01  ",
                "188980"
            ],
            [
                "7-11 STORE 279 LIANG SEAH ST",
                "33 LIANG SEAH STREET NO 01-03  ",
                "189054"
            ],
            [
                "7-11 STORE 760 HAJI LANE",
                "7 Haji Lane, Level 1   ",
                "189200"
            ],
            [
                "7-11 STORE 253 PLAZA BY THE PARK",
                "51 BRAS BASAH ROAD 01 04 PLAZA BY THE PARK  ",
                "189554"
            ],
            [
                "7-11 STORE 707 BRAS BASAH MRT B1",
                "NO. 65 BRAS BASAH ROAD #B1-02 BRAS BASAH MRT STATION  ",
                "189561"
            ],
            [
                "7-11 STORE 709 ESPLANADE MRT B1",
                "NO. 90 BRAS BASAH ROAD #B1-20/21/22 ESPLANADE MRT STATION  ",
                "189562"
            ],
            [
                "CHEERS BENCOOLEN V HTL (CBST48)(834",
                "48 BENCOOLEN STREET UNIT 01-03  ",
                "189627"
            ],
            [
                "7-11 STORE 347 THE BENCOOLEN",
                "180 BENCOOLEN STREET 01 66 THE BENCOOLEN  ",
                "189646"
            ],
            [
                "MAX CAFE",
                "80 BENCOOLEN ST #B1-08   ",
                "189655"
            ],
            [
                "BENCOOL LA PTE LTD",
                "IBIS SINGAPORE ON BENCOOLEN 170 BENCOOLEN ST  ",
                "189657"
            ],
            [
                "7-11 STORE 522 BENCOOLEN IBIS HOTEL",
                "170 BENCOOLEN STREET NO 04-03 IBIS HOTEL  ",
                "189657"
            ],
            [
                "BOMBAY TALKIES(S) PTE LTD",
                "100 BEACH ROAD UNIT 02-00 SHAW TOWERS JADE CINEPLEX ",
                "189702"
            ],
            [
                "ROMAS DELI",
                "100 BEACH RD #01-23 SHAW CENTRE  ",
                "189702"
            ],
            [
                "PRINCE COFFEE HOUSE PTE LTD",
                "249 BEACH RD   ",
                "189757"
            ],
            [
                "PARIBESH - BALI LANE",
                "27 BALI LANE   ",
                "189863"
            ],
            [
                "7-11 STORE 504 ALBERT ST",
                "175 ALBERT STREET UNIT 01-03/04  ",
                "189970"
            ],
            [
                "7-11 STORE 351 BEACH RD BLK 1",
                "BLK 1 BEACH ROAD NO 01-4769  ",
                "190001"
            ],
            [
                "BUKIT MINIMART",
                "6 BEACH RD #01-4875  ",
                "190006"
            ],
            [
                "LAM SENG HUAT",
                "BLK 18 JALAN SULTAN #01-164  ",
                "190018"
            ],
            [
                "I-ECON - LAM SENG HUAT",
                "BLK 18 JALAN SULTAN UNIT 01-164  ",
                "190018"
            ],
            [
                "PARIBESH - SULTAN GATE",
                "32 SULTAN GATE   ",
                "198480"
            ],
            [
                "BLACK & WHITE IMAGE",
                "200 JALAN SULTAN #01-34 TEXTILE CENTRE  ",
                "199018"
            ],
            [
                "7-11 STORE 196 TEXTILE CTR",
                "200 JALAN SULTAN 01 03 TEXTILE CTR  ",
                "199018"
            ],
            [
                "DOULATH ENTERPRISE",
                "200 JALAN SULTAN UNIT 01-K1  ",
                "199018"
            ],
            [
                "BROADWAY FOOD CENTRE - NTU",
                "76 NANYANG DRIVE BLK N2.1 UNIT 02-03 NTU  ",
                "199018"
            ],
            [
                "CHEERS JALAN SULTAN(CJSTAN)(864)",
                "500 Jalan Sultan #01-16  ",
                "199020"
            ],
            [
                "7-11 STORE 445 BUSSORAH ST",
                "28 BUSSORAN STREET .  ",
                "199446"
            ],
            [
                "NEW SUN TRADING",
                "46 BUSSORAH ST SGP   ",
                "199464"
            ],
            [
                "VINTAGEDELI CAF\u00c9 PTE LTD",
                "66 BUSSUROH STREET   ",
                "199479"
            ],
            [
                "CALTEX - BEACH ROAD",
                "4870 BEACH ROAD UNIT 01-01  ",
                "199586"
            ],
            [
                "YEN INVESTMENTS PTE LTD",
                "5001 BEACH RD GOLDEN MILE COMPLEX UNIT 02-54/55/57  ",
                "199588"
            ],
            [
                "MART ONE MINI SUPERMARKET",
                "7500A BEACH ROAD #B1-303/304 THE PLAZA  ",
                "199591"
            ],
            [
                "7-11 STORE 9.72.0 THE PLAZA",
                "7500 BEACH ROAD THE PLAZA UNIT B1 306  ",
                "199591"
            ],
            [
                "PARKROYAL ON BEACH ROAD",
                "7500A BEACH RD #03-301 THE PLAZA  ",
                "199591"
            ],
            [
                "7-11 STORE 518 KEYPOINT",
                "371 BEACH ROAD No 01-01 KEYPOINT  ",
                "199597"
            ],
            [
                "CHEERS CONCOURSE (CBERD)(851)",
                "302 BEACH ROAD, CONCOURSE SKYLINE UNIT 01-01  ",
                "199600"
            ],
            [
                "CAFE LE CAIRE (INTERNATIONAL) PTE LTD",
                "39 ARAB STREET   ",
                "199738"
            ],
            [
                "7-11 STORE 486 ARAB ST",
                "144 ARAB STREET NO 01-01  ",
                "199829"
            ],
            [
                "INNOVATRIX PTE LTD",
                "#01-31 BLK 801 FRENCH RD  ",
                "200801"
            ],
            [
                "COLLIN`S GRILLED BENTO -  KING GEORGE",
                "BLK 803 KING GEORGE AVE #01-206  ",
                "200803"
            ],
            [
                "7-11 STORE 9.83.0 FRENCH RD BLK 809",
                "Blk 809 French Road #01-47 Kitchener Complex  ",
                "200809"
            ],
            [
                "EVERYDAY MART",
                "139 TYRWHITT RD #01-02  ",
                "207557"
            ],
            [
                "7-11 STORE 795 TYRWHITT RD",
                "139 TYRWHITT ROAD UNIT 01-01  ",
                "207557"
            ],
            [
                "SARAVANA BHAVAN PTE LTD",
                "84 SYED ALWI ROAD   ",
                "207663"
            ],
            [
                "CHILL CORNER @ SYED ALWI PTE LTD",
                "88 SYED ALWI ROAD UNIT 01-01  ",
                "207667"
            ],
            [
                "SUJA INTL PTE LTD - PUNYSAMY",
                "104 SYED ALWI ROAD   ",
                "207680"
            ],
            [
                "MIRDHA ENTERPRISE",
                "NO. 39 ROWELL ROAD   ",
                "207991"
            ],
            [
                "SE MART",
                "39 ROWELL ROAD   ",
                "207991"
            ],
            [
                "7-11 STORE 452 PENHAS ROAD",
                "28 PENHAS ROAD NO 01-03  ",
                "208187"
            ],
            [
                "CHEERS MAUDE RD (CMAUDE)(837)",
                "87 MAUDE ROAD UNIT 01-01  ",
                "208358"
            ],
            [
                "I-TEC - KITCHENER RD",
                "123 KITCHENER RD   ",
                "208512"
            ],
            [
                "7-11 STORE 453 KITCHEN ROAD",
                "137 KITCHENER ROAD LEVEL 1  ",
                "208519"
            ],
            [
                "PIZZA HUT - CITY SQUARE",
                "180 KITCHENER ROAD UNIT 01-19/21  CITY SQUARE MALL ",
                "208539"
            ],
            [
                "THE REFINERY",
                "115 KING GEORGE AVE   ",
                "208561"
            ],
            [
                "CHEERS LAVENDER V HTL (FRVHTL) 923",
                "70 JELLICOE ROAD UNIT 01 02  ",
                "208767"
            ],
            [
                "CHEERS ROCHOR HTL 81 (CJBS)(573)",
                "5 JALAN BESAR .  ",
                "208785"
            ],
            [
                "S.S. GROUP TRADING PTE LTD",
                "33 JALAN BESAR   ",
                "208799"
            ],
            [
                "KEMOSABE COFFEE",
                "257 JALAN BESAR   ",
                "208930"
            ],
            [
                "7-11 STORE 195 FOCH HOA NAN BLDG",
                "27 FOCH ROAD 01 07/08 HOA NAM BUILDING  ",
                "209264"
            ],
            [
                "CHEERS FOCH RD (CHFH)(532)",
                "36 FOCH RD .  ",
                "209266"
            ],
            [
                "PRADEEP INTERNATIONAL TRADING",
                "18 DUNLOP ST   ",
                "209347"
            ],
            [
                "7-11 STORE 382 DUNOP ST",
                "77 DUNOP STREET .  ",
                "209404"
            ],
            [
                "7-11 STORE 221 OWEN BLK 45",
                "BLK 45 OWEN ROAD 01 295  ",
                "210045"
            ],
            [
                "SKC EVENTS & DISTRIBUTION",
                "BLK 683 TESSENSOHN RD #01-123  ",
                "210683"
            ],
            [
                "AMISTA INTERNATIONAL PTE LTD",
                "BLK 684 RACE COURSE ROAD #01-300  ",
                "210684"
            ],
            [
                "JUMP START VENTURES PTE LTD",
                "204 RANGOON RD   ",
                "214581"
            ],
            [
                "DZAMBAL VENTURES PTE LTD",
                "POTLUCK CAFE 60 TESSENSOHN ROAD #01-00 CIVIL SERVICE CLUB ",
                "217664"
            ],
            [
                "7-11 STORE 124 LITTLE INDIA ARCADE",
                "48 SERANGOON RD 01-19/20 BLK LITTLE INDIA ARCADE  ",
                "217959"
            ],
            [
                "7-11 STORE 545 SERANGOON RD",
                "212 SERANGOON ROAD   ",
                "218074"
            ],
            [
                "7-11 STORE 121 SERANGOON PL",
                "320 SERANGOON RD 01 29 SERANGOON PLAZA  ",
                "218108"
            ],
            [
                "7-11 STORE 645 SHELL SERANGOON RD",
                "509 SERANGOON ROAD .  ",
                "218152"
            ],
            [
                "THE FRENCH STALL",
                "544 SERANGOON ROAD   ",
                "218166"
            ],
            [
                "COFFEE DYNASTY",
                "2 SERANGOON ROAD THE VERGE #03-03  ",
                "218227"
            ],
            [
                "FIFTH SEASON TANGRA CHINESE RESTAURANT",
                "28 RACE COURSE ROAD   ",
                "218550"
            ],
            [
                "FRENCH CORNER",
                "74 RACE COURSE ROAD   ",
                "218574"
            ],
            [
                "JOLLYMAMA 24 HOURS MINIMART",
                "421 RACE COURSE ROAD   ",
                "218668"
            ],
            [
                "DASIE BHAI MINI MART PTE LTD",
                "25 BIRCH ROAD   ",
                "219890"
            ],
            [
                "7-11 STORE 576 GRD CHANCELLOR HTL",
                "NO.3 BELILIOS RD UNIT 01-01   ",
                "219924"
            ],
            [
                "FAIRPRICE XPRESS PEACE CTR (XPPC)(6",
                "1 SOPHIA RD, PEACE CENTRE UNIT 01-18/20/21/22/49/50  ",
                "228149"
            ],
            [
                "7-11 STORE 158 PEACE CENTER",
                "1 SOPHIA ROAD UNIT 01-19 PEACE CENTER  ",
                "228149"
            ],
            [
                "GRAND HYATT SINGAPORE",
                "10-12 SCOTTS ROAD   ",
                "228211"
            ],
            [
                "DHANIN YAVANA PTE LTD-TEN ELEVEN CUPCAKE",
                "TEN ELEVEN CUPCAKES FAR EAST PLAZA #01-54/55 14 SCOTTS ROAD ",
                "228213"
            ],
            [
                "7-11 STORE 167 FAR EAST PLAZA",
                "14 SCOTTS ROAD 01 05 FAR EAST PLAZA  ",
                "228213"
            ],
            [
                "AMERICAN CLUB",
                "NO. 21 SCOTTS ROAD   ",
                "228219"
            ],
            [
                "ISETAN - SCOTTS",
                "20 ISETAN SCOTTS   ",
                "228221"
            ],
            [
                "7-11 STORE 392 NEWTON MRT",
                "49 SCOTTS ROAD B1 01 NEWTON MRT STATION  ",
                "228234"
            ],
            [
                "7-11 STORE 432 CUPPAGE PLAZA",
                "5 KOEK ROAD 01 16 CUPPAGE PLAZA  ",
                "228796"
            ],
            [
                "7-11 STORE 437 THE CATHAY",
                "2 HANDY RD 01 13/14/K1 THE CATHAY  ",
                "229233"
            ],
            [
                "7-11 STORE 438 BUANGKOK VIEW 1",
                "10 BUANGKOK VIEW LEVEL 1 11 130 BUANGKOK GREEN MDL PK  ",
                "229233"
            ],
            [
                "CATHAY - HANDY ROAD",
                "NO. 2 HANDY ROAD UNIT 05-00 THE CATHAY  ",
                "229233"
            ],
            [
                "EHGINE ROOM PTE LTD-EMERALD",
                "12 EMERALD HILL ROAD   ",
                "229295"
            ],
            [
                "CHEERS BY FP WINSTEDT (EWST)(635)",
                "141 BUKIT TIMAH RD .  ",
                "229841"
            ],
            [
                "7-11 STORE 655 SHELL NEWTON CIRCUS",
                "143 BUKIT TIMAH ROAD .  ",
                "229843"
            ],
            [
                "7-11 STORE 643 SHELL NEWTON HOOPER",
                "150 BUKIT TIMAH ROAD .  ",
                "229846"
            ],
            [
                "CHIR CHIR FUSION FACTORY - ORCHARD",
                "313 ORCHARD ROAD 313@SOMERSET #B3-04/05/06  ",
                "230895"
            ],
            [
                "CHEERS SCAPE (CORLNK)(853)",
                "NO. 2 ORCHARD LINK #02-42 SCAPE  ",
                "237978"
            ],
            [
                "PARK HOTEL CLARKE QUAY",
                "1 UNITY ST   ",
                "237983"
            ],
            [
                "7-11 STORE 191 GREAT WORLD CITY",
                "1 KIM SENG PROMENADE 01 53 GREAT WORLD CITY  ",
                "237994"
            ],
            [
                "7-11 STORE 441 SOMERSET MRT STATION",
                "1 SOMERSET ROAD, SOMERSET MRT STATION UNIT B1-02  ",
                "238162"
            ],
            [
                "7-11 STORE 769 WATERMARK ROBERTSON",
                "7 RODYK STREET UNIT 01-31 WATERMARK@ROBERTSON QUAY  ",
                "238215"
            ],
            [
                "ECO FAMILY MART",
                "7 RODYK STREET UNIT 01-29  ",
                "238215"
            ],
            [
                "7-11 STORE 418 RIVERSIDE VIEW",
                "30 ROBERTSON QUAY 01 02 RIVERSIDE VIEW  ",
                "238251"
            ],
            [
                "7-11 STORE 334 THE QUAYSIDE",
                "60 ROBERTSON QUAY UNIT 01 08 THE QUAYSIDE  ",
                "238252"
            ],
            [
                "7-11 STORE 198 RIVER VALLEY RD",
                "244/246 RIVER VALLEY RD RIVER VALLEY ROAD  ",
                "238300"
            ],
            [
                "ASPEN HEIGHT SUPERMART",
                "BLK 263 RIVER VALLEY RD UNIT B1-03 LOBBY W1 ASPEN HEIGHT ",
                "238309"
            ],
            [
                "YONG AN NEIGHBOURHOOD",
                "329 RIVER VALLEY ROAD TEMBUSU TOWER YONG AN PARK  ",
                "238363"
            ],
            [
                "EACH A CUP - ION ORCHARD",
                "2 ORCHARD TURN UNIT B4-45 ION ORCHARD  ",
                "238801"
            ],
            [
                "7-11 STORE 451 DHOBY GHAUT MRT",
                "11 ORCHARD ROAD B1-08 TO 22 DHOBY GHAUT MRT STN  ",
                "238826"
            ],
            [
                "HOT TOMATO - PLAZA SINGAPURA",
                "#B2-35/36 68 ORCHARD RD   ",
                "238839"
            ],
            [
                "7-11 STORE 247 PLAZA SINGAPURA",
                "68 ORCHARD RD 01 29A PLAZA SINGAPURA  ",
                "238839"
            ],
            [
                "PIZZA HUT - PLAZA SINGAPURA",
                "68 ORCHARD ROAD UNIT B2-01/35 PLAZA SINGAPURA ",
                "238839"
            ],
            [
                "NANDO`S - PLAZA SINGAPURA",
                "68 ORCHARD ROAD UNIT 04-10/11 PLAZA SINGAPURA ",
                "238839"
            ],
            [
                "CHEERS - CONCORDE HOTEL",
                "100 ORCHARD ROAD No. 01-01 CONCORDE HOTEL  ",
                "238840"
            ],
            [
                "7-11 STORE 168 ORCHARD PLAZA",
                "150 ORCHARD ROAD 01 53/54/55 ORCHARD PLAZA  ",
                "238841"
            ],
            [
                "7 11 STORE 9.76.0 CENTREPOINT",
                "176 ORCHARD RD B1 07/8 CENTREPOINT  ",
                "238843"
            ],
            [
                "PERANAKAN PLACE COMPLEX PTE LTD",
                "180 ORCHARD ROAD PERANAKAN PLACE  ",
                "238846"
            ],
            [
                "NOTINUSE",
                "WRONG ENTRY   ",
                "238858"
            ],
            [
                "HOTEL JEN ORCHARDGATEWAY SINGAPORE",
                "277 ORCHARD RD #10-01   ",
                "238858"
            ],
            [
                "OUTBACK STEAKHOUSE - ORCHARD",
                "277 ORCHARD RD 04-01 ORCHARD GATEWAY  ",
                "238858"
            ],
            [
                "COFFEE CLUB - PARAGON",
                "PARAGON SHOPPING MALL #03-09 290 ORCHARD RD  ",
                "238859"
            ],
            [
                "7-11 STORE 9.33.0 PARAGON",
                "290 ORCHARD ROAD UNIT 02-08B  ",
                "238859"
            ],
            [
                "SARIKA CONNOISSEUR CAFE - WHEELOCK",
                "THE HOUSE OF ROBERT TIMMS 501 ORCHARD ROAD #01-02/03 WHEELOCK PLACE ",
                "238860"
            ],
            [
                "7-11 STORE 136 LUCKY PLAZA B1",
                "304 ORCHARD RD B1 02/03 LUCKY PLAZA  ",
                "238863"
            ],
            [
                "PIZZA HUT - LUCKY PLAZA",
                "304 ORCHARD ROAD UNIT 01-67/69/71/72 LUCKY PLAZA SHOPPING CENTRE ",
                "238863"
            ],
            [
                "SARIKA CONNOISSEUR CAFE - OSC",
                "321 ORCHARD RD #01-01/02 ORCHARD SHOPPING CENTRE  ",
                "238866"
            ],
            [
                "MANDARIN ORCHARD SINGAPORE",
                "333 ORCHARD ROAD   ",
                "238867"
            ],
            [
                "7-11 STORE 230 NGEE ANN CITY",
                "NO. 391 ORCHARD ROAD #01-K2 NGEE ANN CITY CIVIC PLAZA  ",
                "238872"
            ],
            [
                "TRIPLE O`S - ORCHARD TOWERS",
                "400 ORCHARD ROAD #01-29C ORCHARD TOWERS  ",
                "238875"
            ],
            [
                "VJS TRADERS",
                "400 ORCHARD RD UNIT 01-22A ORCHARD TOWERS  ",
                "238875"
            ],
            [
                "KZILLION TRADING",
                "400 ORCHARD RD  #01-25 ORCHARD TOWERS  ",
                "238875"
            ],
            [
                "7-11 STORE 318 ORCHARD TOWER B1",
                "NO. 400 ORCHARD ROAD #B1-16 ORCHARD TOWERS  ",
                "238875"
            ],
            [
                "7-11 STORE 9.50.0 ORCHARD TOWER L1",
                "400 ORCHARD RD 01 29 ORCHARD TOWER  ",
                "238875"
            ],
            [
                "AZWAR TRADING",
                "400 ORCHARD ROAD UNIT 01-22A ORCHARD TOWERS ",
                "238875"
            ],
            [
                "DESIGNER`S PARK",
                "400 ORCHARD ROAD UNIT 02-41 ORCHARD TOWERS  ",
                "238875"
            ],
            [
                "7-11 STORE 510 WISMA ATRIA",
                "435 ORCHARD ROAD No 03-14 WISMA ATRIA  ",
                "238877"
            ],
            [
                "7-11 STORE 515 ORCHARD MRT B1",
                "437 ORCHARD ROAD UNIT B1-21 ORCHARD MRT STATION  ",
                "238878"
            ],
            [
                "ORCHARD HOTEL SINGAPORE",
                "442 ORCHARD RD   ",
                "238879"
            ],
            [
                "COFFEE CLUB - WHEELOCK PLACE K1",
                "501 ORCHARD RD #01-K1   ",
                "238880"
            ],
            [
                "NYDC - WHEELOCK PLACE",
                "501 ORCHARD RD WHEELOCK PLACE UNIT 02-19  ",
                "238880"
            ],
            [
                "CHEERS FAR EAST S.CTR (FRFESC)(929)",
                "545 ORCHARD ROAD UNIT 01-18  ",
                "238882"
            ],
            [
                "7-11 STORE 243 FAR EAST S.CTR",
                "545 ORCHARD ROAD 01 14 FAR EAST SHOPPING CTR  ",
                "238882"
            ],
            [
                "7-11 STORE 231 FORUM THE S.MALL",
                "583 ORCHARD RD NO.01-K4 FORUM THE SHOPPING MALL  ",
                "238884"
            ],
            [
                "7-11 STORE 234 313 SOMMERSET",
                "313 ORCHARD ROAD UNIT 01 35 36  ",
                "238895"
            ],
            [
                "HOT TOMATO CAFE & GRILL - 313",
                "313@SOMMERSET #B3-35/36  ",
                "238895"
            ],
            [
                "MACCHA HOUSE (OC)",
                "181 ORCHARD RD ORCHARD CENTRAL #B1-39/45  ",
                "238896"
            ],
            [
                "CHIKUWA TEI JAPANESE RESTAURANT",
                "9 MOHAMED SULTAN ROAD #01-01  ",
                "238959"
            ],
            [
                "7-11 STORE 462 MD. SULTAN RD",
                "33 MOHAMED SULTAN ROAD 01 04  ",
                "238977"
            ],
            [
                "7-11 STORE 378 KILLINEY RD",
                "85 KILLINEY ROAD .  ",
                "239532"
            ],
            [
                "SPC - KILLINEY",
                "132 KILLINEY ROAD UNIT 01-01  ",
                "239662"
            ],
            [
                "7-11 STORE 490 CATHAY CINELEISURE",
                "8 GRANGE ROAD CATHY CINELEISURE ORCHARD  ",
                "239695"
            ],
            [
                "CATHAY - GRANGE ROAD",
                "NO. 8 GRANGE ROAD UNIT 05-00 CINELEISURE ORCHARD ",
                "239695"
            ],
            [
                "7-11 STORE 775 UE SQUARE",
                "81 Clemenceau Avenue UNIT 01-24 UE Square  ",
                "239917"
            ],
            [
                "FRIENDS CATERING - SHELL HOUSE",
                "83 CLEMENCEAU AVENUE SHELL HOUSE UE SQUARE LEVEL 2 WEST WING ",
                "239920"
            ],
            [
                "DAN RYAN`S CHICAGO GRILL",
                "91 TANGLIN ROAD UNIT B1-01 TANGLIN PLACE  ",
                "247918"
            ],
            [
                "7-11 STORE 249 TANGLIN MALL",
                "NO. 163 TANGLIN ROAD, TANGLIN MALL UNIT 01-13A  ",
                "247933"
            ],
            [
                "NANDO`S - TANGLIN MALL",
                "163 TANGLIN ROAD UNIT 01-14/15 TANGLIN MALL  ",
                "247933"
            ],
            [
                "CHEERS BY FP TANGLIN (ETLR)(657)",
                "353 TANGLIN RD .  ",
                "247959"
            ],
            [
                "7-11 STORE 9.34.0 RIVER VALLEY KELL",
                "423 RIVER VALLEY RD .  ",
                "248322"
            ],
            [
                "7-11 STORE 728 VALLEY POINT",
                "491B RIVER VALLEY ROAD UNIT 01 19 VALLEY POINT  ",
                "248373"
            ],
            [
                "FOURNIR PTE LTD",
                "PARK HOUSE  21 ORCHARD BOULEVARD #01-23  ",
                "248645"
            ],
            [
                "THE LOOKING GLASS BISTRO PTE LTD",
                "ORCHARD BOULEVARD UNIT 01-03  CAMDEN MEDICAL CENTRE ",
                "248649"
            ],
            [
                "FAIRPRICE XPRESS JERVOIS (EJVR)(623",
                "1 JERVOIS RD .  ",
                "248992"
            ],
            [
                "SPC - RIVER VALLEY",
                "2 JERVOIS ROAD UNIT 01-01  ",
                "249098"
            ],
            [
                "HOTEL JEN TANGLIN SINGAPORE",
                "1A CUSCADEN ROAD UNIT B1-00 TRADERS HOTEL  ",
                "249716"
            ],
            [
                "THE TANGLIN CLUB",
                "5 STEVEN ROAD   ",
                "257814"
            ],
            [
                "SPC - BUKIT TIMAH 331",
                "331 BUKIT TIMAH ROAD UNIT 01-01  ",
                "259117"
            ],
            [
                "HALIA PROVISION",
                "1 CLUNY ROAD GINGER GARDIN, BOTANICAL GARDEN  ",
                "259569"
            ],
            [
                "7-11 STORE 257 BALMORAL PLAZA",
                "271 BUKIT TIMAH ROAD 01 03 BALMORAL PLAZA  ",
                "259708"
            ],
            [
                "SLOANE COURT HOTEL PTE LTD",
                "17 BALMORAL ROAD   ",
                "259803"
            ],
            [
                "7-11 STORE 365 EMPRESS BLK 8",
                "BLK 8 EMPRESS RD NO 01-23  ",
                "260008"
            ],
            [
                "INTERNATIONAL BAPTIST CHURCH",
                "81 KINGS RD   ",
                "266358"
            ],
            [
                "TOP CHOICE SUPERMART-LEEDON",
                "19 LEEDON HEIGHTS #01-67  ",
                "267938"
            ],
            [
                "ASTRID MEADOWS MINIMARTS",
                "50 CORNATION ROAD UNIT 01-02 WEST SOMERSET COURT ",
                "269264"
            ],
            [
                "SPC - BUKIT TIMAH 623A",
                "623A BUKIT TIMAH ROAD UNIT 01-01  ",
                "269733"
            ],
            [
                "BLUE TEA CAFE",
                "673 BUKIT TIMAH ROAD THE CHINESE HIGH BOARDING SCHOOL  ",
                "269735"
            ],
            [
                "CHEERS BY FP B.TIMAH (EBKT)(664)",
                "751 BUKIT TIMAH RD .  ",
                "269757"
            ],
            [
                "7-11 STORE 142 GHIM MOH BLK 19",
                "BLK 19 GIM MOH ROAD NO 01-237  ",
                "270019"
            ],
            [
                "7-11 STORE 256 HOLLAND DR BLK 43",
                "BLK 43 HOLLAND DRIVE NO 01-41  ",
                "270043"
            ],
            [
                "7-11 STORE 9.04.0 SIXTH AVE BLK 6",
                "SIXTH AVENUE .  ",
                "276472"
            ],
            [
                "RIDGEWOOD GOURMET",
                "BLK 5 G3 RIDGEWOOD CLOSE RIDGEWOOD CONSOMINIUM  ",
                "276696"
            ],
            [
                "VALLE",
                "5 RIDGEWOOD CLOSE UNIT 01-G6 RIDGEWOOD CONDOMINIUM ",
                "276696"
            ],
            [
                "7-11 STORE 9.12.0 LOR MAMBONG",
                "4 LOR MAMBONG .  ",
                "277672"
            ],
            [
                "NYDC - HOLLAND VILLAGE",
                "30 LORONG MAMBONG   ",
                "277688"
            ],
            [
                "CHEERS BY FP HOLLAND (EHOL)(638)",
                "174 HOLLAND RD .  ",
                "278582"
            ],
            [
                "CALTEX - HOLLAND RD",
                "297 HOLLAND ROAD UNIT 01-01  ",
                "278629"
            ],
            [
                "PICOTIN PTE LTD",
                "60 FAIRWAYS DRIVE CHAMPIONS GOLF  ",
                "286966"
            ],
            [
                "EDEN SPORTS & RECREATION PTE LTD",
                "2 TURF CLUB ROAD   ",
                "287988"
            ],
            [
                "GALLOP STABLE (S) PTE LTD - TURF",
                "100 TURF CLUB ROAD #01-02  ",
                "287992"
            ],
            [
                "THE TENNIS CLUB PTE LTD",
                "200 TURF CITY UNIT 01-63  ",
                "287994"
            ],
            [
                "STARK AUTOMOBILE PTE LTD",
                "210 TURF CLUB RD  THE GRANDSTAND LOT B-78  ",
                "287995"
            ],
            [
                "EHGINE ROOM PTE LTD-SIME",
                "67 SIME ROAD   ",
                "288301"
            ],
            [
                "SINGAPORE ISLAND COUNTRY CLUB - BUKIT",
                "240 SIME ROAD   ",
                "288303"
            ],
            [
                "SKY SUPERMARKET PTE LTD",
                "19 SHELFORD RD #01-53  ",
                "288408"
            ],
            [
                "7-11 STORE 668 SHELL GEYLANG LOR 7",
                "203 GEYLANG ROAD .  ",
                "289266"
            ],
            [
                "7-11 STORE 666 SHELL DUNEARN ENG NE",
                "648 DUNEARN ROAD .  ",
                "289629"
            ],
            [
                "CHEERS BY FP DUNEARN (EDUN)(631)",
                "650 DUNEARN RD .  ",
                "289630"
            ],
            [
                "HOWE CATERING - BUKIT TINGGI",
                "72 BUKIT TINGGI RD   ",
                "289760"
            ],
            [
                "FOOD HAVEN BY THE PARK PTE LTD",
                "72 BUKIT TINGGI ROAD GERMAN EUROPEAN SCHOOL  ",
                "289760"
            ],
            [
                "THE BRITISH CLUB",
                "73 BUKIT TINGGI ROAD   ",
                "289761"
            ],
            [
                "SPC - ADAM",
                "31 ADAM ROAD UNIT 01-01  ",
                "289896"
            ],
            [
                "RAFFLES TOWN CLUB",
                "1 PLYMOUTH AVE   ",
                "297753"
            ],
            [
                "CALTEX - WHITLEY RD",
                "236 WHITLEY ROAD UNIT 01-01  ",
                "297826"
            ],
            [
                "POLO RESTAURANT PTE LTD",
                "80 MOUNT PLEASANT ROAD   ",
                "298334"
            ],
            [
                "SPC - DUNEARN",
                "260 DUNEARN ROAD UNIT 01-01  ",
                "299542"
            ],
            [
                "7-11 STORE 658 SHELL DUNEARN UNI RD",
                "314 DUNEARN ROAD .  ",
                "299551"
            ],
            [
                "HOLLANDSE CLUB",
                "22 CAMDEN PARK   ",
                "299814"
            ],
            [
                "7-11 STORE 192 BALESTIER HILL S.CTR",
                "BLK 1 THOMSON ROAD 01 330 BALESTIER HILL S.C.  ",
                "300001"
            ],
            [
                "7-11 STORE 430 SQUARE 2 S.CTR",
                "NO. 10 SINARAN DRIVE UNIT 01-03 SQUARE 2  ",
                "307506"
            ],
            [
                "7-11 STORE 217 UNITED SQUARE",
                "101 THOMSON ROAD 01 01A UNITED SQUARE  ",
                "307591"
            ],
            [
                "7-11 STORE 665 SHELL THOMSON NOVENA",
                "324 THOMSON NOVENA .  ",
                "307672"
            ],
            [
                "SPC - THOMSON ",
                "327 THOMSON ROAD   ",
                "307673"
            ],
            [
                "7-11 STORE 535 NOVENA SQUARE",
                "238 THOMSON ROAD No. 01-06A NOVENA SQUARE  ",
                "307683"
            ],
            [
                "7-11 STORE 632 SHELL MOULMEIN",
                "103 MOULMEIN ROAD .  ",
                "308080"
            ],
            [
                "CHEERS TTSH HOSPITAL(CTTSH)(854)",
                "11 Jalan Tan Tock Seng #01-03  ",
                "308433"
            ],
            [
                "7-11 STORE 129 TAN TOCK SENG",
                "11 JALAN TAN TOCK SENG 01 03 TAN TOCK SENG HOSP  ",
                "308433"
            ],
            [
                "GROCER MART PTE LTD",
                "51 GOLDHILL PLAZA #07-10/11  ",
                "308900"
            ],
            [
                "CHEERS BY FP NEWTON (ENT)(687)",
                "30 DUNEARN RD .  ",
                "309425"
            ],
            [
                "Q-KOKOR PTE LTD",
                "60 DUNEARN ROAD   ",
                "309434"
            ],
            [
                "CALTEX - DUNEARN RD",
                "130 DUNEARN ROAD UNIT 01-01  ",
                "309436"
            ],
            [
                "7-11 STORE 281 TPY BLK 8",
                "BLK 8 TOA PAYOH LOR 7 NO 01-299  ",
                "310008"
            ],
            [
                "CHEERS TPY BLK 18 (CTP18)(838)",
                "BLK 18 TOA PAYOH LORONG 7 UNIT 01-246  ",
                "310018"
            ],
            [
                "HONG ERN CORPORATION",
                "BLK 85 TOA PAYOH LOR 4 UNIT 01-1  ",
                "310085"
            ],
            [
                "7-11 STORE 9.69.0 TPY BLK 111",
                "BLK 111 TOA PAYOH LOR 1 NO 01 358  ",
                "310111"
            ],
            [
                "I-ECON - BAN SENG",
                "BLK 116 TOA PAYOH LOR 2 UNIT 01-01  ",
                "310116"
            ],
            [
                "7-11 STORE 9.67.0 TPY BLK 123",
                "BLK 123 TOA PAYOH LORONG 1 #01-493  ",
                "310123"
            ],
            [
                "7-11 STORE 216 TPY BLK 163",
                "BLK 163 TOA PAYOH LOR 01 1016  ",
                "310163"
            ],
            [
                "7-11 STORE 9.65.0 TPY BLK 190",
                "BLK 190 TOA PAYOH LOR 6 LOR 6 TOA PAYOH  ",
                "310190"
            ],
            [
                "PIZZA HUT - TPY LOR 6",
                "BLK 190 TOA PAYOH LOR 6 UNIT 02-516A  ",
                "310190"
            ],
            [
                "BRAHBU`S A FAMILY MART",
                "BLK 194 KIM KEAT AVE #01-390  ",
                "310194"
            ],
            [
                "7-11 STORE 416 TPY BLK 203",
                "BLK 203 TOA PAYOH NORTH NO 01-1107  ",
                "310203"
            ],
            [
                "COLLIN`S GRILLED BENTO - TOA PAYOH",
                "203 TOA PAYOH NORTH #01-1097  ",
                "310203"
            ],
            [
                "POH HUAT KIOSK",
                "BLK 222 TOA PAYOH LOR 8 UNIT 01-709  ",
                "310222"
            ],
            [
                "I-ECON - HONG JOO AUTO CENTRE PTE LTD",
                "9 TAMPINES AVENUE 2 UNIT 01-01  ",
                "310234"
            ],
            [
                "CHEERS TPY HUB L1 (CHTC)(505)",
                "BLK 500 UNIT01-33 TOA PAYOH LOR 6 TOA PAYOH CENTRAL  ",
                "310500"
            ],
            [
                "7-11 STORE 512 TPY BLK 79D",
                "BLK 79D TOA PAYOH CENTRAL No 01-55  ",
                "314079"
            ],
            [
                "S`PORE PRESS HOLDING CANTEEN",
                "1000 TOA PAYOH NORTH   ",
                "318994"
            ],
            [
                "SUNSET BAY BISTRO",
                "590 TOA PAYOH   ",
                "319134"
            ],
            [
                "SPC - TOA PAYOH",
                "180 TOA PAYOH LORONG 6   ",
                "319381"
            ],
            [
                "JP FOOD SERVICES -KKONGDON TOA PAYOH",
                "293 LOR 6 TOA PAYOH #01-04 SAFRA TOA PAYOH  ",
                "319387"
            ],
            [
                "CHEERS TPY MRT B1 (SMRTTP)(568)",
                "510 TOA PAYOH LORONG 6 UNIT B1 01 TOA PAYOH MRT STN  ",
                "319398"
            ],
            [
                "FAIRPRICE XPRESS TPY LOR 2 (ETP2)(6",
                "399 TOA PAYOH LOR 2 .  ",
                "319640"
            ],
            [
                "7-11 STORE 663 SHELL TOA PAYOH",
                "248 TOA PAYOH LORONG 1 .  ",
                "319755"
            ],
            [
                "LIAN SHAN SHUANG LIN MONASTERY",
                "184 JALAN TOA PAYOH   ",
                "319944"
            ],
            [
                "UNCLE YAP`S ENTERPRISE",
                "BLK 3 ST. GEORGE ROAD UNIT 01-103  ",
                "320003"
            ],
            [
                "COLLIN`S GRILLED BENTO - ST GEORGE",
                "BLK 3 ST GEORGE`S ST #01-70-74  ",
                "320003"
            ],
            [
                "HAO MART PTE LTD",
                "BLK 74 WHAMPOA DR #01-334/336  ",
                "320074"
            ],
            [
                "I-ECON - ACTIVE SUPERMARKET",
                "BLK 74 WHAMPOA DRIVE UNIT 01-334/336  ",
                "320074"
            ],
            [
                "SHOP 2 SAVE MINIMART",
                "BLK 87 WHAMPOA DRIVE UNIT 01-875  ",
                "320087"
            ],
            [
                "100 SUPERMINIMART",
                "BLK 112 MCNAIR ROAD UNIT 01-205  ",
                "320112"
            ],
            [
                "YONG TECK SENG",
                "BLK 22 01-09 BOON KENG RD   ",
                "321108"
            ],
            [
                "COLLIN`S GRILLED BENTO - SHAW PLAZA",
                "360 BALESTIER RD #01-12  ",
                "321978"
            ],
            [
                "7-11 STORE 9.87.0 TOWNER BLK 101",
                "BLK 101 TOWNER ROAD NO 01-234  ",
                "322101"
            ],
            [
                "7-11 STORE 9.89.0 SERANGOON BLK 999",
                "999 SERANGOON RD .  ",
                "328157"
            ],
            [
                "GOH CHYE HUP",
                "1068 SERANGOON ROAD   ",
                "328176"
            ],
            [
                "7-11 STORE 567 BOON KENG MRT",
                "NO. 900 SERANGOON ROAD #01-01 BOOK KENG NEL MRT STATION  ",
                "328260"
            ],
            [
                "7-11 STORE 702 KIM KEAT BLK 34",
                "34 KIM KEAT ROAD   ",
                "328811"
            ],
            [
                "CHEERS BALESTIER V.HTL (FRBLT218)(9",
                "218 BALESTIER RD 01 03  ",
                "329684"
            ],
            [
                "CHEERS BALESTIER HTL 81 (CBLT)(524)",
                "269 BALESTIER RD 37623  ",
                "329720"
            ],
            [
                "7-11 STORE 766 VICTORY POINT",
                "271 BALESTIER ROAD (VICTORY POINT) UNIT 01-01  ",
                "329722"
            ],
            [
                "7-11 STORE 9.27.0 BALESTIER BLK 340",
                "340 BALESTIER RD .  ",
                "329772"
            ],
            [
                "7-11 STORE 408 BALESTIER",
                "BLK 408 BALESTIER ROAD NO 01-02  ",
                "329808"
            ],
            [
                "AH SEAH TRADING",
                "429 BALESTIER ROAD   ",
                "329811"
            ],
            [
                "SPC - BALESTIER",
                "462 BALESTIER ROAD   ",
                "329837"
            ],
            [
                "CALTEX - BALESTIER",
                "542 BALESTIER ROAD   ",
                "329864"
            ],
            [
                "CHEERS BALESTIER V.HTL (FRBLT592)(9",
                "592 BALESTIER RD NO 01-02  ",
                "329901"
            ],
            [
                "7-11 STORE 356 BALESTIER",
                "221 BALESTIER ROAD 01 02 ROCEA BALESTIER  ",
                "329928"
            ],
            [
                "BALESTIER MARKET PTE LTD",
                "411 Balestier Road   ",
                "329930"
            ],
            [
                "CHEERS ZHONG SHAN MALL (CZSHAN)(819",
                "20 AH HOOD ROAD UNIT 01-06 ZHONG SHAN MALL  ",
                "329984"
            ],
            [
                "I-ECON - YONG TECK SENG",
                "BLK 22 BOON KENG ROAD UNIT 01-29  ",
                "330022"
            ],
            [
                "SAN CHUANG MINIMART",
                "BLK 24 BENDEMEER ROAD #01-547  ",
                "330024"
            ],
            [
                "I-ECON - SAN CHUANG",
                "BLK 24 BENDEMEER ROAD UNIT 01-547  ",
                "330024"
            ],
            [
                "BOON KENG TRADING & MINIMART",
                "BLK 34 WHAMPOA WEST UNIT 01-15  ",
                "330034"
            ],
            [
                "TONG SOON MINIMART",
                "BLK 44 BENDEMEER ROAD #01-1468  ",
                "330044"
            ],
            [
                "BENDEMEER STORE",
                "BLK 44 BENDEMEER ROAD UNIT 01-1468  ",
                "330044"
            ],
            [
                "YI JIA MINI MART",
                "BLK 57 GEYLANG BAHRU UNIT 01-99  ",
                "330057"
            ],
            [
                "7-11 STORE 315 GEY BAHRU BLK 68",
                "BLK 68 GEYLANG BAHRU 486871  ",
                "330068"
            ],
            [
                "CHEERS BY FP LAVENDER (ELVR)(679)",
                "216 LAVENDER ST .  ",
                "338771"
            ],
            [
                "PASTA PALACE PTE LTD",
                "2 KALLANG AVE #01-09/12 CITY HUB  ",
                "339407"
            ],
            [
                "7-11 STORE 9.66.0 APERIA MALL KALLA",
                "12 Kallang Avenue #01-52 APERIA MALL  ",
                "339511"
            ],
            [
                "CONTINENTAL AUTOMOTIVE PTE LTD",
                "80 BOON KENG ROAD CONTINENTAL BUILDING  ",
                "339780"
            ],
            [
                "FENG CONG CANTEEN",
                "71 TANNERY LANE #11-04/05 CITY INDUSTRIAL BLDG ",
                "347807"
            ],
            [
                "CALTEX - MACPHERSON 68",
                "68 MACPHERSON ROAD UNIT 01-01  ",
                "348473"
            ],
            [
                "FAIRPRICE XPRESS MACPHERSON (EMAC)(",
                "110/114 MACPHERSON RD .  ",
                "348501"
            ],
            [
                "7-11 STORE 617 SHELL MACPHERSON",
                "259 MACPHERSON ROAD .  ",
                "348584"
            ],
            [
                "SODEXO - SIEMENS",
                "60 MACPHERSON ROAD UNIT 01-01  ",
                "348615"
            ],
            [
                "ELAINE MA",
                "10 KWONG AVENUE   ",
                "348884"
            ],
            [
                "",
                "5 KALLANG PUDDING RD   ",
                "349309"
            ],
            [
                "FRESH PRODUCE SPECIALIST",
                "BLK 136 POTONG PASIR AVE 3 UNIT 01-162  ",
                "350136"
            ],
            [
                "7-11 STORE 413 POTONG PASIR BLK 148",
                "BLK 148 POTONG PASIR AVE 1 NO 01-27  ",
                "350148"
            ],
            [
                "7-11 STORE 642 SHELL BRADDELL",
                "110 BRADDELL ROAD .  ",
                "359914"
            ],
            [
                "JIAN LI MINIMART",
                "BLK 2 ALJUNIED LANE UNIT 01-01  ",
                "360002"
            ],
            [
                "7-11 STORE 713 JOO SENG BLK 14",
                "BLK 14 JOO SENG ROAD UNIT 01-K1  ",
                "360014"
            ],
            [
                "CHEERS BY FP UPP.ALJUNIED (EUAJ)(63",
                "373 UPP ALJUNIED RD .  ",
                "367859"
            ],
            [
                "SPC - MACPHERSON",
                "429 MACPHERSON ROAD UNIT 01-01  ",
                "368140"
            ],
            [
                "CALTEX - MACPHERSON 465",
                "465 MACPHERSON ROAD UNIT 01-01  ",
                "368183"
            ],
            [
                "ASSOCIATE UNITED DISTRIBUTORS-CHOCO EXP",
                "128 JOO SENG ROAD #07-00  ",
                "368356"
            ],
            [
                "I-ECON - ACTIVE EXPRESS MART",
                "BLK 36 CIRCUIT ROAD UNIT 01-412  ",
                "370036"
            ],
            [
                "ACTIVE SUPERMARKET - CIRCUIT",
                "BLK 36 CIRCUIT ROAD #01-412   ",
                "370036"
            ],
            [
                "7-11 STORE 9.75.0 CIRCUIT BLK 36",
                "BLK 36 CIRCUIT RD NO 01 422  ",
                "370036"
            ],
            [
                "7-11 STORE 374 CIRCUIT ROAD",
                "Blk 88 Circuit Road Unit 01 967  ",
                "370088"
            ],
            [
                "SAM-MARTS",
                "BLK 91 PAYA LEBAR WAY UNIT 01-3025  ",
                "370091"
            ],
            [
                "I-ECON - PIN PIN PIAU KAY",
                "BLK 71 SENG POH ROAD UNIT 01-33  ",
                "380011"
            ],
            [
                "7-11 STORE 322 UPP BOON KENG BLK 18",
                "BLK 18 UPPER BOON KENG ROAD NO 01-1157  ",
                "380018"
            ],
            [
                "POH GUAN HUAT",
                "BLK 38 UPPER BOON KENG RD UNIT 01-K1  ",
                "380038"
            ],
            [
                "LONG FA 168 TRADING",
                "BLK 45 SIM DRIVE UNIT 01-168  ",
                "380045"
            ],
            [
                "KHOR THONG HENG",
                "BLK 119 ALJUNIED AVE 2 #01-14  ",
                "380119"
            ],
            [
                "CHEERS - ALJUNIED (CALJ)",
                "BLK 119 ALJUNIED AVE 2 NO 01 74  ",
                "380119"
            ],
            [
                "I-ECON - KHOR THONG HENG",
                "BLK 119 ALJUNIED AVE 2 UNIT 01-14  ",
                "380119"
            ],
            [
                "7-11 STORE 488 KALLANG MRT",
                "5 SIMS AVENUE 01 01 KALLANG MRT STATION  ",
                "387405"
            ],
            [
                "GOURMET EXPRESS MART (529)",
                "529 GEYLANG ROAD LORONG 27A  ",
                "388105"
            ],
            [
                "7-11 STORE 328 GEYLANG LOR 25A",
                "60 LORONG 25A GEYLANG  ",
                "388250"
            ],
            [
                "U K FISH VILLAGE PTE LTD",
                "NO. 43 GEYLANG LOR 21   ",
                "388467"
            ],
            [
                "STARBUY MINIMART",
                "33 LORONG 19 GEYLANG #01-09   ",
                "388502"
            ],
            [
                "STAR BUY - GEYLANG",
                "33 GEYLANG LORONG 19 UNIT 01-09  ",
                "388502"
            ],
            [
                "GOOD COME AGAIN PTE LTD",
                "8 GEYLANG LOR 1   ",
                "389118"
            ],
            [
                "7-11 STORE 146 GEYLANG LOR 10",
                "226 GEYLANG RD .  ",
                "389286"
            ],
            [
                "BA SHU REN JIA STEAMBOAT",
                "233 GEYLANG ROAD   ",
                "389293"
            ],
            [
                "BABLU MINIMART",
                "308 GEULANG ROAD   ",
                "389348"
            ],
            [
                "7-11 STORE 9.30.0 GEYLANG LOR 18",
                "348 GEYLANG RD .  ",
                "389369"
            ],
            [
                "CHEERS BY FP GEYLANG LOR 38 (EGEY)(",
                "638 GEYLANG LOR 38 .  ",
                "389569"
            ],
            [
                "7-11 STORE 266 GEYLANG LOR 44",
                "700 GEYLANG RD .  ",
                "389617"
            ],
            [
                "NEEDS STATION",
                "757 GEYLANG ROAD   ",
                "389659"
            ],
            [
                "JUN TENG INTERNATION TRADING",
                "803 GEYLANG RD   ",
                "389682"
            ],
            [
                "GOURMET EXPRESS MART (803)",
                "803 GEYLANG RD   ",
                "389682"
            ],
            [
                "CHEERS BY FP ALJUNIED B (EAJB)(670)",
                "611 ALJUNIED RD .  ",
                "389830"
            ],
            [
                "CHEERS BY FP ALJUNIED A (EAJA)(675)",
                "630 ALJUNIED RD .  ",
                "389839"
            ],
            [
                "WAH CHEONG",
                "BLK 34 #01-74 CASSIA CRESCENT  ",
                "390034"
            ],
            [
                "I-ECON - WAH CHEONG",
                "BLK 34 CASSIA CRESCENT UNIT 01-74  ",
                "390034"
            ],
            [
                "7-11 STORE 260 JALAN TIGA BLK 39",
                "BLK 39 JALAN TIGA 39817  ",
                "390039"
            ],
            [
                "CHEERS SPORTS HUB MALL (CSPHB)(850)",
                "1 STADIUM PLACE, SPORTS HUB RETAIL MALL UNIT 01-03  ",
                "397628"
            ],
            [
                "TAJ MAHAL STORE",
                "57 WESTERHOUT ROAD   ",
                "397660"
            ],
            [
                "A.R.A WAHEED TRADING",
                "69 WESTERHOUT RD   ",
                "397664"
            ],
            [
                "7-11 STORE 455 KALLANG LEISURE PARK",
                "5 STADIUM WALK 01 56 LEISURE PARK KALLANG  ",
                "397693"
            ],
            [
                "NETBALL SINGAPORE",
                "6 STADIUM BLVD   ",
                "397797"
            ],
            [
                "CHEERS BY FP GUILLEMARD (EGLM)(602)",
                "225 GUILLEMARD RD ESSO SERVICE STATION  ",
                "399379"
            ],
            [
                "YOGA INC PTE LTD",
                "100 GUILLEMARD RD #01-08  ",
                "399718"
            ],
            [
                "7-11 STORE 662 SHELL GUILLEMARD",
                "132 GUILLEMARD ROAD .  ",
                "399720"
            ],
            [
                "ACE FAMILY MART",
                "500 GUILLEMARD ROAD #01-03 EASTA RUBY  ",
                "399839"
            ],
            [
                "I-ECON - TRUST ECONOMIC & FINEST S/MART",
                "500 GUILEMARD ROAD UNIT 01-01  ",
                "399839"
            ],
            [
                "SMILES MART PTE LTD - EUNOS",
                "BLK 6 EUNOS CRESCENT UNIT 01-2631  ",
                "400006"
            ],
            [
                "M MUHAMOOD RAHMATH FAIDAH STORE",
                "BLK 16 EUNOS CRESCENT UNIT 01-2843  ",
                "400016"
            ],
            [
                "7-11 STORE 532 UBI BLK 325",
                "BLK 325 UBI AVENUE 1 UNIT 01- 703  ",
                "400325"
            ],
            [
                "7-11 STORE 715 UBI BLK 344",
                "BLK 344 UBI AVENUE 1 UNIT 01-K1  ",
                "400344"
            ],
            [
                "7-11 STORE 9.21.0 EUNOS BLK 1A",
                "BLK 1A EUNOS CRESCENT   ",
                "401001"
            ],
            [
                "ZAITUN TRADING PTE LTD",
                "BLK 1A EUNOS CRESCENT UNIT 01-K1  ",
                "401001"
            ],
            [
                "U-10 EATING HOUSE PTE LTD",
                "8 UBI AVENUE 2 UNIT 01-15 ZERVEX BUILDING  ",
                "408538"
            ],
            [
                "981 WHOLESALE CENTRE",
                "61 UBI ROAD 1 OXLEY BIZHUB 1  ",
                "408707"
            ],
            [
                "FOODNATION 3",
                "205 UBI AVE 4 CAFETERIA AT COMFORT DRIVING CENTRE  ",
                "408805"
            ],
            [
                "C&L CAFE",
                "UBI ONE, 81 UBI AVE 4 #01-07  ",
                "408830"
            ],
            [
                "WRONGENTRY",
                "81 UBI AVENUE 4 UNIT 03-07  ",
                "408830"
            ],
            [
                "JADE PALACE SEAFOOD RESTAURANT",
                "81 UBI AVE 4 #03-07  ",
                "408830"
            ],
            [
                "HOHA EATING HOUSE",
                "33 UBI AVENUE 3 UNIT 01-35 VERTEX  ",
                "408868"
            ],
            [
                "CHEERS PAYA LEBAR MRT (SPYLB)(570)",
                "30 PAYA LEBAR ROAD, PAYA LEBAR MRT UNIT 01-11/12  ",
                "409006"
            ],
            [
                "7-11 STORE 627 SHELL P.LEBAR PIE",
                "98 PAYA LEBAR ROAD .  ",
                "409008"
            ],
            [
                "CALTEX - PAYA LEBAR",
                "128 PAYA LEBAR ROAD   ",
                "409013"
            ],
            [
                "7-11 STORE 638 SHELL MACPHERSON",
                "255 PAYA LEBAR ROAD .  ",
                "409037"
            ],
            [
                "CHEERS PAYA LEBAR SQ (CPYLSQ)(857)",
                "60 Paya Lebar Road #01-07  ",
                "409051"
            ],
            [
                "7-11 STORE 397 EUNOS MRT",
                "30 EUNOS CRESCENT 01-03 EUNOS MRT STATION  ",
                "409423"
            ],
            [
                "I-ECON - BEGONIA PTE LTD",
                "22 BEGONIA ROAD UNIT 01-01  ",
                "410110"
            ],
            [
                "TENAGA MINIMART",
                "BLK 649 JALAN TENGA UNIT 01-155  ",
                "410649"
            ],
            [
                "GREENLAND MINI MART",
                "BLK 669 JLN DAMAI UNIT 01-51  ",
                "410669"
            ],
            [
                "KALAM MINIMART",
                "BLK 669 JALAN DAMAI UNIT 01-51  ",
                "410669"
            ],
            [
                "SEYU PTE LTD - KAKI BUKIT",
                "1 KAKI BUKIT RD #05-20 ENTERPRISE ONE BUILDING  ",
                "415934"
            ],
            [
                "CHEERS KEMBANGAN MRT (FRSKEM)(914)",
                "55 SIMS AVE EAST 01 02 KEMBANGAN MRT STATION  ",
                "416551"
            ],
            [
                "EASTBAY SUPERMARKET-VACANZA",
                "44 LENGKONG TUJOH #01-43 VACANZA @ EAST  ",
                "417395"
            ],
            [
                "EASTBAY SUPERMARKET-VACANZA - TO CLOSE",
                "44 LENGKONG TUJOH #01-43 VACANZA@EAST  ",
                "417395"
            ],
            [
                "7-11 STORE 242 KEMBANGAN PLAZA",
                "18 JALAN MASJID 01-15 KEMBANGAN PLAZA  ",
                "418944"
            ],
            [
                "FONG ANN HANG ENTERPRISE PTE LTD",
                "111/111A JALAN KEMBANGAN   ",
                "419149"
            ],
            [
                "7-11 STORE 9.01.0 38A CHANGI RD",
                "38A CHANGI ROAD .  ",
                "419701"
            ],
            [
                "CALTEX - CHANGI RD",
                "78 CHANGI ROAD UNIT 01-01  ",
                "419714"
            ],
            [
                "7-11 STORE 470 CHANGI FRAGRANCE BLD",
                "168 CHANGI ROAD No.01-03/04  ",
                "419730"
            ],
            [
                "7-11 STORE 725 ICON AT CHANGI",
                "NO 228 CHANGI ICON AT CHANGI UNIT 01 02  ",
                "419741"
            ],
            [
                "MIRZA FOODS PTE LTD",
                "NO 324 CHANGI RD   ",
                "419799"
            ],
            [
                "SPC - CHANGI COCO",
                "337 CHANGI ROAD UNIT 01-01  ",
                "419810"
            ],
            [
                "19 TRADING PTE LTD",
                "425 CHANGI RD   ",
                "419868"
            ],
            [
                "7-11 STORE 601 SHELL CHANGI",
                "460 CHANGI ROAD .  ",
                "419883"
            ],
            [
                "CHEERS BY FP CHANGI (ECR)(658)",
                "649 CHANGI RD .  ",
                "419946"
            ],
            [
                "LIFESTYLE RECREATION PTE LTD - TEL KURAU",
                "151 LORONG J TELOK KURAU   ",
                "423466"
            ],
            [
                "LIFESTYLE F&B - TELOK KURAU",
                "151 LORONG J TELOK KURAU   ",
                "423466"
            ],
            [
                "MR TEH TARIK - GEYLANG 970",
                "970 GEYLANG ROAD UNIT 01-02 TRISTAR COMPLEX ",
                "423492"
            ],
            [
                "7-11 STORE 9.20.0 PARC ELEGANCE",
                "11 TELOK KURAU UNIT 01-01  ",
                "423761"
            ],
            [
                "KIWI STORES PVT LTD",
                "112 TELOK KURAU RD   ",
                "423800"
            ],
            [
                "CHEERS ONAN HTL81 TRISTAR (COND)(58",
                "01 ONAN RD HOTEL 81 TRISTAR BUILDING  ",
                "424780"
            ],
            [
                "KGH JOO CHIAT POPIAH PTE LTD",
                "SINGAPORE POLYTECHNIC KUOFU FOODCOURT  ",
                "427389"
            ],
            [
                "BES PRICE MINIMART",
                "184 JOO CHIAT ROAD   ",
                "427455"
            ],
            [
                "7-11 STORE 703 JOO CHIAT RD",
                "NO.216 JOO CHIAT ROAD UNIT 01-13/14   ",
                "427483"
            ],
            [
                "STAR BUY - JOO CHIAT",
                "216 JOO CHIAT ROAD UNIT 01-01  ",
                "427483"
            ],
            [
                "GATEWAY MINIMART",
                "60 JOO CHIAT ROAD UNIT 01-03 GATEWAY HOTEL  ",
                "427726"
            ],
            [
                "7-11 STORE 773 EAST GATE BLDG",
                "46 EAST COAST ROAD UNIT 01-02 EAST GATE BUILDING  ",
                "428766"
            ],
            [
                "GRAND MERCURE ROXY HOTEL",
                "50 EAST COAST ROAD UNIT 01-01  ",
                "428769"
            ],
            [
                "7-11 STORE 9.70.0 E.COAST CEYLON",
                "55 EAST COAST RD .  ",
                "428772"
            ],
            [
                "KEITH CRACKLING ROAST",
                "B1-29, KATONG 112 SHOPPING CENTRE 112 EAST COAST ROAD  ",
                "428802"
            ],
            [
                "NANDO`S - KATONG MALL",
                "122 EAST COAST ROAD UNIT 01-14/15 KATONG MALL  ",
                "428802"
            ],
            [
                "THE FISH & CHIP SHOP",
                "206 EAST COAST ROAD   ",
                "428905"
            ],
            [
                "7-11 STORE 205 E.COAST CHAPPEL CLOS",
                "213 EAST COAST ROAD .  ",
                "428912"
            ],
            [
                "FAIRPRICE XPRESS EAST COAST (EECO)(",
                "239/255 EAST COAST RD .  ",
                "428932"
            ],
            [
                "7-11 STORE 631 SHELL EAST COAST",
                "338 EAST COAST ROAD .  ",
                "428961"
            ],
            [
                "CALTEX - PETER CHAN`S ENTERPRISE",
                "355 EAST COAST ROAD   ",
                "428972"
            ],
            [
                "CALTEX - EAST COAST",
                "355 EAST COAST ROAD   ",
                "428972"
            ],
            [
                "CHEERS HAIG RD BLK 12 (CHHR)(382)",
                "BLK 12 HAIG RD 01 333  ",
                "430012"
            ],
            [
                "7-11 STORE 763 JLN BATU BLK 7",
                "BLK 7 JALAN BATU UNIT 01-109  ",
                "431007"
            ],
            [
                "LEONG BROTHERS DEPT. STORE",
                "BLK 8 KAMPONG ARANG RD UNIT 01-09  ",
                "431008"
            ],
            [
                "WATERSIDE MINIMART",
                "13 TANJONG RHU RD #01-01  ",
                "436897"
            ],
            [
                "PEBBLE BAY MINIMART",
                "130 TANJONG RHU ROAD BLK 4 LOBBY J UNIT 01-02 PEBBLE BAY CONDOMINIUM ",
                "436918"
            ],
            [
                "CHEERS BY FP TANJONG KATONG (ETKB)(",
                "189 TANJONG KATONG RD .  ",
                "436991"
            ],
            [
                "7-11 STORE 650 SHELL TANJONG KATONG",
                "191 TANJONG KATONG ROAD .  ",
                "436993"
            ],
            [
                "MALAYSIAN LOCAL DELIGHTS",
                "224 TANJONG KATONG RD   ",
                "437014"
            ],
            [
                "TECK HENG MINIMART",
                "254 TANJONG KATONG ROAD   ",
                "437042"
            ],
            [
                "CALTEX - TG KATONG",
                "265 TANJONG KATONG RD UNIT 01-01  ",
                "437052"
            ],
            [
                "STAR UP PTE LTD",
                "310 TANJONG KATONG ROAD   ",
                "437093"
            ],
            [
                "7-11 STORE 9.16.0 TG KATONG BLK 366",
                "366 TAJONG KATONG RD .  ",
                "437124"
            ],
            [
                "SPC - TANJONG KATONG",
                "1 SWANGE TANJONG HATAY UNIT 01-01  ",
                "437168"
            ],
            [
                "SHOP RIGHT SUPERMARKET PTE LTD",
                "#B1-01 7 RHU CROSS   ",
                "437435"
            ],
            [
                "LENAS MART",
                "7 RHU CROSS UNIT B1-01 COSTA RHU  ",
                "437435"
            ],
            [
                "FAIRPRICE XPRESS MOUNTBATTEN (EMBN)",
                "708 MOUNTBATTEN RD .  ",
                "437733"
            ],
            [
                "SPC - MOUNTBATTAN",
                "710 MOUNTBATTAN ROAD UNIT 01-01  ",
                "437734"
            ],
            [
                "7-11 STORE 184 KATONG S.CTR",
                "865 Mountbatten Road UNIT B1 34 Katong Shopping Centre  ",
                "437844"
            ],
            [
                "NEWS POINT",
                "865 MOUNTBATTEN ROAD UNIT B1-18 KATONG SHOPPING CENTRE ",
                "437844"
            ],
            [
                "MAKENA`S MART",
                "121 MEYER ROAD UNIT 01-05A THE MAKENA CONDOMINIUM ",
                "437932"
            ],
            [
                "CAFE MELBA",
                "GOODMAN ARTS CENTRE 90 GOODMAN ROAD  BLOCK N #01-56 ",
                "439053"
            ],
            [
                "7-11 STORE 639 SHELL DUNMAN",
                "743 DUNMAN ROAD .  ",
                "439241"
            ],
            [
                "LIFESTYLE F&B - EAST COAST C4",
                "1030 EAST COAST PARKWAY EAST COAST PARK AREA C4  ",
                "440000"
            ],
            [
                "7-11 STORE 367 MARINE",
                "47 MARINE CRESCENT NO 01-66  ",
                "440047"
            ],
            [
                "7-11 STORE 135 MARINE TERRACE BLK 5",
                "BLK 57 MARINE TERRACE NO 01-125  ",
                "440057"
            ],
            [
                "AM ARPOTHAM ENTERPRISE PTE LTD",
                "BLK 58 MARINE TERRANCE UNIT 01-47  ",
                "440058"
            ],
            [
                "7-11 STORE 371 MARINE PARADE BLK 83",
                "BLK 83 MARINE PARADE CENTRAL NO 01-582  ",
                "440083"
            ],
            [
                "EEZEE VENDING PTE LTD - SUTD",
                "5 SIGLAP ROAD #06-36  ",
                "448908"
            ],
            [
                "CHEERS NEPTUNE COURT(CNCT)(865)",
                "10 Marine Vista 01-33 Neptune Court  ",
                "449034"
            ],
            [
                "ONG SENG SAN - VICTORIA JC",
                "20 MARINE VISTA   ",
                "449035"
            ],
            [
                "7-11 STORE 250 NEPTUNE COURT",
                "NO. 10 MARINE VISTA #01-33 NEPTUNE COURT  ",
                "449036"
            ],
            [
                "JP FOOD SERVICES -KKONGDON PARKWAY PDE",
                "80 MARINA PARADE ROAD #02-31 PARKWAY PARADE  ",
                "449269"
            ],
            [
                "MONICA`S (SHRIAUMONKARA)",
                "BLK 500F MARINE PARADE ROAD #01-26 LAGUNA PARK  ",
                "449288"
            ],
            [
                "VILLAGE HOTEL KATONG",
                "25 MARINE PARADE #03-13 BOH OFFICE  ",
                "449536"
            ],
            [
                "PONDOK GURAME",
                "902 EAST COAST PARKWAY BLK E #01-26 BIG SPLASH  ",
                "449874"
            ],
            [
                "7-11 STORE 463 BIG SPLASH BLK B",
                "BLK B THE BIG SPLASH 01 06 EAST COAST PARKWAY  ",
                "449874"
            ],
            [
                "CHEERS PARKLAND GREEN (CPLGN)(849)",
                "1 Parkland Green, 920 East Coast Parkway #01-01  ",
                "449875"
            ],
            [
                "QUICK PICK",
                "1018 EAST COAST PARKWAY UNIT 01-03  ",
                "449877"
            ],
            [
                "WAT-A-DEAL PTE LTD",
                "1110 EAST COAST PARKWAY EAST COAST RESORT  ",
                "449880"
            ],
            [
                "RED HOUSE SEAFOOD RESTAURANT",
                "BLK 1204 EAST COAST PARKWAY UNIT 01-05 UDMC SEAFOOD CENTRE  ",
                "449882"
            ],
            [
                "MANA MANA SINGAPORE PTE LTD",
                "1212 EAST COAST PARKWAY   ",
                "449888"
            ],
            [
                "7-11 STORE 228 UPP EAST COAST",
                "13 UPPER EAST COAST ROAD .  ",
                "455206"
            ],
            [
                "7-11 STORE 602 SHELL SIGLAP",
                "40 UPPER EAST COAST ROAD .  ",
                "455212"
            ],
            [
                "SPC - UPPER EAST COAST",
                "157 UPPER EAST COAST RD UNIT 01-01  ",
                "455253"
            ],
            [
                "I-ECON - JONG HENG TONG KEE",
                "166 UPPER EAST COAST RD UNIT 01-01  ",
                "455270"
            ],
            [
                "CALTEX - FRANKEL AVE",
                "71 FRANKEL AVENUE UNIT 01-01  ",
                "458200"
            ],
            [
                "LIAN BENG HUAT MINIMART",
                "5 FIGARO STREET   ",
                "458329"
            ],
            [
                "VSN PTE LTD",
                "28 FERNWOOD TERRACE #01-01B FERNWOOD TOWERS  ",
                "458556"
            ],
            [
                "CHEERS BY FP E.COAST FRANKEL (EFRK)",
                "590 EAST COAST RD .  ",
                "458995"
            ],
            [
                "7-11 STORE 9.23.0 E.COAST FRANKEL",
                "705 EAST COAST RD .  ",
                "459062"
            ],
            [
                "PIZZA HUT - SIGLAP",
                "889/891 EAST COAST ROAD   ",
                "459092"
            ],
            [
                "COFFEE CLUB - SIGLAP",
                "907 EAST COAST RD #01-01 SPRINGVALE  ",
                "459107"
            ],
            [
                "7-11 STORE 102 BEDOK BLK 18",
                "BLK 18 BEDOK SOUTH RD .  ",
                "460018"
            ],
            [
                "CODE CHANGE PRIME SMKT - BEDOK SOUTH",
                "BLK 18 BEDOK SOUTH RD UNIT 01-87  ",
                "460018"
            ],
            [
                "HAN KIM CHOO - TEMASEK JC",
                "22 BEDOK SOUTH AVE 1   ",
                "460022"
            ],
            [
                "USHA S MARKETING PTE LTD",
                "BLK 54 CHAI CHEE ST  #01-881  ",
                "460054"
            ],
            [
                "7-11 STORE 165 CHAI CHEE",
                "BLK 55 CHAI CHEE DRIVE NO 01-192  ",
                "460055"
            ],
            [
                "TAJNISA STORE",
                "BLK 59 CHAI CHEE ROAD UNIT 01-K1  ",
                "460059"
            ],
            [
                "SHINNING STAR MART",
                "BLK 62 CHAI CHEE RD  #K-1  ",
                "460062"
            ],
            [
                "V.A.HADI",
                "BLK 82 #01-320 BEDOK NORTH ROAD  ",
                "460082"
            ],
            [
                "YEE HONG SENG SUPERMARKET",
                "BLK 88 BEDOK NORTH ST 4 #01-147  ",
                "460088"
            ],
            [
                "7-11 STORE 143 BEDOK BLK 89",
                "BLK 89 BEDOK NORTH ST 4 NO 01-83  ",
                "460089"
            ],
            [
                "7-11 STORE 235 BEDOK BLK 123",
                "BLK 123 BEDOK NORTH ST 2 NO 01-158  ",
                "460123"
            ],
            [
                "7-11 STORE 162 BEDOK BLK 168",
                "BLK 168 BEDOK SOUTH AVE 3 NO 01-1477  ",
                "460168"
            ],
            [
                "PIZZA HUT - BEDOK 215",
                "BLK 215 BEDOK NORTH ST 1 UNIT 01-83  ",
                "460215"
            ],
            [
                "COLLIN`S GRILLED BENTO - BEDOK",
                "217 BEDOK NORTH #01-77  ",
                "460217"
            ],
            [
                "HENG ENG BOON MINIMART",
                "BLK 419 YISHUN AVE 11 UNIT 01-379  ",
                "460419"
            ],
            [
                "K M OTHUMAN & SON",
                "BLK 423 BEDOK NORTH AVE 1 #01-228  ",
                "460423"
            ],
            [
                "AZEEM MARKETING",
                "BLK 505 #01-315  BEDOK NORTH AVE 3  ",
                "460505"
            ],
            [
                "MELON SUPERMARKET PTE LTD",
                "BLK 510 BEDOK NORTH ST 3   ",
                "460510"
            ],
            [
                "SPK STORES PTE LTD",
                "BLK 510 BEDOK NORTH ST 3 UNIT 01-75  ",
                "460510"
            ],
            [
                "7-11 STORE 189 BEDOK BLK 510",
                "BLK 510 BEDOK NORTH ST 3 NO 01-43  ",
                "460510"
            ],
            [
                "LC MART",
                "BLK 515 BEDOK NORTH AVE 2 UNIT 01-189  ",
                "460515"
            ],
            [
                "I-ECON - LC MART",
                "BLK 515 BEDOK NORTH AVE 2 UNIT 01-189  ",
                "460515"
            ],
            [
                "SHAIK ABDUL KADER",
                "BLK 527 BEDOK NORTH ST 3 UNIT 01-500  ",
                "460527"
            ],
            [
                "ZAITUN TRADING PTE LTD - BEDOK NTH",
                "BLK 537 ST 3 BEDOK NORTH #01-547 ",
                "460527"
            ],
            [
                "COLLIN`S GRILLED BENTO - BEDOK NTH ST 3",
                "531 BEDOK NORTH ST 3 #01-680   ",
                "460531"
            ],
            [
                "7-11 STORE 746 BEDOK BLK 31",
                "BLK 531 BEDOK NORTH STREET 3 UNIT 01-706  ",
                "460531"
            ],
            [
                "SIMPANG LIMA",
                "BLK 537 BEDOK NORTH ST 3 UNIT 01-555  ",
                "460537"
            ],
            [
                "CHEERS BEDOK BLK 539 (CHBN)(378)",
                "BLK 539 BEDOK NORTH ST 3 01 625  ",
                "460539"
            ],
            [
                "KONG HOCK TV ELECTRIC CO.",
                "BLK 539 BEDOK NORTH ST 3 UNIT 01-623  ",
                "460539"
            ],
            [
                "RAHMANIYA GROCERY",
                "BLK 543 BEDOK NORTH ST 3 UNIT 01-1318  ",
                "460543"
            ],
            [
                "7-11 STORE 578 CHAI CHEE BLK 11",
                "CHAI CHEE ROAD BLK 11 #01-23  ",
                "461011"
            ],
            [
                "7-11 STORE 395 CHAI CHEE",
                "BLK 27A CHAI CHEE ROAD NO 01-377  ",
                "461027"
            ],
            [
                "HAJIA PROVISION STORE",
                "BLK 36 CHAI CHEE AVENUE UNIT 01-161  ",
                "461036"
            ],
            [
                "RANGER SUPERMART",
                "BLK 42 CHAI CHEE STREET UNIT 01-62  ",
                "461042"
            ],
            [
                "CHEERS N.UPP.CHANGI BLK 59 (CHUC)(3",
                "BLK 59 NEW UPPER CHANGI RD NO 01 1272  ",
                "461059"
            ],
            [
                "7-11 STORE 227 NEW UPP.CHANGI BLK 2",
                "BLK 25 NEW UPPER CHANGI ROAD NO 01-626  ",
                "462025"
            ],
            [
                "JOOHZ PTE LTD",
                "BLK 208B NW UPPER CHANGI RD #01-01  ",
                "462208"
            ],
            [
                "FOODFARE CATERING - BEDOK CAMP",
                "768 UPPER EAST COAST RD 3 GUARDS AFPN 1014 GUARDS AVE  ",
                "465556"
            ],
            [
                "TAMMY KITCHEN",
                "329 TANAH MERAH KECHIL AVE   ",
                "465792"
            ],
            [
                "POORNEMA TRADING",
                "KEW GREEN MINIMART 155 KEW CRESCENT  ",
                "466147"
            ],
            [
                "CHEERS BY FP UPP.EAST COAST (EUEC)(",
                "251 UPP EAST COAST RD .  ",
                "466404"
            ],
            [
                "FOODFARE CATERING - 1 GUARDS AFPN",
                "762 UPPER EAST COAST ROAD BLK 17  ",
                "466634"
            ],
            [
                "7-11 STORE 9.91.0 BEDOK MRT STN",
                "315 UPPER CHANGI ROAD BEDOK MRT STATION UNIT 01 01  ",
                "467347"
            ],
            [
                "CHIR CHIR FUSION FACTORY - BEDOK POINT",
                "799 UPPER CHANGI ROAD BEDOK POINT #02-05/06  ",
                "467351"
            ],
            [
                "7-11 STORE 582 TANAH MERAH MRT",
                "920 NEW UPPER CHANGI ROAD UNIT 01-01 TANAH MERAH MRT STATION  ",
                "467356"
            ],
            [
                "CHEERS BEDOK MALL (CBDML)(840)",
                "311 NEW UPPER CHANGI ROAD, BEDOK MALL UNIT 01-09  ",
                "467360"
            ],
            [
                "PIZZA HUT - BEDOK MALL",
                "311 NEW UPPER CHANGI ROAD UNIT B2-05/34 BEDOK MALL  ",
                "467360"
            ],
            [
                "SUNBAY PTE LTD",
                "1300 EAST COAST PARK (CARPARK F2)  ",
                "468964"
            ],
            [
                "LIFESTYLE F&B - EAST COAST G1",
                "1490 EAST COAST PARKWAY EAST COAST PARK AREA G1  ",
                "468965"
            ],
            [
                "BAMBOO RICE BOWL",
                "NO. 1 BEDOK SOUTH ROAD   ",
                "469267"
            ],
            [
                "FAIRPRICE XPRESS BEDOK SOUTH (EBDS)",
                "799 BEDOK SOUTH AVE 1 .  ",
                "469335"
            ],
            [
                "7-11 STORE 623 SHELL SIMPANG BEDOK",
                "331 BEDOK ROAD .  ",
                "469504"
            ],
            [
                "CHEAP MINIMART",
                "343 BEDOK ROAD   ",
                "469526"
            ],
            [
                "7-11 STORE 9.02.0 BEDOK S.CMPLX",
                "346 BEDOK RD BEDOK SHOPPING CMPLX  ",
                "469532"
            ],
            [
                "CHEERS BY FP BEDOK NORTH (EBDN)(626",
                "99 BEDOK NORTH ROAD   ",
                "469667"
            ],
            [
                "SPC - BEDOK",
                "101 BEDOK NORTH ROAD UNIT 01-01  ",
                "469678"
            ],
            [
                "SMILES MART PTE LTD - BEDOK",
                "BLK 117 BEDOK RESERVOIR RD UNIT 01-70  ",
                "470117"
            ],
            [
                "DOJIN INTERNATIONAL TRADING ENTERPRISE",
                "BLK 121 BEDOK RESERVOIR ROAD UNIT 01-198  ",
                "470121"
            ],
            [
                "BLUESKY MINIMART PTE LTD",
                "BLK 631 #01-904 BEDOK RESERVOIR ROAD  ",
                "470631"
            ],
            [
                "7-11 STORE 9.46.0 BEDOK RESV",
                "BLK 631 BEDOK RESERVOIR RD BEDOK RESERVOIR RD  ",
                "470631"
            ],
            [
                "TOP PLUS SUPERMARKET",
                "BLK 632 BEDOK RESERVOIR RD UNIT 01-834/836  ",
                "470632"
            ],
            [
                "TOP PLUS SUPERMARKET",
                "BLK 632 BEDOK RESERVOIR RD UNIT 01-834/836  ",
                "470632"
            ],
            [
                "I-ECON - SAVE MINIMART",
                "BLK 760 BEDOK RESERVOIR RD #01-339  ",
                "470670"
            ],
            [
                "TONG SHENG SUPERMART",
                "BLK 718 BEDOK RESERVOIR RD #01-4596  ",
                "470718"
            ],
            [
                "I-ECON - TONG SHENG SUPERMART",
                "BLK 718 BEDOK RESERVOIR RD UNIT 01-4596  ",
                "470718"
            ],
            [
                "7-11 STORE 137 BEDOK BLK 137",
                "BLK 744 BEDOK RESERVOIR RD NO 01-3061  ",
                "470744"
            ],
            [
                "UGOLD ENTERPRISE",
                "1 BEDOK RESERVOIR RD VIEW UNIT 01-04 AQUARIUS CONDOMINIUM ",
                "478926"
            ],
            [
                "HUI MIN MINIMART",
                "1 BEDOK RESERVOIR VIEW #01-04 AQUARIUS BY THE PARK  ",
                "478926"
            ],
            [
                "CHEERS UE BIZ HUB EAST (CUEBH)(816)",
                "2 CHANGI BIZ PARK AVE 1 UNIT 01 04  ",
                "486015"
            ],
            [
                "7-11 STORE 546 CHANGI",
                "NO. 1 CHANGI BUSINESS PARK CRESCENT UNIT 01- 20  ",
                "486025"
            ],
            [
                "MR TEH TARIK PTE LTD - CHANGI",
                "NO 1 CHANGI BUSINESS PARK CRESCENT UNIT 01-21  ",
                "486025"
            ],
            [
                "SODEXO - STANDARD CHARTERED BANK",
                "CHANGI BUSINESS PARK 7 CHANGI BUSINESS PARK CRESCENT  ",
                "486028"
            ],
            [
                "LAVAEDGE RESTAURANT AND BAR",
                "5 CHANGI BUSINESS PARK CENTRAL 1 CHANGI CITY POINT #01-72/73  ",
                "486038"
            ],
            [
                "EGGS & BERRIES - CHANGI CITY POINT",
                "5 CHANGI BIZ PARK CENTRAL 1 UNIT 01-37/38 CHANGI CITY POINT ",
                "486038"
            ],
            [
                "THE CORNER CONVENIENCE STORE",
                "726 UPPER CHANGI ROAD EAST   ",
                "486046"
            ],
            [
                "7-11 STORE 79 SIA SPORTS CLUB",
                "726 UPPER CHANGI RD EAST SIA SPORTS CLUB UNIT 01 02  ",
                "486046"
            ],
            [
                "ITEA",
                "10 SIMEI AVE   ",
                "486047"
            ],
            [
                "CREAMY DUCK - EAST ITE COLLEGE",
                "10 SIMEI AVE BUSINESS BLOCK UNIT 02-33 CANTEEN ITE COLLEGE EAST ",
                "486047"
            ],
            [
                "ELLIPSE - ITEA AT ITE COLLEGE EAST",
                "10 SIMEI AVE UNIT -1-12 ITE COLLEGE EAST BUSINESS BLK  ",
                "486047"
            ],
            [
                "BELLYGOOD CATERER",
                "1 EXPO DRIVE HALL 2 OPPOSITE ITE SCHOOL MAX ATRIA KITCHEN 2ND LEVEL ",
                "486150"
            ],
            [
                "7-11 STORE 366 EXPO FOYER 2 HALL 6",
                "EXPO DRIVE UNIT 01-62 (HALL 6) SINGAPORE EXPO  ",
                "486150"
            ],
            [
                "MUM`S KITCHEN CATERING PTE LTD",
                "BLK 3015 #02-06 BEDOK NORTH ST 5  ",
                "486350"
            ],
            [
                "...",
                ".   ",
                "486442"
            ],
            [
                "SAN BISTRO PTE LTD",
                "20 EASTWOOD RD #01-03 EASTWOOD CENTRE  ",
                "486442"
            ],
            [
                "BOOKLINK PTE LTD - SOMAPAH",
                "8 SOMAPAH ROAD #01-201 BUILDING 2  ",
                "487372"
            ],
            [
                "YONG SHENG FOOD CATERING",
                "MESS, BLK 112 TANAH MERAH COAST RD RSN CENTRAL  ",
                "498794"
            ],
            [
                "OCEANSPOON - CHANGI SAF YACHT CLUB",
                "OCEANSPOON DINING 110 TANAH MERAH COAST RD CHANGI CLUBHOUSE ",
                "498800"
            ],
            [
                "LIFESTYLE RECREATION PTE LTD - NICOLL DR",
                "CHANGI BEACH PARK (C1) 260 NICOLL DRIVE  ",
                "498823"
            ],
            [
                "LIFESTYLE F&B - NICOLL DRIVE",
                "260 NICOLL DRIVE   ",
                "498823"
            ],
            [
                "NEO PHOO SOON",
                "11 CHANGI NORTH STREET 1   ",
                "498823"
            ],
            [
                "7-11 STORE 724 T.MERAH FERRY",
                "50 TANAH MERAH FERRY ROAD UNIT 01 19 TANAH MERAH FERRY TERMINAL  ",
                "498833"
            ],
            [
                "BINTAN RESORT FERRIES PTE LTD",
                "50 TANAH MERAH FERRY RD   ",
                "498833"
            ],
            [
                "PALMS FOODS INTL - KILLINERY KOPITIAM",
                "50 TANAH MERAH FERRY RD   ",
                "498833"
            ],
            [
                "COMPASS GREEN STORE",
                "100 TANAH MERAH BERSAR RD UNIT 02-06  ",
                "498839"
            ],
            [
                "GRAND OCEAN RESTAURANT PTE LTD",
                "SAF YACHT CLUB 110 TAMAH MERAH COAST ROAD  ",
                "498880"
            ],
            [
                "BISTRO 11 PTE LTD",
                "Bistro @ Changi 260 Nicoll Drive Changi Beach Carpark 1 ",
                "498991"
            ],
            [
                "SATURDAY HOUSE PTE LTD",
                "339 Upper Paya Lebar Rd   ",
                "498991"
            ],
            [
                "LIFESTYLE F&B - CHANGI BEACH PARK (C1)",
                "CHANGI BEACH CARPARK C1 NO. 260 NICOLL DRIVE  ",
                "498991"
            ],
            [
                "LIFESTYLE RECREATION PTE LTD - C FERRY",
                "CHANGI BEACH PARK (C7) NO. 3 CHANGI FERRY ROAD  ",
                "499676"
            ],
            [
                "LIFESTYLE F&B - CHANGI FERRY",
                "NO. 3 CHANGI FERRY ROAD   ",
                "499676"
            ],
            [
                "TANAH MERAH COUNTRY CLUB",
                "25 CHANGI COAST RD   ",
                "499803"
            ],
            [
                "7-11 STORE 9.26.0 CHANGI VILLAGE",
                "BLK 1 CHANGI VILLAGE RD CHANGI VILLAGE RD  ",
                "500001"
            ],
            [
                "CHEERS CHANGI VILLAGE (FRCV)(936)",
                "BLK 4 CHANGI VILLAGE NO 01-2074  ",
                "500004"
            ],
            [
                "7-11 STORE 607 SHELL PASIR RIS",
                "1 NEW LOYANG LINK .  ",
                "506931"
            ],
            [
                "YOUR CHOICE MINI MART",
                "NO. 1 FLORA DRIVE DAHLIA PARK CONDOMINIUM  ",
                "507009"
            ],
            [
                "FOODFARE CATERING - SELERANG CAMP",
                "HQ9 DIVISION AFPN 1069 UPPER CHANGI NORTH RD  ",
                "507087"
            ],
            [
                "CHEERS BISHAN BLK 282 (FRBS)(903)",
                "BLK 282 BISHAN ST 22 01 101  ",
                "507282"
            ],
            [
                "FAIRPRICE XPRESS U.CHANGI.NTH(EUCN)",
                "955 UPPER CHANGI RD NORTH .  ",
                "507662"
            ],
            [
                "LOW YAK HONG",
                "49 PULAU UBIN   ",
                "508296"
            ],
            [
                "FOODFARE CATERING - TEKONG AFPN 1272",
                "51 PULAU TEKONG BESAR AFPN 1272  ",
                "508451"
            ],
            [
                "FOO CHEE SENG",
                "25 LOYANG CRESENT BOX 506B LOYANG OFFSHORE SUPPLY BASE ",
                "508988"
            ],
            [
                "LV MART",
                "BLK 216 LOYANG AVENUE LOYANG VALLEY  ",
                "509070"
            ],
            [
                "E-MINI MART",
                "BLK 121 PASIR RIS ST 11 UNIT 01-K1  ",
                "510121"
            ],
            [
                "ONE STOP MINIMART",
                "BLK 136 PASIR RIS ST 11 UNIT 01-233  ",
                "510136"
            ],
            [
                "7-11 STORE 521 PASIR RIS BLK 185",
                "BLK 185 PASIR RIS STREET 11 No 01-60  ",
                "510185"
            ],
            [
                "XIN SHENG MINIMART ",
                "BLK 212 PASIR RIS ST 21 #01-226  ",
                "510212"
            ],
            [
                "I-ECON - XIN SHENG MINIMART",
                "BLK 212 PASIR RIS ST 21 UNIT 01-226  ",
                "510212"
            ],
            [
                "M.R PASIR RIS MINIMART",
                "BLK 230 PASIR RIS ST 21 UNIT 01-44  ",
                "510230"
            ],
            [
                "7-11 STORE 762 PASIR RIS BLK 245",
                "BLK 245 PASIR RIS STREET 21 UNIT 01-83  ",
                "510245"
            ],
            [
                "7-11 STORE 246 PASIR RIS ST 21",
                "BLK 259 PASIR RIS ST21 01-01 LOYANG POINT  ",
                "510259"
            ],
            [
                "GOH MINIMART",
                "407 PASIR RIS DR 6 #01-K1  ",
                "510407"
            ],
            [
                "I-ECON - GOH MINIMART",
                "BLK 407 PASIR RIS DRIVE 6 UNIT 01-K1  ",
                "510407"
            ],
            [
                "7-11 STORE 9.77.0 PASIR RIS BLK 446",
                "BLK 446 PASIR RIS ST 41 NO 01 112  ",
                "510466"
            ],
            [
                "J-KEARTS CONTRACTS & SERVICE(PASIR RIS)",
                "BLK 470 PASIR RIS DRIVE 6 #01-K1  ",
                "510470"
            ],
            [
                "7-11 STORE 547 P RIS DR6",
                "BLK 470 PASIR RIS DRIVE 6 UNIT 01-14  ",
                "510470"
            ],
            [
                "YI CHENG DEPT STORE",
                "BLK 477 PASIR RIS DRIVE 6 UNIT B1-520  ",
                "510477"
            ],
            [
                "ANG CHONG MINIMART",
                "BLK 506 PASIR RIS ST 52 UNIT 01-189  ",
                "510506"
            ],
            [
                "BABA JAN TRADING",
                "506 PASIR RIS ST 52   ",
                "510506"
            ],
            [
                "7-11 STORE 139 ELIAS RD",
                "BLK 625 ELIAS RD 01 308 ELIAS MALL  ",
                "510621"
            ],
            [
                "7-11 STORE 115 PASIR RIS BLK 735",
                "BLK 735 PASIR RIS STREET 72 #01-49/51  ",
                "510735"
            ],
            [
                "JUZ BREAD - PASIR RIS",
                "BLK 735 PASIR RIS ST 2 #01-308  ",
                "510735"
            ],
            [
                "773 PASIR RIS MINIMART",
                "773 PASIR RIS MINIMART BLK 773 PASIR RIS ST 71 UNIT 01-380 ",
                "510773"
            ],
            [
                "7-11 STORE 536 PASIR RIS BLK 776",
                "BLK 776 PASIR RIS ST 71 UNIT 01- 412  ",
                "510776"
            ],
            [
                "RAW MARKET - PASIR RIS",
                "SEASTRAND CONDO 11 PASIR RIS LINK #01-48  ",
                "518180"
            ],
            [
                "COASTLINE F&B - PASIR RIS",
                "51 Pasir Ris Green   ",
                "518226"
            ],
            [
                "RENT-A-BIKE KIOSK",
                "51 PASIR RIS GREEN CARPARK C PASIR RIS PARK  ",
                "518226"
            ],
            [
                "APEX HARMONY LODGE",
                "10 PASIR RIS WALK DRIVE 10   ",
                "518240"
            ],
            [
                "ANG MO SMKT - PUNGGOL FIELD - BLK196A",
                "BLK 196A PUNGGOL FIELD UNIT 01-519  ",
                "518240"
            ],
            [
                "7-11 STORE 9.19.0 PASIR RIS CENTRAL",
                "1 PASIR RIS CENTRAL STREET 3 UNIT 01-12B  ",
                "518457"
            ],
            [
                "CYCLING CONNECTIONS PTE LTD",
                "201 PASIR RIS RD #01-01  ",
                "519147"
            ],
            [
                "A&L FOOD & BEVERAGE MANAGEMENT",
                "BLK 133 PASIR RIS ROAD UNIT 01-01  ",
                "519149"
            ],
            [
                "COASTLINE F&B PTE LTD",
                "EAST COAST PARK AREA E BICYCLE STATION  ",
                "519200"
            ],
            [
                "WIN MEAL FOOD SERVICES",
                "81 PASIR RIS HEIGHTS   ",
                "519292"
            ],
            [
                "PET MOVERS SPORE PTE LTD",
                "4 PASIR RIS FARMWAY 2   ",
                "519318"
            ],
            [
                "MAINLAND TROPICAL FISH FARM",
                "1 PASIR RIS FARMWAY 1   ",
                "519352"
            ],
            [
                "SPC - PASIR RIS",
                "11 PASIR RIS DRIVE 4 UNIT 01-01  ",
                "519456"
            ],
            [
                "LIFESTYLE RECREATION PTE LTD - PASIR RIS",
                "PARIS RIS PARK NO 45 PASIR RIS DRIVE 3  ",
                "519500"
            ],
            [
                "LIFESTYLE F&B - PASIR RIS DR 3",
                "45 PASIR RIS DRIVE 3   ",
                "519500"
            ],
            [
                "FAIRPRICE XPRESS PASIR RIS (EPRS)(6",
                "61 PASIR RIS DRIVE 1 .  ",
                "519525"
            ],
            [
                "7-11 STORE 549 DOWNTOWN EAST",
                "1 Pasir Ris Close Unit 01-05 Downtown East  ",
                "519599"
            ],
            [
                "CHEERS DOWNTOWN EAST (CDTER)(860)",
                "1 PASIR RIS CLOSE .  ",
                "519599"
            ],
            [
                "CATHAY - PASIR RIS",
                "NO. 1 PASIR RIS CLOSE UNIT 04-106 E!HUB DOWNTOWN EAST ",
                "519599"
            ],
            [
                "7-11 STORE 396 PASIR RIS MRT L1-09",
                "10 PASIR RIS CENTRAL 01-09 PASIR RIS MRT STATION  ",
                "519634"
            ],
            [
                "D`BEST RECREATION PTE LTD",
                "90 PASIR RIS CENTRAL   ",
                "519635"
            ],
            [
                "7-11 STORE 716 SIMEI BLK 156",
                "BLK 156 SIMEI ROAD UNIT 01-330  ",
                "520156"
            ],
            [
                "I-ECON GO2MART TAMPINES 164",
                "BLK 164 TAMPINES ST 12   ",
                "520164"
            ],
            [
                "GO2MART TAMPINES 164",
                "BLK 164 TAMPINES ST 12   ",
                "520164"
            ],
            [
                "7-11 STORE 497 SIMEI BLK 225",
                "BLK 225 SIMEI ST 4 01 68  ",
                "520225"
            ],
            [
                "ONE FAMILY SIMEI",
                "BLK 248 SIMEI ST 3 #01-100  ",
                "520248"
            ],
            [
                "DV GROUPS PTE LTD",
                "BLK 251 TAMPINES ST 21 UNIT 01-K1  ",
                "520251"
            ],
            [
                "7-11 STORE 406 TAMPINES BLK 282",
                "BLK 282 TAMPINES ST 22 NO 01-302  ",
                "520282"
            ],
            [
                "VINEYARD INTEGRATION",
                "289 TAMPINES ST 22 #01-K1  ",
                "520289"
            ],
            [
                "ASHABI STORE",
                "BLK 298 TAMPINES ST 22 UNIT 01-K1  ",
                "520298"
            ],
            [
                "YEN`S MART",
                "BLK 340 TAMPINES ST 33   ",
                "520340"
            ],
            [
                "I-ECON GO2MART TAMPINES 406",
                "BLK 406 TAMPINES ST 41 UNIT 01-11  ",
                "520406"
            ],
            [
                "GO2MART TAMPINES 406",
                "BLK 406 TAMPINES ST 41   ",
                "520406"
            ],
            [
                "WELLMART - TAMPINES",
                "BLK 406 TAMPINES ST 41 UNIT 01-11  ",
                "520406"
            ],
            [
                "NEW ENG SENG FRUIT & PROVISION",
                "BLK 419 TAMPINES ST 41 UNIT 01-92  ",
                "520419"
            ],
            [
                "7-11 STORE 325 TAMPINES BLK 419",
                "BLK 419 TAMPINES ST 41 NO 01-86  ",
                "520419"
            ],
            [
                "M&L MINIMART (PMS)",
                "BLK 433 TAMPINES ST 43 UNIT 01-75  ",
                "520433"
            ],
            [
                "7-11 STORE 531 TAMPINES BLK 440",
                "BLK 440 TAMPINES STREET 43 No. 01-K1  ",
                "520440"
            ],
            [
                "7-11 STORE 491 TAMPINES BLK 445",
                "BLK 445 TAMPINES STREET 42 01 10 SHOP B  ",
                "520445"
            ],
            [
                "HAJEE KIOSK",
                "BLK 451 TAMPINES ST 42 UNIT 01-K1  ",
                "520451"
            ],
            [
                "7-11 STORE 391 TAMPINES BLK 462",
                "BLK 462 TAMPINES ST 44 NO 01-72  ",
                "520462"
            ],
            [
                "COLLIN`S GRILLED BENTO - TAMPINES",
                "476 TAMPINES ST 44 #01-207/9  ",
                "520476"
            ],
            [
                "MR TEH TARIK PTE LTD - TAMPINES 503",
                "BLK 503 TAMPINES CENTRAL 1 UNIT 01-293  ",
                "520503"
            ],
            [
                "7-11 STORE 9.63.0 TAMPINES BLK 802",
                "BLK 802 TAMPINES AVE 4 NO 01 09  ",
                "520802"
            ],
            [
                "7-11 STORE 753 TAMPIMES BLK 820",
                "BLK 820 TAMPINES STREET 81 UNIT 01-528  ",
                "520820"
            ],
            [
                "7-11 STORE 149 TAMPINES",
                "BLK 827 TAMPINES ST 81 NO 01-150  ",
                "520827"
            ],
            [
                "CHUAN LEE MINIMART",
                "BLK 835 TAMPINES ST 83 UNIT 01-02  ",
                "520835"
            ],
            [
                "7-11 STORE 199 TAMPINES BLK 844",
                "BLK 844 TAMPINES ST 82 NO 01-137  ",
                "520844"
            ],
            [
                "ZAFRAH MINI MART",
                "BLK 861 TAMPINES AVE 5 UNIT 01-581  ",
                "520861"
            ],
            [
                "SHIVANI MINIMART",
                "BLK 865 TAMPINES ST 83 #01-K1  ",
                "520865"
            ],
            [
                "OM SAI MINIMART",
                "BLK 878 TAMPINES AVE 8 01 318   ",
                "520878"
            ],
            [
                "I-ECON - OM SAI MINIMART",
                "BLK 878 TAMPINES AVE 8 UNIT 01-318  ",
                "520878"
            ],
            [
                "7-11 STORE 557 TAMPINES BLK 891",
                "Blk 891Tampines Ave 8 Unit 01-82  ",
                "520891"
            ],
            [
                "I-ECON - ACTUA TRADING & SUPPLIES",
                "BLK 915 TAMPINES ST 91 UNIT 01-43  ",
                "520915"
            ],
            [
                "A H MINIMART",
                "BLK 933 TAMPINES ST 91 UNIT 01-K1  ",
                "520933"
            ],
            [
                "7-11 STORE 9.61.0 TAMPINES BLK 139",
                "BLK 139 TAMPINES ST 11 NO 01 2014  ",
                "521139"
            ],
            [
                "CHEERS TAMPINES BLK 142 (CTAM142)(8",
                "BLK 142 TAMPINES ST 12 UNIT 01 - K1  ",
                "521142"
            ],
            [
                "7-11 STORE 410 TAMPINES BLK 164",
                "BLK 164 TAMPINES ST 12 NO 01-297  ",
                "521164"
            ],
            [
                "AL BISIMI MINIMART",
                "BLK 247 TAMPINES ST 21 UNIT 01-K1  ",
                "521247"
            ],
            [
                "CHEERS TAMPINES CC (CTMC)(544)",
                "BLK 866A TAMPINES ST 83 01 01 TAMPINES CENTRAL  ",
                "521886"
            ],
            [
                "YES SUPERMARKET - TAMPINES ST 21",
                "BLK 201B TAMPINES ST 21 UNIT 02-1095  ",
                "522201"
            ],
            [
                "7-11 STORE 181 TAMPINES BLK 201B",
                "BLK 201B TAMPINES ST 21 NO 01-1063  ",
                "522201"
            ],
            [
                "..",
                ". .  ",
                "522523"
            ],
            [
                "7-11 STORE 566 TAMPINES BLK 491D",
                "BLK 491D TAMPINES STREET 45 UNIT 01-224  ",
                "523491"
            ],
            [
                "MR TEH TARIK PTE LTD - TAMPINES 201D",
                "BLK 201D TAMPINES ST 21 UNIT 01-1155  ",
                "524201"
            ],
            [
                "SIRAJUDEEN STORE",
                "BLK 230 TAMPINES ST 24 UNIT 01-K1  ",
                "524230"
            ],
            [
                "7-11 STORE 151 TAMPINES BLK 201E",
                "BLK 201E TAMPINES ST 23 NO 01-100  ",
                "527201"
            ],
            [
                "SODEXO - UNITED WORLD COLLEGE TAMPINES",
                "1 TAMPINES STREET 73   ",
                "528704"
            ],
            [
                "7-11 STORE 436 TAMPINES GIANT WRS",
                "21 TAMPINES NORTH AVE 2 01 02 WRS  ",
                "528765"
            ],
            [
                "42562",
                "7-ELEVEN DISTRIBUTION CENTRE 21,TAMPINES NORTH DRIVE 2  ",
                "528765"
            ],
            [
                "I-ECON BEGONIA PTE LTD- TAMPINES",
                "NO 2 TAMPINES PLACE #01-65  ",
                "528821"
            ],
            [
                "COMPASS GROUP - GSP FAB 3E",
                "1 TAMPINES INDUSTRIAL AVE 5 CHARTERED BUILDING  ",
                "528830"
            ],
            [
                "CHEERS EAST POINT MALL (CEPML)(855)",
                "3 Simei Street, 6 East Point Mall #01-10 &11  ",
                "528833"
            ],
            [
                "INSTAMART PTE LTD",
                "842H TAMPINES ST 82 #01-70  ",
                "528842"
            ],
            [
                "I-ECON - TAI YEE TRADING",
                "BLK 843 TAMPINES ST 82 UNIT 01-70  ",
                "528842"
            ],
            [
                "7-11 STORE 106 TAMPINES BLK 5",
                "BLK 5 TAMPINES ST 32 NO 01-19/20  ",
                "529284"
            ],
            [
                "TAMPINES PRIMARY SCHOOL (STALL 7)",
                "250 TAMPINES ST 12   ",
                "529426"
            ],
            [
                "7-11 STORE 275 TELEPARK TAMPINES",
                "5 TAMPINES CENTRAL 01- 20/21 TELEPARK  ",
                "529482"
            ],
            [
                "PIZZA HUT - TAMPINES MALL",
                "NO. 4 TAMPINES CENTRAL 4 UNIT 02-02 TAMPINES MALL  ",
                "529510"
            ],
            [
                "NANDO`S - TAMPINES MALL",
                "4 TAMPINES CENTRAL 5 UNIT 01-46 TAMPINES MALL  ",
                "529510"
            ],
            [
                "EACH A CUP - TAMPINES 1",
                "10 TAMPINES CENTRAL  UNIT B1-K8 TAMPINES 1 SHOPPING MALL ",
                "529536"
            ],
            [
                "7-11 STORE 464 TAMPINES MRT",
                "20 TAMPINES CENTRAL 1 UNIT 01 02 TAMPINES MRT STATION  ",
                "529538"
            ],
            [
                "UNITED OVERSEAS BANK LIMITED-TAMPINES",
                "1 TAMPINES CENTRAL 1  #02-01 UOB TAMPINES  ",
                "529539"
            ],
            [
                "CHEERS BY FP TAMPINES AVE 9 (ETM9)(",
                "40 TAMPINES AVE 9 .  ",
                "529568"
            ],
            [
                "CHEERS BY FP TAMPINES AVE 7 (ETAM7)",
                "9 TAMPINES AVE 7 .  ",
                "529619"
            ],
            [
                "LIFESTYLE RECREATION PTE LTD - SUN PLAZA",
                "SUN PLAZA PARK 30 TAMPINES AVENUE  ",
                "529621"
            ],
            [
                "LIFESTYLE F&B - SUN PLAZA PARK",
                "30 TAMPINES AVENUE SUN PLAZA PARK  ",
                "529621"
            ],
            [
                "7-11 STORE 615 SHELL TAMPINES AVE 4",
                "10 TAMPINES AVENUE 4 .  ",
                "529679"
            ],
            [
                "CALTEX - TAMPINES",
                "1 TAMPINES AVENUE 8   ",
                "529707"
            ],
            [
                "CHEERS TEMASEK POLY (FRTMP(906)",
                "21 TAMPINES AVE 1 21 TAMPINES AVE 1  ",
                "529757"
            ],
            [
                "KAZEFA TRADING",
                "59 TAMPINES AVE 1 #01-01  ",
                "529775"
            ],
            [
                "CSTORE TRADING PTE LTD",
                "71 TAMPINES  AVE 1 #01-50 WATERVIEW CONDOMINIUM CLUB HOUSE  ",
                "529779"
            ],
            [
                "7-11 STORE 399 SIMEI MRT",
                "3 SIMEI STREET 01-05/06/07 SIMEI MRT STATION  ",
                "529888"
            ],
            [
                "7-11 STORE 113 CGH HOSPITAL",
                "2 SIMEI ST 3 01-17 NEW CHANGI HOSPITAL  ",
                "529889"
            ],
            [
                "TECK LEONG LEE KEE",
                "BLK 15 HOUGANG AVE 3 UNIT 01-109  ",
                "530015"
            ],
            [
                "OA JALIL",
                "BLK 19 HOUGANG AVE 3 UNIT 01-185  ",
                "530019"
            ],
            [
                "CHEERS HOUGANG BLK 23 (FRHG)(924)",
                "BLK 23 HOUGANG AVE 3 NO 01 281 HOUGANG AVE 3  ",
                "530023"
            ],
            [
                "J-KEARTS CONTRACTS & SERVICE(HOUGANG)",
                "BLK 24 HOUGANG AVE 3 #01-414  ",
                "530024"
            ],
            [
                "CHOP ENG SENG",
                "BLK 356 HOUGANG AVE 7 UNIT 01-793  ",
                "530056"
            ],
            [
                "7-11 STORE 197 HOUGANG BLK 106",
                "BLK 106 HOUGANG AVE 1 NO 01-1223  ",
                "530106"
            ],
            [
                "PRIME SMKT - HOUGANG",
                "BLK 106 HOUGANG AVE 1 UNIT 01-1213  ",
                "530106"
            ],
            [
                "LIM SOON SENG",
                "BLK 113 HOUGANG AVE 1 UNIT 01-K1  ",
                "530113"
            ],
            [
                "KOH TIA HONG",
                "BLK 123 HOUGANG AVE 1 UNIT 01-1420  ",
                "530123"
            ],
            [
                "LOVEABLE SWEET HOUSE 1",
                "BLK 134 LORONG AH SOO UNIT 01-468  ",
                "530134"
            ],
            [
                "PRIME SMKT - HOUGANG 159A",
                "BLK 159A HOUGANG ST 11   ",
                "530159"
            ],
            [
                "PIZZA HUT - HEARTLAND MALL",
                "BLK 205 HOUGANG ST 21 UNIT 02-08/09 HEARTLAND MALL KOVAN ",
                "530205"
            ],
            [
                "NEW YORK NEW YORK - HEARTLAND MALL",
                "205 HOUGANG ST 21 UNIT 02-08 HEARTLAND MALL  ",
                "530205"
            ],
            [
                "7-11 STORE 9.07.0 HOUGANG BLK 210",
                "BLK 210 HOUGANG ST 21 HOUGANG ST 21 N0 01 275  ",
                "530210"
            ],
            [
                "DING DONG SHAKE",
                "BLK 246 HOUGANG ST 22 #01-157  ",
                "530246"
            ],
            [
                "MEEKNESS STATIONARY & TRADING",
                "BLK 246 HOUGANG ST 22 UNIT 01-157  ",
                "530246"
            ],
            [
                "7-11 STORE 467 HOUGANG BLK 247",
                "BLK 247 HOUGANG AVE 3 01 444  ",
                "530247"
            ],
            [
                "YONG HUP HONG TRADING",
                "BLK 251 HOUGANG AVE 3 UNIT 01-K1  ",
                "530251"
            ],
            [
                "RAMANI INTERNATIONAL PTE LTD",
                "BLK 302 HOUGANG AVE 5 UNIT 01-K1  ",
                "530302"
            ],
            [
                "BREAD & MILK",
                "BLK 308 HOUGANG AVE 5 UNIT 01-K1  ",
                "530308"
            ],
            [
                "CHNG WAH SENG SUPERMARKET",
                "BLK 309 #01-291 HOUGANG AVE 5   ",
                "530309"
            ],
            [
                "CHOP AH TAT",
                "BLK 309 HOUGANG AVE 5 UNIT 01-293  ",
                "530309"
            ],
            [
                "I-ECON - CHNG WAH SENG SUPERMARKET",
                "BLK 309 HOUGANG AVE 5 UNIT 01-291  ",
                "530309"
            ],
            [
                "99 GLOBAL MARKETING",
                "BLK 317 HOUGANG AVE 7   ",
                "530317"
            ],
            [
                "7-11 STORE 570 HOUGANG BLK 332",
                "BLK 332 HOUGANG AVE 5 UNIT 01-K1  ",
                "530332"
            ],
            [
                "7-11 STORE 379 HOUGANG BLK 379",
                "BLK 356 HOUGANG AVE 7 NO 01-781  ",
                "530352"
            ],
            [
                "7-11 STORE 188 HOUGANG BLK 401",
                "BLK 401 HOUGANG AVE 10 01 1168  ",
                "530401"
            ],
            [
                "MAJFA MINI MARKET",
                "BLK 436 HOUGANG AVE 8 UNIT 01-K1  ",
                "530436"
            ],
            [
                "NOOR BEST MINIMART",
                "BLK 468 HOUGANG AVE 8 UNIT 01-1510  ",
                "530468"
            ],
            [
                "BUZZ - SERANGOON VIEW",
                "BLK 476 UPPER SERANGOON VIEW #02-14  ",
                "530476"
            ],
            [
                "HOM MINI MART",
                "BLK 506 HOUGANG AVE 8 UNIT 01-672  ",
                "530506"
            ],
            [
                "CHEERS HOUGANG BLK 631 (CHG631)(598",
                "BLK 631 HOUGANG AVE 8 UNIT 01-10  ",
                "530631"
            ],
            [
                "HAN BROTHERS",
                "BLK 635 HOUGANG AVE 8 UNIT 01-K1  ",
                "530635"
            ],
            [
                "7-11 STORE 110 HOUGANG BLK 644",
                "BLK 644 HOUGANG AVE 8 NO 01-273  ",
                "530644"
            ],
            [
                "RILAH STORE",
                "BLK 673 HOUGANG AVE 8 UNIT 01-K1  ",
                "530673"
            ],
            [
                "7-11 STORE 474 HOUGANG AVE 8",
                "BLK 678 HOUGANG AVENUE 8 Unit 01 505  ",
                "530678"
            ],
            [
                "7-11 STORE 481 HOUGANG",
                "BLK 685 HOUGANG STREET 61 01 154  ",
                "530685"
            ],
            [
                "7-11 STORE 193 HOUGANG BLK 698",
                "BLK 698 HOUGANG ST 61 NO 01-02  ",
                "530698"
            ],
            [
                "7-11 STORE 176 HOUGANG BLK 809",
                "BLK 809 HOUGANG CENTRAL NO 01-172  ",
                "530809"
            ],
            [
                "CHEERS HOUGANG BLK 810 (FRHG810)(93",
                "BLK 810 HOUGANG CENTRAL NO 01-214  ",
                "530810"
            ],
            [
                "CHYI YUAN MINIMART",
                "BLK 911 HOUGANG ST 91 #01-58  ",
                "530911"
            ],
            [
                "I-ECON - CHYI YUAN MINIMART",
                "BLK 911 HOUGANG ST 91 UNIT 01-58  ",
                "530911"
            ],
            [
                "SENG YONG HUAT PROVN & FRUITS",
                "BLK 919 HOUGANG AVE 4 UNIT 01-457  ",
                "530919"
            ],
            [
                "CHNG WAH SENG MINIMART",
                "BLK 2 #01-42 LORONG LEW LIAN   ",
                "531002"
            ],
            [
                "I-ECON - CHNG WAH SENG",
                "BLK 2 LOR LEW LIAN UNIT 01-42  ",
                "531002"
            ],
            [
                "I-ECON - BEGONIA 280 TAMPINES",
                "BLK 280 TAMPINES ST 22 UNIT 01-244  ",
                "531002"
            ],
            [
                "7-11 STORE 9.11.0 TAI SENG ST",
                "30 TAI SENG STREET UNIT 01-07  ",
                "534013"
            ],
            [
                "JKP MINIMART",
                "31 UPPER SERANGOON VIEW BOATHOUSE RESIDENCES #01-21  ",
                "534043"
            ],
            [
                "LUCKY CREATION MINIMART",
                "14 UPPER SERANGOON VIEW RIO VISTA UNIT B1-46  ",
                "534200"
            ],
            [
                "CALTEX - SERANGOON AVE",
                "559 UPPER SERANGOON ROAD   ",
                "534561"
            ],
            [
                "7-11 STORE 409 KOVAN HTL 81",
                "768 UPPER SERANGOON ROAD UPP SERANGOON RD  ",
                "534636"
            ],
            [
                "CALTEX - UPP SERANGOON",
                "818 UPPER SERANGOON ROAD   ",
                "534677"
            ],
            [
                "SPC - UPPER SERANGOON",
                "849 UPPER SERANGOON ROAD   ",
                "534686"
            ],
            [
                "CHEERS BY FP KOVAN (EKVN)(691)",
                "866 UPPER SERANGOON RD .  ",
                "534694"
            ],
            [
                "7-11 STORE 731 SUITES KOVAN",
                "981 UPPER SERANGOON ROAD UNIT 01-01  ",
                "534729"
            ],
            [
                "7-11 STORE 317 UPP.SERANGOON J.RENG",
                "1000 UPPER SERANGOON ROAD FLORENCE ROAD  ",
                "534738"
            ],
            [
                "P.OSH - SERANGOON",
                "1011 UPPER SERANGOON RD UNIT 01-02 THE OLD HOUSE ",
                "534749"
            ],
            [
                "CHEERS BY FP UPP.SERANGOON (EUSA)(6",
                "1027 UPPER SERANGOON RD .  ",
                "534765"
            ],
            [
                "HOLY INNOCENT HIGH SCHOOL",
                "1191 UPPER SERANGOON RD UNIT 01-01  ",
                "534786"
            ],
            [
                "CHOP HWA TIONG",
                "171 UPPER PAYA LEBAR RD   ",
                "534861"
            ],
            [
                "BETHANY INDEPENDENT",
                "301 UPPER PAYA LEBAR ROAD   ",
                "534934"
            ],
            [
                "7-11 STORE 797 PAYA LEBAR",
                "396 UPPER PAYAR LEBAR ROAD UNIT 01-02  ",
                "534984"
            ],
            [
                "PLAB SPECIALIST`S MESS",
                "BLK 56 AIRPORT ROAD PAYA LEBAR AIR FORCE  ",
                "535395"
            ],
            [
                "CHEERS HOUGANG 1 (FRHGST91)(916)",
                "1 HOUGANG STREET 91 UNIT 01 35  ",
                "538692"
            ],
            [
                "7-11 STORE 263 HOUGANG GREEN S.MALL",
                "21 HOUGANG GREEN STRT 51 01 17/21 HOUGANG GREEN S/M  ",
                "538719"
            ],
            [
                "MINTON SUPERMARKET",
                "BLK 4A HOUGANG ST 11 UNIT 01-82 THE MINTON  ",
                "538754"
            ],
            [
                "PIZZA HUT - HOUGANG MALL",
                "90 HOUGANG AVE 10 HOUGANG MALL UNIT 02-25  ",
                "538766"
            ],
            [
                "JIREH MART",
                "70 HOUGANG AVE 7 #01-05  ",
                "538804"
            ],
            [
                "FLORIMART",
                "70 HOUGANG AVE 7 THE FLORIDA UNIT 01-05  ",
                "538804"
            ],
            [
                "7-11 STORE 675 SHELL HOUGANG AVE 3",
                "600 Hougang Ave 3   ",
                "538846"
            ],
            [
                "CHEERS BY FAIRPRICE-HOUGANG",
                "600 HOUGANG AVE 3 .  ",
                "538846"
            ],
            [
                "SPC - HOUGANG AVE 2",
                "120 HOUGANG AVENUE 2   ",
                "538858"
            ],
            [
                "INSTITUTE OF MENTAL HEALTH",
                "10 BUANGKOK VIEW   ",
                "539747"
            ],
            [
                "7-11 STORE 138 RIVERVALE BLK 118",
                "BLK 118 RIVERVALE DRIVE 01-05/06 RIVERVALE PLAZA  ",
                "540118"
            ],
            [
                "JUZ BREAD - RIVERVALE",
                "BLK 118 RIVERVALE DRIVE UNIT 01-04 RIVERVALE MALL  ",
                "540118"
            ],
            [
                "7-11 STORE 501 COMPASSVALE BLK 232",
                "BLK 232 COMPASSAVALE WALK 01 458  ",
                "540232"
            ],
            [
                "YAK HONG PTE LTD",
                "BLK 237 COMPASSVALE WALK #01-534  ",
                "540237"
            ],
            [
                "7-11 STORE 482 COMPASSVALE WALK",
                "BLK 237 COMPASSVALE WALK 01 534  ",
                "540237"
            ],
            [
                "ANCHORVALE MINIMART",
                "BLK 267 COMPASSVALE LINK #01-01  ",
                "540267"
            ],
            [
                "I-ECON - ANCHORVALE MINIMART",
                "BLK 267 COMPASSVALE LINK UNIT 01-01  ",
                "540267"
            ],
            [
                "I-ECON - FAIR MART SUPERSTORE SENGKANG",
                "BLK 297 COMPASSVALE ST UNIT 01-01  ",
                "540297"
            ],
            [
                "U STARS SUPERMARKET (ANCHORVALE)",
                "BLK 330 ANCHORVALE ST #01-01  ",
                "540330"
            ],
            [
                "7-11 STORE 213 ANCHORVALE BLK 319A",
                "BLK 319A ANCHORVALE DRIVE NO 01-78  ",
                "541319"
            ],
            [
                "NICE MINIMART (ANCHORVALE)",
                "Blk 326A Anchorvale Road #01-256  ",
                "541326"
            ],
            [
                "7-11 STORE 278 ANCHORVALE BLK 318B",
                "BLK 318B ANCHORVALE LINK NO 01-255  ",
                "542318"
            ],
            [
                "ZONE MINIMART",
                "BLK 205D COMPASSVALE LANE UNIT 01-09  ",
                "544205"
            ],
            [
                "SPC - SENG KANG",
                "91 SENG KANG EAST WAY   ",
                "544885"
            ],
            [
                "J&F FAMILY HUT",
                "57 ANCHORVALE ROAD UNIT 02-05 SENGKANG SPORTS & RECREATION ",
                "544964"
            ],
            [
                "7-11 STORE 626 SHELL SENGKANG",
                "61 SENGKANG EAST ROAD NO 01-01  ",
                "545015"
            ],
            [
                "SATHIA`S STORE",
                "20 RIVERVALE DRIVE UNIT 02-00 LANGKAR LRT  ",
                "545052"
            ],
            [
                "7-11 STORE 218 COMPASS POINT",
                "NO. 1 SENGKANG SQUARE #01-33/34/35/36 COMPASS POINT  ",
                "545078"
            ],
            [
                "PIZZA HUT - COMPASSPOINT",
                "NO. 1 SENG KANG SQUARE UNIT B1-22 COMPASS POINT  ",
                "545078"
            ],
            [
                "EACH A CUP - RIVERVALE",
                "11 RIVERVALE CRESCENT UNIT 01-K7 RIVERVALE MALL  ",
                "545082"
            ],
            [
                "CHEERS RIVERVALE MALL (FRRV)(908)",
                "11 RIVERVALE CRESCENT 01 05/06 RIVERVALE MALL  ",
                "545082"
            ],
            [
                "HEARTLAND MART",
                "36 YIO CHU KANG ROAD   ",
                "545553"
            ],
            [
                "SPC - YIO CHU KANG",
                "76 YIO CHU KANG ROAD   ",
                "545570"
            ],
            [
                "7-11 STORE 633 SHELL YIO CHU KANG",
                "158 YIO CHU KANG ROAD .  ",
                "545612"
            ],
            [
                "CHEERS BY FP YCK A (EYCK)(634)",
                "160 YIO CHU KANG RD .  ",
                "545614"
            ],
            [
                "S-POWER MINI SUPERMARKET",
                "176 YIO CHU KANG ROAD   ",
                "545626"
            ],
            [
                "FAIRPRICE XPRESS SENGKANG (ESK)(622",
                "211 PUNGGOL RD .  ",
                "546673"
            ],
            [
                "YONG FU MINIMART",
                "BLK 107 SERANGOON  NORTH AVE 1 UNIT 01-675  ",
                "550107"
            ],
            [
                "NAM SUN",
                "BLK 152 SERANGOON NORTH AVE 1 UNIT 01-314  ",
                "550152"
            ],
            [
                "7-11 STORE 126 SERANGOON BLK 153",
                "BLK 153 SERANGOON NORTH AVE 1 NO 01-546  ",
                "550153"
            ],
            [
                "MOORTHY MINIMART",
                "BLK 214 SERANGOON AVE 4 UNIT 01-94  ",
                "550214"
            ],
            [
                "I-ECON - HT MINIMART",
                "BLK 214 SERANGOON AVE 4 UNIT 01-104  ",
                "550214"
            ],
            [
                "KEE SONG OCEAN PTE LTD",
                "BLK 262 SERANGOON CENTRAL DRIVE #01-121   ",
                "550262"
            ],
            [
                "7-11 STORE 355 SERANGOON BLK 301",
                "BLK 301 SERANGOON AVE 2 NO 01-340  ",
                "550301"
            ],
            [
                "MEGA MINIMART",
                "BLK 310 SERANGOON AVE 2 UNIT 01-K1  ",
                "550310"
            ],
            [
                "7-11 STORE 109 SERANGOON BLK 109",
                "BLK 326 SERANGOON AVE 3 NO 01-378  ",
                "550326"
            ],
            [
                "7-11 STORE 494 SERANGOON BLK 504",
                "BLK 504 SERANGOON NORTH AVENUE 4 UNIT 01 474  ",
                "550504"
            ],
            [
                "SIN HIN",
                "BLK 523 SERANGOON NORTH AVENUE 4 UNIT 01-1689  ",
                "550523"
            ],
            [
                "PRIME SMKT - SERANGOON NORTH AVE 3",
                "BLK 542B SERANGOON NORTH AVENUE 3 UNIT 02-01 ",
                "550542"
            ],
            [
                "SMART ENERGY PTE LTD (SERANGOON)",
                "9A SERNAGOON NORTH AVE5   ",
                "554500"
            ],
            [
                "THE WOK PEOPLE - ST BHQ",
                "5A SERANGOON AVE 5   ",
                "554574"
            ],
            [
                "SINGTEL",
                "1 SERANGOON NORTH AVENUE 5   ",
                "554915"
            ],
            [
                "PRO 3 INSTITUTIONAL CATERING - SERANGOON",
                "5 SERANGOON NORTH AVE 5 5TH FLR (UTAC)  ",
                "554916"
            ],
            [
                "7-11 STORE 606 SHELL SERANGOON GDN",
                "49 SERANGOON GARDEN WAY .  ",
                "555944"
            ],
            [
                "7-11 STORE 735 SERANGOON CENTRAL",
                "23 SERANGOON CENTRAL UNIT 04-62  ",
                "556083"
            ],
            [
                "7-11 STORE 733 SERANGOON CENTRAL MA",
                "23 SERANGOON CENTRAL UNIT B2-16, SERANGOON CENTRAL MALL ",
                "556083"
            ],
            [
                "PIZZA HUT - NEX",
                "23 SERANGOON CENTRAL NEX SHOPPING CENTRE UNIT 03-11/12/13 ",
                "556083"
            ],
            [
                "NANDO`S - NEX",
                "23 SERANGOON CENTRAL UNIT B1-41/42/43 NEX SHOPPING  ",
                "556083"
            ],
            [
                "FRESH MART (SERANGOON)",
                "137 SERANGOON AVE 3 CHILTERN PARK  ",
                "556115"
            ],
            [
                "CHEERS - MAJU AVE",
                "2 MAJU AVE   ",
                "556680"
            ],
            [
                "KIRAN ENTERPRISES",
                "246 LORONG CHUAN UNIT 01-03 CHUAN PARK CONDO  ",
                "556746"
            ],
            [
                "CALTEX - LORONG CHUAN",
                "277 LORONG CHUAN   ",
                "556771"
            ],
            [
                "FAIRPRICE XPRESS LOR CHUAN (ELRC)(6",
                "384 LORONG CHUAN RD .  ",
                "556810"
            ],
            [
                "SODEXO - AIS",
                "AIS 1 LORONG CHUAN   ",
                "556818"
            ],
            [
                "7-11 STORE 9.03.0 KENSINGTON PARK R",
                "3 KENSINGTON PARK RD .  ",
                "557255"
            ],
            [
                "SERANGOON GARDEN COUNTRY CLUB",
                "22 KENSINGTON PARK ROAD   ",
                "557271"
            ],
            [
                "7-11 STORE 544 AMK BLK 151",
                "BLK 151 ANG MO KIO AVE 5 UNIT 01 3034  ",
                "560151"
            ],
            [
                "SPICES N HERBS",
                "BLK 163 ANG MO KIO AVE 4 #01-420  ",
                "560163"
            ],
            [
                "MIKI MART",
                "BLK 163 ANG MO KIO AVE 4 UNIT 01-420  ",
                "560163"
            ],
            [
                "7-11 STORE 240 AMK BLK 163",
                "BLK 163 ANG MO KIO AVE 4 NO 01-430  ",
                "560163"
            ],
            [
                "STARTERS MART ",
                "BLK 28 ANG MO KIO AVE 1   ",
                "560218"
            ],
            [
                "NEW ALEEF PROVISIONS",
                "BLK 256 ANG MO KIO AVE 4 UNIT 01-43  ",
                "560256"
            ],
            [
                "SRI SELVI STORE PTE LTD",
                "BLK 313 ANG MO KIO AVE 3   ",
                "560313"
            ],
            [
                "AX ENTERPRISE - AMK",
                "BLK 332 ANG MO KIO #011-1883  ",
                "560332"
            ],
            [
                "LUCKY JOY SUPERMARKET",
                "BLK 332 ANG MO KIO AVE 1 #01-1883  ",
                "560332"
            ],
            [
                "I-ECON - AX ENTERPRISE AMK",
                "BLK 332 ANG MO KIO UNIT 01-1883  ",
                "560332"
            ],
            [
                "AX ENTERPRISE - AMK",
                "BLK 332 ANG MO KIO #011-1883  ",
                "560332"
            ],
            [
                "7-11 STORE 9.25.0 AMK BLK 339",
                "BLK 339 ANG MO KIO AVE NO 01 1579  ",
                "560339"
            ],
            [
                "SIONG JI FOODSTUFFS TRADING",
                "BLK 339 ANG MO KIO AVE 1 UNIT 01-1591  ",
                "560339"
            ],
            [
                "7-11 STORE 251 AMK AVE 10",
                "BLK 407 ANG MO KIO AVE 10 NO 01-747  ",
                "560407"
            ],
            [
                "CHEERS AMK BLK 407 (FRAM407)(931)",
                "BLK 407 ANG MO KIO AVE 10 NO 01 741  ",
                "560407"
            ],
            [
                "7-11 STORE 344 AMK BLK 416",
                "BLK 416 ANG MO KIO AVENUE 10 Unit 01 991  ",
                "560416"
            ],
            [
                "LUCKY LAKI PTE LTD",
                "BLK 443 ANG MO KIO AVE 10 UNIT 01-1257  ",
                "560443"
            ],
            [
                "YEW GUAN MINIMART",
                "BLK 443 ANG MO KIO AVE 10 UNIT 01-1231  ",
                "560443"
            ],
            [
                "ONE 165",
                "BLK 443 ANG MO KIO AVE 10 #01-1257  ",
                "560443"
            ],
            [
                "7-11 STORE 175 AMK BLK 452",
                "BLK 452 ANG MO KIO AVE 10 NO 01-1775  ",
                "560452"
            ],
            [
                "SRI BALAJI STORES",
                "BLK 460 ANG MO KIO AVE 10 #01-1578  ",
                "560460"
            ],
            [
                "VMAM MOHAMED TRADING",
                "BLK 473 ANG MO KIO AVE 10 UNIT 01-728  ",
                "560473"
            ],
            [
                "7-11 STORE 407 AMK AVE 8",
                "BLK 505 ANG MO KIO AVE 8 NO 01-2684  ",
                "560505"
            ],
            [
                "I-ECON GO2MART AMK",
                "BLK 532 AMK AVE 10 #01-2465  ",
                "560532"
            ],
            [
                "GO2MART AMK",
                "BLK 532 AMK AVE 10 #01-2465  ",
                "560532"
            ],
            [
                "7-11 STORE 9.15.0 AMK BLK 532",
                "BLK 532 ANG MO KIO AV0 10 NO 01 2455  ",
                "560532"
            ],
            [
                "7-11 STORE 748 BLK 554 AMK AVE 10",
                "BLK 554 ANG MO KIO AVE 10 UNIT 01-2050   ",
                "560554"
            ],
            [
                "7-11 STORE 154 AMK BLK 630",
                "BLK 630 ANG MO KIO AVE 4 NO 01-970  ",
                "560630"
            ],
            [
                "632 FAMILY STORE",
                "BLK 632 ANG MO KIO AVE 4  #01-952  ",
                "560632"
            ],
            [
                "I-ECON - 632 FAMILY STORE",
                "BLK 632 ANG MO KIO AVE 4 UNIT 01-952  ",
                "560632"
            ],
            [
                "CMART STORE",
                "BLK 673 HOUGANG AVE 8  ",
                "560673"
            ],
            [
                "OMNIUM GATHERUM PTE LTD",
                "#01-3501B  BLK 711 ANG MO KIO AVE 8  ",
                "560711"
            ],
            [
                "7-11 STORE 172 AMK BLK 711",
                "BLK 711 ANG MO KIO AVE 8 01-3501B  ",
                "560711"
            ],
            [
                "PIZZA HUT - AMK 715",
                "BLK 715 ANG MO KIO AVE 6 UNIT 01-4000  ",
                "560715"
            ],
            [
                "7-11 STORE 420 AMK AVE 1",
                "BLK 226A ANG MO KIO AVE 1 UNIT 01-627  ",
                "561226"
            ],
            [
                "SOON LEE HENG EATING HOUSE",
                "1 ANG MO KIO  S T ELECTRONICS  ",
                "567710"
            ],
            [
                "FM CAFE",
                "ITE HEADQUARTERS 2 ANG MO KIO DRIVERBLK F, #F-03D  ",
                "567720"
            ],
            [
                "JAMES COOK UNIVERSITY",
                "SCOTTS 37 TUCKSHOP 10 ANG MO KIO ST 54  ",
                "569184"
            ],
            [
                "AUNTY LEE FRUIT STALL",
                "501 ANG MO KIO ST    ",
                "569405"
            ],
            [
                "THE WOK PEOPLE - ST AMJ9",
                "28 ANG MO KIO INDUSTRIAL PARK 2   ",
                "569508"
            ],
            [
                "BEE KEONG RESTAURANT",
                "BLK 5058 ANG MO KIO INSTRIAL PARK 2 #01-1255  ",
                "569561"
            ],
            [
                "JP FOOD SERVICES -KKONGDON ANG MO KIO",
                "5 ANG MO KIO CENTRAL 2 #01-06 DJITSUN MALL  ",
                "569663"
            ],
            [
                "JUN HANG F&B PTE LTD",
                "8 ANG MO KIO AVE 12 LEVEL 2 INDUSTRIAL PARK 2 MICRON  ",
                "569709"
            ],
            [
                "FAIRPRICE XPRESS AMK AVE 8 (EAM8)(6",
                "2225 ANG MO KIO AVE 8   ",
                "569810"
            ],
            [
                "CHEERS AMK MRT (SMAK)(848)",
                "2450 ANG MO KIO AVE 8 UNIT 01-07  ",
                "569811"
            ],
            [
                "7-11 STORE 737 YIO CHU KANG MRT",
                "3000 ANG MO KIO AVE 8 UNIT 01 01 YIO CHU KANG MRT STATION  ",
                "569813"
            ],
            [
                "NORTHERN DELIGHT CANTEEN",
                "NANYANG POLYTECHNIC BLOCK E LEVEL 2 180 ANG MO KIO AVE 8  ",
                "569830"
            ],
            [
                "CHEERS NANYANG POLY (CNYP)(527)",
                "180 ANG MO KIO AVE 8 Block A, Unit A.278, A.278A, A.278B  ",
                "569830"
            ],
            [
                "CREAMY DUCK - NYP",
                "180 ANG MO KIO AVE 8 NANYANG POLYTECHNIC CARPARK 15 BESIDE MCDONALD`S ",
                "569830"
            ],
            [
                "7-11 STORE 670 SHELL AMK AVE 6",
                "3535 ANG MO KIO AVENUE 6 ANG MO KIO AVE 6  ",
                "569839"
            ],
            [
                "SPC - ANG MO KIO AVE 5",
                "2761 ANG MO KIO   ",
                "569866"
            ],
            [
                "YIO CHU KANG SEC SCHOOL",
                "3063 ANG MO KIO AVE 5   ",
                "569868"
            ],
            [
                "7-11 STORE 160 BIG MAC CTR",
                "51 ANG MO KIO AVE 3 01-01A BIG MAC CTR  ",
                "569922"
            ],
            [
                "SODEXO - FRENCH SCH AMK",
                "French Sch AMK (FOOD) 3000 Ang Mo Kio Ave 3  ",
                "569926"
            ],
            [
                "FAIRPRICE XPRESS AMK AVE 3 (EAM3)(6",
                "3351 ANG MO KIO AVENUE 3   ",
                "569927"
            ],
            [
                "CHEERS AMK HUB L1 (CAHA)(545)",
                "53 ANG MO KIO AVE 3 01 37 AMK HUB  ",
                "569933"
            ],
            [
                "CHEERS AMK HUB B1 (CAHB)(546)",
                "53 ANG MO KIO AVE 3 NO B1 82 ANG MO KIO HUB  ",
                "569933"
            ],
            [
                "CATHAY - AMK HUB",
                "NO. 53 ANG MO KIO AVE 3 UNIT 04-00 AMK HUB  ",
                "569933"
            ],
            [
                "SPC - ANG MO KIO",
                "793 ANG MO KIO AVENUE 1   ",
                "569975"
            ],
            [
                "SPC - ANG MO KIO AVE 1",
                "1351 ANG MO KIO AVENUE 1   ",
                "569977"
            ],
            [
                "KOH ONN TONG MEDICAL HALL",
                "BLK 23 SIN MING ROAD UNIT 01-17  ",
                "570023"
            ],
            [
                "CHOP SIN HIN",
                "BLK 24 SIN MING RD #01-43  ",
                "570024"
            ],
            [
                "I-ECON - CHOP SIN HIN",
                "BLK 24 SIN MING ROAD UNIT 01-43  ",
                "570024"
            ],
            [
                "7-11 STORE 108 BISHAN BLK 116",
                "BLK 116 BISHAN ST 12 NO 01-26  ",
                "570116"
            ],
            [
                "7-11 STORE 519 BISHAN BLK 121",
                "BLK 121 BISHAN STREET 21 No 01-93  ",
                "570121"
            ],
            [
                "AX ENTERPRISE - BISHAN",
                "LK 222 BISHAN ST 23 #01-K1  ",
                "570222"
            ],
            [
                "I-ECON - AX ENTERPRISE BISHAN",
                "BLK 222 BISHAN ST 23 UNIT 01-K1  ",
                "570222"
            ],
            [
                "CHAI YU TRADING",
                "BLK 445 SIN MING AVE UNIT 01-473  ",
                "570445"
            ],
            [
                "7-11 STORE 161 BISHAN BLK 150A",
                "BLK 150A BISHAN ST 11 NO 01-179  ",
                "571150"
            ],
            [
                "PRO 3 INSTITUTIONAL CATERING - BISHAN",
                "11 BISHAN ST 21 (BOSCH)  ",
                "573943"
            ],
            [
                "7-11 STORE 657 SHELL LAKE VIEW",
                "80 UPPER THOMSON ROAD .  ",
                "574326"
            ],
            [
                "SPC - UPPER THOMSON",
                "98 UPPER THOMSON ROAD   ",
                "574330"
            ],
            [
                "7-11 STORE 625 SHELL SIN MING",
                "183A UPPER THOMSON ROAD .  ",
                "574332"
            ],
            [
                "7-11 STORE 9.22.0 UPP.THOMSON BLK 2",
                "244H UPP THOMSON RD .  ",
                "574369"
            ],
            [
                "7-11 STORE 525 THOMSON PLAZA",
                "301 UPPER THOMSON ROAD NO 01-44 THOMSON PLAZA  ",
                "574408"
            ],
            [
                "PIZZA HUT - THOMSON PLAZA",
                "301 UPPER THOMSON ROAD UNIT 02-24/26 THOMSON PLAZA ",
                "574408"
            ],
            [
                "CHEERS BY FP WINDSOR (EWSR)(667)",
                "353 UPPER THOMSON RD .  ",
                "574410"
            ],
            [
                "7-11 STORE 636 SHELL PIERCE RESERVO",
                "551 UPPER THOMSON ROAD .  ",
                "574415"
            ],
            [
                "CHEERS BY FP LOWER PIERCE (ELPE)(65",
                "553 UPPER THOMSON RD .  ",
                "574416"
            ],
            [
                "CALTEX - UPPER THOMSON",
                "555 UPPER THOMSON ROAD   ",
                "574417"
            ],
            [
                "CHEERS BY FP UPP.THOMSON (EUTH)(655",
                "594 UPP THOMSON RD .  ",
                "574420"
            ],
            [
                "SPC - JALAN LEBAN",
                "1 JALAN LEBAN   ",
                "577546"
            ],
            [
                "7-11 STORE 9.05.0 JLN LEBAN",
                "6 JALAN LEBAN .  ",
                "577549"
            ],
            [
                "SINGAPORE ISLAND COUNTRY CLUB - ISLAND",
                "180 ISLAND CLUB ROAD   ",
                "578774"
            ],
            [
                "SPC - BRADDELL",
                "317 BRADDELL ROAD   ",
                "579706"
            ],
            [
                "CALTEX - SEH AUTOMOTIVE ENTERPRISE",
                "319 BRADDELL ROAD   ",
                "579707"
            ],
            [
                "SUN ISLAND CAFE PTE LTD - HOBBYIST CAFE",
                "5 BISHAN ST 14 #03-01  ",
                "579783"
            ],
            [
                "7-11 STORE 363 BISHAN MRT",
                "200 BISHAN ROAD 01 01/02 BISHAN MRT STN  ",
                "579827"
            ],
            [
                "PIZZA HUT - JUNCTION 8",
                "NO. 9 BISHAN PLACE UNIT 01-40 JUNCTION 8 SHOPPING CENTRE ",
                "579837"
            ],
            [
                "NANDO`S - JUNCTION 8",
                "8 BISHAN PLACE JUNCTION 8 SHOPPING CENTRE #01-51  ",
                "579837"
            ],
            [
                "7-11 STORE 659 SHELL UPP BT TIMAH P",
                "35 UPPER BUKIT TIMAH ROAD .  ",
                "588166"
            ],
            [
                "FAIRPRICE XPRESS U.B.TIMAH A (EUBA)",
                "213 UPP BT TIMAH RD .  ",
                "588183"
            ],
            [
                "7-11 STORE 667 SHELL BT TIMAH HILL",
                "219 UPPER BUKIT TIMAH HILL .  ",
                "588186"
            ],
            [
                "NIK NAT GIFTS & PREMIUM - BITS&BITES",
                "SINGAPORE BOWLING AT TEMASEK CLUB BLK 3 #04-02 131 RIFLE RANGE ROAD  ",
                "588406"
            ],
            [
                "PIZZA HUT - BT TIMAH PLAZA",
                "JALAN ANAK BUKIT UNIT 01-16A BUKIT TIMAH PLAZA ",
                "588996"
            ],
            [
                "CALTEX - BINJAI PARK",
                "836 DUNEARN ROAD UNIT 01-01  ",
                "589457"
            ],
            [
                "CHEERS BY FP YARWOOD (EYWD)(656)",
                "870 DUNEARN RD .  ",
                "589471"
            ],
            [
                "7-11 STORE 265 B.TIMAH OLD HOLLAND",
                "901 BUKIT TIMAH ROAD .  ",
                "589619"
            ],
            [
                "SANCTUARY MART - MAPLEWOODS",
                "989 BUKIT TIMAH ROAD MAPLEWODDS CONDOMINIUM  ",
                "589629"
            ],
            [
                "RAW MARKET PTE LTD",
                "5 BINJAI PARK   ",
                "589820"
            ],
            [
                "7-11 STORE 9.62.0 TOH YI BLK 19",
                "BLK 19 TOH YI DRIVE UNIT 01 117  ",
                "590019"
            ],
            [
                "CHEERS SIGNATURE PARK (CSIP)(547)",
                "58 TOH TUCK RD 39814  ",
                "596747"
            ],
            [
                "BIGHOUSE PTE LTD",
                "REVERLRY 21 LORONG KILAT #01-02 SUN COURT  ",
                "598123"
            ],
            [
                "CANOSSIAN CONVENT KINDERGARDEN",
                "100 JALAN MERBOK   ",
                "598454"
            ],
            [
                "CHEERS BY FP JURONG KECHIL (EKRK)(6",
                "37 JALAN JURONG KECHIL .  ",
                "598577"
            ],
            [
                "HOWE CATERING - JJK",
                "300 JALAN JURONG KECHIL   ",
                "598668"
            ],
            [
                "CHECKMATE BOX LLP",
                "71 HUME AVE #01-01 HILLVIEW GREEN CONDOMINIUM CLUB HOUSE ",
                "598741"
            ],
            [
                "KENNY GROCERY",
                "23 ENG KONG   ",
                "598995"
            ],
            [
                "CREAMY DUCK - NGEE ANN BLK22",
                "BLK 22 #01-01A, STALL 158 535 CLEMENTI ROAD  ",
                "599489"
            ],
            [
                "CHEERS - NGEE ANN POLY",
                "535 CLEMENTI RD STUDENT PLAZA 2  ",
                "599489"
            ],
            [
                "NGEE ANN POLY CONSUMER CO-OP - BLK 5",
                "535 CLEMENTI ROAD BLK 5 UNIT 01-01  ",
                "599489"
            ],
            [
                "CREAMY DUCK - NGEE ANN POLY",
                "535 CLEMENTI ROAD BLK 18 POOLSIDE FOODCOURT  ",
                "599489"
            ],
            [
                "GRAB & GO AT SIM",
                "JR FOODS PTE LTD 461 CLEMENTI RD BLK A UNIT 03-02 SINGAPORE INSTITUTE OF MANAGEMENT",
                "599491"
            ],
            [
                "7-11 STORE 336 TEBAN GDN BLK 38",
                "BLK 38 TEBAN GARDENS 01 315  ",
                "600038"
            ],
            [
                "7-11 STORE 9.36.0 JURONG E. BLK 130",
                "BLK 130 JURONG EAST ST 13 NO 01 223  ",
                "600130"
            ],
            [
                "7-11 STORE 556 JURONG E. BLK 202",
                "Blk 202 Jurong East St 21 Unit 01-111  ",
                "600202"
            ],
            [
                "KUAY SHIN",
                "BLK 212 JURONG EAST ST 21 UNIT 01-K1  ",
                "600212"
            ],
            [
                "XIN SHUN FENG TRADING",
                "BLK 242 JURONG EAST ST 24 #01-629  ",
                "600242"
            ],
            [
                "MIN MART (ROLAND RAIN PTE LTD)",
                "BLK 249 #01-94 JURONG EAST ST 24   ",
                "600249"
            ],
            [
                "SHIVANI`S MART",
                "BLK 249 JURONG EAST ST 24 UNIT 01-94  ",
                "600249"
            ],
            [
                "7-11 STORE 9.57.0 JURONG E. BLK 252",
                "BLK 252 JURONG EAST ST 24 NO 01 129  ",
                "600252"
            ],
            [
                "PIABIA",
                "BLK 261 #01-K1 JURONG EAST ST 24   ",
                "600261"
            ],
            [
                "7-11 STORE 523 JURONG E. BLK 338",
                "BLK 338 JURONG AVE1 NO 01-1636  ",
                "600338"
            ],
            [
                "WGW F&B PTE LTD (LAO HUO GUO)",
                "BLK 350 JURONG EAST AVE 1 #01-1237  ",
                "600350"
            ],
            [
                "OMOCHA VILLAGE PTE LTD",
                "BLK 352 JURONG EAST ST 31 #01-131  ",
                "600352"
            ],
            [
                "HUI CHENG PROVISION",
                "BLK 416 PANDAN GARDENS #01-127  ",
                "600416"
            ],
            [
                "I-ECON - HUI CHENG PROVISION",
                "BLK 416 PANDAN GARDENS UNIT 01-127  ",
                "600416"
            ],
            [
                "JOO GUAN HIN MINIMART",
                "BLK 286E TOH GUAN ROAD UNIT 01-02  ",
                "605286"
            ],
            [
                "PIZZA HUT - WEST GATE",
                "3 GATE WAY DRIVE  UNIT 04-04/05 WEST GATE  ",
                "608532"
            ],
            [
                "EGGS & BERRIES - WESTGATE MALL",
                "3 GATEWAY DRIVE UNIT 02-06/06A WESTGATE MALL ",
                "608532"
            ],
            [
                "CATHAY - JEM",
                "NO. 50 JURONG GATEWAY UNIT 05-04/05 JEM SHOPPING CENTRE ",
                "608549"
            ],
            [
                "Food-Joy -Toh Guan",
                "Blk 34 Toh Guan Road East #01-25  ",
                "608579"
            ],
            [
                "7-11 STORE 9.09.0 PANDAN SPORT AREN",
                "200 PANDAN GARDENS UNIT 01-08  ",
                "609336"
            ],
            [
                "ZDY INTL GROUP - IMM",
                "2 JURONG EAST ST 21 #02-158  ",
                "609601"
            ],
            [
                "SHU JIANG GRILLED FISH",
                "2 JURONG EAST ST 21 #02-25 IMM BUILDING  ",
                "609601"
            ],
            [
                "CHEERS NG TENG FONG HOSPITAL(NTFH)(",
                "1 Jurong East St 21 #02-04 Ng Teng Fong General Hospital  ",
                "609606"
            ],
            [
                "CHEERS NG TENG FONG GH(CNTFGH)(861)",
                "1 Jurong East St 21, #02-04 Ng Teng Fong General Hospital  ",
                "609606"
            ],
            [
                "7-11 STORE 734 JURONG EAST JCUBE",
                "2 JURONG EAST CENTRAL 1 UNIT 04 14 JCUBE  ",
                "609731"
            ],
            [
                "NANDO`S - JCUBE",
                "2 JURONG EAST CENTRAL 1 UNIT 03-07/19 JCUBE SHOPPING CENTRE ",
                "609731"
            ],
            [
                "FAIRPRICE XPRESS JURONG EAST (EJE)(",
                "150 JURONG EAST .  ",
                "609787"
            ],
            [
                "CHEF LAB GROUP PTE LTD",
                "200 JURONG EAST AVE 1 #01-03   ",
                "609789"
            ],
            [
                "SPC - JURONG EAST COCO",
                "91 JURONG EAST AVE 1 UNIT 01-01  ",
                "609789"
            ],
            [
                "JURONGVILLE SECONDARY SCHOOL",
                "202 JURONG EAST AVE 1 JURONGVILLE SECONDARY SCHOOL  ",
                "609790"
            ],
            [
                "CALTEX - JALAN BUROH",
                "210 JALAN BUROH  LEVEL 1  ",
                "609831"
            ],
            [
                "CHEERS CHINESE GDN MRT (FRSCHG)(909",
                "151 BOON LAY WAY 39816  ",
                "609959"
            ],
            [
                "HYDRO MECH ENTERPRISE",
                "BLK 151 YUNG HO ROAD UNIT 01-87  ",
                "610151"
            ],
            [
                "SRI PERUMAL SUPERMARKET",
                "BLK 163 YUNG PING RD   ",
                "610163"
            ],
            [
                "7-11 STORE 156 T.JURONG S.CTR BLK 3",
                "BLK 399 YUNG SHENG RD 01-49 TAMAN JURONG SHOPPING CTR  ",
                "610399"
            ],
            [
                "SOON HOCK MINI SUPERMARKET",
                "BLK 346 KANG CHING ROAD UNIT 01-115  ",
                "613346"
            ],
            [
                "SODEXO - CATERPILLAR JT",
                "5 TUKANG INNOVATION GROVE   ",
                "618304"
            ],
            [
                "SODEXO - CATERPILLAR ASIA",
                "5 JURONG INNOVATIONS GROVE UNIT 01-01  ",
                "618304"
            ],
            [
                "KALAM GIFT STORE",
                "1 YUAN CHING RD   ",
                "618640"
            ],
            [
                "KS DISTIBUTION PTE LTD",
                "19 JURONG PORT   ",
                "619093"
            ],
            [
                "REDMART PTE LTD",
                "3A JALAN TERUSAN SAGAWA EXPRESS LEVEL 2M  ",
                "619302"
            ],
            [
                "SIMPLY SANDWICH",
                "9 NORTH BUONA VISTA DRIVE UNIT 01-15  ",
                "619336"
            ],
            [
                "SPC - JALAN BUROH",
                "33 JALAN BUROH UNIT 01-01  ",
                "619487"
            ],
            [
                "FAIRPRICE XPRESS J.A.IBRAHIM (EJAI)",
                "302 JLN AHMAD IBRAHIM .  ",
                "619594"
            ],
            [
                "7-11 STORE 620 SHELL JLN AHMAD IBRA",
                "311 JALAN AHMAD IBRAHIM .  ",
                "619595"
            ],
            [
                "BEN FOODS (S) PTE LTD (STAFF SHOP)",
                "NO 1 FISHERY PORT RD   ",
                "619729"
            ],
            [
                "FAR OCEAN SEA PRODUCTS PTE LTD",
                "15 FISHERY PORT ROAD   ",
                "619735"
            ],
            [
                "REDMART LIMITED",
                "6 FISHERY PORT ROAD LEVEL 3, DRY DOCK  ",
                "619747"
            ],
            [
                "REDMART PTE LTD - 6 FISHERY",
                "6 FISHERY PORT READ LEVEL 3  ",
                "619747"
            ],
            [
                "7-11 FISHERY PORT WAREHOUSE",
                "6 Fishery Port Road #01-01  ",
                "619747"
            ],
            [
                "MEIDI-YA SINGAPORE CO PTE LTD- CHIN BEE",
                "14 CHIN BEE ROAD   ",
                "619824"
            ],
            [
                "TABASSUM PTE LTD",
                "#01-32 PIONEER CENTRE   ",
                "627605"
            ],
            [
                "THOMSON CATERING - PESEK RD",
                "NO. 1 PESEK ROAD JURONG ISLAND  ",
                "627833"
            ],
            [
                "SAKRA MINIMART",
                "NO. 3 SAKRA ROAD UNIT 01-04 JURONG ISLAND  ",
                "627878"
            ],
            [
                "COOL LINK MARKETING PTE LTD",
                "21 WAN LEE ROAD   ",
                "627949"
            ],
            [
                "SODEXO - CATERPILLAR 7",
                "7 TRACTOR ROAD UNIT 01-01  ",
                "627968"
            ],
            [
                "SODEXO - CATERPILLAR 14",
                "14 TRACTOR ROAD UNIT 01-01  ",
                "627973"
            ],
            [
                "TEO SOON SENG WHOLESALES PTE LTD",
                "18 SOON LEE ROAD   ",
                "628081"
            ],
            [
                "EXXON MOBIL PIONEER CAFETERIA",
                "18 PIONEER RD   ",
                "628498"
            ],
            [
                "CHEERS BY FP PIONEER (EPNR)(659)",
                "19 PIONEER RD .  ",
                "628499"
            ],
            [
                "JURONG BIRD PARK PTE LTD - BANQUET",
                "JBP BANQUET 2 JURONG HILL  ",
                "628925"
            ],
            [
                "CONTAINER PRINTERS PTE LTD -JOO KOON",
                "83 JOO KOON CIRCLE   ",
                "629109"
            ],
            [
                "7-11 STORE 543 JOO KOON MRT",
                "NO. 91 JOO KOON CIRCLE JOO KOON MRT  ",
                "629116"
            ],
            [
                "CHEERS FP HUB JOO KOON (CFPHUB)(858",
                "1 Joo Koon Circle #02-25 Fairprice Hub  ",
                "629117"
            ],
            [
                "LEISURE ENTERTAINMENT WORLD PTE LTD",
                "241 JALAN AHMAD IBRAHIM   ",
                "629143"
            ],
            [
                "CALTEX - JLN AHMAD IBRAHIM",
                "400 JALAN AHMAD IBRAHIM UNIT 01-01  ",
                "629153"
            ],
            [
                "CONTAINER PRINTERS PTE LTD - INTL RD",
                "90 INTERNATIONAL RD   ",
                "629172"
            ],
            [
                "KEPPEL F.E CANTEEN",
                "50 GUL ROAD LEVINGTON FAR EAST  ",
                "629351"
            ],
            [
                "SODEXO - TETRAPAK JURONG",
                "19 GUL LANE UNIT 01-01  ",
                "629414"
            ],
            [
                "KEPPEL COMMUNICATIONS PTE LTD",
                "7 GUL CIRCLE   ",
                "629563"
            ],
            [
                "KEPPEL LOGISTICS PTE LTD",
                "7 GUL CIRCLE   ",
                "629563"
            ],
            [
                "LEE AIK HOE",
                "7 GUL CIRCLE KEPPEL LOGISTICS BUILDING UNIT 1M-00 ",
                "629563"
            ],
            [
                "CASH CUSTOMER",
                "SELF COLLECTION   ",
                "629563"
            ],
            [
                "FONG ANN HANG ENTERPRISES - MS PAN OCEAN",
                "M/S PAN OCEAN TRANSPORT PTE LTD 7 FAN YOONG ROAD JURONG   ",
                "629785"
            ],
            [
                "SODEXO - SCHLUMBERGER GSS",
                "1 BENOI CRESCENT   ",
                "629986"
            ],
            [
                "SAVORY PARADISE",
                "NTU CANTEEN A BLK N2.1 #02-08 NANYANG DRIVE  ",
                "637331"
            ],
            [
                "SHELL EASTERN PETROLEUM PTE LTD",
                "TUAS SOUTH AVE 5 LAMP POST NO 317  ",
                "637362"
            ],
            [
                "THE WOK PEOPLE - LONZA BIOLOGICS TUAS",
                "35 TUAS AVENUE 6   ",
                "637377"
            ],
            [
                "7-11 STORE 9.58.0 NTU HALL 14",
                "34 NANYANG CRESCENT NANYANG TECHNOLOGICAL UNIVERSITY  ",
                "637634"
            ],
            [
                "WAFFLES STREET",
                "32 NANYANG CRESCENT NTU CANTEEN 13   ",
                "637658"
            ],
            [
                "SFI-UPSB 12 CCO P.LABA",
                "CCOPLC 233 PASIR LEBA RD I 2 CCO PASIR LABA CAMP  ",
                "637901"
            ],
            [
                "SFI-UPSE (CCO) PASIR LABA CAMP",
                "BLK 10D CAMP PASIR LABA RD MUSLIM COOK HOUSE  ",
                "637901"
            ],
            [
                "SFI-UJRA NON MUSLIM COOKHOUSE",
                "E3-JURONG CAMP 1 BLK 102 100 UPPER JURONG RD ",
                "638358"
            ],
            [
                "HMS FAR EAST PTE LTD",
                "12 TUAS RD   ",
                "638486"
            ],
            [
                "7-11 STORE 9.68.0 NTU STUDENTS WALK",
                "35 STUDENT WALK CANTEEN 2 NANYANG TECHNOLOGICAL UNIVERSITY  ",
                "639548"
            ],
            [
                "CREAMY DUCK - NTU",
                "35 STUDENT WALK NTU CANTEEN 2  ",
                "639548"
            ],
            [
                "CHEERS NTU EXECUTIVE CTR (CNYVIEW)(",
                "NO. 60 NANYANG VIEW #01-01 NANYANG EXECUTIVE CENTRE  ",
                "639673"
            ],
            [
                "BUZZ NTU",
                "50 NANYANG AVE NS3-01-07 NANYANG TECHNOLOGICAL UNIVERSITY  ",
                "639789"
            ],
            [
                "VIDA CAFE",
                "50 Nanyang Ave NTU   ",
                "639798"
            ],
            [
                "CHEERS NTU BLK 50 (FRNYAVE)(927)",
                "NANYANG AVE BLK 50   ",
                "639798"
            ],
            [
                "CELIA`S SWEET BAKERY",
                "20 NANYANG AVE NTU CNATEEN 2 (STALL 9)  ",
                "639809"
            ],
            [
                "THOW KWANG INDUSTRY PTE",
                "85 LORONG TAWAS   ",
                "639823"
            ],
            [
                "GOLDEN SPOON EATING HOUSE&CATERING-NANYA",
                "50 NANYANG WALK UNIT 01-01  ",
                "639929"
            ],
            [
                "JR F&B CONCEPTS PTE LTD",
                "450 JALAN AHMAD IBRAHIM   ",
                "639932"
            ],
            [
                "HARON MINI MARKET",
                "BLK 175 BOON LAY DRIVE UNIT 01-328  ",
                "640175"
            ],
            [
                "7-11 STORE 219 BOON LAY S.CTR",
                "BLK 221 BOON LAY PLACE 01-140/144 BOON LAY SHP/CTR  ",
                "640221"
            ],
            [
                "GOOD PRICE CENTRE - JURONG WEST",
                "BLK 276 JURONG WEST ST 25 UNIT 01-07  ",
                "640276"
            ],
            [
                "NANYANG MINIMART",
                "BLK 406 JURONG WEST ST 42 UNIT 01-599  ",
                "640406"
            ],
            [
                "I-ECON - HUI WAH S.M",
                "BLK 406 JURONG WEST ST 42 UNIT 01-601  ",
                "640406"
            ],
            [
                "HUIWAH SUPERMARKET",
                "BLK 406 JURONG WEST ST 42 #01-601  ",
                "640406"
            ],
            [
                "SA BAE PTE LTD",
                "BLK 414 JURONG WEST ST 42 UNIT 01-795  ",
                "640414"
            ],
            [
                "7-11 STORE 732 JURONG WEST",
                "BLK 442 JURONG WEST AVENUE 1 UNIT 01 754  ",
                "640442"
            ],
            [
                "I-ECON - LIM THIONG BENG MINI MART",
                "BLK 453 JURONG WEST ST 42 UNIT 01-K1  ",
                "640453"
            ],
            [
                "DIN HAO WEI RESTAURANT",
                "BLK 456 JURONG WEST 41 #01-726 ",
                "640456"
            ],
            [
                "7-11 STORE 133 JURONG W. BLK 492",
                "BLK 492 JURONG WEST ST 41 26299  ",
                "640492"
            ],
            [
                "SUN STORE",
                "BLK 498 JURONG WEST ST 41 UNIT 01-448  ",
                "640498"
            ],
            [
                "7-11 STORE 9.43.0 JURONG W. BLK 501",
                "BLK 501 JURONG WEST ST 51 NO 01 255  ",
                "640501"
            ],
            [
                "MALAR SUPERMARKET",
                "BLK 523 #01-K1  JURONG WEST ST 52  ",
                "640523"
            ],
            [
                "V.V. FINE MART",
                "BLK 523 JURONG WEST ST 52 UNIT 01-K1  ",
                "640523"
            ],
            [
                "LEE HENG",
                "BLK 539 JURONG WEST AVE 1 UNIT 01-K1  ",
                "640539"
            ],
            [
                "SOON CHYE PROVISION SHOP",
                "BLK 452 JURONG WEST ST 42 UNIT 01-K1  ",
                "640542"
            ],
            [
                "7-11 STORE 539 JURONG W. BLK 659",
                "BLK 659 JURONG EST STREET 65 No. 01-01S  ",
                "640659"
            ],
            [
                "MALLIGA MINI MART",
                "BLK 703 JURONG WEST ST 71 UNIT 01-108  ",
                "640703"
            ],
            [
                "ARCHANA STORES",
                "BLK 721 JURONG WEST ST 72 UNIT B1-102  ",
                "640721"
            ],
            [
                "MING HUAT MINIMART",
                "BLK 727 JUSRONG WEST AVE 5 #01-190  ",
                "640727"
            ],
            [
                "I-ECON - MING HUAT",
                "BLK 727 JURONG WEST AVE 5 UNIT 01-190  ",
                "640727"
            ],
            [
                "7-11 STORE 755 JURONG W. BLK 746",
                "BLK 746, JURONG WEST ST 73 UNIT 01-K1  ",
                "640746"
            ],
            [
                "33 CONVENIENCE MART",
                "BLK 762 JURONG WEST ST 75 UNIT 01-298 GEK POH SHOPPING CENTRE ",
                "640762"
            ],
            [
                "FRESHPICK SUPERMARKET",
                "BLK 814 JURONG WEST ST 81 UNIT 01-190  ",
                "640814"
            ],
            [
                "SOON HENG NAN DA",
                "BLK 907 JURONG WEST ST 91 UNIT 01-197  ",
                "640907"
            ],
            [
                "7-11 STORE 130 JURONG W. BLK 959",
                "BLK 959 JURONG WEST STREET 92 #01-156  ",
                "640959"
            ],
            [
                "42562",
                "BLK 959 JURONG WEST ST 92 NO 01 156  ",
                "640959"
            ],
            [
                "7-11 STORE 303 JURONG W. BLK 638A",
                "BLK 638A JURONG WEST STREET 61 #01-20 PIONEER MALL  ",
                "641638"
            ],
            [
                "7-11 STORE 756 JURONG W. BLK 668A",
                "Blk668A JURONG WEST ST 64 UNIT 01-120  ",
                "641668"
            ],
            [
                "7-11 STORE 354 JURONG W. BLK 988C",
                "BLK 988C JURONG WEST STREET 93 UNIT 01 645  ",
                "643988"
            ],
            [
                "7-11 STORE 517 JURONG W. BLK 678D",
                "BLK 678D JURONG WEST ST 64 No 01-345  ",
                "644678"
            ],
            [
                "7-11 STORE 541 JURONG W. BLK 735",
                "BLK 735 JURONG WEST, ST 75 UNIT 01-35  ",
                "645735"
            ],
            [
                "SODEXO - GOOGLE",
                "2 JURONG WEST DATA CENTRE STREET 23 (AVE 2)  ",
                "648195"
            ],
            [
                "LIFESTYLE DINING PTE LTD - E&B JP",
                "EGGS & BERRIES JURONG POINT #01-32 JURONG POINT 1 JURONG WEST CENTRAL 2 ",
                "648886"
            ],
            [
                "CHEERS JURONG POINT (FRJPT)(912)",
                "1 JURONG WEST CENTRAL 2 No 01-26B/C  ",
                "648886"
            ],
            [
                "PIZZA HUT - JURONG POINT",
                "1 JURONG WEST CENTRAL 2 UNIT 01-33 JURONG POINT SHOPPING CENTRE ",
                "648886"
            ],
            [
                "BILLY BOMBERS - JURONG POINT",
                "1 JURONG WEST CENTRAL 2 UNIT 02-20E JURONG POINT SHOPPING CENTRE ",
                "648886"
            ],
            [
                "",
                "#01-32 JURONG POINT  1 JURONG WEST CENTRAL 2  ",
                "648886"
            ],
            [
                "INTER-ASIA MULTI PROVIDER",
                "BLK 4 LAKEPOINT DRIVE UNIT 01-25 LAKEPOINT CONDO  ",
                "648924"
            ],
            [
                "CALTEX - JURONG WEST",
                "21 JURONG WEST ST 93 UNIT 01-01  ",
                "648964"
            ],
            [
                "MINISTRY OF DEFENCE 3 - JURONG CAMP II",
                "JURONG CAMP II 29 JURONG WEST ST 91  ",
                "649042"
            ],
            [
                "7-11 STORE 262 CIRCULAR RD",
                "58 CIRCULAR ROAD NO 01-01  ",
                "649413"
            ],
            [
                "7-11 STORE 611 SHELL JURONG WEST",
                "21 JURONG WEST AVENUE 5 .  ",
                "649481"
            ],
            [
                "CHEERS BY FP JURONG WEST (EJW)(678)",
                "10 JURONG WEST AVE 1 .  ",
                "649517"
            ],
            [
                "SPC - JURONG WEST 100",
                "100 JURONG WEST AVE 1 UNIT 01-01  ",
                "649519"
            ],
            [
                "7-11 STORE 533 LAKESIDE MRT",
                "No. 201 Boon Lay Way Unit 01- 03  ",
                "649845"
            ],
            [
                "7-11 STORE 469 BOON LAY MRT",
                "301 BOON LAY WAY 01 27/28 BOON LAY MRT STN  ",
                "649846"
            ],
            [
                "7-11 STORE 616 SHELL BOON LAY",
                "2 BOON LAY AVENUE .  ",
                "649960"
            ],
            [
                "MING JIA MINIMART",
                "BLK 109 BT BATOK WEST AVE 6 UNIT 01-09  ",
                "650109"
            ],
            [
                "7-11 STORE 9.37.0 B.BATOK BLK 132",
                "BLK 132 BUKIT BATOK AVE 6 N0 01 304  ",
                "650132"
            ],
            [
                "CHEERS B.BATOK BLK 153 (CHB1)(521)",
                "BLK 153 BUKIT BATOK ST 11 NO 01 296A  ",
                "650153"
            ],
            [
                "AL FATAH STORE",
                "BLK 161 BUKIT BATOK ST 11 UNIT 01-K1  ",
                "650161"
            ],
            [
                "SAY HENG KIOSK",
                "BLK 171 BT BATOK AVE 8 UNIT 01-K1  ",
                "650171"
            ],
            [
                "SAKTHI STORE",
                "BLK 177 BUKIT BATOK WEST AVE 8 #01-249  ",
                "650177"
            ],
            [
                "7-11 STORE 564 BUKIT BATOK WEST AVE",
                "BLK 177 BUKIT BATOK WEST AVENUE 8 UNIT 01 257  ",
                "650177"
            ],
            [
                "AUNG ZABU PTE LTD",
                "BLK 207 BUKIT BATOK ST 21 UNIT 01-116  ",
                "650207"
            ],
            [
                "MY MINI SHOP",
                "BLK 210 BUKIT BATOK ST 21 UNIT 01-K1  ",
                "650210"
            ],
            [
                "SING BEE & CO",
                "BLK 213 BT BATOK ST 21 UNIT 01-207  ",
                "650213"
            ],
            [
                "I-ECON - YEW LEONG MINI MART",
                "BLK 217 BT BATOK ST 21 UNIT 01-359  ",
                "650217"
            ],
            [
                "7-11 STORE 701 B.BATOK BLK 242",
                "BLK 242 BT BATOK EAST AVE 5 UNIT 01-K1  ",
                "650242"
            ],
            [
                "WRONG ENTRY.",
                "259 BUKIT BATOK EAST AVE 4 #01-K1 ",
                "650259"
            ],
            [
                "OUR LOVE CONVENIENCE STORE PTE LTD",
                "259 BUKIT BATOK  EAST AVE 4 #01-K1 ",
                "650259"
            ],
            [
                "JOO SIANG HUP KEE PROVISION",
                "BLK 265 BUKIT BATOK EAST AVE 4 UNIT 01-385  ",
                "650265"
            ],
            [
                "7-11 STORE 177 B.BATOK BLK 272",
                "BLK 272 BUKIT BATOK EAST AVE 4 NO 01-66/68  ",
                "650272"
            ],
            [
                "KOH SENG HIN",
                "BLK 323 BUKIT BATOK ST 33 UNIT 01-112  ",
                "650323"
            ],
            [
                "7-11 STORE 484 BT BATOK ST 33",
                "BLK 323 BT BATOK ST 33 UNIT 01 108  ",
                "650323"
            ],
            [
                "GOOD PRICE CENTRE - BT BATOK",
                "BLK 324 BUKIT BATOK ST 33 UNIT 01-45  ",
                "650324"
            ],
            [
                "GOOD PRICE CENTRE - BT BATOK",
                "BLK 324 BUKIT BATOK ST 33 UNIT 01-45  ",
                "650324"
            ],
            [
                "T S CHEW TRADING",
                "BLK 347 BT BATOK ST 34 UNIT 01-268  ",
                "650347"
            ],
            [
                "7-11 STORE 293 B.BATOK BLK 347",
                "BLK 347 BUKIT BATOK ST 34 NO 01-0262  ",
                "650347"
            ],
            [
                "FROGO MART",
                "BLK 410 BT. BATOK WEST AVE 4 UNIT 01-148  ",
                "650410"
            ],
            [
                "SIN BIN HENG MINIMARKET",
                "BLK 413 BT BATOK WEST AVE 4 UNIT 01-204  ",
                "650413"
            ],
            [
                "GIGA PROVISION SHOP",
                "BLK 415 BT BATOK WEST AVE 4 UNIT 01-274  ",
                "650415"
            ],
            [
                "7-11 STORE 798 B.BATOK BLK 505",
                "Blk 505 Bukit Batok Street 52 UNIT 01 141  ",
                "650505"
            ],
            [
                "7-11 STORE 758 B.BATOK BLK 523",
                "BLK 523 BT BATOK RD UNIT 01-721  ",
                "650523"
            ],
            [
                "CHEERS B.BATOK BLK 642 (BBCH)(302)",
                "BLK 642 BT BATOK CENTRAL 1.964285714  ",
                "650642"
            ],
            [
                "7-11 STORE 594 BUKIT BATOK WEST AVE",
                "BLK 395A BUKIT BATOK WEST AVE 5 Unit 03 05  ",
                "651395"
            ],
            [
                "7-11 STORE 719 B.BATOK BLK 289H",
                "BLK 289H BUKIT BATOK ST 25 UNIT 01-02  ",
                "657289"
            ],
            [
                "D`FINE CATERING SERVICE PTE LTD",
                "20 BUKIT BATOK CRESCENT ENTREPRISE CENTRE #03-05  ",
                "658080"
            ],
            [
                "CATHAY - WEST MALL",
                "1 BUKIT BATOK CENTRAL LINK UNIT 05-00 WEST MALL SHOPPING CENTRE ",
                "658713"
            ],
            [
                "SODEXO - DULWICH COLLEGE",
                "DULWICH COLLEGE 71 BUKIT BATOK WEST AVE 8  ",
                "658966"
            ],
            [
                "7-11 STORE 447 B.GOMBAK MRT",
                "802 BUKIT BATOK WEST AVE 5 01 12 BT GOMBAK MRT STN  ",
                "659083"
            ],
            [
                "FAIRPRICE XPRESS B.BATOK (EBBW)(613",
                "813 BUKIT BATOK .  ",
                "659084"
            ],
            [
                "7-11 STORE 608 SHELL BT BATOK WEST",
                "11 BUKIT BATOK WEST AVENUE 3 .  ",
                "659166"
            ],
            [
                "STRATEGY ENTERPRISE",
                "50 BUKIT BATOK ST 23 MINDVIEW BLDG #08-01  ",
                "659578"
            ],
            [
                "7-11 STORE 630 SHELL BT BATOK EAST",
                "28 BUKIT BATOK EAST AVENUE 6 .  ",
                "659760"
            ],
            [
                "CALTEX - BUKIT BATOK",
                "50 BUKIT BATOK EAST AVE 3 UNIT 01-01  ",
                "659879"
            ],
            [
                "7-11 STORE 593",
                "10 BUKIT BATOK CENTRA, #01-01 BUKIT BATOK MRT STATION  ",
                "659958"
            ],
            [
                "7-11 STORE 595",
                "10 BUKIT BATOK CENTRAL UNIT 01-13 BUKIT BATOK MRT STATION  ",
                "659958"
            ],
            [
                "FANTORI PETALS",
                "BLK 97 HILLVIEW AVE UNIT 01-33 THE PETALS  ",
                "669628"
            ],
            [
                "7-11 STORE 405 CHU LIN RD",
                "1 CHU LIN RD .  ",
                "669887"
            ],
            [
                "I TRADE",
                "BLK 255 BANGKIT ROAD UNIT 03-418  ",
                "670225"
            ],
            [
                "S E MART - BANGKIT",
                "BLK 259A #01-03 BANGKIT ROAD   ",
                "670259"
            ],
            [
                "I-ECON - GREEN PROVISION STORE",
                "BLK 435 BT PANJANG RING RD UNIT 01-661  ",
                "670435"
            ],
            [
                "7-11 STORE 107 FAJAR BLK 445",
                "BLK 445 FAJAR ROAD 01-556 FAJAR SHOPPING CENTRAL  ",
                "670445"
            ],
            [
                "M28 MINIMART - SEGAR",
                "BLK 465 SEGAR ROAD UNIT 01-150  ",
                "670465"
            ],
            [
                "M28 MINIMART (SG)",
                "BLK 485 SEGAR ROAD  #01-516  ",
                "670485"
            ],
            [
                "7-11 STORE 729 SENJA BLK 628",
                "BLK 628 SENJA ROAD UNIT 01 02  ",
                "670628"
            ],
            [
                "7-11 STORE 558 GANGSA BLK 152A",
                "Blk 152A Gangsa Road   ",
                "671152"
            ],
            [
                "ROSELAND DEPARTMENTAL STORE PTE LTD",
                "BLK 259 BUKIT PANJANG RING RD #01-10  ",
                "671259"
            ],
            [
                "7-11 STORE 9.82.0 BT PANJANG BLK 42",
                "BLK 259 BUKIT PANJANG RD NO 01 2014  ",
                "671259"
            ],
            [
                "7-11 STORE 155 JELEPANG BLK 524A",
                "BLK 524A JELEPANG RD #02-16/17 GREENRIDGE SHOPPING CTR  ",
                "671524"
            ],
            [
                "SENJA MINIMART",
                "BLK 603A SENJA ROAD UNIT 01-01  ",
                "671603"
            ],
            [
                "CUTECH GREEN VENTURES PTE LTD",
                "635C SENJA ROAD #01-04  ",
                "673635"
            ],
            [
                "7-11 STORE 528",
                "1 SEGAR ROAD ZHENGHUA COMMUNITY CLUB  ",
                "677738"
            ],
            [
                "7-11 STORE 292 BT PANJANG PLAZA",
                "1 JELEBU ROAD 02-01A BUKIT PANJANG PLAZA  ",
                "677743"
            ],
            [
                "PIZZA HUT - BT PANJANG",
                "NO. 1 JELEBU ROAD UNIT 02-33/35 BUKIT PANJANG PLAZA ",
                "677743"
            ],
            [
                "7-11 STORE 647 SHELL B.PANJANG",
                "772 UPPER BUKIT TIMAH ROAD .  ",
                "678122"
            ],
            [
                "CHEERS BY FP B.PANJANG (EBPJ)(632)",
                "926 UPPER BUKIT TIMAH RD .  ",
                "678205"
            ],
            [
                "7-11 STORE 9.88.0 BT PANJANG MRT",
                "950 Upper Bukit Timah Road Bukit Panjang DTL MRT Station #B2-02 ",
                "678213"
            ],
            [
                "MAY SPRINGS MINI MART",
                "21 PETIR RD #01-15  ",
                "678265"
            ],
            [
                "YI FENG ZA HUO SHANG DIAN",
                "BLK 17 DAIRY FARM RD #B1-02 DAIRY FARM ESTATE  ",
                "679043"
            ],
            [
                "I-ECON - YIFENG ZA HUA",
                "BLK 17 DAIRY FARM RD UNIT B1-02 DAIRY FARM ESTATE ",
                "679043"
            ],
            [
                "EACH-A-CUP - SENJA CASHEW CC",
                "101 BUKIT PANJANG ROAD UNIT 01-03  ",
                "679910"
            ],
            [
                "SPC - BUKIT PANJANG",
                "41 BUKIT PANJANG RING RD UNIT 01-01  ",
                "679945"
            ],
            [
                "7-11 STORE 489 TECK WHYE BLK 137",
                "BLK 137 TECH WHYE LANE 01 331  ",
                "680137"
            ],
            [
                "BUZZ CHOA CHU KANG",
                "BLK 230 CHOA CHU KANG CENTRAL  #01-K1  ",
                "680230"
            ],
            [
                "CHEERS CCK BLK 303 (FRCCK)(901)",
                "BLK 303 CHOA CHU KANG 01 723  ",
                "680303"
            ],
            [
                "7-11 STORE 9.99.0 CCK BLK 423",
                "BLK 423 CHOA CHU KANG AVE 3 NO 01 260  ",
                "680423"
            ],
            [
                "7-11 STORE 749 CCK BLK 475",
                "BLK 475 CHOA CHU KANG AVENUE 3 UNIT 01-21 SUNSHINE PLACE  ",
                "680475"
            ],
            [
                "BAN ENG LEE MINI MART",
                "BLK 486 CHOA CHU KANG AVE 5 UNIT 01-152  ",
                "680486"
            ],
            [
                "7-11 STORE 326 LIMBANG S.CTR BLK 53",
                "BLK 533 CHOA CHU KANG ST 51 01 19A LIMBANG SHOPPING CTR  ",
                "680533"
            ],
            [
                "I-ECON - FULL YEN TRADING",
                "BLK 601 CHOA CHU KANG ST 62 UNIT 01-09  ",
                "680601"
            ],
            [
                "FULL YEN TRADING",
                "BLK 601 CHOA CHU KANG ST 62 #01-09  ",
                "680601"
            ],
            [
                "KIAN HUAT PROVISION SHOP",
                "BLK 618 CHOA CHU KANG NORTH 7 UNIT 01-421  ",
                "680618"
            ],
            [
                "7-11 STORE 125 CCK BLK 623",
                "BLK 623 CHOA CHU KANG STREET 62 #01-216  ",
                "680623"
            ],
            [
                "EGOME PTE LTD",
                "BLK 624 CHOA CHU KANG ST 62 #01-222A YEW TEE SQUARE ",
                "680624"
            ],
            [
                "MING WAN HENG MINIMART & TRADING",
                "BLK 660 CHOA CHU KANG CRESCENT   ",
                "680660"
            ],
            [
                "7-11 STORE 573 TECKWHYE BLK 160A",
                "BLK 160A JALAN TECK WHYE LANE UNIT 01-02  ",
                "681160"
            ],
            [
                "BUZZ TECK WHYE",
                "BLK 165A TECK WHYE CRESCENT #01-343  ",
                "681165"
            ],
            [
                "MWH MINIMART",
                "BLK 462 CHOA CHU KANG AVE 4 UNIT 01-09  ",
                "681462"
            ],
            [
                "M28 MINIMART - CCK",
                "BLK 678A CHOA CHU KANG CRESENT UNIT 01-02  ",
                "681678"
            ],
            [
                "DOUBLE ONE MINIMARKET",
                "BLK 787B CHOA CHU KANG DR UNIT 01-239  ",
                "681787"
            ],
            [
                "E OCEAN MINIMART",
                "BLK 673B CHOA CHU KANG CRESCENT #01-02  ",
                "682673"
            ],
            [
                "OCEAN MINIMART",
                "BLK 673B CHOA CHU KANG CRESCENT UNIT 01-02  ",
                "682673"
            ],
            [
                "7-11 STORE 200 CCK BLK 689B",
                "BLK 689B CHOA CHU KANG DRIVE NO 01-306  ",
                "682689"
            ],
            [
                "ITE COLLEGE WEST",
                "ITE COLLEGE WEST 1 CHOA CHU KANG GROVE RECEIVING DEPARTMENT BLK2 LEVEL1 CARPARK LOTS 98&99",
                "688236"
            ],
            [
                "ITE WEST - SNACK",
                "1 CHOA CHU KANG GROVE STALL 1 #03-05  ",
                "688236"
            ],
            [
                "7-11 STORE 726 ITE WEST CCK",
                "1 CHOA CHU KANG GROVE SINGAPORE 688236  ",
                "688236"
            ],
            [
                "MINISTRY OF DEFENSE",
                "KRANJI CAMP AFPN 1155, 91 CHOA CHU KANG WAY #01-04 ",
                "688256"
            ],
            [
                "SFI-UKJB KRANJI CAMP",
                "911  CHOA CHU KANG WAY   ",
                "688256"
            ],
            [
                "SFI-UKJC D14-(ALTC) KRANJI",
                "151 CHOA CHU KANG WAY   ",
                "688256"
            ],
            [
                "FAIRPRICE XPRESS CCK WAY (ECKW)(618",
                "31 CHOA CHU KANG WAY .  ",
                "688786"
            ],
            [
                "SFI-UKJA D1 21SA/41SAR KRANJI",
                "310 LORONG KEBASI D1 KRANJI CAMP  ",
                "688788"
            ],
            [
                "SFI-USTZ B2 HQSIG STAGMONT",
                "312 STAGMONT RD B2 STAGMONT CAMO CCO  ",
                "688794"
            ],
            [
                "SFI-USTZ NON MUSLIM COOKHOUSE",
                "B2-STAGMONT CAMP BLK 209 STAGMONT ROAD  ",
                "688794"
            ],
            [
                "S123 MINIMART",
                "BLK 2A HONGSAN WALK #B1-01  ",
                "689047"
            ],
            [
                "HENG HENG TRANSPORT COMPANY",
                "BLK 2 HONG SAN WALK PALM GARDEN CONDOMINUIM #B1-01  ",
                "689047"
            ],
            [
                "CHEERS YEW TEE MRT (FRSYT)(910)",
                "61 CHOA CHU KANG DRIVE UNIT 01-09  ",
                "689715"
            ],
            [
                "CHEERS BY FP CCK DRIVE (EMDP)(674)",
                "50 CHOA CHU KANG DR .  ",
                "689716"
            ],
            [
                "7-11 STORE 656 SHELL CCK",
                "20 CHOA CHU KANG DRIVE .  ",
                "689717"
            ],
            [
                "CHEERS CCK MRT (SCCK)(562)",
                "10 CHUA CHU KANG AVE4 CCK MRT STATION  ",
                "689810"
            ],
            [
                "7-11 STORE 238 LOT 1 S.CTR",
                "21 CHOA CHU KANG AVE 4 01-07A LOT 1 SHOPPERS MALL  ",
                "689812"
            ],
            [
                "PIZZA HUT - LOT ONE",
                "21 CHOA CHU KANG AVE 4 UNIT 02-20 LOT ONE SHOPPER`S MALL ",
                "689812"
            ],
            [
                "DELIFRANCE SINGAPORE PTE LTD",
                "21 CHOA CHU KANG AVE 4 UNIT 03-12  ",
                "689812"
            ],
            [
                "NANDO`S - LOT ONE",
                "21 CHOA CHU KANG AVE 4 UNIT 01-06/07 LOT ONE SHOPPING  ",
                "689812"
            ],
            [
                "FAIRPRICE XPRESS CCK AVE 3 (ECCK)(6",
                "50 CHOA CHU KANG AVE 3 .  ",
                "689858"
            ],
            [
                "TONG XING FA SUPERMARKET",
                "BLK 410 CHOA CHU KANG AVE 3 UNIT 01-341  ",
                "690410"
            ],
            [
                "COUNTRY FOODS - HTAC CCK",
                "COOKHOUSE @ HTAC NON-MUSLIM BLK 10 MESS HALL 501 OLD CHOA CHU KANG RD COOKHOUSE EXECUTIVE",
                "698928"
            ],
            [
                "KEAT HONG CAMP CANTEEN",
                "661 OLD CHOA CHU KANG RD BLK 12 UNIT 01-01  ",
                "698930"
            ],
            [
                "KBS ENTERPRISE",
                "PAYA LEBAR AIRPORT   ",
                "698930"
            ],
            [
                "YI HU FISH FARM TRADING",
                "71 JALAN LEKAR   ",
                "698950"
            ],
            [
                "SFI-UCLA B10 4 SIR LIM CHU KANG",
                "50 OLD LIM CHU KANG ROAD B10 4 SIR LIM CHU KANG CAMP  ",
                "710000"
            ],
            [
                "MAX KOI FARM",
                "251 NEO TIEW CRESCENT   ",
                "718835"
            ],
            [
                "MINISTRY OF DEFENCE 3 - SUNGEI GEDONG",
                "SUNGEI GEDONG CAMP 252 SUNGEI GEDONG ROAD #02-05  ",
                "718844"
            ],
            [
                "STAR SHINE WESTERN",
                "BLK 214 SUNGEI GEDONG CAMP #01-05  ",
                "718919"
            ],
            [
                "SFI-USGA ATC SUNGEI GEDONG",
                "SUNGEI GEDONG CAMP BLK 105A  ",
                "718919"
            ],
            [
                "SMART ENERGY PTE LTD (MANDAI)",
                "1 MANDAI LINK   ",
                "728650"
            ],
            [
                "7-11 STORE 648 (SHELL WOODLANDS MAN",
                "695 MANDAI RD .  ",
                "729752"
            ],
            [
                "SINGAPORE ZOOLOGICAL GARDEN-RIVER SAFARI",
                "RIVER SAFARI TEA HOUSE 80 MANADAI LAKE ROAD  ",
                "729826"
            ],
            [
                "B 8 L ENTERPRISE (S) PTE LTD",
                "BLK 1765 GEYLANG BAHRU UNIT 01-06  ",
                "729826"
            ],
            [
                "7-11 STORE 574 WOODLANDS BLK 105",
                "BLK 105 WOODLANDS STREET 13 UNIT 01 K1  ",
                "730105"
            ],
            [
                "7-11 STORE 427 MARSILING BLK 131",
                "BLK 131 MARSILING RISE 01 194  ",
                "730131"
            ],
            [
                "I-ECON - UNITED SUPERMART",
                "BLK 136 MARSILING ROAD UNIT 01-2186  ",
                "730136"
            ],
            [
                "VALE STORE - WOODLANDS",
                "BLK 154 WOODLANDS ST 13 UNIT 01-K1  ",
                "730154"
            ],
            [
                "7-11 STORE 580 MARSILING BLK 204",
                "Blk 204, Marsiling Drive #01-204  ",
                "730204"
            ],
            [
                "7-11 STORE 480 WOODLANDS",
                "BLK 304 WOODLANDS STREET 31 01 141  ",
                "730304"
            ],
            [
                "COLLIN`S GRILLED BENTO - WOODLANDS",
                "306 WOODLANDS ST 31 #01-19  ",
                "730306"
            ],
            [
                "ANGEL MINIMART PTE LTD",
                "BLK 326 WOODLANDS ST 32 #01-119  ",
                "730326"
            ],
            [
                "7-11 STORE 596 WOODLANDS BLK 326",
                "BLK 326 WOODLAND ST 32 #01-123   ",
                "730326"
            ],
            [
                "KM EZ MARTS",
                "BLK 335 WOODLANDS ST 32 #01-K1  ",
                "730335"
            ],
            [
                "LAI LAI MINIMART",
                "BLK 355 WOODLANDS AVE 1 UNIT 01-707  ",
                "730355"
            ],
            [
                "7-11 STORE 267 VISTA POINT",
                "BLK 548 WOODLANDS DR 44 01 09 VISTA POINT  ",
                "730548"
            ],
            [
                "CHEERS WOODLANDS BLK 548 (FRWL)(907",
                "BLK 548 WOODLANDS DR 44 01 06 VISTA POINT  ",
                "730548"
            ],
            [
                "VIDEKS GROCERS (326)",
                "#01-117 BLK 326 WOODLANDS ST 32   ",
                "730726"
            ],
            [
                "T K T MINISUPERMARKET",
                "BLK 743 WOODLANDS CIRCLE UNIT 01-465  ",
                "730743"
            ],
            [
                "7-11 STORE 134 WOODLANDS BLK 768",
                "BLK 768 WOODLANDS AVE 6 NO 01-06  ",
                "730768"
            ],
            [
                "M K MART AT 795",
                "BLK 795 WOODLANDS DR 72 UNIT 01-13  ",
                "730795"
            ],
            [
                "7-11 STORE 540",
                "BLK 827 WOODLANDS ST 81 No. 01-92  ",
                "730827"
            ],
            [
                "WONG LI MINI MART",
                "BLK 832 WOODLANDS ST 83 UNIT 01-69  ",
                "730832"
            ],
            [
                "7-11 STORE 313 WOODLANDS BLK 883",
                "BLK 883 WOODLANDS ST 82 NO 01-494  ",
                "730883"
            ],
            [
                "7-11 STORE 131 WOODLANDS BLK 768",
                "BLK 888 WOODLANDS DR 50 NO 01-705  ",
                "730888"
            ],
            [
                "CHEERS WOODLANDS BLK 5A (CWL)(538)",
                "BLK 5A WOODLANDS CENTRE RD 02 182A  ",
                "731005"
            ],
            [
                "7-11 STORE 123 WOODLANDS BLK 678A",
                "BLK 678A WOODLANDS AVE 6 NO 01-10  ",
                "731678"
            ],
            [
                "FORTUNE SUPERMARKET PTE LTD - WOODLANDS",
                "BLK 780 WOODLANDS CRESCENT #01-01  ",
                "731780"
            ],
            [
                "YEONG HENG MINIMART",
                "BLK 895B WOODLANDS DR 50 #01-24  ",
                "731895"
            ],
            [
                "I-ECON - YEONG HENG MINIMART",
                "BLK 895A WOODLANDS DRIVE 50 UNIT 01-24  ",
                "731895"
            ],
            [
                "VIDEKO GROCER",
                "BLK 686C #01-90 WOODLANDS DRIVE 73  ",
                "733686"
            ],
            [
                "CANDY KIOSK 1",
                "1 TURF CLUB AVENUE SINGAPORE RACE COURSE  ",
                "738078"
            ],
            [
                "7-11 STORE 298 CAUSEWAY",
                "1 WOODLAND SQUARE UNIT 01-K09 CAUSEWAY POINT  ",
                "738099"
            ],
            [
                "CATHAY - CAUSEWAY POINT",
                "NO. 1 WOODLANDS SQUARE UNIT 07-00 CAUSEWAY POINT SHOPPING ",
                "738099"
            ],
            [
                "PIZZA HUT - CAUSEWAY POINT",
                "NO. 1 WOODLANDS SQUARE UNIT B1-25 CAUSEWAY POINT SHOPPING CENTRE ",
                "738099"
            ],
            [
                "EACH A CUP - CAUSEWAY POINT",
                "1 WOODLANDS SQUARE UNIT B1-K13 CAUSEWAY POINT SHOPPING ",
                "738099"
            ],
            [
                "MM SUNDRY SHOP",
                "27 WOODLANDS SECTOR 1 UNIT 01-70  ",
                "738252"
            ],
            [
                "7-11 STORE 443 ADMIRALTY MRT",
                "70 WOODLANDS AVE 7 01 03 ADMIRALTY MRT STATION  ",
                "738344"
            ],
            [
                "AJMIR STORE PTE LTD",
                "70 WOODLANDS AVENUE UNIT 02-K1 @ OVERHEAD BRIDGE  ",
                "738344"
            ],
            [
                "COMPASS GROUP - GSP FAB 2",
                "60 WOODLANDS INDUSTRIAL PARK D STREET 2  ",
                "738406"
            ],
            [
                "CS TAY FOODS PTE LTD - WOODLANDS",
                "64 WOODLANDS TERRACE WOODLANDS EAST INDUSTRIAL ESTATE  ",
                "738468"
            ],
            [
                "7-11 STORE 603 SHELL WOODLANDS",
                "20 WOODLANDS AVENUE 9 .  ",
                "738954"
            ],
            [
                "KOUFU - STALL 8 -REPUBLIC POLY",
                "9 WOODLANDS AVENUE 9 REPUBLIC POLY CANTEEN A  ",
                "738964"
            ],
            [
                "CHEERS REPUBLIC POLY(CRPPLY)(862)",
                "One Stop Centre, 9 Woodlands Ave 9, #01-04/05  ",
                "738964"
            ],
            [
                "7-11 STORE 401 REPUBLIC POLY",
                "NO. 9 WOODLANDS AVENUE 9 #01-04/05 REPUBLIC POLYTECHNIC  ",
                "738964"
            ],
            [
                "CREAMY DUCK - BREAKTIME",
                "NO. 9 WOODLANDS AVE 9 3RD FLOOR W6 BLDG REPUBLIC POLYTECHNIC THE LAWN FOODCOURT ",
                "738964"
            ],
            [
                "CREAMY DUCK - RP WAFFLES & CREPES",
                "NO. 9 WOODLANDS AVE 9 REPUBLIC POLYTECHNIC OPPOSITE SPORTS HALL ",
                "738964"
            ],
            [
                "BOOKLINK PTE LTD - WOODLANDS",
                "NO. 9 WOODLANDS AVE 9 UNIT 01-01 REPUBLIC POLYTECHNIC ",
                "738964"
            ],
            [
                "CREAMY DUCK - BREAKTIME",
                "NO. 9 WOODLANDS AVE 9 3RD FLOOR W6 BLDG REPUBLIC POLYTECHNIC ",
                "738964"
            ],
            [
                "PRO 3 INSTITUTIONAL CATERING - WOODLANDS",
                "1 WOODLANDS AVENUE 8   ",
                "738972"
            ],
            [
                "7-11 STORE 300 MARSILING MRT",
                "NO. 71 WOODLANDS AVENUE 3 #01-04 MARSILING MRT STATION  ",
                "739044"
            ],
            [
                "EQUINE SANCTUARY PTE LTD",
                "NO. 10 WOODLANDS AVE 3 SINGAPORE TURF CLUB RIDING CENTRE  ",
                "739045"
            ],
            [
                "7-11 STORE 118 THE WOODGROVE",
                "BLK 30 WOODLANDS AVE 1 01 20 THE WOODGROVE  ",
                "739065"
            ],
            [
                "FAIRPRICE XPRESS WDLANDS AVE (EWL1)",
                "50 WOODLANDS AVE 1 .  ",
                "739066"
            ],
            [
                "7-11 STORE 605 SHELL MARSILING",
                "10 MARSILING ROAD .  ",
                "739109"
            ],
            [
                "MANGROVE WETLAND RETAIL & SEAFOOD CENTER",
                "60 KRANJI WAY  (CAR PARK C)  ",
                "739453"
            ],
            [
                "SPC - WOODLANDS",
                "250 ADMIRALTY ROAD   ",
                "739981"
            ],
            [
                "7-11 STORE 304 SEMBAWANG BLK 335",
                "Blk 335 Sembawang Close Unit 01 473  ",
                "750335"
            ],
            [
                "7-11 STORE 738 SEMBAWANG BLK 406",
                "Blk 406 SEMBAWANG DRIVE Unit 01 822  ",
                "750406"
            ],
            [
                "FORTUNE SUPERMARKET PTE LTD - SEMBAWANG",
                "BLK 463 SEMBAWANG DRIVE UNIT 01-02  ",
                "750463"
            ],
            [
                "IKEA MINIMART",
                "BLK 505 CANBERRA LINK SEMBAWANG #01-01  ",
                "750505"
            ],
            [
                "7-11 STORE 248 SEMBAWANG BLK 511",
                "BLK 511 CANBERRA ROAD 01 06 SEMBAWANG MART  ",
                "750511"
            ],
            [
                "GO2MART WELLINGTON",
                "501A WELLINGTON CIRCLE #01-26  ",
                "751501"
            ],
            [
                "VIDEKS GROCERS (MONTREAL)",
                "BLK 590A MONTREAL DRIVE #01-27 SEMBAWANG  ",
                "751590"
            ],
            [
                "FRUTO NINO LLP",
                "NO 2 WOODLANDS INDUSTRIAL PARK E4 SSDC CANTEEN  ",
                "757387"
            ],
            [
                "MICRON SEMICONDUCTOR ASIA PTE LTD - PRO3",
                "1 NORTH COAST DRIVE   ",
                "757432"
            ],
            [
                "REVADA FOOD & SERVICES PTE LTD",
                "8A ADMIRALTY ST FOOD EXCHANGE #04-24/25 ",
                "757437"
            ],
            [
                "CHEERS SUN PLAZA (CSUN)(859)",
                "30 Sembawang Drive #01-01 Sun Plaza  ",
                "757713"
            ],
            [
                "PRO 3 INSTITUTIONAL CATERING - YHS CANT",
                "YHS CANTEEN 3 SENOKO WAY  ",
                "758057"
            ],
            [
                "CANADIAN PIZZA YISHUN",
                "369 SEMBAWANG ROAD #01-02 SEMBAWANG COTAGE  ",
                "758382"
            ],
            [
                "SPC - SEMBAWANG",
                "588 SEMBAWANG ROAD   ",
                "758448"
            ],
            [
                "CHEERS BY FP SEMBAWANG B (ESBB)(672",
                "590 SEMBAWANG RD .  ",
                "758450"
            ],
            [
                "CHEERS BY FP SEMBAWANG A (ESBA)(673",
                "593 SEMBAWANG RD .  ",
                "758452"
            ],
            [
                "7-11 STORE 628 SHELL SEMBAWANG",
                "595 SEMBAWANG ROAD .  ",
                "758454"
            ],
            [
                "7-11 STORE 9.41.0 JALAN LEGUNDI",
                "8 JALAN LEGUNDI UNIT 01-01/02  ",
                "759274"
            ],
            [
                "7-11 STORE 296 SEMBAWANG MRT",
                "11 CANBERRA ROAD 01-08 SEMBAWANG MRT STATION  ",
                "759775"
            ],
            [
                "7-11 STORE 9.17.0 YISHUN BLK 102",
                "BLK 102 YISHUN AVE 5 01-137  ",
                "760102"
            ],
            [
                "I-ECON - KIM ENG MINI SUPERMARKET",
                "BLK 103 YISHUN RING ROAD UNIT 01-79  ",
                "760103"
            ],
            [
                "CHEERS YISHUN BLK 110 (CHYR)(530)",
                "BLK 110 YISHUN RING RD NO 01 389  ",
                "760110"
            ],
            [
                "7-11 STORE 171 YISHUN BLK 123",
                "BLK 123 YISHUN STREET 11 NO 01-495  ",
                "760123"
            ],
            [
                "VALE STORE - YISHUN",
                "BLK 140 YISHUN RING RD UNIT 01-K1  ",
                "760140"
            ],
            [
                "7-11 STORE 308 YISHUN BLK 156",
                "BLK 156 YISHUN STREET NO 01-120  ",
                "760156"
            ],
            [
                "ASERET TRADING",
                "BLK 173 YISHUN AVE 7 #01-827  ",
                "760173"
            ],
            [
                "I-ECON - ASERET",
                "BLK 173 YISHUN AVE 7 UNIT 01-827  ",
                "760173"
            ],
            [
                "7-11 STORE 476 YISHUN BLK 256",
                "BLK 256 YISHUN RING RD 01 1003 LEVEL 1  ",
                "760256"
            ],
            [
                "7-11 STORE 375 YISHUN BLK 285",
                "BLK 285 YISHUN AVE 6 NO 01-04  ",
                "760285"
            ],
            [
                "TOH ENG LEE MINI SUPERMARKET",
                "BLK 291 YISHUN ST 22 #01-347  ",
                "760291"
            ],
            [
                "7-11 STORE 9.60.0 YISHUN BLK 291",
                "BLK 291 YISHUN ST 22 NO 01 337  ",
                "760291"
            ],
            [
                "I-ECON - TOH ENG LEE",
                "BLK 291 YISHUN ST 22 UNIT 01-347  ",
                "760291"
            ],
            [
                "SMART 99 PTE LTD",
                "BLK 317 YISHUN AVE 9  #01-04  ",
                "760317"
            ],
            [
                "M28 MINIMART - YISHUN",
                "BLK 348 YISHUN AVE 11 UNIT 01-01  ",
                "760348"
            ],
            [
                "7-11 STORE 104 YISHUN BLK 413",
                "BLK 413 YISHUN RING ROAD YISHUN RING RD  ",
                "760413"
            ],
            [
                "METRO FRESH TRADING & MART PTE LTD",
                "VLK 504 #01-04 YISHUN ST 51  ",
                "760504"
            ],
            [
                "PIAK LAN HIONG",
                "BLK 605 YISHUN ST 61 #01-311   ",
                "760605"
            ],
            [
                "I-ECON - PIAK LAN HIONG",
                "BLK 605 YISHUN ST 61 UNIT 01-311  ",
                "760605"
            ],
            [
                "7-11 STORE 346 YISHUN BLK 627",
                "BLK 627 YISHUN ST 61 NO 01-61  ",
                "760627"
            ],
            [
                "7-11 STORE 314 YISHUN BLK 641",
                "Blk 641, Yishun Street 61 Unit 01 204  ",
                "760641"
            ],
            [
                "7-11 STORE 285 YISHUN BLK 654",
                "BLK 654 YISHUN AVENUE 4 #01-439  ",
                "760654"
            ],
            [
                "I-ECON - HOCK TAI CHEONG",
                "BLK 664 YISHUN AVE 4 UNIT 01-279  ",
                "760664"
            ],
            [
                "ZENG MAO SHENG",
                "BLK 716 YISHUN ST 71 UNIT 01-252  ",
                "760716"
            ],
            [
                "HARVEST MOON CORNER",
                "BLK 726 YISHUN ST 71 UNIT 01-K1  ",
                "760726"
            ],
            [
                "CHEERS YISHUN BLK 743 (FRY5)(913)",
                "BLK 743 YISHUN AVE 5 No 01-546  ",
                "760743"
            ],
            [
                "7-11 STORE 9.59.0 YISHUN BLK 807",
                "BLK 807 YISHUN RING RD NO 01 4217  ",
                "760807"
            ],
            [
                "SERVICE POINT UNLIMITED",
                "BLK 868 YISHUN ST 81 UNIT 01-87  ",
                "760868"
            ],
            [
                "I-ECON GO2MART CANBERRA",
                "#01-10 EIGHT COURTYARDS 8 CANBERRA DRIVE  ",
                "768141"
            ],
            [
                "GO2MART CANBERRA",
                "#01-10 EIGHT COURTYARDS 8 CANBERRA DRIVE  ",
                "768141"
            ],
            [
                "7-11 STORE 609 SHELL YISHUN AVE 5",
                "1 YISHUN STREET 11 .  ",
                "768642"
            ],
            [
                "SPC - YISHUN",
                "599 YISHUN RING ROAD   ",
                "768683"
            ],
            [
                "CHEERS YISHUN GV (CYSH10)(831)",
                "51 YISHUN CENTRAL 1 UNIT 01-06/01-K2   ",
                "768794"
            ],
            [
                "CHEERS KTPH YISHUN (CKTPH)(599)",
                "90 YISHUN CENTRAL UNIT 01-07  ",
                "768828"
            ],
            [
                "FAIRPRICE XPRESS YISHUN (EYSH)(617)",
                "10 YISHUN AVE 9 .  ",
                "768888"
            ],
            [
                "THE FOOD BARN - YISHUN",
                "1 YISHUN AVENUE 7   ",
                "768923"
            ],
            [
                "JO`S CAFE BAR",
                "60 YISHUN AVE 4 @01-V4  ",
                "769027"
            ],
            [
                "7-11 STORE 332 KHATIB MRT",
                "NO. 210 YISHUN AVENUE 2 #01-03A KHATIB MRT STATION  ",
                "769092"
            ],
            [
                "THE CREPE SHOP",
                "930 YISHUN AVE 2 #B1-09/12G  ",
                "769098"
            ],
            [
                "7-11 STORE 187 NORTHPOINT",
                "BLK 930 YISHUN AVENUE 2 No.01-05/06 NORTH POINT SHOPPING CTR ",
                "769098"
            ],
            [
                "PIZZA HUT - NORTH POINT",
                "930 YISHUN AVENUE 2 UNIT B1-40/41 NORTH POINT SHOPPING CENTRE ",
                "769098"
            ],
            [
                "WRONG",
                "ORCHID COUNTRY CLUB BANQUET NON-MUSLIM KITCHEN 1 ORCHID CLUB RD ",
                "769162"
            ],
            [
                "NTUC FOODFARE COOPERATIVE LTD-ORCHID",
                "ORCHID COUNTRY CLUB (BANQUET NON-MUSLIM KITCHEN) 1 ORCHID CLUB ROAD  ",
                "769162"
            ],
            [
                "BOTTLE TREE PARK",
                "81 LORONG CHENCHARU   ",
                "769198"
            ],
            [
                "7-11 STORE 297 TRANSIT",
                "17 TRANSIT ROAD TRANSIT ROAD  ",
                "778889"
            ],
            [
                "SFI-SOCE/UNSB",
                "BLK 586 NEE SOON CAMP TRANSIT RD  ",
                "778901"
            ],
            [
                "CALTEX - HH& PARTNERS PTE LTD",
                "62 SEMBAWANG ROAD #01-01  ",
                "779089"
            ],
            [
                "CALTEX - NOTINUSE",
                "62 SEMBAWANG ROAD   ",
                "779089"
            ],
            [
                "7-11 STORE 618 SHELL YISHUN RING",
                "3700 YISHUN RING ROAD .  ",
                "786960"
            ],
            [
                "CHEERS TYP BLK 109 (FRTP)(904)",
                "BLK 109 TOA PAYOH LOR 1 NO 01 310  ",
                "787103"
            ],
            [
                "7-11 STORE 9.06.0 UPP THOMSON",
                "912 UPP THOMSON RD .  ",
                "787113"
            ],
            [
                "7-11 STORE 622 SHELL UPP THOMSON",
                "1200 UPPER THOMSON ROAD .  ",
                "787124"
            ],
            [
                "7-11 STORE 718 FERNVALE BLK 403A",
                "BLK 403A FERNVALE LANE UNIT 01-177 UNIT 01-177  ",
                "791403"
            ],
            [
                "JAYA AMBIGA TRADING PTE LTD",
                "BLK 432A SENGKANG WEST WAY #01-01  ",
                "791432"
            ],
            [
                "EN2ICE PTE LTD",
                "BLK 403C FERNVALE LANE UNIT 04-157  ",
                "793403"
            ],
            [
                "7-11 STORE 492 FERNVALE POINT",
                "21 SENGKANG WEST AVE 01 18 FERNVALE POINT  ",
                "797650"
            ],
            [
                "CHEERS SELETAR MALL (CSLML)(856)",
                "33 Sengkang West Avenue #01-57/58/59  ",
                "797653"
            ],
            [
                "SFI-USLA C6 CCO-SLT SELETAR",
                "179 PICADILLY RD C6 SELETAR CAMP  ",
                "797778"
            ],
            [
                "SELETAR COUNTRY CLUB",
                "101 SELETAR CLUB ROAD SELETAR COUNTRY CLUB  ",
                "798273"
            ],
            [
                "CHEERS BY FP JLN KAYU (EJKU)(668)",
                "215 JALAN KAYU .  ",
                "799439"
            ],
            [
                "THASEVI FOOD FAMOUS",
                "237/239 JALAN KAYU JALAN KAYU PRATA RESTAURANT  ",
                "799461"
            ],
            [
                "7-11 STORE 613 SHELL SELETAR HILL",
                "298 YIO CHU KANG ROAD .  ",
                "805908"
            ],
            [
                "CHEERS BY FP YCK B (EYCB)(669)",
                "299 YIO CHU KANG RD .  ",
                "805909"
            ],
            [
                "7-11 STORE 394 GREENWICH VILLAGE",
                "1 SELETAR ROAD UNIT 01 01 GREENWICH VILLAGE  ",
                "807011"
            ],
            [
                "I-ECON - TOP CHOICE SUPERMARKET",
                "84 BAYSHORE ROAD UNIT 01-38 COASTA DEL S01 ",
                "809810"
            ],
            [
                "WRONG-CODE",
                "80 BOULEVARD #03-03 CHANGI AIRPORT T1 DEPARTMENT TRANSIT LOUNGE WEST ",
                "819642"
            ],
            [
                "PLAZA PREMIUM LOUNGE - (T1)",
                "AEROTEL HOTEL  TERMINAL 1,DEPARTURE TRANSIT LOUNGE WEST  ",
                "819642"
            ],
            [
                "7-11 STORE 714 CHANGI T1",
                "80 AIRPORT BOULEVARD Unit B1 01 CHANGI AIRPORT TERMINAL 1  ",
                "819642"
            ],
            [
                "PIZZA HUT - CHANGI T1",
                "CHANGI AIRPORT TERMINAL 1 UNIT 02-86 DEPARTURE HALL NEAR SKYTRAIN ",
                "819642"
            ],
            [
                "SO CHOCOLATE/THE CHOCOLATIERS - B1",
                "#02-095-03 DEPARTURE, TERMINAL 2 SINGAPORE CHANGI AIRPORT 60 AIRPORT BLVD ",
                "819643"
            ],
            [
                "SO CHOCOLATE/THE CHOCOLATIERS - B2",
                "#026-079 DEPARTURE, TERMINAL 2 SINGAPORE CHANGI AIRPORT 60 AIRPORT BLVD ",
                "819643"
            ],
            [
                "SO CHOCOLATE/THE CHOCOLATIERS - B3",
                "#027-025 DEPARTURE, TERMINAL 2 SINGAPORE CHANGI AIRPORT 60 AIRPORT BLVD ",
                "819643"
            ],
            [
                "SO CHOCOLATE/THE CHOCOLATIERS - B4",
                "#026-126-01 DEPARTURE, TERMINAL 2 SINGAPORE CHANGI AIRPORT 60 AIRPORT BLVD ",
                "819643"
            ],
            [
                "CHEERS CHANGI T2 DEP. (CT2DH)(594)",
                "S`pore Changi Airport Terminal 2 Departure Hall Unit No 026-039-01  ",
                "819643"
            ],
            [
                "NANDO`S - CHANGI T2",
                "60 AIRPORT BLVD #036-057 LEVEL 3 VIEWING MALL SOUTH CHANGI AIRPORT TERMINAL 2 ",
                "819643"
            ],
            [
                "COFFEE CLUB - TERMINAL 3",
                "65 AIRPORT BOULEVRAD L2LF1  ",
                "819663"
            ],
            [
                "CHEERS CHANGI T3 ARR. (CAA3)(574)",
                "NO. 65 AIRPORT BOULEVARD BASEMENT 2 NORTH #01-24 SINGAPORE CHANGI AIRPORT T3 ",
                "819663"
            ],
            [
                "CHEERS PUNGGOL BLK 168 (FRPG)(934)",
                "BLK 168 PUNGGOL FIELD #01-04 PUNGGOL PLAZA  ",
                "820168"
            ],
            [
                "7-11 STORE 736 PUNGGOL BLK 639",
                "BLK 639 PUNGGOL DRIVE Unit 01 02  ",
                "820639"
            ],
            [
                "BEST STAR ENTERPRISE",
                "BLK 201A PUNGGOL FIELD #01-202  ",
                "821201"
            ],
            [
                "NICE MINIMART PTE LTD-PUNGGOL",
                "PUNGGOL BLK 266C #01-376   ",
                "821266"
            ],
            [
                "FOOTSIE CONVENIENT STORE",
                "400 ORCHARD RD #B1-04  ",
                "821306"
            ],
            [
                "U STARS SUPERMARKET (PUNGGOL)",
                "BLK 261 PUNGGOL WAY #01-02  ",
                "822261"
            ],
            [
                "BUZZ PUNGGOL",
                "BLK 211D PUNGGOL WALK  #01-665  ",
                "824211"
            ],
            [
                "BUZZ PUNGGOL",
                "BLK 211D PUNGGOL WALK #01-665   ",
                "824211"
            ],
            [
                "7-11 STORE 9.32.0 PUNGGOL SETTLEMEN",
                "3 PUNGGOL POINT ROAD UNIT 01-06  ",
                "828694"
            ],
            [
                "HAI BIN P ENTERPRISE PTE LTD",
                "6 TEBING LANE UNIT 01-04  ",
                "828835"
            ],
            [
                "SPC - PUNGGOL",
                "100 PUNGGOL CENTRAL   ",
                "828839"
            ],
            [
                "HAPPY MINIMART (NIBONG LRT)",
                "41 PUNGGOL WAY   ",
                "828862"
            ],
            [
                "HAPPY MINIMART (SOO TECK LRT)",
                "21 PUNGGOL WAY SOO TECH LRT  ",
                "828864"
            ],
            [
                "CHEERS PUNGGOL MRT (SPUNGOL)(569)",
                "70 PUNGGOL CENTRAL PUNGGOL NEL MRT STATION UNIT 01-02  ",
                "828868"
            ],
            [
                "GALLOP STABLE (S) PTE LTD - PUNGGOL",
                "900 PUNGGOL RD   ",
                "829168"
            ],
            [
                "7-11 STORE 672 SHELL PUNGGOL RD",
                "821 PUNGGOL ROAD   ",
                "829169"
            ],
            [
                "7-11 STORE 551 PUNGGOL MARINA",
                "NO. 600 PUNGGOL 17TH AVE   ",
                "829734"
            ],
            [
                "DESIGNER PAD DRINKS & DESSERTS",
                "Blk 28 Temasek Polytechnic   ",
                "NA"
            ],
            [
                "LIFESTYLE RECREATION PTE LTD - EC G1",
                "1490 EAST COAST PARKWAY EAST COAST CARPARK G1  ",
                "NA"
            ],
            [
                ".",
                ".   ",
                "NA"
            ],
            [
                "WRONG ENTRY",
                "WRONG ENTRY   ",
                "NA"
            ],
            [
                "WRONG ENTRY",
                "    ",
                "NA"
            ],
            [
                "CREATION MYANMAR CO LTD",
                "NO. 15-18@ND FLOOR MYIT TA YEIK MEN HOUSING. THOMAIN RD, TAMIWE YANGON ",
                "NA"
            ]
        ],
        "version": "1.0"
    },
    "target": {
        "application": "Elixir Data Mixer",
        "definitions": "PREPROCESS (S) SINGAPORE\nPREPROCESS \"`\" \"\"\nPREPROCESS \".\" \" \"\nPREPROCESS \",\" \" \"\nPREPROCESS \"(\" \" \"\nPREPROCESS \")\" \" \"\nPREPROCESS \"&\" \" \"\n\nALIAS M/M MINIMART\nALIAS MINI-MART MINIMART\nALIAS SMKT SUPERMARKET\nALIAS RD ROAD\nALIAS AVE AVENUE\nALIAS ST STREET\nALIAS JLN JALAN\nALIAS CRESC CRESCENT\nALIAS DR DRIVE\n\nPATTERN \"BLK[ ]*([0-9]+(\\-[0-9]+)?[A-Z]?)\" Block \"BLK $1\"\nPATTERN \"BLOCK[ ]*([0-9]+(\\-[0-9]+)?[A-Z]?)\" Block \"BLK $1\"\n\nPATTERN \"\\#[ ]*([A-Z]?[0-9]+)[ -]([A-Z]?[0-9]+(/[0-9]+)?)\" Unit \"#$1-$2\"\nPATTERN \"UNIT[ ]*([A-Z]?[0-9]+)[ -]([A-Z]?[0-9]+(/[0-9]+)?)\" Unit \"#$1-$2\"\nPATTERN \"NO[ ]*([A-Z]?[0-9]+)[ -]([A-Z]?[0-9]+(/[0-9]+)?)\" Unit \"#$1-$2\"\n\nPOSTPROCESS \"MINI MART\" MINIMART\n\n",
        "headers": [
            "Retailer.Code.name",
            "Retailer.Code.address",
            "Retailer.Code.postal"
        ],
        "module": "Dataset",
        "name": "RetailerData.csv",
        "records": [
            [
                "MARINA BAY SANDS PTE LTD",
                "NO 10  BAYFRONT AVENUE  ",
                "18956"
            ],
            [
                "AP HOUSE PTE LTD",
                "NO 12  MARINA VIEW ASIA #01-6/7/8 SQUARE TOWER 2 ",
                "18961"
            ],
            [
                "AL MARCHE PTE LTD",
                "NO 2  MARINA BOULEVARD #B1-05 THE SAIL @ MARINA ",
                "18987"
            ],
            [
                "ETERNALLY",
                "MARINA COSTA DR MARINA SOUTH PIER #01-06(TEL:65348735) ",
                "18988"
            ],
            [
                "SARUS MINIMART",
                "BLK 122, MCNAIR RD #01-39  ",
                "20122"
            ],
            [
                "JOHN LITTLE PTE LTD-MSQ",
                "NO 6  RAFFLES BLVD #02-237  MARINA SQUARE",
                "39594"
            ],
            [
                "JOHN LITTLE PTE LTD-TB",
                "6 RAFFLES BOULEVARD #02-237 MARINA SQ  ",
                "39594"
            ],
            [
                "JOHN LITTLE PTE LTD-EXPO",
                "6 RAFFLES BOULEVARD #02-237 MARINA SQ  ",
                "39594"
            ],
            [
                "ROBINSON & COMPANY (S) PTE LTD - CP",
                "6 RAFFLES BOULEVARD #02-238 MARINA SQ SINGAPORE 039594",
                "39594"
            ],
            [
                "MT MERU PTE LTD",
                "3RAFFLES PLACE  #07-01 BHARAT BUILDING ",
                "48617"
            ],
            [
                "ORTHOMED PTE LTD",
                "NO 11  COLLYER QUAY #12-04 THE ARCADE ",
                "49317"
            ],
            [
                "BENETA PTE LTD",
                "NO 3  CHURCH ST #01-002 SAMSUNG HUB ",
                "49483"
            ],
            [
                "CHUA LEE",
                "BLK 32 NEW MARKET RD #03-1122 OFF UPP CROSS STREET ",
                "50032"
            ],
            [
                "SUNNY OCEAN PTE LTD",
                "BLK 32  NEW MARKET RD,OFF UPP CROSS ST #03-1058 ",
                "50032"
            ],
            [
                "SWANSTON - PEOPLES PARK COMPLEX",
                "BLK 32 NEW MARKET RD #02-1002 OFF UPP CROSS STREET ",
                "50032"
            ],
            [
                "MIRAL COSMETICS",
                "BLK 34  UPP CROSS ST #03-138 ",
                "50034"
            ],
            [
                "SWANSTON - PEOPLES PARK CENTRE",
                "BLK 34  UPP CROSS ST #02-144 ",
                "50034"
            ],
            [
                "YEO & ONG CLASSIC FOOD TRADING",
                "BLK 335  SMITH ST #01-037/038,CHINATOWN COMPLEX ",
                "50335"
            ],
            [
                "C.K. DEPARTMENT STORE - CHINATOWN",
                "BLK 336  SMITH ST #01-304 NEW BRIDGE CTR ",
                "50336"
            ],
            [
                "DA YOU DEPT STORE PTE LTD",
                "BLK 336  SMITH ST #02-300 NEW BRIDGE CTR ",
                "50336"
            ],
            [
                "GAINSWELL TRADING PTE LTD",
                "BLK 531  UPP CROSS ST 01-14/16/38/55 HONG LIM COMPLEX",
                "50531"
            ],
            [
                "SIEW HIONG",
                "BLK 531A  UPP CROSS ST #01-04 HONG LIM MARKET & FOOD CTR ",
                "50531"
            ],
            [
                "FIRST EMPORIUM & SUPERMARKET PTE LTD",
                "NO 1  PARK RD #01-79 PEOPLES PARK COMPLEX ",
                "59108"
            ],
            [
                "MILLION PERSONAL CARE STOREMETICS",
                "NO 1  PARK RD #01-85 PEOPLES PARK COMPLEX ",
                "59108"
            ],
            [
                "SKY",
                "1 PARK RD #02-26/27 PEOPLES PARK CPLX ",
                "59108"
            ],
            [
                "BARTLE BOGLE HEGARTY LTD",
                "5 MAGAZINE RD #03-03 CENTRAL MALL ",
                "59571"
            ],
            [
                "THE MARKET CENTRAL PTE LTD",
                "6 EU TONG SEN ST #B1-28 THE CENTRAL ",
                "59817"
            ],
            [
                "ZERO.ZERO PTE LTD",
                "6 EU TONG SEN ST #04-86 THE CENTRAL  ",
                "59817"
            ],
            [
                "OGILVY & MATHER (S) PTE LTD",
                "71 ROBINSON RD #07-01  ",
                "68895"
            ],
            [
                "INTER ASIA MULTI PROVIDER",
                "2A HONG SAN WALK #B1-01 PALM GARDENS ",
                "68904"
            ],
            [
                "GIFTIZEN",
                "10 ANSON ROAD INTERNATIONAL PLAZA #26-04 ",
                "79903"
            ],
            [
                "HDF MARINE SERVICES",
                "NO 10  ANSON RD #26-04 INTERNATIONAL PLAZA ",
                "79903"
            ],
            [
                "MAHAKAVI AGENCY",
                "10 ANSON RD #05-17 INTERNATIONAL PLZ  ",
                "79903"
            ],
            [
                "JADELY FOOD SUPPLIES PTE LTD",
                "BLK 5 EVERTON PARK #01-24  ",
                "80005"
            ],
            [
                "EVERTON MINIMART",
                "BLK 7  EVERTON PARK #01-07 ",
                "80007"
            ],
            [
                "J.K MINISUPERMART",
                "BLK 7  EVERTON PARK #01-25 ",
                "80007"
            ],
            [
                "SHOU JIN MINMART",
                "BLK 7 EVERTON PARK #01-09  ",
                "80007"
            ],
            [
                "VIR & VIR",
                "BLK 102  SPOTTIWOODE PERK RD #01-80 ",
                "80102"
            ],
            [
                "LEONG YICK LOONG",
                "BLK 333  KRETA AYER RD #01-28 ",
                "80333"
            ],
            [
                "MEDIC DRUG STORE PTE LTD",
                "BLK 1 TANJONG PAGAR PLAZA #01-57  ",
                "82001"
            ],
            [
                "YOUNG BOX",
                "BLK 1 TANJONG PAGAR #02-27 ",
                "82001"
            ],
            [
                "NICE MINIMART - PUNGGOL ",
                "BLK 266C  POUGGOL WAY #01-376 TEL:9878 8618",
                "82366"
            ],
            [
                "FOODXSERVICES INC PTE LTD",
                "BLK 39  KEPPEL RD #01-02/04 TG PAGAR D.PARK  ",
                "89065"
            ],
            [
                "A-LINKZ MARKETING PTE LTD",
                "BLK B  1557 KEPPEL RD  #02-25 CANTONMENT CENTRAL ",
                "89066"
            ],
            [
                "ZACKS MARINE TRADER PRIVATE LIMITED",
                "BLK 6  TELOK BLANGAH CRESC #01-430 ",
                "90006"
            ],
            [
                "BAN ANG TONG MEDICAL HALL",
                "BLK 9  TELOK BLANGAH CRESC #01-131 ",
                "90009"
            ],
            [
                "C.K. DEPARTMENT STORE - TBC",
                "BLK 9  TELOK BLANGAH CRESC #01-125 ",
                "90009"
            ],
            [
                "MURUGAN MART PTE LTD",
                "BLK 9  TELOK BLANGAH CRESC #01-123 ",
                "90009"
            ],
            [
                "ACCOLADE PHARMACEUTICALS PTE LTD",
                "BLK 30  TELOK BLANGAH RISE #05-306 ",
                "90030"
            ],
            [
                "HENG CHYE HIN",
                "BLK 35  TELOK BLANGAH RISE #01-277 ",
                "90035"
            ],
            [
                "N.K.K TRADING",
                "BLK 38  TELOK BLANGAH RISE #01-327 ",
                "90038"
            ],
            [
                "K.S. KUMAR & CO",
                "BLK 61  TELOK BLANGAH HEIGHTS #01-113 ",
                "90061"
            ],
            [
                "WEN SHENG MEDICAL HALL",
                "BLK 109  BUKIT PURMEI RD #01-1510 ",
                "90109"
            ],
            [
                "HONG HENG MINI MART",
                "BLK 112  BUKIT PURMEI RD #01-211 ",
                "90112"
            ],
            [
                "YUMI MINIMART",
                "BLK 112 BUKIT PURMEI RD #01-213 ",
                "90112"
            ],
            [
                "THE GROCERS",
                "NO 13  KEPPEL BAY VIEW #B1-99 ",
                "98409"
            ],
            [
                "SAFRA NATIONAL SERVICE ASSOCIATION",
                "NO 2  TELOK BLANGAH WAY  ",
                "98803"
            ],
            [
                "SENG HUAT DEPT. STORE TRADING",
                "BLK 61  TELOK BLANGAH HEIGHTS #01-99 ",
                "100061"
            ],
            [
                "TECK GUAN & CO",
                "BLK 77 TELOK BLANGAH DR #01-228 ",
                "100077"
            ],
            [
                "HOW TUCK SENG KEE MINIMART",
                "BLK 77  TELOK BLANGAH DR #01-226 ",
                "100077"
            ],
            [
                "DAZZLE INTERNATIONAL & TRADING",
                "BLK 77 TELOK BLANGAH DR #01-238  ",
                "101077"
            ],
            [
                "TAY KONG JOO",
                "BLK 77 TELOK BLANGAH DR #01-234  ",
                "101077"
            ],
            [
                "123 MINIMART",
                "BLK 78B TELOK BLANGAH DR #01-28  ",
                "101078"
            ],
            [
                "LOW CHIN HENG TEXTILES DEPT STORE",
                "BLK 78A  TELOK BLANGAH ST 32 #01-11 ",
                "101078"
            ],
            [
                "HORIZON ASIA RESOURCES P/L",
                "NO 61  UBI AVE 2 #06-07 AUTOMOBILE MEGAMART BLDG",
                "108898"
            ],
            [
                "GROCER @ INRERLACE PTE LTD",
                "BLK 180  DEPOT RD #01-02 THE INTERLACE ",
                "109684"
            ],
            [
                "MING`S GROUP PTE LTD",
                "24 DEPOT LANE #01-01  TEL:9229 6932",
                "109767"
            ],
            [
                "CHIA & THAI FOOD",
                "BLK 14  PASIR PANJANG RD #01-29 WHOLESALE CTR ",
                "110014"
            ],
            [
                "HSIN LIAN FA TRADING CO",
                "BLK 14  PASIR PANJANG RD #01-33 WHOLESALE CTR ",
                "110014"
            ],
            [
                "HUAT YANG",
                "BLK 15  PASIR PANJANG RD #01-63 WHOLESALE CTR ",
                "110014"
            ],
            [
                "POI HONG TRADING",
                "BLK 14  PASIR PANJANG RD #01-34 WHOLESALE CTR ",
                "110014"
            ],
            [
                "LIM SONG KEE & CO",
                "BLK 14  PASIR PANJANG RD #01-36 WHOLESALE CTR ",
                "110015"
            ],
            [
                "SHEN TRADING & WHOLESALE",
                "BLK 15  WHOLESALE CTR #01-62 PASIR PANJANG",
                "110015"
            ],
            [
                "GOH YEOW HENG PTE LTD",
                "BLK 16  PASIR PANJANG RD #01-86 WHOLESALE CTR ",
                "110016"
            ],
            [
                "GUO RUI CHENG PTE LTD",
                "BLK 16  PASIR PANJANG RD #01-89 WHOLESALE CTR ",
                "110016"
            ],
            [
                "TEH BROTHER PROVISION SHOP",
                "BLK 16  PASIR PANJANG RD #01-88 WHOLESALE CTR ",
                "110016"
            ],
            [
                "UNILEVER SINGAPORE PTE LTD",
                "20 PASIR PANJANG ROAD #06-22 MAPLETREE BUSINESS CITY SINGAPORE 117439 ",
                "117439"
            ],
            [
                "FOODJOY PTE LTD",
                "NO 24  SOUTH BOUNA VISTA OFF PASIR PANJANG RD ",
                "118157"
            ],
            [
                "NANYANG MART PTE LTD",
                "BLK 31  PRINCE GEORGES PARK  #02-18 MULTI PURPOSE HALL (NUS)",
                "118427"
            ],
            [
                "LANDOM DISTRIBUTIONS PTE LTD",
                "BLK 151  PASIR PANJANG RD #03-04  PASIR PANJANG DISTRIPARK",
                "118480"
            ],
            [
                "MELLON COMMERCIAL PTE LTD",
                "BLK 151  PASIR PANJANG RD #02-11 PASIR PANJANG DISTRIPARK ",
                "118480"
            ],
            [
                "SUTL CORPORATION PTE LTD",
                "NO 100J  PASIR PANJANG RD #05-00 SUTL HOUSE  ",
                "118525"
            ],
            [
                "SCN SINGAPORE PTE LTD",
                "BLK 102F  PASIR PANJANG RD #05-09 CITILINK COMPLEX ",
                "118530"
            ],
            [
                "ASHMI MINIMART PTE LTD",
                "NO 126  PASIR PANJANG RD DINESH - 9825 3070 ",
                "118546"
            ],
            [
                "NORMANTON SUPERMARKET PTE LTD",
                "BLK 16  AYER RAJAH RD #01-169 NORMANTON PARK ",
                "119011"
            ],
            [
                "NUS MULTI-PURPOSE CO-OPERATIVE",
                "SOCIETY LIMITED LOWER KENT RIDGE CRESC SCIENCE & MEDICAL BRANCH-B S CPLEX ",
                "119078"
            ],
            [
                "NUS MULTI-PURPOSE CO-OPERATIVE",
                "NO 10  SOCIETY LIMITED KENT RIDGE CREST GROUND FLOOR CTRL LIBRARY BLDG",
                "119260"
            ],
            [
                "GRINDELWALD SUPERMARKET",
                "BLK 108  CLEMENTI ST 11 #01-00 ",
                "120108"
            ],
            [
                "KEE GUAN HUAT SUPERMARKET",
                "BLK 308  CLEMENTI AVE 4 #01-351/353 ",
                "120308"
            ],
            [
                "U STARS SUPERMARKET - CLEMENTI",
                "BLK 345 CLEMENTI AVE 5 #01-78 ",
                "120345"
            ],
            [
                "C.K. DEPARTMENT STORE - CA",
                "BLK 354  CLEMENTI AVE 2 #01-157 ",
                "120354"
            ],
            [
                "THAZIN MINI MART",
                "BLK 364 CLEMENTI AVE 2  ",
                "120364"
            ],
            [
                "ABDUL MUNAFF ENTERPRISE",
                "BLK 378  CLEMENTI AVE 5 #01-340 ",
                "120378"
            ],
            [
                "TEIW SIN HUAT CO",
                "BLK 378 CLEMENTI AVE 5 #01-336  ",
                "120378"
            ],
            [
                "GOOD PRICE CENTRE-CLMT",
                "BLK 380  CLEMENTI AVE 5 #01-374 ",
                "120380"
            ],
            [
                "H.M. HUSSIAN -CLEMENTI",
                "BLK 407 CLEMENTI AVE 1 #01-48  ",
                "120407"
            ],
            [
                "KUTUB SULTAN TRADING",
                "BLK 411 COMMONWEALTH AVE WEST #01-3075  ",
                "120411"
            ],
            [
                "MAGO MINIMART",
                "BLK 415 COMMONWEALTH AVE WEST #01-3009  ",
                "120415"
            ],
            [
                "DOCKSIDE TRADERS PTE LTD",
                "BLK 431 CLEMENTI AVE 3 #01-332 ",
                "120431"
            ],
            [
                "HONG YIT BAKERY & CONFECTIONERY",
                "BLK 431  CLEMENTI AVE 3 #01-322 ",
                "120431"
            ],
            [
                "VASANTH MINIMART",
                "BLK 431 CLEMENTI AVE 3 #01-332  ",
                "120431"
            ],
            [
                "CHERRYHEART NATURAL",
                "BLK 432  CLEMENTI AVE 3 #01-274 ",
                "120432"
            ],
            [
                "A CON SUPPLY CENTRE",
                "447 CLEMENTI AVE 3 #01-199  ",
                "120447"
            ],
            [
                "RICHARD TAI ENTERPRISES-A",
                "BLK 449 CLEMENTI AVE 3 #01-221  ",
                "120449"
            ],
            [
                "TARGET DEPARTMENTAL STORE",
                "449 CLEMENTI AVENUE 3 #01-255  ",
                "120449"
            ],
            [
                "HANG HENG DEPT STORE",
                "BLK 501  WEST COAST DR #01-276 ",
                "120501"
            ],
            [
                "HOCK BENG AIK PROVISION SHOP",
                "BLK 501  WEST COAST DR #01-272 ",
                "120501"
            ],
            [
                "SENG LY PROVISION STORE",
                "BLK 501  WEST COAST DR #01-278 ",
                "120501"
            ],
            [
                "HAI SENG MINIMART",
                "BLK 504 WEST COAST DR #01-228 ",
                "120504"
            ],
            [
                "UNIVERSAL HOUSEWARE CENTRE-WC504",
                "BLK 504 WEST COAST DRIVE #01-222  ",
                "120504"
            ],
            [
                "GOOD PRICE CENTRE-WC505",
                "BLK 505 WEST COAST DR #01-220 ",
                "120505"
            ],
            [
                "188 PROVISION SHOP",
                "BLK 516 WEST COAST DR #01-543  ",
                "120516"
            ],
            [
                "DHAKA FOODS PTE LTD",
                "BLK 517 WEST COAST DR #01-567 ",
                "120517"
            ],
            [
                "M/THOUHEED MINIMART",
                "BLK 517 WEST COAST DR #01-567  ",
                "120517"
            ],
            [
                "XIN SAN YEN PROVISION SHOP",
                "BLK 612  CLEMENTI ST 1 #01-294 ",
                "120612"
            ],
            [
                "HENG YUAN PROVISION",
                "BLK 710  CLEMENTI ST 2 #01-251 ",
                "120710"
            ],
            [
                "HOCK HIN CHAN PROVISION",
                "BLK 710  CLEMENTI ST 2 #01-255 ",
                "120710"
            ],
            [
                "ONG SWEE GUAN DEPARTMENT STORE PTE LTD",
                "BLK 710  CLEMENTI ST 2 #01-263 ",
                "120710"
            ],
            [
                "SGP MINIMART",
                "BLK 722  CLEMENTI WEST ST 2 #01-158 ",
                "120722"
            ],
            [
                "C.K. DEPARTMENT STORE - CLEMENTI",
                "BLK 727  CLEMENTI ST 2 #01-232 ",
                "120727"
            ],
            [
                "MAISON DE BEAUTE",
                "BLK 727  CLEMENTI ST 2 #01-242 ",
                "120727"
            ],
            [
                "SKY MART",
                "BLK 31  WEST COAST CRESC #01-32 BLUE HORIZON ",
                "128050"
            ],
            [
                "GAY SENG (2008) PTE LTD",
                "BLK S, NO 21  PANDAN LOOP OFF JLN BUROH ",
                "128239"
            ],
            [
                "CANTER SINGAPORE PTE LTD",
                "BLK 192  PANDAN LOOP,#01-09 PANTECH BUSINESS HUB ",
                "128381"
            ],
            [
                "GMS SUPPLIES AND TRADING PTE LTD",
                "NO 192  PANDAN LOOP #04-08 PANTECH BUSINESS HUB ",
                "128381"
            ],
            [
                "CLEANMAGE PTE LTD",
                "192 PANDAN LOOP #05-24 PANTECH BUSINESS HUB Attn:MR RICHARD GOH  TEL: 96999811 / 65158754 ",
                "128383"
            ],
            [
                "S K REGIONAL ENTERPRISES",
                "BLK 194 #04-19  PANTECH BUSINESS HUB PANDAN LOOP",
                "128383"
            ],
            [
                "RASACINTA PTE LTD",
                "207B PANDAN LOOP PANDAN  ",
                "128400"
            ],
            [
                "SYMRISE ASIA PACIFIC PTE LTD",
                "226 PANDAN LOOP   ",
                "128412"
            ],
            [
                "PHOON HUAT & CO (PTE) LTD",
                "NO 231A  PANDAN LOOP TEL:6289 8989 ",
                "128419"
            ],
            [
                "HOCK SENG FOOD PTE LTD",
                "NO 267  PANDAN LOOP  ",
                "128439"
            ],
            [
                "SUPERMARCHE PREMIERE PTE LTD",
                "BLK 8  JALAN LEMPENG #01-01 PARK WEST ",
                "128796"
            ],
            [
                "LIM MONG LEE PROVISION SHOP",
                "NO 102  FABER DR,OFF JLN LEMPENG  ",
                "129430"
            ],
            [
                "VENUS BEAUTY PTE LTD - WAREHOUSE",
                "NO 6  CLEMENTI LOOP HOE LEONG CORPORATION LTD LEVEL 2 ",
                "129814"
            ],
            [
                "PRINCETON PHARMACY (S) PTE LTD",
                "1 CLEMENTI LOOP #06-02/03 CLEMENTI WEST LOGISTIC PARK ",
                "129820"
            ],
            [
                "JUMBO MINIMART",
                "BLK 5  DOVER CRESC #01-10 ",
                "130005"
            ],
            [
                "E-MART",
                "BLK 34  DOVER RD #01-143-145 ",
                "130034"
            ],
            [
                "CHUAN HAO DEPARTMENTAL STORE",
                "BLK 19A  DOVER CRESC #01-04 ",
                "131019"
            ],
            [
                "ROCHESTER MARKET PTE LTD",
                "35 ROCHESTER DRIVE #02-16  TEL:66846734",
                "138639"
            ],
            [
                "QUICKPICK MINIMART",
                "BLK 69  AYER RAJAH CRESC #01-02 ",
                "139961"
            ],
            [
                "KONVI LLP",
                "6 AYER RAJAH CRST #01-01  ",
                "139962"
            ],
            [
                "CHEE SENG HOE MEDICAL HALL",
                "BLK 116  COMMONWEALTH CRESC #01-139 ",
                "140116"
            ],
            [
                "CHIP AIK LIQUAR & CO",
                "BLK 116  COMMONWEALTH CRESC #01-141 ",
                "140116"
            ],
            [
                "NAN HUA MEDICAL STORE",
                "BLK 117 COMMONWEALTH CRESC #01-725 ",
                "140117"
            ],
            [
                "CHENG HUA S MART",
                "BLK 118  COMMONWEALTH CRESC #01-19 ",
                "140118"
            ],
            [
                "JING CAI PROVSION SHOP",
                "BLK 153  MEI LING ST #01-32 ",
                "140153"
            ],
            [
                "DAILY PERSONAL CARE",
                "BLK 157  MEI LING ST #01-56 ",
                "140157"
            ],
            [
                "HXRON TRADING",
                "BLK 157  MEI LING ST #01-58 ",
                "140157"
            ],
            [
                "TECK SENG MINIMART",
                "BLK 157  MEI LING ST #01-68 ",
                "140157"
            ],
            [
                "CHUA YAN HENG",
                "BLK 159  MEI CHIN RD #01-19 ",
                "140159"
            ],
            [
                "LIONG HWEE PROVISION (WET MARKET)",
                "BLK 159 MEI CHIN RD #01-87  ",
                "140159"
            ],
            [
                "WENG FATT PROVISION STORE",
                "BLK 159  MEI CHIN RD #01-17/18 ",
                "140159"
            ],
            [
                "YONG HWA MINIMART",
                "BLK 164  STIRLING RD #01-1206 ",
                "140164"
            ],
            [
                "QUEENSTOWN SUPERMARKET",
                "BLK 169  STIRLING RD #01-1157/1159 ",
                "140169"
            ],
            [
                "TAI HUAT COMPANY",
                "BLK 46-02 COMMONWEALTH DR #01-360 ",
                "140462"
            ],
            [
                "CAI & CAI PTE LTD",
                "BLK 46-2 COMMONWEALTH DR #01-364  ",
                "140462"
            ],
            [
                "ERP TRADING PTE LTD",
                "BLK 23B  QUEENS CLOSE #01-183 ",
                "141023"
            ],
            [
                "SAUCE GROCERY",
                "BLK 159 MEI LING ST #01-15/16  ",
                "141153"
            ],
            [
                "CHUA YAN KEE",
                "BLK 49 TANGLIN HALT RD #01-349 ",
                "142049"
            ],
            [
                "EVERGREEN (HUP KEE) PHOTO STUDIO",
                "BLK 49  TANGLIN HALT RD #01-351 ",
                "142049"
            ],
            [
                "POH ONN TONG MEDICAL HALL",
                "BLK 49 TANGLIN HALT RD #01-357  ",
                "142049"
            ],
            [
                "HDBFRIEND PTE LTD",
                "BLK 93 DAWSON RD #01-01 ",
                "142093"
            ],
            [
                "CHIP SENG & CO",
                "BLK 39  TANGLIN HALT RD #01-119 ",
                "143039"
            ],
            [
                "GREAT EASTERN COSMETIC CO.",
                "NO 1  QUEENSWAY #02-33 QUEENSWAY SHOPPING CTR ",
                "149053"
            ],
            [
                "VALUE PLUS MINIMART-BM",
                "BLK 7  JALAN BUKIT MERAH #01-4434 ",
                "150007"
            ],
            [
                "KENG ANN MINIMART",
                "BLK 35 JLN RUMAH TINGGI #01-493  ",
                "150035"
            ],
            [
                "PAO FU TRADING",
                "BLK 58 LENGKOK BAHRU #01-509 ",
                "150058"
            ],
            [
                "HIONG KEE CO",
                "BLK 59  LENGKOK BAHRU #01-549 ",
                "150059"
            ],
            [
                "LEONG HUAT HUP KEE",
                "BLK 78  REDHILL LANE #01-09 ",
                "150078"
            ],
            [
                "GOOD PRICE CENTRE - RH84",
                "BLK 84  REDHILL LANE #01-360 ",
                "150084"
            ],
            [
                "WHY MINI MINI MART",
                "BLK 86 REDHILL CLOSE #01-592  ",
                "150086"
            ],
            [
                "KIAN FATT MEDICAL HALL",
                "BLK 116 BT MERAH VIEW #01-239  ",
                "150116"
            ],
            [
                "SIMMEI COSMETICS",
                "BLK 163  BUKIT MERAH CTRL #02-3599 ",
                "150163"
            ],
            [
                "SILKEN COSMETICS",
                "BLK 163 BUKIT MERAH CTRL #02-3599B ",
                "150163"
            ],
            [
                "C.K. DEPARTMENT STORE - REDHILL",
                "BLK 164  BT MERAH CTL #01-3656 ",
                "150164"
            ],
            [
                "REDHILL TRADERS",
                "BLK 28  HOY FATT RD #01-28 ",
                "151028"
            ],
            [
                "ANB YOUR SAVING STORE",
                "BLK 116  BUKIT MERAH VIEW #01-243 ",
                "151116"
            ],
            [
                "GOOD PRICE CENTRE-BM116",
                "BLK 116  BUKIT MERAH VIEW #01-227 ",
                "151116"
            ],
            [
                "HAPPY MART",
                "BLK 116  BUKIT MERAH VIEW #01-237 ",
                "151116"
            ],
            [
                "CHOP CHUAN LEONG",
                "BLK 28 JALAN BUKIT MERAH #01-4466 ",
                "152028"
            ],
            [
                "SOON SENG PRODUCTS PTE LTD",
                "BLK 28 JLN BKIT MERAH #01-4474  ",
                "152028"
            ],
            [
                "RONG XING PTE LTD",
                "BLK 75D REDHILL RD #01-92 ",
                "154075"
            ],
            [
                "SASA COSMETIC CO (S) PTE LTD",
                "NO 1  JALAN KILANG TIMOR #06-02 PACIFIC TECH CTR ",
                "159303"
            ],
            [
                "NINJA LOGISTICS PTE LTD",
                "NO 30  JALAN KILANG BARAT  ",
                "159363"
            ],
            [
                "KIM LEE KIAT TRADING ENTERPRISE PTE LTD",
                "BLK 1001 JLN BT MERAH #06-13/18  ",
                "159455"
            ],
            [
                "EVERY TRADINGS ENTERPRISES PTE LTD",
                "205 HENDERSON RD #06-01  ",
                "159549"
            ],
            [
                "SAN HUAT COMPANY",
                "BLK 22  HAVELOCK RD #01-691 ",
                "160022"
            ],
            [
                "REAL BUY",
                "BLK 38  BEO CRESC #01-28 ",
                "160038"
            ],
            [
                "HONG GUAN",
                "BLK 46  JLN BUKIT HO SWEE #01-884 ",
                "160046"
            ],
            [
                "PIN PIN PIAU KAY & CO",
                "BLK 71 SENG POH RD #01-33 ",
                "160071"
            ],
            [
                "HUP SENG",
                "BLK 55 TIONG POH RD #01-02 OFF TIONG BAHRU ROAD ",
                "160082"
            ],
            [
                "OK PROVISION SHOP",
                "BLK 107  JALAN BUKIT MERAH #01-1814 ",
                "160107"
            ],
            [
                "SIN HUP LEE",
                "BLK 111  JALAN BUKIT MERAH #01-1698 ",
                "160111"
            ],
            [
                "UNIQUE EXPRESS CLEANING PTE LTD",
                "BLK 111 JALAN BUKIT MERAH #01-1702 ",
                "160111"
            ],
            [
                "MRS JOREEN PABARI",
                "BLK 123 KIM TIAN RD  ",
                "160123"
            ],
            [
                "LEO`S MINIMART",
                "BLK 126 KIM TIAN RD #01-07 ",
                "160126"
            ],
            [
                "OM SHREE MINIMART",
                "BLK 126 KIM TIAN RD #01-07  ",
                "160126"
            ],
            [
                "SRI THIRUMALA MINIMART",
                "BLK 126  KIM TIAN RD #01-147 ",
                "160126"
            ],
            [
                "CHOON HUAT STORE",
                "BLK 131  JLN BUKIT MERAH #01-1569 NEAR KIM TIAN RD ",
                "160131"
            ],
            [
                "NEW JOTHY STORE",
                "BLK 131  JALAN BUKIT MERAH #01-1581 ",
                "160131"
            ],
            [
                "D & S MINIMART",
                "BLK 133  JALAN BUKIT MERAH #01-1526 ",
                "160133"
            ],
            [
                "LIM KIM GUAN & CO",
                "BLK 133  JALAN BUKIT MERAH #01-1510 ",
                "160133"
            ],
            [
                "MARYS",
                "BLK 140 JALAN BUKIT MERAH #01-1156  TEL:9005 1855",
                "160140"
            ],
            [
                "GLICO MINIMART",
                "BLK 141  JALAN BUKIT MERAH #01-1168 ",
                "160141"
            ],
            [
                "FU MAN MEN",
                "BLK 146  JALAN BUKIT MERAH #01-1072/1074 ",
                "160146"
            ],
            [
                "BEE HIN",
                "BLK 146  JLN BT MERAH #01-1078 ",
                "160146"
            ],
            [
                "ENG BAN LEONG MEDICAL HALL",
                "BLK 3  JLN KUKOH #01-113 ",
                "161003"
            ],
            [
                "KIM SANG MEDICAL HALL - BT",
                "BLK 11A BOON TIONG RD #01-02 ",
                "161011"
            ],
            [
                "HUI HUAT YEW KAI MINIMART",
                "BLK 26  JLN MEMBINA,OFF THIONG BAHRU RD #01-04 ",
                "161026"
            ],
            [
                "LUCK SAN MINIMART",
                "BLK 4  JLN BT HO SWEE #01-162 ",
                "162004"
            ],
            [
                "J.S.P SUPPLIES",
                "BLK 78 YONG SIAK ST #01-16 OFF TIONG BAHRU ROAD ",
                "163078"
            ],
            [
                "LAM SENG CONFECTIONERY TRADING CO.",
                "30 SENG POH RD #01-236 THIONG BAHRU FOOD CTR ",
                "168898"
            ],
            [
                "JOHN LITTLE PTE LTD-JP",
                "NO 171 CHIN SWEE RD #06-01 ",
                "169877"
            ],
            [
                "JOHN LITTLEPTE LTD-PS",
                "NO 171 CHIN SWEE RD #06-01 ",
                "169877"
            ],
            [
                "ROBINSON & COMPANY (S)PTE LTD - RC",
                "NO 171 CHIN SWEE RD #06-01 ",
                "169877"
            ],
            [
                "ROBINSON & COMPANY (S) PTE LTD - HEEREN",
                "NO 171 CHIN SWEE RD #06-01 ",
                "169877"
            ],
            [
                "ROBINSON & COMPANY (S) PTE LTD - JEM",
                "NO 171 CHIN SWEE RD #06-01 ",
                "169877"
            ],
            [
                "ROBINSON & COMPANY (S) PTE LTD - HQ",
                "NO 171  CHIN SWEE RD #06-01 ",
                "169877"
            ],
            [
                "MEIDI-YA SINGAPORE CO (PTE) LTD",
                "NO 177  RIVER VALLEY RD #B1-50 LIANG COURT ",
                "179030"
            ],
            [
                "LA PYAE TRADING",
                "111 NTH BRIDGE RD #04-65 PENINSULA PLAZA ",
                "179098"
            ],
            [
                "SHWE YADANAR TRADING PTE LTD",
                "111 NTH BRIDGE RD #03-52 PENINSULA PLAZA ",
                "179098"
            ],
            [
                "HUP TECK LI TRADING",
                "BLK 3  ROCHOR RD #01-622 ROCHOR CTR ",
                "180001"
            ],
            [
                "TIONG HWA TEO DEPARTMENT STORE",
                "BLK 1  ROCHOR RD #01-604 ROCHOR CTR",
                "180001"
            ],
            [
                "PING XIAN SUPERMARKET",
                "BLK 3 QUEENS RD #02-155  ",
                "180003"
            ],
            [
                "WESTLAKE 3 PTE LTD",
                "BLK 3 QUEEN`S ROAD #02-153  ",
                "180003"
            ],
            [
                "NEW SPRING TRADING ENTERPRISE",
                "BLK 269 QUEEN ST #01-231 CHEN YAN COURT ",
                "180269"
            ],
            [
                "GECK HUAT",
                "BLK 270 QUEEN ST #03-55/5  ",
                "180270"
            ],
            [
                "GREAT FORTUNE DEPT STORE",
                "BLK 270  QUEEN ST #03-97 ",
                "180270"
            ],
            [
                "KEE TONG DEPARTMENT STORE",
                "BLK 270 QUEEN ST #03-65 BUGIS (MARKET) ",
                "180270"
            ],
            [
                "POH KEE DEPARTMENT STORE",
                "BLK 270  QUEEN ST #03-36 BUGIS (MARKET) ",
                "180270"
            ],
            [
                "YUE CHEONG TRADING",
                "BLK 269A  QUEEN ST #01-227 ",
                "181269"
            ],
            [
                "ALI & ZEENATH (S) PTE LTD",
                "NO 390  VICTORIA STREET #01-32 GOLDEN LANDMARK ",
                "188061"
            ],
            [
                "TAOS RESTURANT",
                "1 SELEGIE RD #B1-19 POMO ",
                "188306"
            ],
            [
                "HERITAGE SUITES PTE LTD",
                "NO 6  PURVIS ST #05-02 TEL:8261 3475",
                "188585"
            ],
            [
                "HUA FENG TDG & TRANSPORT PTE LTD",
                "190 MIDDLE RD #19-05 FORTUNE CTR ",
                "188979"
            ],
            [
                "NEOSONIC INTERNATIONAL PTE LTD",
                "NO 175  BENCOOLEN ST #01-13 BURLINGTON SQUARE ",
                "189649"
            ],
            [
                "COOL BOX CONVENIENT STORE",
                "NO 81 BENCOOLEN ST #01-70 SUNSHINE PLAZA ",
                "189652"
            ],
            [
                "CHOON HING MINIMART",
                "NO 15  BEACH RD #01-4681 BEACH CENTER ",
                "189677"
            ],
            [
                "014727 TRADING SHOP",
                "BLK 1 BEACH RD #01-4727 ",
                "190001"
            ],
            [
                "HOMES MINIMART",
                "BLK 2  BEACH RD #01-4785 ",
                "190002"
            ],
            [
                "UNITEC ENTERPRISE PTE LTD",
                "BLK 2  BEACH RD #01-4787 ",
                "190002"
            ],
            [
                "KIM HOE LEONG",
                "BLK 2  BEACH RD #01-4783 ",
                "190005"
            ],
            [
                "SAIFON SHOP",
                "BLK 6 BEACH RD #01-4887  ",
                "190006"
            ],
            [
                "MUHIL MINIMART",
                "BLK 13  NORTH BRIDGE RD #01-3988 ",
                "190013"
            ],
            [
                "BAN TECK MEDICAL STORE",
                "BLK 14  BEACH RD #01-4679 ",
                "190014"
            ],
            [
                "LAM SENG HUAT",
                "BLK 18 JALAN SULTAN #01-164 ",
                "190018"
            ],
            [
                "KIE HENG HARDWARE & ENGINEERING",
                "BLK 18  JALAN SULTAN #01-158 ",
                "190018"
            ],
            [
                "CK 88 WHOLESALE CENTRE PTE LTD",
                "BLK 465 NORTH BRIDGE RD #01-50197(CRAWFORD LANE) ",
                "191465"
            ],
            [
                "DUO FU MINIMART",
                "BLK 465 NTH BRIDGE RD #01-5069  ",
                "191465"
            ],
            [
                "KONG PENG CHANG PROVISION SHOP",
                "BLK 465  NORTH BRIDGE RD #01-5085 ",
                "191465"
            ],
            [
                "LIANG TYE MEDICAL CO PTE LTD",
                "BLK 465  NORTH BRIDGE RD #01-5053 ",
                "191465"
            ],
            [
                "MR. MINIMART",
                "BLK 465 NORTH BRIDGE RD #01-5069  ",
                "191465"
            ],
            [
                "TAI CHOON FOH & CO",
                "BLK 465  NORTH BRIDGE RD #01-5045 ",
                "191465"
            ],
            [
                "SEVEN STAR MINIMART",
                "BLK 465  NORTH BRIDGE RD #01-5069 ",
                "191564"
            ],
            [
                "ZHU HAI MINI SUPERMARKET",
                "NO 81  JALAN SULTAN #01-01 ",
                "198990"
            ],
            [
                "BLACK & WHITE IMAGE",
                "NO 200 JALAN SULTAN #01-34 TEXTILE CENTRE ",
                "199018"
            ],
            [
                "SEN LEE TEXTILES COMPANY",
                "NO 357  BEACH RD OFF ALIWAL STREET ",
                "199574"
            ],
            [
                "YEN INVESTMENTS PTE LTD",
                "BLK 5001  BEACH RD #02-16,GOLDEN MILE ",
                "199588"
            ],
            [
                "BODY AND FACE",
                "5001 BEACH RD  #02-43 GOLDEN MILE COMPLEX ",
                "199588"
            ],
            [
                "NEW THAI MINIMART",
                "5001 BEACH ROAD #01-67C GOLDEN MILE COMPLEX ",
                "199588"
            ],
            [
                "SOMJAINEUK TRADING",
                "NO 5001  BEACH RD #01-41 GOLDEN MILE ",
                "199588"
            ],
            [
                "UD PROVISION",
                "5001 BEACH RD #01-67C GOLDEN MILE ",
                "199588"
            ],
            [
                "DECORLIFE PTE LTD",
                "391 BEACH ROAD #01-26 KEYPOINT  ",
                "199597"
            ],
            [
                "HIAP SOON HIN",
                "BLK 640  ROWELL RD #01-64 VEERASAMY RD ",
                "200640"
            ],
            [
                "KVRS TRADING PTE LTD",
                "640 ROWELL RD #01-58  ",
                "200640"
            ],
            [
                "HOE KIAN HUAT TRADING",
                "BLK 803  KING GEORGES AVE #01-228 ",
                "200803"
            ],
            [
                "I-TEC SUPERMARKET PTE LTD - 123",
                "NO 123  KITCHENER RD  ",
                "203512"
            ],
            [
                "KAVITHA BRIGHTDAY IMPEX PTE LTD",
                "NO 8  VEROADUN RD OFF KITCHENER RD,VERDUN HOUSE  ",
                "207276"
            ],
            [
                "R.MUNUSAMY ENTERPRISE PTE LTD",
                "NO 2C VEERASAMY RD  ",
                "207308"
            ],
            [
                "EVERYMANS SHOPPING CENTRE",
                "NO 29  VEERASAMY RD LITTLE INDIA ",
                "207333"
            ],
            [
                "MAYUR TRADING",
                "NO 56  UPP WELD RD OFF SERANGOON RD ",
                "207411"
            ],
            [
                "KOH KHANG HIN TRADING PTE LTD",
                "NO 34  SAM LEONG RD OFF JALAN BESAH ",
                "207924"
            ],
            [
                "TBC BUILDERS PTE LTD",
                "NO 12  PERAK RD  ",
                "208133"
            ],
            [
                "ALL INDIA SUPERMART",
                "41 MORRIS ROAD  ",
                "208282"
            ],
            [
                "TANMOY ENTERPRISE PTE LTD",
                "27A LEMBU RD LITTLE INDIA  ",
                "208455"
            ],
            [
                "TUBEMAL EXPORTS PTE LTD",
                "195 KITCHENER ROAD  TEL:91304033 ",
                "208535"
            ],
            [
                "CHIA TECK SOON PTE LTD",
                "NO 1  KALANTAN RD OFF JALAN BESAH ",
                "208600"
            ],
            [
                "KOMALAS VEGE MART PTE LTD",
                "NO 49 DUNLOP ST  ",
                "209378"
            ],
            [
                "HANIFFA PTE LTD",
                "NO 118  DUNLOP ST LITTLE INDIA ",
                "209411"
            ],
            [
                "THANDAPANI CO",
                "NO 124  DUNLOP ST OFF JLN BESAH ",
                "209443"
            ],
            [
                "CHENNAI TRADING & SUPERMART PTE LTD",
                "127 DUNLOP ST LITTLE INDIA  ",
                "209446"
            ],
            [
                "ANACAONA PTE LTD",
                "NO 128  DUNLOP ST LITTLE INDIA ",
                "209447"
            ],
            [
                "SRI AMBAL",
                "136 DUNLOP ST LITTLE INDIA  ",
                "209454"
            ],
            [
                "APPOLLO SELLAPPAS PTE LTD",
                "NO 153  DUNLOP ST LITTLE INDIA ",
                "209467"
            ],
            [
                "NEPA SPICES TDG (S) PTE LTD",
                "NO 86  DESKER RD LITTLE INDIA ",
                "209608"
            ],
            [
                "KVRS TRADING PTE LTD",
                "NO. 2C VEERASAMY RD LITTLE INDIA  ",
                "209713"
            ],
            [
                "KHAN KMBS PTE LTD",
                "NO 20  CUFF ROAD,LITTLE INDIA  ",
                "209731"
            ],
            [
                "KHAN MOHAMED BHOY & SONS",
                "66 BUFFALO RD TEKKA MARKET  ",
                "209731"
            ],
            [
                "GURUS MARKETING",
                "NO 30  CLIVE ST LITTLE INDIA ",
                "209782"
            ],
            [
                "JOTHI STORE & FLOWER SHOP",
                "1 CAMPBELL LANE LITTLE INDIA  ",
                "209882"
            ],
            [
                "VARSHINI TRADINGS",
                "NO 23  CAMPBELL LANE  OFF JLN BESAH ",
                "209896"
            ],
            [
                "CHENNAI TDG & SUPERMART P/L",
                "NO 25  CAMPBELL LANE OFF JLN BESAH ",
                "209898"
            ],
            [
                "MKS BACK PACK PACKERS` HOSTEL PTE LTD",
                "44 CUFF ROAD LITTLE INDIA  ",
                "209910"
            ],
            [
                "CHOP KIM HENG",
                "BLK 41  CAMBRIDGE RD #01-17 ",
                "210041"
            ],
            [
                "NOTTANS",
                "BLK 41 CAMBRIDGE RD #01-23  ",
                "210041"
            ],
            [
                "ZHEN HE PTE LTD",
                "BLK 42 CAMBRIDGE RD #01-01  ",
                "210042"
            ],
            [
                "YONG HEN STORE",
                "BLK 44  OWEN RD #01-307 ",
                "210044"
            ],
            [
                "MJ 2000",
                "BLK 46  OWEN RD #01-287 ",
                "210046"
            ],
            [
                "SWEE HUAT LIQUOR",
                "BLK 46  OWEN RD #01-271 ",
                "210046"
            ],
            [
                "HUA BROTHERS HARDWARE PTE LTD",
                "BLK 662  BUFFALO RD #01-23 ",
                "210062"
            ],
            [
                "AAB SWEETS & SNACKS",
                "BLK 661  BUFFALO RD #01-28 ",
                "210661"
            ],
            [
                "CHENNAI TRADING AND SUPERMART",
                "BLK 661  BUFFALO RD #01-27 ",
                "210661"
            ],
            [
                "EE HENG DEPARTMENT STORE",
                "BLK 662  BUFFALO RD #01-18 ",
                "210662"
            ],
            [
                "SELVI STORES PTE LTD",
                "BLK 662  BUFFALO RD #01-20 ",
                "210662"
            ],
            [
                "RASOOL SHOP PTE LTD",
                "BLK 664  BUFFALO RD #01-01 ",
                "210664"
            ],
            [
                "RFM ENTERPRISE PTE LTD",
                "BLK 664 BUFFALO RD #01-02  ",
                "210664"
            ],
            [
                "WAH SIANG HUAN ENTERPRISE CO",
                "BLK 681  RACE COURSE RD #01-317 ",
                "210681"
            ],
            [
                "LIM CHUAN CHEONG",
                "BLK 683  TESSENSOHN RD #01-131 OFF RACE COURSE RD ",
                "210683"
            ],
            [
                "AMISTA INTERNATIONAL PTE LTD",
                "BLK 684  RACE COURSE RD #01-300 ",
                "210684"
            ],
            [
                "JY MART (FLOWER MINIMART)",
                "BLK 63B  LENGKOK BAHRU #01-360 TEL:9767 1208",
                "215206"
            ],
            [
                "S. SUBRAMANIAM",
                "NO 116  SERANGOON RD  OFF CUFF RD LITTLE INDIA ",
                "218021"
            ],
            [
                "LIAN HOCK HARDWARE",
                "560-560A SERANGOON RD OFF PETAIN ROAD LITTLE INDIA  ",
                "218177"
            ],
            [
                "JRS GLOBAL TRADING PTE LTD",
                "NO 33  ROBERTS LANE  ",
                "218312"
            ],
            [
                "MIZMOR PTE LTD (HARBE YOTER)",
                "64 RANGOON RD OFF RACE COURSE ROAD  ",
                "218354"
            ],
            [
                "ELYITE EXIMS TRADING PTE LTD - RC",
                "NO 30  RACE COURSE RD LITTLE INDIA ",
                "218551"
            ],
            [
                "DARSHNI`S PTE LTD",
                "NO 1    KERBAU RD   ",
                "219140"
            ],
            [
                "SELVI STORES TRADING PTE LTD",
                "NO 5 KERBAU RD OFF RACE COURSE RD  ",
                "219144"
            ],
            [
                "ROYAL TRADING HUB PTE LTD",
                "NO 18 KERBAU ROAD LITTLE INDIA  ",
                "219157"
            ],
            [
                "OM SRI TRADING PTE LTD",
                "21 KERBAU RD LITTLE INDIA  ",
                "219160"
            ],
            [
                "OVERSEA COSMETICS PTE LTD",
                "11 CHANDER RD LITTLE INDIA  ",
                "219529"
            ],
            [
                "LIAN YUAN",
                "NO 15  CHANDER RD,LITTLE INDIA  ",
                "219538"
            ],
            [
                "HYPERLINK MINI MART PTE LTD",
                "NO 11 CHANDER RD  ",
                "219545"
            ],
            [
                "AAB SWEETS & SNACKS PTE LTD",
                "18 BUFFALO RD TEKKA MARKET  ",
                "219788"
            ],
            [
                "BIZCOMPTECH PTE LTD",
                "22 BUFFALO RD TEKKA MARKET  ",
                "219790"
            ],
            [
                "KVRS TRADING PTE LTD",
                "NO 22  BUFFALO RD  ",
                "219790"
            ],
            [
                "SRI KAVITHA FLOWER TRADING PTE LTD",
                "30BUFFALO ROAD   ",
                "219794"
            ],
            [
                "KARTHIKA ENTREPRISES PTE LTD",
                "NO 34  BUFFALO RD TEKKA MARKET ",
                "219796"
            ],
            [
                "GOOD LUCK SPICES PTE LTD",
                "NO 52  BUFFALO RD TEKKA MARKET ",
                "219800"
            ],
            [
                "NAMMAVAR TRADING PTE LTD",
                "NO 62  BUFFALO RD TEKKA MARKET ",
                "219805"
            ],
            [
                "GURUS MARKETING PTE LTD-BFLO",
                "NO 70  BUFFALO RD TEKKA MARKET ",
                "219809"
            ],
            [
                "SHAHINA TRADING P/L",
                "72 BUFFALO RD TEKKA MARKET  ",
                "219810"
            ],
            [
                "C.K. DEPARTMENT STORE - FE",
                "N0 14  SCOTTS RD #01-08/14 FAR EAST PLAZA ",
                "228213"
            ],
            [
                "EXOTIC TATTOOS & TDG CTR",
                "NO 14  SCOTTS RD #04-11 FAR EAST PLAZA ",
                "228213"
            ],
            [
                "THE AMERICAN CLUB",
                "NO 10  CLAYMORE HILL OPP FAR EAST PLAZA ",
                "229573"
            ],
            [
                "THE RIVERGATE GROCER",
                "NO 95  ROBERTSON QUAY #01-17 RIVERGATE ",
                "238256"
            ],
            [
                "ASPEN HEIGHT SUPERMARKET",
                "BLK 263 RIVER VALLEY RD #B1-03 ASPEN HEIGHTS ",
                "238309"
            ],
            [
                "YONG ANN PARK MINIMART",
                "BLK 329  RIVER VALLEY RD #01-01,YONG ANN PARK ",
                "238361"
            ],
            [
                "KIM SWEE STORE",
                "BLK 8  RIVER VALLEY CLOSE #B1-01 PACIFIC MANSION ",
                "238432"
            ],
            [
                "MJS FAITH PTE LTD",
                "304 ORCHARD RD #02-25 LUCKY PLAZA ",
                "238843"
            ],
            [
                "ASAGO MINIMART",
                "NO 304  ORCHARD ROAD #01-07  LUCKY PLAZA",
                "238863"
            ],
            [
                "CHUNG AUDIOLOGY & ASSOCIATES PTE LTD",
                "304, ORCHARD ROAD, #04-54 LUCKY PLAZA ",
                "238863"
            ],
            [
                "FIRST CHOICE",
                "304 ORCHARD RD #02-16 LUCKY PLAZA ",
                "238863"
            ],
            [
                "GNA FIRST CHOICE TRADING",
                "304 ORCHARD RD #03-23 LUCKY PLAZA ",
                "238863"
            ],
            [
                "GLORYDERM COSMETICS & FACIAL SERVICES",
                "304 ORCHARD RD #02-56 LUCKY PLAZA ",
                "238863"
            ],
            [
                "GNA-2",
                "304 ORCHARD RD #02-93 LUCKY PLAZA ",
                "238863"
            ],
            [
                "HBC",
                "304 ORCHARD RD #03-12 LUCKY PLAZA ",
                "238863"
            ],
            [
                "MEGA LIFESTYLE",
                "304 ORCHAROAD RD #04-24 LUCKY PLAZA ",
                "238863"
            ],
            [
                "MJs FAITH TRADING & SERVICE",
                "NO 304  ORCHAROAD RD #04-88 LUCKY PLAZA ",
                "238863"
            ],
            [
                "HOUSE OF PHILIPPINES PRODUCTS",
                "304 ORCHARD RD #02-22 LUCKY PLAZA ",
                "238868"
            ],
            [
                "ISETAN (SINGAPORE)LIMITED",
                "NO 350  ORCHARD RD #11-05 SHAW HOUSE ",
                "238868"
            ],
            [
                "METRO PTE LTD",
                "NO 391A ORCHARD RD #17-01  NGEE ANN CITY TOWER A TEL: 6836 3322",
                "238873"
            ],
            [
                "HILTON SINGAPORE",
                "NO 581  ORCHARD RD HILTON HOTEL ",
                "238883"
            ],
            [
                "SINGTEL MOBILE SINGAPORE PTE LTD",
                "NO 31  EXETER RD #01-00 COMCENTRE 1 ",
                "239732"
            ],
            [
                "DOZO RESTAURANT PTE LTD",
                "491 RIVER VALLEY RD #02-02/03 VALLEY POINT ",
                "248371"
            ],
            [
                "SPRING GROVE CAFE AND MINIMART",
                "NO 53C  GRANGE RD #01-01 SPRING GROVE CONDO ",
                "249568"
            ],
            [
                "THE TANGLIN CLUB",
                "NO 5  STEVENS RD  OFF DRAYCOTT DR ",
                "257814"
            ],
            [
                "GLORY MINIMART",
                "BLK 81  FARRER DR #01-01 SUMMERVILLA ",
                "259284"
            ],
            [
                "PRISON FELLOWSHIP SINGAPORE PTE LTD",
                "BLK 2  CLUNY RD ACCOUNTS DEPARMENT ",
                "259570"
            ],
            [
                "BUDGET LINK SHOP",
                "BLK 8  EMPRESS RD #01-33 ",
                "260008"
            ],
            [
                "CHENG NAM SENG",
                "BLK 8  EMPRESS RD #01-25 ",
                "260008"
            ],
            [
                "KIAN HUAT CHAN MINIMART",
                "BLK 8  EMPRESS RD #01-31 ",
                "260008"
            ],
            [
                "SHANTHI MINIMART & TRADING",
                "BLK 8  EMPRESS RD #01-27 ",
                "260008"
            ],
            [
                "HOMELY HAPPY MINIMART",
                "NO 19  LEEDON HEIGHTS #01-64 D`LEEDON ",
                "266227"
            ],
            [
                "TOP CHOICE SUPERMART - LEEDON",
                "NO 19  LEEDON HEIGHTS #01-67,D`LEEDON ",
                "266227"
            ],
            [
                "JOO HUAT FOOD SUPPLY",
                "9 DUKES RD #01-08  ",
                "268889"
            ],
            [
                "ASTRID MEADOWS MINIMART",
                "NO 50  CORONATION RD WEST #01-02 ASTRID MEADOWS ",
                "269264"
            ],
            [
                "SUPER BUDGET STORE",
                "BLK 19  GHIM MOH RD #01-253 ",
                "270019"
            ],
            [
                "SENG CHUNG TRADING",
                "BLK 20 GHIM MOH ROAD #01-204/205 GIM MOH MKT TEL: 94656160/98641275 ",
                "270020"
            ],
            [
                "THOI LAI CHUA",
                "BLK 20  GHIM MOH RD #01-77 ",
                "270020"
            ],
            [
                "FOOK CHOON WON KEE MEDICAL STORE",
                "BLK 21  GHIM MOH RD #01-189 ",
                "270021"
            ],
            [
                "NG HUP KEE",
                "BLK 21 GHIM MOH RD #01-157 TEL: 64784813 ",
                "270021"
            ],
            [
                "TONG SENG MEDICAL HALL DEPT STORE",
                "BLK 21  GHIM MOH RD #01-191 ",
                "270021"
            ],
            [
                "CHUA GUAN LEONG & CO",
                "BLK 31  HOLLAND CLOSE #01-233 ",
                "270031"
            ],
            [
                "HOLLAND V FIRST STOP CAFE",
                "31 HOLLAND CLOSE #01-241  ",
                "270031"
            ],
            [
                "SENG BEE PROVISION SHOP",
                "BLK 31  HOLLAND CLOSE #01-229 ",
                "270031"
            ],
            [
                "TAN HAK HIN MINIMART",
                "BLK 31  HOLLAND CLOSE #01-221 ",
                "270031"
            ],
            [
                "UNIVERSAL HOMEMART",
                "BLK 36  HOLLAND DR #01-08 ",
                "270036"
            ],
            [
                "EVERYDAY LOW PRICE (ELP) STORE",
                "BLK 45  HOLLAND DR #01-355 TEL:9007 5040",
                "270045"
            ],
            [
                "H.M. HUSSAIN PROVISION STORE -HL",
                "BLK 6  HOLLAND CLOSE #01-12 ",
                "271006"
            ],
            [
                "RIDGEWOOD GOURMET",
                "BLK 5  RIDGEWOOD CLOSE #G3 RIDGEWOOD CONDO ",
                "276696"
            ],
            [
                "SKY SUPREMART PTE LTD",
                "NO 19  SHELFORD RD #01-53 ",
                "288408"
            ],
            [
                "HENG HENG FOOD SUPPLIERS",
                "NO 7  GREENDALE AVE OFF HILLCREST ROAD ",
                "289504"
            ],
            [
                "GERMAN EUROPEAN SCHOOL SINGAPORE",
                "NO 72 BUKIT TINGGI RD  ",
                "289760"
            ],
            [
                "THE BRITISH CLUB",
                "NO 73  BUKIT TINGGI RD OFF BINJAI PARK ",
                "289761"
            ],
            [
                "YANS SHOP MINIMART",
                "251A ARCADIA RD #02-09  ",
                "289848"
            ],
            [
                "VN MINI MART",
                "BLK 20  TOA PAYOH LOR 7 # 01-742 ",
                "310007"
            ],
            [
                "CHENG KWANG LEE MINI-MART",
                "BLK 8 LOR 7 TOA PAYOH #01-283  ",
                "310008"
            ],
            [
                "TECK HUAT TOH KEE",
                "BLK 20  LOR 7 TOA PAYOH #01-750 ",
                "310020"
            ],
            [
                "YEOW LIAN HENG",
                "BLK 20  TAO POYOH LOR 7 #01-740 ",
                "310020"
            ],
            [
                "CHENNAI STORE-TP",
                "BLK 70  TOA PAYOH LOR 4 #01-353 ",
                "310070"
            ],
            [
                "HAI HIN MINIMART",
                "BLK 70 LOR 4 TOA PAYOH #01-343  ",
                "310070"
            ],
            [
                "SOON SENG GROCERY MARKETING",
                "BLK 70  LOR 4 TOA PAYOH #01-341 ",
                "310070"
            ],
            [
                "BAN CHUAN TONG DRUG STORE",
                "BLK 95  LOR 4 TOA PAYOH #01-56 ",
                "310095"
            ],
            [
                "SIMPLE ESSENTIALS",
                "BLK 111 LOR 1 TOA PAYOH #01-356  ",
                "310111"
            ],
            [
                "CHUAN JIAN HUAT MINIMART",
                "BLK 116  LOR 2 TOA PAYOH #01-168 ",
                "310116"
            ],
            [
                "SIANT INTERNATIONAL PTE LTD",
                "BLK 116 TOA PAYOH LOR 2  ",
                "310116"
            ],
            [
                "YONG MUI",
                "BLK 123 LOR 1 TOA PAYOH #01-493  ",
                "310123"
            ],
            [
                "CAI NAN FA DEPARTMENTAL STORE",
                "BLK 124  LOR 1 TOA PAYOH #01481 ",
                "310124"
            ],
            [
                "KOK KIONG DEPT. STORE",
                "BLK 127  TOA PAYOH LOR 1 #01-55/60 ",
                "310127"
            ],
            [
                "BOON SENG HUP KEE MINIMART",
                "BLK 150 LOR 1 TOA PAYOH #01-1009  ",
                "310150"
            ],
            [
                "CHOP SENG HENG",
                "BLK 150  LOR 1 TOA PAYOH #01-1009 ",
                "310150"
            ],
            [
                "TIEN TECK TRADING",
                "BLK 150  LOR 1 TOA PAYOH #01-999 ",
                "310150"
            ],
            [
                "HEALTHY LIVING CHINESE M/H",
                "BLK 168  LOR 1 TOA PAYOH #01-1024 ",
                "310168"
            ],
            [
                "SHOPMORE GROCERY",
                "BLK 168  TOA PAYOH LOR 1 #01-1036 ",
                "310168"
            ],
            [
                "BRABHUS A FAMILY MART",
                "BLK 194  KIM KEAT AVE #01-390 OFF TOA PAYOH EAST ",
                "310194"
            ],
            [
                "HENG CHEONG HENG MINIMART",
                "BLK 194  KIM KEAT AVE #01-424 ",
                "310194"
            ],
            [
                "I-LUSH",
                "BLK 194 KIM KEAT AVE #01-41 OFF LOR 6 TOA PAYOH ",
                "310194"
            ],
            [
                "THYE GUAN SIN NAM HUAT PROVISION STORE",
                "BLK 206  TOA PAYOH NORTH #01-1205 ",
                "310206"
            ],
            [
                "RAINBOW ESSENTIALS",
                "BLK 210 TOA PAYOH LOR 8 #01-108  ",
                "310210"
            ],
            [
                "HOE KEE HUAT SUPERMART",
                "BLK 212  TOA PAYOH LOR 8 #01-43/45 ",
                "310212"
            ],
            [
                "EA MINI MART & TRADING ",
                "BLK 216 TOA PAYOH LOR 8 #01-607  TEL:8692 7988",
                "310216"
            ],
            [
                "POH HUAT KIOSK",
                "BLK 222  LOR 8 TOA PAYOH #01-709 ",
                "310222"
            ],
            [
                "THONG HUP",
                "BLK 233  LOR 8 TOA PAYOH #01-260 ",
                "310233"
            ],
            [
                "GOODLUCK PROVISION SHOP (66)",
                "BLK 66 LOR 4 TOA PAYOH #01-301/305  ",
                "311066"
            ],
            [
                "YU LIAN MEDICAL HALL",
                "BLK 1004  TOA PAYOH IND. PARK  #01-1485/1487 ",
                "319076"
            ],
            [
                "ELITEZ PTE LTD",
                "93 TOA PAYOH CENTRAL #05-02 TOA PAYOH CENTRAL COMMUNITY BUILDING",
                "319194"
            ],
            [
                "UNCLE`S YAP ENTERPRISE",
                "BLK 3 ST GEORGE RD #01-103  ",
                "320003"
            ],
            [
                "CHIN HONG MINIMART",
                "BLK 3 ST GEORGE RD #01-89  ",
                "320003"
            ],
            [
                "HAO MART PTE LTD",
                "BLK 74 WHAMPOA DR #01-332/334/336 ",
                "320074"
            ],
            [
                "HUA BEE MINI SUPERMARKET",
                "BLK 74 WHAMPOA DR #01-340  ",
                "320074"
            ],
            [
                "SIONG WAN CO",
                "BLK 82  WHAMPOA DR #01-957 ",
                "320082"
            ],
            [
                "WHAMPOA 88",
                "BLK 88  WHAMPOA DR #01-861 ",
                "320088"
            ],
            [
                "TEO TECK YEOW",
                "BLK 92  WHAMPOA MARKET #01-56/57 ",
                "320092"
            ],
            [
                "BRAHBUS A FAMILY MART",
                "BLK 96 WHAMPOA DR #01-232  ",
                "320096"
            ],
            [
                "LION VIEW MINIMART",
                "BLK 102  JLN RAJAH #01-K1 ",
                "320102"
            ],
            [
                "100 SUPERMINIMART",
                "BLK 112 MCNAIR RD #01-205  ",
                "320112"
            ],
            [
                "SIVA IMPORT & EXPORT PTE LTD",
                "BLK 122 MCNAIR RD #01-39  ",
                "320122"
            ],
            [
                "LUCKY CHOICE MINIMART",
                "BLK 21  ST GEORGE RD #01-K1 ",
                "321021"
            ],
            [
                "111 SUPER CONVENIENT",
                "111 WHAMPOA RD #01-33  ",
                "321111"
            ],
            [
                "LEE SOON GUAN",
                "NO 4  ST GEORGES RD OFF SERANGOON RD ",
                "328024"
            ],
            [
                "LEE KIM HOCK",
                "NO 4 ST GEORGE`S RD  ",
                "328024"
            ],
            [
                "SIN TONG KOK MEDICAL & DEPARTMENTAL P L",
                "NO 37  OPAL CRESC END OF SERANGOON RD B4 PIE BRIDGE ",
                "328426"
            ],
            [
                "SIN TONG KOK MED & DEPT P/L",
                "37 OPAL CRSC END SGOON RD  ",
                "328426"
            ],
            [
                "ZHENG FA TRADING PTE LTD",
                "BLK 1769 GEYLANG BAHRU KALLANG DISTRIPARK  #01-06 ",
                "328780"
            ],
            [
                "YONG TECK SENG",
                "BLK 22 BOON KENG RD #01-29 ",
                "330022"
            ],
            [
                "SAMHUAT CLEANING PRODUCTS",
                "BLK 23  BENDEMEER RD #01-505 ",
                "330023"
            ],
            [
                "SAN CHUNG MINIMART",
                "BLK 24 BENDEMEER RD #01-547 ",
                "330024"
            ],
            [
                "GOOD PRICE CENTRE-BD25",
                "BLK 25  BENDEMEER RD #01-569 ",
                "330025"
            ],
            [
                "WANG LI ESSENTIALS",
                "BLK 25  BENDEMEER RD #01-583 ",
                "330025"
            ],
            [
                "BOON KENG TRADING & MINIMART",
                "BLK 34  WHAMPOA WEST #01-15 ",
                "330034"
            ],
            [
                "TONG SOON MINIMART",
                "BLK 44  BENDEMEER RD #01-1468 ",
                "330044"
            ],
            [
                "GHEE HUAT PROVISION",
                "BLK 45 BENDEMEER RD #01-144  ",
                "330045"
            ],
            [
                "TREATS HAVEN PTE LTD",
                "161 LAVENDER ST #02-03 LAVENDER PLACE ",
                "338750"
            ],
            [
                "FLEISHMAN-HILLARD SINGAPORE",
                "NO. 20 KALLANG AVE #08-00 PICO CREATIVE CTR ",
                "339411"
            ],
            [
                "AH PAU CHOP",
                "NO 101  KALLANG AVE #01-03 VICTORIA WHOLESALE CTR ",
                "339508"
            ],
            [
                "HUANG SONG HUNG",
                "BLK 101  KALLANG AVE #01-12 VICTORIA WHOLESALE CTR ",
                "339508"
            ],
            [
                "HUP SOON & CO",
                "NO 101  KALLANG AVE #07-10/11 VICTORIA WHOLESALE  ",
                "339508"
            ],
            [
                "OH GUAN LEE PTE LTD",
                "NO. 101 KALLANG AVE #01-21 VICTORIA WHOLESALE CTR ",
                "339508"
            ],
            [
                "BAN SENG WINE PTE LTD",
                "1775 GEYLANG BAHRU #01-02  ",
                "339704"
            ],
            [
                "DE CHENG XIN XING TRADING PTE LTD",
                "BLK 1775 GEYLANG BAHRU #01-03 KALLANG DISTRIPARK ",
                "339704"
            ],
            [
                "SAM SENG PTE LTD",
                "NO 1801  GEYLANG BAHRU KALLANG DISTRIPARK 10B  ",
                "339709"
            ],
            [
                "AMPRO PTE LTD",
                "NO 47  TANNERY LANE #05-06 ",
                "347794"
            ],
            [
                "YAK SOON TRADING CO.",
                "NO 47  TANNERY LANE  #06-05,ELITE IND BLDG II ",
                "347794"
            ],
            [
                "GO ASIA TRADING PTE LTD",
                "NO 49  TANNERY LANE #06-02 NOBLE WAREHOUSE ",
                "347796"
            ],
            [
                "SHABAN ENTERPRISES PTE LTD",
                "71 TANNERY LANE #04-06 CITY IND.BULD  ",
                "347807"
            ],
            [
                "MA BAI JUN",
                "10 KWONG AVENUE   ",
                "348884"
            ],
            [
                "JIN HEE STATIONERY & OFFICE SUPPLIES",
                "BLK 155  KALLANG WAY #02-01 ",
                "349244"
            ],
            [
                "WPW PTE LTD",
                "NO 164  KALLANG WAY  #06-28 FAX:68484765/HP:91514231",
                "349248"
            ],
            [
                "GIFTWERX PTE LTD",
                "64-D KALLANG PUDDING RD #09-00 WEE TIONG BUILDING ",
                "349323"
            ],
            [
                "BEAUTY LANGUAGE PTE LTD - 35",
                "NO 50  KALLANG PUDDING RD #06-02 GOLDEN WHEEL IND. BLG ",
                "349326"
            ],
            [
                "LEONG ENG GIN PTE LTD",
                "73 JLN WANGI SENNETT EST.  ",
                "349386"
            ],
            [
                "LEONG ENG GIN PTE LTD",
                "NO 73  JALAN WANGI  ",
                "349386"
            ],
            [
                "A&P MAINTENANCE SERVICES PTE LTD",
                "NO 50  GENTING LANE #04-01 CIDECO IND COMPLEX ",
                "349558"
            ],
            [
                "ENLE PTE LTD",
                "80 GENTING LANE  #10-09 RUBY INDUSTRIAL COMPLEX ",
                "349565"
            ],
            [
                "WAH TECK HAO",
                "NO 80  GENTING LANE #10-09,RUBY IND. COMPLEX ",
                "349565"
            ],
            [
                "SPH BUZZ PTE LTD",
                "NO 82  GENTING LANE  MEDIA CTR ",
                "349567"
            ],
            [
                "LBD STAR",
                "BLK 102 POTONG PASIR #01-K1 ",
                "350102"
            ],
            [
                "LBD STAR",
                "BLK 102 POTONG PASIR #01-K1 ",
                "350102"
            ],
            [
                "HMS SOLUTIONS",
                "BLK 107 POTONG PASIR AVE 1 #01-K1  ",
                "350107"
            ],
            [
                "JIT SHENG PROVISION TRADING",
                "BLK 120 POTONG PASIR AVE 1 #01-822  ",
                "350120"
            ],
            [
                "FRESH PRODUCE SPECIALIST",
                "BLK 136  POTONG PASIR AVE 3 #01-162 ",
                "350136"
            ],
            [
                "BAN HIN MINI SUPERMARKET",
                "BLK 137  POTONG PASIR AVE 3 #01-140 ",
                "350137"
            ],
            [
                "KIN ZHAN PENG TDG COMPANY",
                "BLK 146  POTONG PASIR AVE 1 #01-137 ",
                "350146"
            ],
            [
                "XIN F& K MEDICAL HALL",
                "BLK 146 POTONG PASIR AVE 1 #01-137  ",
                "350146"
            ],
            [
                "LUSTRELITE STORE",
                "BLK 148  POTONG PASIR AVE 1 #01-75 ",
                "350148"
            ],
            [
                "SEOW CHYE SENG MINI SUPERMARKET",
                "BLK 148 POTONG PASIR AVE 1 #01-53  ",
                "350148"
            ],
            [
                "YEEP FOOD RESTAURANT AND CAFE",
                "BLK 48  WOODLEIGHT PARK,BRADDELL RD   PUB RECREATION CLUB",
                "357844"
            ],
            [
                "KHIAN AIK PROVISION SHOP",
                "NO 6  BRADDELL RD,BRADDELL  ",
                "359897"
            ],
            [
                "JIAN LI MINIMARTS",
                "BLK 2  UPP ALJUNIED LANE #01-01 ",
                "360002"
            ],
            [
                "CHIN HIONG HUP KEE - BLK 2",
                "BLK 2 UPP ALJUNIED LANE #01-11  ",
                "360002"
            ],
            [
                "CANTO DEPARTMENTAL STORE",
                "BLK 2  UPP ALJUNIED LANE #01-05 ",
                "360002"
            ],
            [
                "CHIN TECK CHIANG SEAH KEE",
                "BLK 82  MACPHERSON LANE #01-19 ",
                "360082"
            ],
            [
                "HYACINTH DREAM PTE LTD",
                "BLK 82  MACPHERSON LANE #01-15 ",
                "360082"
            ],
            [
                "TOP STATION PTE LTD ",
                "BLK 82 MACPHERSON LANE #01-17 SINGAPORE 360082 ",
                "360082"
            ],
            [
                "FAMILY GROCERY STATION",
                "BLK 83 MACPHERSON LANE #01-255  ",
                "360083"
            ],
            [
                "NAVALINK (S) PTE LTD",
                "BLK 82 MACPHERSON LANE #01-11  ",
                "366082"
            ],
            [
                "GOOD PRICE CENTRE-AJ385",
                "NO 385  UPP ALJUNIED RD,JOO SENG  ",
                "367870"
            ],
            [
                "METROPOLITAN YMCA SINGAPORE",
                "NO 10 LOR 37 GEYLANG  ",
                "367907"
            ],
            [
                "KEEN TRADING AND CONTRACTOR",
                "10 SHAW ROAD MACPHERSON  ",
                "367950"
            ],
            [
                "CAFE-BAR SERVICES",
                "NO 5  PEREIRA RD,ASIAWIDE IND BLDG #06-02  ",
                "368025"
            ],
            [
                "R S MINIMART PTE LTD",
                "BLK 460  MACPHERSON LANE  ",
                "368178"
            ],
            [
                "3BL MART",
                "474 MACPERSON RD MACPHERSON  ",
                "368190"
            ],
            [
                "OK MART",
                "474 MACPHERSON ROAD   ",
                "368190"
            ],
            [
                "TKC SHOP",
                "474 MACPHERSON RD   ",
                "368190"
            ],
            [
                "THIAM HAK PTE LTD",
                "126 JOO SENG RD #01-02 GOLDPINE IND BLDG ",
                "368355"
            ],
            [
                "AUGMENT MARKETING PTE LTD",
                "128 JOO SENG RD #04-01/02 DP ",
                "368356"
            ],
            [
                "JILIN QIAN AN JUN ZI IMPORT & EXPORT P/L",
                "11 JALAN MESIN   TEL:9781 2435",
                "368813"
            ],
            [
                "ACTIVE EXPRESS MART",
                "BLK 36 CIRCUIT ROAD #01-412 ",
                "370036"
            ],
            [
                "ACTIVE SUPERMARKET",
                "BLK 36 CIRCUIT ROAD #01-412 ",
                "370036"
            ],
            [
                "LAM HUAT WINE MERCHANT",
                "BLK 36  CIRCUIT RD #01-428 ",
                "370036"
            ],
            [
                "1 BASIC",
                "BLK 37  CIRCUIT RD #01-399 ",
                "370037"
            ],
            [
                "GOODLUCK PROVISION SHOP (37)",
                "BLK 37  CIRCUIT RD #01-403/405 ",
                "370037"
            ],
            [
                "LIEN SENG TRADING COMPANY",
                "BLK 37  CIRCUIT RD #01-407 ",
                "370037"
            ],
            [
                "S3 MART",
                "BLK 51 CIRCUIT RD #01-809  ",
                "370051"
            ],
            [
                "ZEN BLUE TRADING",
                "BLK 51 CIRCUIT RD #01-809  ",
                "370051"
            ],
            [
                "BEST 2 MINIMART",
                "BLK 55 PIPIT RD #01-04  ",
                "370055"
            ],
            [
                "CPX MINIMART",
                "BLK 55 PIPIT ROAD #01-04  TEL:67455807",
                "370055"
            ],
            [
                "MELON SUPERMARKET PTE LTD",
                "BLK 55 PIPIT ROAD #01-04 ",
                "370055"
            ],
            [
                "YONG JIA MINIMART",
                "BLK 55  PIPIT RD #01-04 ",
                "370055"
            ],
            [
                "APEX MOON PTE LTD",
                "BLK 64 CIRCUIT ROAD #01-347 ",
                "370064"
            ],
            [
                "GOLDEN MOON IMPORT & EXPORT PTE LTD",
                "BLK 64 CIRCUIT RD #01-347  ",
                "370064"
            ],
            [
                "SENG MENG",
                "BLK 64 CIRCUIT RD #01-359  ",
                "370064"
            ],
            [
                "SIVADEVAN SEVENS PTE LTD",
                "BLK 64 CIRCUIT ROAD #01-359  ",
                "370064"
            ],
            [
                "BEST 1 MINIMART",
                "BLK 65  CIRCUIT RD #01-365 ",
                "370065"
            ],
            [
                "KEE & L GENERAL TRADING",
                "BLK 72  CIRCUIT RD #01-19 ",
                "370072"
            ],
            [
                "BAN SAN HIN KEE CHINESE MEDICAL HALL",
                "BLK 77  CIRCUIT RD #01-468 ",
                "370077"
            ],
            [
                "SIEW LUNG COSMETICS",
                "BLK 89  CIRCUIT RD #01-82 ",
                "370089"
            ],
            [
                "S@M MARTS",
                "BLK 91  PAYA LEBAR WAY #01-3025 ",
                "370091"
            ],
            [
                "GOOD PRICE CENTRE - BK11",
                "BLK 11  UPP BOON KENG RD #01-917 ",
                "380011"
            ],
            [
                "JIE SHI PROVISION",
                "BLK 16 UPP BOON KENG RD #01-1111  ",
                "380016"
            ],
            [
                "BEAUTE PHARMA ",
                "NO 17 UPPER BOON KENG ROAD  #01-91  TEL:64412467",
                "380017"
            ],
            [
                "NG JOO CHIANG",
                "BLK 17  UPPER BOON KENG RD #01-139  ",
                "380017"
            ],
            [
                "TAN WAH HENG DEPT STORE",
                "BLK 17  UPP BOON KENG RD #01-141/142 ",
                "380017"
            ],
            [
                "FU KWEE SIANG",
                "BLK 18  UPP BOON KENG RD #01-1123 ",
                "380018"
            ],
            [
                "LONG FA 168 TRADING",
                "BLK 45  SIMS DR #01-168 ",
                "380045"
            ],
            [
                "LIM HEOK PROVISION SHOP ",
                "BLK 47  SIMS PLACE #01-171 ",
                "380047"
            ],
            [
                "CHUAN HENG",
                "BLK 49  SIMS PL #01-96 ",
                "380049"
            ],
            [
                "CHUAN HONG HIN PROVISION SHOP",
                "BLK 49  SIMS PL #01-95 ",
                "380049"
            ],
            [
                "JEE SENG PROVISION SHOP",
                "BLK 49  SIMS PLACE #01-92 MARKET PLACE ",
                "380049"
            ],
            [
                "LIAU CHOON YIAM SUNDRY STORE",
                "BLK 49  SIMS PLACE #01-67 MARKET ",
                "380049"
            ],
            [
                "SIM TIOW HOCK",
                "BLK 49 SIMS PL #01-93 (MARKET PLACE) ",
                "380049"
            ],
            [
                "YARDLEY DEPT. STORE",
                "BLK 49  SIMS DR #01-64 ",
                "380049"
            ],
            [
                "FAMILY FIRST CHOICE MINIMART",
                "BLK 53 SIMS PL #01-176  ",
                "380053"
            ],
            [
                "HING KEE ENTERPRISE",
                "BLK 53 SIMS PL #01-160  ",
                "380053"
            ],
            [
                "CHUAN SENG",
                "BLK 48 SIMS PL #01-157  ",
                "380059"
            ],
            [
                "GOOD PRICE CENTRE-AJ95",
                "BLK 95  ALJUNIED CRESC #01-511 ",
                "380095"
            ],
            [
                "PASSON TRADING",
                "BLK 95 ALJUNIED CRSC #01-503  ",
                "380095"
            ],
            [
                "CHOP TIONG AIK",
                "BLK 119 ALJUNIED AVE 2 #01-18  ",
                "380119"
            ],
            [
                "MIN CHONG COMFORT HOME PTE LTD",
                "NO 39  SIMS AVE  ",
                "387412"
            ],
            [
                "THYE KHENG SUPERMART",
                "131 SIMS AVE GEYLANG  ",
                "387454"
            ],
            [
                "WONDERFUL FRUIT ENTERPRISE PTE LTD",
                "147 SIMS AVE AFTER GEYLANG SERAI  ",
                "387469"
            ],
            [
                "CAUTHEN TRADING LLP",
                "NO 65  LOR 27 GEYLANG GEYLANG ",
                "388188"
            ],
            [
                "TOMATO MART",
                "64 LOR 25A GEYLANG GEYLANG  ",
                "388252"
            ],
            [
                "DAWN SUPERMARKET PTE LTD",
                "32 LOR 23 GEYLANG GEYLANG  ",
                "388367"
            ],
            [
                "UK FISH VILLAGE PTE LTD",
                "NO 43  LOR 21 GEYLANG  ",
                "388467"
            ],
            [
                "ZHENG PING & ASSOCIATES CONSULTANCY",
                "NO 1  LOR 19 GEYLANG #01-02 ",
                "388487"
            ],
            [
                "J. CON TRADING",
                "220 GEYLANG RD OFF LOR 8 GEYLANG  ",
                "389280"
            ],
            [
                "PRB TRADING PTE LTD",
                "230 GEYLANG RD AFTER LOR 10 GEYLANG  ",
                "389290"
            ],
            [
                "MIN SHENG HE HEALTH PRODUCTS DEPT STORE",
                "NO 313  GEYLANG RD OFF LOR 17 GEYLANG ",
                "389352"
            ],
            [
                "I-TEC SUPERMART PTE LTD (317)",
                "NO 317-319  GEYLANG RD OFF LOR 19 GEYLANG ",
                "389356"
            ],
            [
                "I-TEC SUPERMART PTE LTD (347)",
                "NO 347  GEYLANG RD OFF LOR 21 GEYLANG ",
                "389368"
            ],
            [
                "M.R. PROVISIONS",
                "NO 354 GEYLANG RD  ",
                "389374"
            ],
            [
                "I-TEC SUPERMART PTE LTD - (500)",
                "NO 500  GEYLANG RD THE GREEN COURT ",
                "389458"
            ],
            [
                "GREENBEGGER MART PTE LTD",
                "527 GEYLANG RD OFF LOR 27A GEYLANG  ",
                "389483"
            ],
            [
                "ZEVAN PTE LTD",
                "NO 584  GEYLANG RD  ",
                "389523"
            ],
            [
                "JUN TENG INTERNATIONAL TRADING PTE LTD",
                "NO 803  GEYLANG RD  ",
                "389682"
            ],
            [
                "BAN HONG HUP SENG",
                "NO 5  ALJUNIED RD NEAR SIMS AVE ",
                "389797"
            ],
            [
                "A STAR 33 STORE",
                "17 OLD AIRPORT RD KALLANG EST. MARKET STALL 33  ",
                "397972"
            ],
            [
                "JEEWA LIMITED",
                "31 LOR 12 GEYLANG GEYLANG  ",
                "399006"
            ],
            [
                "MUSLIM MISSIONARY SOCIETY SINGAPORE",
                "31 LORONG 12 GEYLANG  ",
                "399006"
            ],
            [
                "JIRA-KEN TRADING",
                "NO 70  LOR 8 GEYLANG,GEYLANG  ",
                "399132"
            ],
            [
                "WATSON MINI SUPERMARKET",
                "3B GUILLEMAROAD RD KATONG EST.  ",
                "399684"
            ],
            [
                "HUA BROTHERS HARDWARE PTE LTD-GB",
                "BLK 92 GEYLANG BAHRU #01-2768 KALLANG BASIN IND. PK ",
                "399700"
            ],
            [
                "TEONG SHUN TRADING",
                "BLK 5   EUNOS CRESCENT #01-2599 ",
                "400005"
            ],
            [
                "SMILES MART PTE LTD",
                "BLK 6  EUNOS CRESC #01-2631 ",
                "400006"
            ],
            [
                "EUNOS CRESCENT (ECON)",
                "BLK 6 EUNOS CRSC #01-2633  ",
                "400006"
            ],
            [
                "FERDOUZE MINIMART",
                "BLK 6 EUNOS CRSC #01-2631  ",
                "400006"
            ],
            [
                "KIA JOO",
                "BLK 6  EUNOS CRESC #01-2635 ",
                "400006"
            ],
            [
                "LOW PRICE CENTRE",
                "BLK 6  EUNOS CRESC #01-2649 ",
                "400006"
            ],
            [
                "USHA S MARKETING PTE LTD",
                "BLK 20  EUNOS CRSC #01-2955 ",
                "400020"
            ],
            [
                "GOOD PRICE CENTRE -UB 302",
                "BLK 302  UBI AVE #01-69 ",
                "400302"
            ],
            [
                "SEH HAN FRUITS TRADING",
                "BLK 302 UBI AVE 1 #01-69  ",
                "400302"
            ],
            [
                "TAI SING ESSENTIALS",
                "BLK 304  UBI AVE 1 #01-123 TEL:6745 1381",
                "400304"
            ],
            [
                "ORANGE DEPARTMENT STORE (UBI)",
                "BLK 306  UBI AVE 1 #01-213 ",
                "400306"
            ],
            [
                "EVERYDAY MARKET UBI PTE LTD",
                "325 UBI AVE 1 #01-699  ",
                "400325"
            ],
            [
                "EVERYDAY MARKET UBI PTE LTD",
                "BLK 325  UBI AVE 1 #01-699 ",
                "400325"
            ],
            [
                "KTM 11 SUPERMART UBI PTE LTD",
                "BLK 325 UBI AVE 1 #01-699  ",
                "400325"
            ],
            [
                "LIM CHYE HUAT TRADING COMPANY",
                "BLK 325  UBI AVE 1 #01-705 ",
                "400325"
            ],
            [
                "FOOK YUAN TONG",
                "BLK 342 UBI AVE 1 #01-931  ",
                "400342"
            ],
            [
                "NEO GUAN HUAT",
                "BLK 350  UBI AVE 1 #01-945 ",
                "400350"
            ],
            [
                "FOURSEAS PRODUCTS PTE LTD",
                "NO 8  UBI RD 2 #05-04 ZERVEX",
                "408538"
            ],
            [
                "BUYLAH PTE LTD",
                "NO 10 UBI CRESCENT #04-47 UBI TECKPARK LOBBY C ",
                "408564"
            ],
            [
                "JUST RELAX HOME SERVICES PTE LTD",
                "NO 10  UBI CRESC #03-62,LOBBY D UBI TECHPARK ",
                "408564"
            ],
            [
                "LIN HUP TRADING CO. PTE LTD",
                "NO 70  UBI CRESC #01-05 UBI TECHPARK ",
                "408570"
            ],
            [
                "PAN-CO HARDWARE & ENGRG PTE LTD",
                "55 UBI CRESENT #01-00  ",
                "408595"
            ],
            [
                "JITT YI SHENG TRADING",
                "BLK 3025 UBI RD 3 #01-121  ",
                "408653"
            ],
            [
                "FERRAGOLD S PTE LTD -(UBI)",
                "BLK 3015A UBI RD 1 #05-07  ",
                "408705"
            ],
            [
                "918 WHOLESALE",
                "BLK 61 UBI RD 1 #01-18 OXLEY BIZHUB ",
                "408727"
            ],
            [
                "TH MARINE PTE LTD",
                "NO 125  UBI AVE 4 THONG XING COMPLEX ",
                "408768"
            ],
            [
                "FISHER & PAYKEL SINGAPORE PTE LTD",
                "NO 150  UBI AVE 4 #03-01A UBI BIZ HUB ",
                "408825"
            ],
            [
                "PINK BEAUTY COSMETICS PTE LTD",
                "NO 52  UBI AVENUE 3 #02-44 THE FRONTIER ",
                "408867"
            ],
            [
                "BLACK SEA MARINE & TRADING PTE LTD",
                "NO 33  UBI AVE 3 #01-67 VERTEX",
                "408868"
            ],
            [
                "SENA TRADING COMPANY",
                "NO 53  UBI AVE 1 #01-43 PAYA UBI IND. PARK",
                "408934"
            ],
            [
                "SENA IMPORT EXPORT PTE LTD",
                "NO 53  UBI AVE 1 #01-43 PAYA UBI IND PARK ",
                "408934"
            ],
            [
                "LEGEND MAINTENANCE (S) P/L",
                "59 UBI AVE 1 #03-05 BIZLINK CTR ",
                "408938"
            ],
            [
                "NEW INTENTION TRADING CO",
                "59 UBI AVE 1 #02-07 BIZLINK CTR ",
                "408938"
            ],
            [
                "VIETNAM CHAMBER OF COMMERCE P/L-V SQUARE",
                "NO 140  PAYA LEBAR RD #01-11,A2 BLDG ",
                "409015"
            ],
            [
                "CHINA HEALTHCARE LIMITED",
                "20 JLN AFIFI #06-02 CISCO CTR ",
                "409179"
            ],
            [
                "ABDULLAH TRADING",
                "NO 810  GEYLANG ROAD #01-66 ",
                "409286"
            ],
            [
                "CITY HERBS TRADING (810)",
                "810 GEYLANG RD #02-05 CITY PLAZA ",
                "409286"
            ],
            [
                "MEI YEN BEAUTY & COSMETIC CENTRE",
                "810 GEYLANG RD #01-41 CITY PLAZA ",
                "409286"
            ],
            [
                "PAPER CUP MARKET PLACE",
                "NO 409  EUNOS RD #01-03 EUNOS BUS INTERCHANGE ",
                "409388"
            ],
            [
                "IMPRES TRADING",
                "BLK 30  EUNOS CRESC #01-09 EUNOS MRT STATION ",
                "409423"
            ],
            [
                "IYDA MARINE SERVICES PTE LTD",
                "BLK 1049  EUNOS AVE 6 #01-148 ",
                "409628"
            ],
            [
                "YEW TIN HARDWARE TRADING COMPANY",
                "BLK 1034 EUNOS AVE 5 #01-62/64(TEL:6746 5506) ",
                "409743"
            ],
            [
                "TOPIMAX MARINE PTE LTD",
                "BLK 1046  EUNOS AVE 5 #01-131 ",
                "409746"
            ],
            [
                "GAN SAI TRADING",
                "BLK 1057 EUNOS AVE 3 #01-61  ",
                "409849"
            ],
            [
                "TENAGA MINIMART",
                "BLK 649  JLN TENAGA #01-155 ",
                "410649"
            ],
            [
                "GOLDEN BAMBOO BROS SUPERMART PTE LTD-655",
                "BLK 655  JLN TENAGA #01-94 ",
                "410655"
            ],
            [
                "GREENLAND MINIMART",
                "BLK 669 JALAN DAMAI #01-51 ",
                "410669"
            ],
            [
                "KALAM MINI MART",
                "BLK 669 JLN DAMAI #01-51  ",
                "410669"
            ],
            [
                "FRIENDS HYPERMART PTE LTD",
                "NO. 7 KAKI BT AVE 3 KAKI BUKIT RECREATION CTR  ",
                "415814"
            ],
            [
                "NAVALINK (S) PTE LTD",
                "NO 7  KAKI BUKIT AVE 3  ",
                "415819"
            ],
            [
                "PMC MART PTE LTD",
                "NO 10  KAKI BUKIT AVE 4 #06-75,PREMIER@KAKIBUKIT ",
                "415874"
            ],
            [
                "JASRACO MARINE SERVICES PTE LTD",
                "NO 15  KAKI BUKIT RD 3 EAST POINT TERRACE ",
                "415886"
            ],
            [
                "5 STAR SUPERMARKET PTE LTD",
                "31 KAKI BT AVE 3 #01-00 GOLDEN BUKIT DORMITORY 2 ",
                "415916"
            ],
            [
                "5 STAR SUPERMARKET PTE LTD",
                "39 KAKI BT AVE 3 FIVE (5) STAR DORMITORY  ",
                "415920"
            ],
            [
                "AZ SUPERMART PTE LTD-KB39",
                "39 KAKI BUKIT AVE 3 DORMITORY  ",
                "415920"
            ],
            [
                "UNIVERSAL HOMEMART-1KB",
                "1 KAKI BT RD 1 #01-15 ENTERPRISE ONE ",
                "415934"
            ],
            [
                "TOSN MINIMART & RESTAURANT",
                "18 KAKI BT RD 3 #01-12 ENTERPRENEUR BUSSINESS CENTR ",
                "415978"
            ],
            [
                "ABI MINIMART",
                "NO 11  KAKI BUKIT TERRACE ",
                "416095"
            ],
            [
                "BRITISH ESSENTIAL (S) PTE LTD-KB13",
                "NO 13  KAKI BUKIT IND.TER. NUOVAMAT ENTERPRISE ",
                "416096"
            ],
            [
                "HAPPY MINIMART",
                "2 KAKI BT AVE 4 KAKI BUKIT HOSTEL  ",
                "416242"
            ],
            [
                "MOCARZ TRADING",
                "NO 25  KAKI BUKIT RD 4 #05-55 SYNERGY@KB ",
                "417800"
            ],
            [
                "BEST COSMETICS TRADING",
                "30 KAKI BT RD 3 #02-10 EMPIRE TECHNO CTR ",
                "417819"
            ],
            [
                "IDEAL PARTS PTE LTD",
                "NO 15  KAKI BUKIT RD 2 KB WAREHOUSE COMPLEX ",
                "417845"
            ],
            [
                "MOCARZ TRADING",
                "10 KAKI BT RD 2 #03-07 FIRST EAST CTR ",
                "417868"
            ],
            [
                "YUKIN PTE LTD",
                "61 KAKI BT AVE 1 #03-13 SHUN LI IND. PARK ",
                "417943"
            ],
            [
                "YUKIN PTE LTD",
                "BLK 61  KAKI BUKIT AVE 1 #03-13,SHUN LI IND. PARK ",
                "417943"
            ],
            [
                "HAI SENG SUPERMARKET",
                "84 JLN SENANG KEMBANGAN  ",
                "418454"
            ],
            [
                "HONG CHYE PROVISION GOOD TRADING",
                "NO 14-B  JLN MASJID OPP KEMBANGAN MRT ",
                "418934"
            ],
            [
                "KIWI STORES PTE LTD - TELOK KURAU",
                "NO 112  TELOK KURAU RD  ",
                "423800"
            ],
            [
                "HAPPY IN-N-OUT",
                "BLK 201  TELOK KURAU RD #01-07 KURAU COURT ",
                "423910"
            ],
            [
                "MOHAMMAD HABIB & SONS PTE LTD",
                "NO 54  ONAN RD JOO CHIAT ",
                "424502"
            ],
            [
                "98 FAIR PRICE MARKET ",
                "BLK 26  NEW UPPER CHANGI RD #01-664 ",
                "426026"
            ],
            [
                "NSL & NEO SEWING MACHINE & TRADING",
                "NO 13  LOR 106 CHANGI  TEL:6348 8473",
                "426479"
            ],
            [
                "CHOP KOON GUAN",
                "56 KOON SENG RD JOO CHIAT  ",
                "426996"
            ],
            [
                "81 WHOLESALERS & TRADING",
                "NO 94  JOO CHIAT RD JOO CHIAT ",
                "427388"
            ],
            [
                "NEW AQSA TRADING PTE LTD",
                "154 JOO CHAIT ROAD   ",
                "427432"
            ],
            [
                "BESPRICE MINIMART",
                "NO 184  JOO CHIAT RD  TEL:91684148",
                "427455"
            ],
            [
                "B.N.M TRADING PTE LTD",
                "269 JOO CHIAT RD JOO CHIAT  ",
                "427523"
            ],
            [
                "SHI HUI PROVISION STORE",
                "NO 270  JOO CHIAT RD JOO CHIAT ",
                "427524"
            ],
            [
                "81 WHOLESALE PTE LTD",
                "81 JOO CHIAT RD JOO CHIAT  ",
                "427725"
            ],
            [
                "BEAUTY & CARE-PRODUCTS STORE PTE LTD",
                "NO 428  RIVER VALLEY RD #01-02 LOFT @ NATHAN ",
                "428327"
            ],
            [
                "M.R.S SHAMIR TRADING-EC",
                "NO 33  EAST COAST RD OPP PARAMOUNT SHP CTR. ",
                "428753"
            ],
            [
                "KENG KEI FOODS ENTERPRISE",
                "231 EAST COAST RD EAST COAST RD  ",
                "428927"
            ],
            [
                "HUA TONG YEW KEE P/S",
                "288 EAST COAST RD EAST COAST ROAD  ",
                "428949"
            ],
            [
                "BIZCOMPTECH PTE LTD (HR)",
                "BLK 3  HAIG RD  #01-523 TEL: 82767786",
                "430003"
            ],
            [
                "GIM HIN LEE (PTE) LTD",
                "BLK 10  HAIG RD #01-363/365 ",
                "430010"
            ],
            [
                "THYE HIN TONG MEDICAL STORE",
                "BLK 10  HAIG RD #01-371 ",
                "430010"
            ],
            [
                "FAIRPRICE GENERAL STORE PTE LTD",
                "BLK 7  JLN BATU #01-103 ",
                "431007"
            ],
            [
                "HENG CHOON FOH MEDICAL STORE",
                "BLK 7 JLN BATU #01-105  ",
                "431007"
            ],
            [
                "HIJIRATH IMPEX PTE LTD",
                "#01-103 BLK 7 JALAN BATU  TEL:9343 9039",
                "431007"
            ],
            [
                "MENG HUAT PROVISION SHOP",
                "BLK 7  JLN BATU #01-97 ",
                "431007"
            ],
            [
                "LEONG BROTHER DEPT STORE",
                "BLK 8  JLN BATU,KAMPONG ARANG RD #01-09  ",
                "431008"
            ],
            [
                "LIANG KEE MINIMART",
                "BLK 8  JLN BATU #01-17 ",
                "431008"
            ],
            [
                "GOH BENG KIAT",
                "BLK 4A JLN BATU #02-28/29 (MARKET) ",
                "432004"
            ],
            [
                "WATERSIDE MINIMART",
                "BLK 13  TANJONG RHU RD #01-01/02,THE WATERSIDE ",
                "436897"
            ],
            [
                "PEBBLE BAY MINIMART",
                "NO 130 BLOCK 4 TANJONG RHU RD #01-02  ",
                "436918"
            ],
            [
                "EVERGREEN DISTRIBUTION PTE LTD",
                "BLK 210 TANJONG KATONG  ",
                "437003"
            ],
            [
                "TECK HENG MINIMART",
                "NO 254  TANJONG KATONG RD KATONG EST. ",
                "437042"
            ],
            [
                "STAR UP PTE LTD",
                "310 TANJONG KATONG RD KATONG EST.  ",
                "437093"
            ],
            [
                "AVIGHNA TRADING SERVICES PTE LTD",
                "NO 314 TANJONG KATONG ROAD  ",
                "437097"
            ],
            [
                "STAR UP PTE LTD",
                "314 TANJONG KATONG ROAD   ",
                "437097"
            ],
            [
                "KATONG NEWS AGENCY",
                "NO 350  TANJONG KATONG RD KATONG EST. ",
                "437116"
            ],
            [
                "SHOP RIGHT SUPERMARKET P/L (LENA`S MART)",
                "BLK 7  RHU CROSS  #B1-01 COSTA RHU ",
                "437435"
            ],
            [
                "LENAS MART",
                "7 RHU CROSS #B1-01 COSTA RHU ",
                "437435"
            ],
            [
                "REY IM COSMETICS HOUSE",
                "NO 865  MOUNTBATTEN RD #01-53 KATONG SHOPPING CTR ",
                "437844"
            ],
            [
                "RINGO MOBILE TRADING",
                "NO 865  MOUNTBATTEN RD #B1-25,KATONG SHOPPING CTR ",
                "437844"
            ],
            [
                "SLIMMING SANCTUARY PTE LTD",
                "865 MOUNTBATTEN RD #05-41 KATONG SHOPPING CTR ",
                "437844"
            ],
            [
                "MAKENAS MART",
                "NO 121  MEYER RD #01-05A THE MAKENA CONDO ",
                "437932"
            ],
            [
                "MR MARK",
                "NO 19  JLN SEDAP OFF CRESCENT RD SINGAPORE 438275 Tel:9662 8680",
                "438275"
            ],
            [
                "SHIVSAGER TRADING PTE LTD",
                "NO 28  HAIG RD OFF EAST COAST RD  ",
                "438736"
            ],
            [
                "HASRAH TRADING PTE LTD",
                "114A ARTHUR RD #01-02 KATONG PARK TOWERS ",
                "439826"
            ],
            [
                "SUNRISE & SHINE TRADING",
                "NO 85  AMBER RD #16-16 ",
                "439895"
            ],
            [
                "M.R.S. SHAMIR TRADING",
                "BLK 19 AMBER GAROADENS #01-19 MARYLAND PARK ",
                "439962"
            ],
            [
                "K & M FRESH MART PTE LTD",
                "BLK 13 MARINE TERRACE #01-176  ",
                "440013"
            ],
            [
                "KHAI TECK WINE MERCHANT",
                "BLK 57  MARINE TERRACE #01-111 ",
                "440057"
            ],
            [
                "DIAN ESSENTIALS",
                "BLK 58  MARINE TERRACE #01-53 ",
                "440058"
            ],
            [
                "GOOD PRICE CENTRE -59",
                "BLK 59  MARINE TERRACE #01-83 ",
                "440059"
            ],
            [
                "SIN HUP SENG LIM KEE",
                "BLK 59  MARINE TERRACE #01-95 ",
                "440059"
            ],
            [
                "THONG SENG LEE MINI MART",
                "BLK 59 MARINE TERRACE #01-97 ",
                "440059"
            ],
            [
                "YONG HER SIN MEDICAL HALL",
                "BLK 59  MARINE TERRACE #01-87 ",
                "440059"
            ],
            [
                "HOTEL 81 MANAGEMENT PTE LTD",
                "NO 80  MARINE PARADE RD #21-01 PARKWAY PARADE ",
                "449269"
            ],
            [
                "VALENTINE FRAGRANCE & COSMETICS",
                "NO 80  MARINE PARADE RD #B1-07,PARKWAY PARADE ",
                "449269"
            ],
            [
                "V HOTEL MANAGEMENT PTE LTD",
                "NO 80  MARINE PARADE RD #21-01,PARKWAY PARADE ",
                "449269"
            ],
            [
                "VILLAGE HOTEL KATONG",
                "NO 25  MARINE PARADE EAST VILLAGE HOTEL ",
                "449536"
            ],
            [
                "LEISURE @ EAST COAST PTE LTD",
                "NO 1018  EAST COAST PARKWAY EAST COAST PARK ",
                "449877"
            ],
            [
                "WAT-A-DEAL PTE LTD",
                "NO 1110 EAST COAST PARKWAY EAST COAST RESORT ",
                "449880"
            ],
            [
                "CHOP THYE BEE LIQUORS",
                "NO 105  FRANKEL AVE FRANKEL EST. ",
                "458226"
            ],
            [
                "LIAN BENG HUAT",
                "NO 5-D  FIGARO ST,OPERA EST.  ",
                "458329"
            ],
            [
                "YOUR FRIEND @ MINIMART",
                "BLK 3  BEDOK SOUTH AVE 1 #01-855 ",
                "460003"
            ],
            [
                "EC FRAGRANCE & PERFUMERY TRADING",
                "BLK 16 BEDOK STH RD #01-491  ",
                "460016"
            ],
            [
                "HE SHENG VEGETABLE SUPPLIER",
                "BLK 17  BEDOK SOUTH RD #01-577 ",
                "460017"
            ],
            [
                "NG KIAN SENG",
                "BLK 17 BEDOK STH RD #01-567  ",
                "460017"
            ],
            [
                "NGOW CHE SWEE MEDICAL HALL",
                "BLK 17  BEDOK SOUTH RD #01-579 ",
                "460017"
            ],
            [
                "SAN AIK TRADING CO.",
                "BLK 17 BEDOK STH RD #01-581  ",
                "460017"
            ],
            [
                "GOOD PRICE CENTRE-BS18(FOOD)",
                "BLK 18  BEDOK SOUTH RD #01-59 ",
                "460018"
            ],
            [
                "GOOD PRICE CENTRE-BS18(COS)",
                "BLK 18  BEDOK SOUTH RD #01-53 ",
                "460018"
            ],
            [
                "LAM GUAN COMPANY",
                "BLK 18 BEDOK STH RD #01-71  ",
                "460018"
            ],
            [
                "USHA S MARKETING",
                "BLK 54  CHAI CHEE ST #01-881 ",
                "460054"
            ],
            [
                "KWONG SENG MINI-SUPERMARKET",
                "BLK 55 CHAI CHEE DR #01-196  ",
                "460055"
            ],
            [
                "GOOD PRICE CENTRE-BS59",
                "BLK 59  NEW UPP CHANGI RD #01-1222 ",
                "460059"
            ],
            [
                "SHINNING STAR MART",
                "BLK 62 CHAI CHEE RD #01-K1 ",
                "460062"
            ],
            [
                "K.K.L. SUPER STORE",
                "BLK 62 CHAI CHEE RD #01-K1 ",
                "460062"
            ],
            [
                "REAL BUY-CC62",
                "BLK 62 CHAI CHEE RD #01-K1  ",
                "460062"
            ],
            [
                "TIAN TIAN LAI MINIMART",
                "62 CHAI CHEE RD #01-K1  ",
                "460062"
            ],
            [
                "SUEN HOE HUAT",
                "BLK 69  BEDOK SOUTH AVE 3 #01-484 ",
                "460069"
            ],
            [
                "NOOR HAMARA",
                "BLK 73  BEDOK SOUTH AVE 3 #01-466 ",
                "460073"
            ],
            [
                "CHEN HOE MEDICAL HALL",
                "BLK 84 BEDOK NTH ST 4 #01-71  ",
                "460084"
            ],
            [
                "GOOD PRICE CENTRE -BN84",
                "BLK 84  BEDOK NORTH ST4 #01-57 ",
                "460084"
            ],
            [
                "HUNG SANG HOE MEDICAL HALL",
                "BLK 84  BEDOK NORTH ST 4 #01-61 ",
                "460084"
            ],
            [
                "YU KO FU PTE LTD",
                "BLK 84  BEDOK NORTH ST 4 #01-01 ",
                "460084"
            ],
            [
                "YEE HONG SENG SUPERMARKET",
                "BLK 88  BEDOK NORTH ST 4 #01-147 ",
                "460088"
            ],
            [
                "LAM HENG HANG TRADING CO PTE LTD",
                "BLK 88 BEDOK NTH ST 4 #01-147  ",
                "460088"
            ],
            [
                "MCP FAIRMART PTE LTD - BEDOK",
                "BLK 89 BEDOK NORTH AVE 4 #01-107 ",
                "460089"
            ],
            [
                "JABBAR STORE",
                "BLK 105 BEDOK NTH AVE 4 #01-2182  ",
                "460105"
            ],
            [
                "ATOK-MART PTE LTD",
                "BLK 122 BEDOK NORTH ST 2 #01-120B ",
                "460122"
            ],
            [
                "BENG GUAN MINIMART",
                "BLK 122  BEDOK NTH ST 2 #01-102 ",
                "460122"
            ],
            [
                "MOIDEEN TRADING PTE LTD",
                "BLK 122 BEDOK NTH ST #01-120B  ",
                "460122"
            ],
            [
                "MUHAMMAD AMIR PTE LTD",
                "BLK 122 BEDOK NORTH ST 2 #01-120B ",
                "460122"
            ],
            [
                "SON OF A BEAN PTE LTD",
                "BLK 136  BEDOK NORTH AVE 3 #01-152 ",
                "460136"
            ],
            [
                "VARIETIES TRADING",
                "BLK 158  BEDOK SOUTH AVE 3 #01-585 ",
                "460158"
            ],
            [
                "B.P. POWER",
                "BLK 206  BEDOK NTH ST 1 #01-355 ",
                "460206"
            ],
            [
                "THYE HIN HOE MEDICAL STORE",
                "BLK 208  NEW UPP CHANGI RD #01-683 ",
                "460208"
            ],
            [
                "FU WAH DEPT STORE",
                "BLK 218  BEDOK NORTH ST 1 #01-39 ",
                "460218"
            ],
            [
                "VELAN TRADING PTE LTD - BEDOK",
                "BLK 418 BEDOK NORTH AVE 2 #01-71 ",
                "460418"
            ],
            [
                "GOOD PRICE CENTRE-BN509",
                "BLK 509  BEDOK NORTH ST 3 #01-131 ",
                "460509"
            ],
            [
                "MELON SUPERMARKET PTE LTD",
                "BLK 510  BEDOK NORTH ST 3 #01-33 TEL: 8652 2669",
                "460510"
            ],
            [
                "SPK STORES PTE LTD ",
                "BLK 510  BEDOK NORTH ST 3 #01-75  ",
                "460510"
            ],
            [
                "SUBAIDA MINIMART",
                "BLK 527 BEDOK NTH ST 3 #01-516  ",
                "460527"
            ],
            [
                "FOOK CHONG FOH MEDICAL HALL",
                "BLK 530 BEDOK NTH ST 3 #01-628  ",
                "460530"
            ],
            [
                "THAT KORNER SHOP",
                "BLK 533  BEDOK NORTH ST 3 #01-274 TEL:62458563/94240521",
                "460533"
            ],
            [
                "AREHMAN TRADING PTE LTD",
                "BLK 537 BEDOK NTH ST 3 #01-547  ",
                "460537"
            ],
            [
                "JAMAL MINI MART",
                "BLK 537 BEDOK NTH ST 3 #01-547  ",
                "460537"
            ],
            [
                "ROYAL ROSE MINIMART",
                "537 BEDOK NTH ST 3 #01-527  ",
                "460537"
            ],
            [
                "CASH & CARRY VALUE STORE",
                "539 BEDOK NORTH ST 3  #01-583  ",
                "460539"
            ],
            [
                "JEN TIAN MEDICAL HALL",
                "BLK 539 BEDOK NTH ST3 #01-629  ",
                "460539"
            ],
            [
                "RUNDA TRADING PTE LTD",
                "BLK 21  CHAI CHEE RD #01-442 ",
                "461021"
            ],
            [
                "SUNSHINE SUPERMART PTE LTD",
                "BLK 21 CHAI CHEE RD #01-442  ",
                "461021"
            ],
            [
                "KG. CHAI CHEE MINIMART",
                "BLK 42  CHAI CHEE ST #01-62 ",
                "461042"
            ],
            [
                "BONG KIM MEDICAL HALL & TRADING CO.",
                "BLK 59 NEW UPP CHANGI RD #01-1250  ",
                "461059"
            ],
            [
                "TUNGSAN FOOD INDUSTRIES PTE LTD -BD",
                "BLK 539A  BEDOK NORTH ST 3 #01-475 ",
                "461539"
            ],
            [
                "NG LIAN HUAT",
                "BLK 25  NEW UPP CHANGI RD #01-638 ",
                "462025"
            ],
            [
                "BUDGET CENTRE",
                "BLK 57A  NEW UPP CHANGI RD #01-1396 ",
                "462057"
            ],
            [
                "YES SUPERMARKET WAREHOUSE",
                "BLK 502  CHAI CHEE LANE #01-02G ",
                "469025"
            ],
            [
                "LOW HONG HUAT (KENG KEE) MINI SUPERMART",
                "NO 339  BEDOK RD SIMPANG BEDOK ",
                "469518"
            ],
            [
                "CHEAP MINIMART",
                "NO 343  BEDOK RD BEDOK ",
                "469526"
            ],
            [
                "TOP CHOICE SUPERMARKET - BAYSHORE",
                "BLK 84  BAYSHORE RD #01-38 COSTA DEL SOL ",
                "469994"
            ],
            [
                "DOJIN INTERNATIONAL TRADING",
                "BLK 121  BEDOK RESERVOIR RD #01-198 ",
                "470121"
            ],
            [
                "BEDOK RESERVOIR MINI MART",
                "BLK 121  BEDOK RESERVOIR RD #01-194 ",
                "470121"
            ],
            [
                "CHEE HOE SENG MINI SUPERMARKET",
                "BLK 121  BEDOK RESERVOIR RD #01-204 ",
                "470121"
            ],
            [
                "AL BISMI MINIMART",
                "BLK 136  BEDOK RESERVIOR RD #01-1421 ",
                "470136"
            ],
            [
                "CHUAN NAM MINIMART",
                "BLK 151  BEDOK RESERVIOR #01-1739 ",
                "470151"
            ],
            [
                "ABDULLAHA TRADING AND SERVICES PTE. LTD.",
                "BLK 631  BEDOK RESERVOIR RD #01-952 ",
                "470631"
            ],
            [
                "BAN MOH HENG PROVISION SHOP",
                "BLK 631  BEDOK RESERVOIR RD #01-972 ",
                "470631"
            ],
            [
                "GIBSON MEDICAL HALL",
                "BLK 631  BEDOK REDERVOIR #01-950 ",
                "470631"
            ],
            [
                "TOP PLUS SUPERMARKET",
                "BLK 632  BEDOK RESERVOIR RD #01-834/836 ",
                "470632"
            ],
            [
                "FOOK ANN SIANG MED & TRD CO",
                "BLK 632  BEDOK RESERVOIR RD #01-802 ",
                "470632"
            ],
            [
                "TT DEPARTMENTAL STORE",
                "BLK 632  BEDOK RESERVOIR RD #01-810 ",
                "470632"
            ],
            [
                "TL DEPT STORE",
                "BLK 632  BEDOK RESERVOIR RD #01-810 ",
                "470632"
            ],
            [
                "SAVE MINI MART",
                "BLK 760 BEDOK RESERVOIR VIEW #01-339 ",
                "470760"
            ],
            [
                "PENG WANG FISH PRODUCT",
                "BLK 3017 BEDOK NORTH ST 5 #01-33 ",
                "486121"
            ],
            [
                "FIRST PRICE 2 PTE LTD",
                "3018 BEDOK NTH ST 5 #06-09 EASTLINK LIGHT IND. FACTORY ",
                "486132"
            ],
            [
                "SAVER TRADING PTE LTD",
                "BLK 3018  BEDOK NORTH ST 5 #05-14 ",
                "486132"
            ],
            [
                "UNICARE IMPEX PTE LTD",
                "BLK 3016  BEDOK NORTH AVE 4 #08-29,EASTECH ",
                "489947"
            ],
            [
                "WALSON FOOD DISTRIBUTOR PTE LTD",
                "BLK 3016 BEDOK NTH AVE 4 #05-04 EASTECH ",
                "489947"
            ],
            [
                "CP MANAGEMENT SERVICES PTE LTD",
                "NO 80  TANAH MERAH COAST RD #01-02 ",
                "498736"
            ],
            [
                "GOBULK PTE LTD",
                "NO 15 CHANGI NORTH ST 1 #01-22 I-LOFTS@CHANGI ",
                "498765"
            ],
            [
                "COMPASS GREEN STORE",
                "100 TANAH MERAH BESAR RD #02-06  ",
                "498841"
            ],
            [
                "SUN 100",
                "BLK 4  CHANGI VILLAGE RD #01-2066 ",
                "500004"
            ],
            [
                "YOUR CHOICE MINI MART",
                "NO 1 FLORA DR DAHLIA PARK CONDO ",
                "507009"
            ],
            [
                "CHANGI FRIENDLY STORE",
                "NO 963  UPPER CHANGI RD NORTH CHANGI GAROADEN ",
                "507664"
            ],
            [
                "SOON TONG HUAT",
                "NO 963-A  UPPER CHANGI RD  NORTH CHANGI GARDEN ",
                "507664"
            ],
            [
                "DASHMESH SINGAPORE PTE LTD",
                "NO 19  LOYANG WAY #03-23 CHANGI LOGISTICS CTR ",
                "508724"
            ],
            [
                "A G MINIMART",
                "NO 9  FLORA RD #01-04 AVILA GARDEN ",
                "508737"
            ],
            [
                "CONTACT ME SERVICES & DECORATION PTE LTD",
                "NO 25 LOYANG CRESC LOYANG OFFSHORE SUPP BASE BLK 103,TOP AVE1 #03-08,BOX NO:5171",
                "508988"
            ],
            [
                "L V MART",
                "BLK 216  LOYANG AVE LOYANG VALLEY CONDO ",
                "509070"
            ],
            [
                "RVR MINI MART",
                "BLK 114  PASIR RIS ST 11 #01-KI1 ",
                "510114"
            ],
            [
                "VIBRANT MART",
                "BLK 114 PASIR RIS ST. 11 #01-K1  ",
                "510114"
            ],
            [
                "E-MINIMART",
                "BLK 121  PASIR RIS ST 11 #01-K1 ",
                "510121"
            ],
            [
                "ONE STOP MINI MART",
                "BLK 136  PASIR RIS ST 11 #01-233 ",
                "510136"
            ],
            [
                "XIN SHENG MINI-MART",
                "BLK 212 PASIR RIS ST 21 #01-226 ",
                "510212"
            ],
            [
                "M.R. PASIR RIS MINIMART",
                "BLK 230  PASIR RIS ST 2 #01-44 ",
                "510230"
            ],
            [
                "BODY SENZE",
                "BLK 258  PASIR RIS DR 21 #01-343 ",
                "510258"
            ],
            [
                "TONG XING TANG BA XI LI CAN RONG YAO",
                "BLK 258  PASIR RIS ST 21 #02-337,LOYANG POINT ",
                "510258"
            ],
            [
                "GOH MINI-MART",
                "BLK 407  PASIR RIS DR 6 #01-K1 TEL: 6581 4763",
                "510407"
            ],
            [
                "SHIVARANJANI MINIMART",
                "BLK 416 PSIR RIS DR 6 #01-K1 ",
                "510416"
            ],
            [
                "JANES DEPARTMENTAL STORE",
                "BLK 443  PASIR RIS DR 6 #01-08 ",
                "510443"
            ],
            [
                "JIN TAI TONG-445",
                "BLK 445 PASIR RIS DR 6 #01-96  ",
                "510445"
            ],
            [
                "POH HENG PROVISION SHOP",
                "BLK 445  PASIR RIS DR 6 #01-90 ",
                "510445"
            ],
            [
                "NEW HUAY TONG TRADING",
                "BLK 446  PASIR RIS DR 6 #01-110 ",
                "510446"
            ],
            [
                "YI CHENG DEPT STORE",
                "BLK 477  PASIR RIS DR 6 #B1-520 ",
                "510477"
            ],
            [
                "ANG CHONG MINI MART",
                "BLK 506 PASIR RIS ST 52 #01-189  ",
                "510506"
            ],
            [
                "HENG`S FAMILY MINIMART",
                "BLK 515  PASIR RIS ST 52 #01-81 TEL:9027 8281",
                "510515"
            ],
            [
                "S S STAR MART",
                "BLK 515 PASIR RIS ST 52 #01-81  ",
                "510515"
            ],
            [
                "HENGS FAMILY MINIMART",
                "BLK 567  PASIR RIS ST 51 #01-100 ",
                "510567"
            ],
            [
                "GOLDEN BAMBOO BROS SUPERMART PTE LTD-625",
                "BLK 625  ELIAS RD #01-302 ELIAS MALL ",
                "510625"
            ],
            [
                "TONG DE TANG CAN RONG ZHONG XIN",
                "BLK 735  PASIR RIS ST 72 #01-306,WEST PLAZA ",
                "510735"
            ],
            [
                "MAI-YA STORE",
                "BLK 763  PASIR RIS ST 51 #01-240 ",
                "510763"
            ],
            [
                "773 PASIR RIS MINIMART",
                "BLK 773  PASIR RIS ST71 #01-380 ",
                "510773"
            ],
            [
                "HIS MILITARY PRODUCTS",
                "NO 10  PASIR RIS CTRL PASIR RIS BUS INTERCHANGE TEL:9779 7024",
                "519634"
            ],
            [
                "WEI YING MINIMART",
                "BLK 107 SIMEI ST 1 #01-834  ",
                "520107"
            ],
            [
                "BEST & FAIR MINI MARKET",
                "BLK 139  SIMEI ST 1 #01-12 ",
                "520139"
            ],
            [
                "TECK HENG DEPT STORE",
                "BLK 139  TAMPINES ST 11 #01-88 ",
                "520139"
            ],
            [
                "SUZYAMEER FROZEN",
                "BLK 201D  TAMPINES ST 21 #01-1161 ",
                "520201"
            ],
            [
                "BELLE`S TRADING AND PRODUCTS",
                "BLK 248 SIMEI STREET 3 #01-124 HP:9876 3744",
                "520248"
            ],
            [
                "FALMED ENTERPRISE PTE LTD",
                "BLK 248  SIMEI ST 3 #01-116 ",
                "520248"
            ],
            [
                "LEONG CHOON BUILDING CONTRACTOR &TRDG",
                "BLK 248  SIMEI ST 3 #01-124 ",
                "520248"
            ],
            [
                "CHUA SANG HING TRADING",
                "BLK 250  TAMPINES ST 21 #01-514 ",
                "520250"
            ],
            [
                "ONG HO HUAT MINI MARKET",
                "BLK 267  TAMPINES ST21 #01-37 ",
                "520267"
            ],
            [
                "BEGONIA SUPERMARKET",
                "BLK 280 TAMPINES ST 22 #01-244 ",
                "520280"
            ],
            [
                "RAYNE LINE TRADING PTE LTD",
                "BLK 282  TAMPINES ST 22 #01-298 TEL:8127 3285",
                "520282"
            ],
            [
                "NEW CASTLE KIOSK",
                "BLK 286  TAMPINES ST 22 #01-K1 ",
                "520286"
            ],
            [
                "RAMYAA S MAAKETING-321",
                "BLK 321  TAMPINES ST 33 #01-K1 ",
                "520321"
            ],
            [
                "YEN`S MART",
                "BLK 340  TAMPINES ST 33 #01-260 ",
                "520340"
            ],
            [
                "WARM VENTURE PTE LTD",
                "BLK 351  TAMPINES ST 32 #01-472 ",
                "520351"
            ],
            [
                "RAMIYAA S MARKETING PTE LTD",
                "BLK 369 TAMPINES ST 34 #01-21 ",
                "520369"
            ],
            [
                "CHAO BROTHERS SUPER MINI-MART",
                "BLK 406  TAMPINES ST 41 #01-27 ",
                "520406"
            ],
            [
                "NEW ENG SENG FRUITS & PROVISION",
                "BLK 419 TAMPINES ST 41 #01-92 ",
                "520419"
            ],
            [
                "M & L MINIMART",
                "BLK 433  TAMPINES ST 43 #01-75 ",
                "520433"
            ],
            [
                "YES SUPERMARKET PTE LTD - TP433",
                "BLK 433 TAMPINES ST 43  ",
                "520433"
            ],
            [
                "YEO SENG HENG MINI MARKET",
                "BLK 462 TAMPINES ST 44 #01-66  ",
                "520462"
            ],
            [
                "GROUPCERY PTE LTD",
                "BLK 477 TAMPINES ST 43 #01-156  ",
                "520474"
            ],
            [
                "RAYA JAYA AMBIGA TRADING PTE LTD",
                "BLK 476  TAMPINES ST 44 #01-199 TEL:8615 1353",
                "520476"
            ],
            [
                "C.K. DEPARTMENT STORE - TAMPINES 3",
                "BLK 478  TAMPINES ST 44 #01-219 ",
                "520478"
            ],
            [
                "YI XIN YUAN BEAUTY CARE",
                "BLK 478  TAMPINES ST44 #01-215 ",
                "520478"
            ],
            [
                "NOORHAJ MINIMART",
                "BLK 504  TAMPINES CTRL 1 #01-317 ",
                "520504"
            ],
            [
                "YEO CHUAN HUAT FOOD CENTRAL",
                "BLK 505 TAMPINES CTL 1 #01-351/353  ",
                "520505"
            ],
            [
                "C.K. DEPARTMENT STORE - TM3",
                "BLK 513 TAMPINES CTL 1 #01-170C  ",
                "520513"
            ],
            [
                "HAPPYFAMILY N`HOOD BUDGET MMART PTE LTD",
                "BLK 708  TAMPINES ST 71 #01-102 TEL:9182 5673",
                "520708"
            ],
            [
                "L J MINIMART",
                "BLK 708 TAMPINES ST 71 #01-102  ",
                "520708"
            ],
            [
                "GRACIE JOAN MINIMART (B730)",
                "BLK 730  TAMPINES ST 71 #01-51 ",
                "520730"
            ],
            [
                "CHOOS FAMILY MINIMART",
                "BLK 735 TAMPINES ST 72 #01-04  ",
                "520735"
            ],
            [
                "ZHEN BAO PTE LTD",
                "BLK 735  TAMPINES ST 72 #01-04 ",
                "520735"
            ],
            [
                "TS SENG TRADING",
                "BLK 821 TAMPINES ST 81 #01-224  ",
                "520821"
            ],
            [
                "WING SENG MEDICAL HALL",
                "BLK 821  TAMPINES ST 81 #01-220 ",
                "520821"
            ],
            [
                "LUCK HUP CHAI TRADING",
                "BLK 823  TAMPINES ST 81 #01-168 ",
                "520823"
            ],
            [
                "COLA SNACK BAR",
                "BLK 826A  TAMPINES AVE 3 #01-154 TEL:9637 8755",
                "520826"
            ],
            [
                "HP POWER",
                "BLK 826 TAMPINESE ST 81 #01-100 ",
                "520826"
            ],
            [
                "KAR MUI MARKET PRODUCE SHOP",
                "BLK 826  TAMPINES ST 81 #01-112 ",
                "520826"
            ],
            [
                "BABY & CHILD CLINIC",
                "BLK 828 TAMPINES ST 81 #01-238  ",
                "520828"
            ],
            [
                "CHUAN LEE MINI-MART",
                "BLK 835  TAMPINES ST 83 #01-02 ",
                "520835"
            ],
            [
                "CHIN JU HENG MINI S.MARKET",
                "BLK 835  TAMPINES ST 83 #01-12 ",
                "520835"
            ],
            [
                "ZAFRAH MINI MART",
                "BLK 861  TAMPINES AVE 5 #01-589 ",
                "520861"
            ],
            [
                "SIM-PLY MINIMART - TP",
                "BLK 902  TAMPINES AVE 4 #01-K1 ",
                "520902"
            ],
            [
                "ACTUA TRADING & SUPPLIES",
                "BLK 915 TAMPINES ST 91 #01-43 ",
                "520915"
            ],
            [
                "CHOON HUAT GROCERY",
                "BLK 929 TAMPINES ST 91 #01-441  ",
                "520929"
            ],
            [
                "HIN HUAT SUPERMARKET",
                "BLK 929  TAMPINES ST 91 #01-447 ",
                "520929"
            ],
            [
                "HENG TONG HUAT",
                "BLK 138  TAMPINES ST 11 #01-128 ",
                "521138"
            ],
            [
                "UNIVERSAL HOUSEHOLD & HARDWARE TRADING",
                "BLK 138  TAMPINES ST 11 #01-144 ",
                "521138"
            ],
            [
                "YES SUPERMARKET PTE LTD-TP138",
                "BLK 138  TAMPNES ST 11 #01-108/110 ",
                "521138"
            ],
            [
                "DJ.COM.SCENTS & BEAUTY SHOP",
                "BLK 152A  SERANGOON NORTH AVE 1 #01-358 ",
                "521152"
            ],
            [
                "ALICE MINI-MART",
                "BLK 487B  TAMPINES ST 45 #B1-123 ",
                "521487"
            ],
            [
                "SHAHID MINIMART (B742A TAMPINES)",
                "BLK 742A TAMPINES ST 72 #01-02  ",
                "521742"
            ],
            [
                "YES SUPERMARKET PTE LTD - 201",
                "BLK 201B  TAMPINES ST 21 #02-1095 ",
                "522201"
            ],
            [
                "KIAN CHOON MEDICAL TRADING",
                "BLK 201B TAMPINES ST21 #01-1081  ",
                "522201"
            ],
            [
                "C.K. DEPARTMENT STORE - TAMPINES",
                "BLK 201E  TAMPINES ST 23 #01-66 ",
                "525201"
            ],
            [
                "RED BERRIES BEAUTY SHOP",
                "BLK 201E TAMPINES ST 23 #01-92  ",
                "527201"
            ],
            [
                "JEFF SUPPLY PTE LTD",
                "NO 47 TAMPINES IND AVE 5 T5@TAMPINES ",
                "528633"
            ],
            [
                "TRIMECH ENGINEERING PTE LTD",
                "NO 13  TAMPINES IND AVE 5 T5 @ TAMPINES ",
                "528762"
            ],
            [
                "DAYVIEW TRADING MINIMART",
                "2 TAMPINES PL #01-66 TAMPINES DORMITORY ",
                "528821"
            ],
            [
                "BEAUTY LANGUAGE",
                "3 SIMEI ST 6 #03-04A EAST POINT MALL ",
                "528833"
            ],
            [
                "BUDGET WAREHOUSE SALE",
                "BLK 9003 TAMPINES ST 93 #01-160  ",
                "528837"
            ],
            [
                "INSTAMART PTE LTD",
                "BLK 842H TAMPINES ST 82 #01-70 ",
                "528842"
            ],
            [
                "SUZYAMEER ONLINE.COM",
                "BLK 9010  TAMPINES ST 93 #03-133 ",
                "528844"
            ],
            [
                "YES SUPERMARKET PTE LTD - TP92(WH)",
                "NO 11 TAMPINES ST 92 #02-12/13,TAMPINES BIZHUB ",
                "528872"
            ],
            [
                "C.K. DEPARTMENT STORE - WAREHOUSE",
                "NO 39  TAMPINES ST 92 C K BLDG ",
                "528883"
            ],
            [
                "YES MARKETPLACE",
                "NO 7 TAMPINES ST 32  TAMPINES MART WET MKT",
                "529285"
            ],
            [
                "MACO FRAGRANCES & COSMETICS",
                "NO 9  TAMPINES MART ST 32 #01-31 ",
                "529286"
            ],
            [
                "GIOSIS PTE LTD - QOO10",
                "NO 5  TAMPINES CTRL 1 #04-04 TAMPINES PLAZA ",
                "529541"
            ],
            [
                "CHIN GUAN HIN MINIMART",
                "BLK 6  HOUGANG AVE 3 #01-82 ",
                "530006"
            ],
            [
                "NAM HO",
                "BLK 6  HOUGANG AVE 3 #01-88 ",
                "530006"
            ],
            [
                "P.KUNHAMMED BISMILAH PROV.STR",
                "BLK 6  HOUGANG AVE 3 #01-90 ",
                "530006"
            ],
            [
                "RAINBOW SUPER MART PTE LTD - BLK 6",
                "BLK 6  HOUGANG AVE 3 #01-68 ",
                "530006"
            ],
            [
                "TEOK LEONG LEE KEE",
                "BLK 15  HOUGANG AVE 3 #01-K1 ",
                "530015"
            ],
            [
                "SEOW WAH ON & COMPANY",
                "BLK 23 HOUGANG AVE 3 #01-287  ",
                "530023"
            ],
            [
                "PRIME SUPERMARKET (1996) P/L-HG106",
                "BLK 106  HOUGANG AVE 1 #01-1213 ",
                "530106"
            ],
            [
                "AL`IKHLAS INTL PTE LTD",
                "BLK 108 HOUGANG AVE 1 #01-1265  ",
                "530108"
            ],
            [
                "SOON TAI SUPERMARKET",
                "BLK 108 HOUGANG AVE 1 #01-1311  ",
                "530108"
            ],
            [
                "THIRUMALAI TRADING PTE LTD",
                "BLK 108  HOUGANG AVE 1 #01-1265 TEL:6383 4717",
                "530108"
            ],
            [
                "KAI SOON SUPERMARKET PTE LTD - HOUGANG",
                "BLK 123  HOUGANG AVE 1 #01-1430 ",
                "530123"
            ],
            [
                "CHIN HUAT SIONG KEE MINI-MART",
                "BLK 124 HOUGANG AVE 1 #01-1432 ",
                "530124"
            ],
            [
                "LAMBERT TRADING CO",
                "BLK 124  HOUGANG AVE 1 #01-1442 ",
                "530124"
            ],
            [
                "MINERVA DISTRIBUTOR PTE LTD",
                "BLK 124 HOUGANG AVE 1 #01-446  ",
                "530124"
            ],
            [
                "LOVABLE SWEET HOUSE",
                "BLK 134  LOR AH SOO #01-462 ",
                "530134"
            ],
            [
                "JR ESSENTIALS",
                "BLK 204  HOUGANG ST 21 #01-115 ",
                "530204"
            ],
            [
                "C.K. DEPARTMENT STORE - HOUGANG",
                "BLK 210  HOUGANG ST 21 #01-225 ",
                "530210"
            ],
            [
                "BAN HIN BROTHER",
                "BLK 232  HOUGANG AVE 1 #01-K1 ",
                "530232"
            ],
            [
                "RONG SEN MINIMART",
                "BLK 247 HOUGANG AVE 3 #01-458  ",
                "530247"
            ],
            [
                "SAN HUP PTE LTD",
                "BLK 247  HOUGANG AVE 3 #01-458 ",
                "530247"
            ],
            [
                "BREAD & MILK",
                "BLK 308 HOUGANG AVE 5 #01-K1  ",
                "530308"
            ],
            [
                "CHNG WAH SENG SUPERMARKET",
                "BLK 309 HOUGANG AVE 5 #01-29 ",
                "530309"
            ],
            [
                "CHOP AH TAT MINI SUPERMARKET",
                "BLK 309  HOUGANG AVE 5 #01-293 ",
                "530309"
            ],
            [
                "99 GLOBAL MARKETING",
                "BLK 317 HOUGANG AVE 7 #01-K1 ",
                "530317"
            ],
            [
                "AIK SENG (S) TRADING",
                "BLK 322  HOUGANG AVE 5 #01-72 ",
                "530322"
            ],
            [
                "CHOP YEE JOO",
                "BLK 322  HOUGANG AVE 5 #01-80 ",
                "530322"
            ],
            [
                "TECK CHUA MEDICAL HALL",
                "BLK 322  HOUGANG AVE 5 #01-84 ",
                "530322"
            ],
            [
                "MOVON SUPERMARKET",
                "BLK 327 HOUGANG AVE 5 #01-170 ",
                "530327"
            ],
            [
                "HOUGANG CHINESE MEDICAL HALL",
                "BLK 335 HOUGANG AVE 7 #01-361  ",
                "530335"
            ],
            [
                "STAR ROCKZ ENTERPRISE",
                "BLK 339 HOUGANG AVE 7 #01-K1  ",
                "530339"
            ],
            [
                "CHOP ENG SENG",
                "BLK 356  HOUGANG AVE 7 #01-793 ",
                "530356"
            ],
            [
                "KTM 11 SUPERMART",
                "BLK 401  HOUGANG AVE 10 #01-1166 ",
                "530401"
            ],
            [
                "ORANGE IMART PTE LTD",
                "BLK 419 HOUGANG AVE 8 #01-K1  ",
                "530419"
            ],
            [
                "NIDHAAN INTERNATIONAL PTE LTD",
                "BLK 423 HOUGANG AVE 6 #01-K1  ",
                "530423"
            ],
            [
                "R&W MART",
                "BLK 423 HOUGANG AVE 6 #01-K1  ",
                "530423"
            ],
            [
                "SUPREME MART GROUP PTE LTD",
                "BLK 423 HOUGANG AVE 6 #01-K1  ",
                "530423"
            ],
            [
                "LIM TECK BEE TRADING",
                "BLK 246  HOUGANG ST 22 #01-155 ",
                "530426"
            ],
            [
                "MAJFA MINI MARKET",
                "BLK 436  HOUGANG AVE 8 #01-K1 ",
                "530436"
            ],
            [
                "LIM SEOW HONG (LIMS PROVISION)",
                "BLK 458  HOUGANG AVE 10 #01-K1 ",
                "530458"
            ],
            [
                "NOOR BEST MINIMART",
                "BLK 468  HOUGANG AVE 8 #01-1510 ",
                "530468"
            ],
            [
                "S99 SMART PTE LTD",
                "BLK 475 UPPER SERANGOON CRESC #01-02 ",
                "530475"
            ],
            [
                "GUAN SENG HUAT SUPERMARKET",
                "BLK 511 HOUGANG AVE 10 #01-149 ",
                "530511"
            ],
            [
                "JIT SIN MINI-MARKET",
                "BLK 523  HOUGANG AVE 6 #01-117 ",
                "530523"
            ],
            [
                "TECK GUAN MINIMART",
                "BLK 523  HOUGANG AVE 6 #01-123 ",
                "530523"
            ],
            [
                "FAIR PRICE UNDERGROUND SUPERSTORE",
                "BLK 539  HOUGANG ST52 #B1-48 ",
                "530539"
            ],
            [
                "PRIME SUPERMARKET 1996 PTE LTD-SN542",
                "BLK 542B  SERANGOON NORTH AVE 3 #02-01 ",
                "530542"
            ],
            [
                "J.H. MINI SUPERMARKET",
                "BLK 570 HOUGANG ST 51 #01-105  ",
                "530570"
            ],
            [
                "HIAP LEE YEW TRADING PTE LTD",
                "BLK 620  HOUGANG AVE 8 #01-262 ",
                "530620"
            ],
            [
                "649 HOUGANG FOOD KIOSK",
                "BLK 649  HOUGANG AVE 8 #01-K1 ",
                "530649"
            ],
            [
                "HE JI FA SUPERMART",
                "BLK 678 HOUGANG AVE 8 #01-517 ",
                "530678"
            ],
            [
                "LIAN SENG PROVISION SHOP",
                "BLK 678  HOUGANG AVE 8 #01-515 ",
                "530678"
            ],
            [
                "MK ESSENTIALS PTE LTD",
                "BLK 681  HOUGANG AVE 8 #01-861 TEL:98712161",
                "530681"
            ],
            [
                "HONG HUA FINE SEASONAL PRODUCTS",
                "BLK 682 HOUGANG AVE 4 #01-358 ",
                "530682"
            ],
            [
                "JIAMING PROVISION SHOP",
                "BLK 682  HOUGANG AVE 4 #01-354 ",
                "530682"
            ],
            [
                "FERNVALE MINI MART",
                "BLK 408B  FERNVALE RD #01-16 CORAL VALE ",
                "530683"
            ],
            [
                "FOOD VALUE MINIMART",
                "BLK 683  HOUGANG AVE 8 #01-913 ",
                "530683"
            ],
            [
                "AI WEI",
                "BLK 684 HOUGANG AVE 8 #01-957  ",
                "530684"
            ],
            [
                "CHUA TEO HENG",
                "BLK 703  HOUGANG AVE 2 #01-195 ",
                "530703"
            ],
            [
                "PONGGOL COMPANY",
                "BLK 703  HOUGANG AVE 2 #01-193 ",
                "530703"
            ],
            [
                "LI DUO XING PROVISION STORE",
                "BLK 708  HOUGANG AVE 2 #01-K1 ",
                "530708"
            ],
            [
                "AZAR TRADING ENTERPRISE",
                "BLK 711  HOUGANG AVE 2 #01-K1 ",
                "530711"
            ],
            [
                "PS ESSENTIALS (S) PTE LTD",
                "BLK 806  HOUGANG CTL #01-144 ",
                "530806"
            ],
            [
                "HAN SENG THYE MEDICAL HALL",
                "BLK 809  HOUGANG CTL #01-184 ",
                "530809"
            ],
            [
                "BRITISH ESSENTIAL (S) PTE LTD",
                "BLK 810 HOUGANG CTL #01-218  ",
                "530810"
            ],
            [
                "CHYI YUAN MINI SUPERMART",
                "BLK 911 HOUGANG ST 91 #01-58 ",
                "530911"
            ],
            [
                "SENG YONG HUAT PROVISION & FRUITS SHOP",
                "BLK 919  HOUGANG AVE 4 #01-457 ",
                "530919"
            ],
            [
                "CHNG WAH SENG MINIMART",
                "BLK 2 LORONG LEW LIAN #01-42 ",
                "531002"
            ],
            [
                "TAN CHUAN HONG (BLK 3)",
                "BLK 3  LOR LEW LIAN #01-70 ",
                "531003"
            ],
            [
                "PRIME SUPERMARKET (1996) P/L-HG159A",
                "BLK 159A  HOUGANG ST 11 #01-01 ",
                "531159"
            ],
            [
                "BAKERZIN HOLDINGS PTE LTD",
                "NO 28 TAI SENG ST #04-01 SAKAE BLDG ",
                "534106"
            ],
            [
                "5 STAR EXPORT PTE LTD",
                "BLK 1026 TAI SENG AVE #04-3544 TAI SENG IND. EST. ",
                "534413"
            ],
            [
                "SUNSHINE TRADING CENTRE",
                "NO 536  UPPER SERANGOON RD OFF SERANGOON AVE 1 ",
                "534551"
            ],
            [
                "CHOP HWA TIONG",
                "NO 171  UPP PAYA LEBAR RD PAYA LEBAR ",
                "534861"
            ],
            [
                "MUMMYS FAIR PRICE PTE LTD",
                "333 UPP PAYA LEBAR RD QUEMOY BUILDING  ",
                "534950"
            ],
            [
                "EVERSHINE SERVICES PTE LTD",
                "362 UPP PAYA LEBAR RD #07-06 DA JIN FACTORY BUILDING ",
                "534963"
            ],
            [
                "KUMPULAN DEVELOPMENT (S) PTE LTD",
                "NO 15  TAI SENG DR #02-02 AXIS IND. CTR ",
                "535220"
            ],
            [
                "EVERGREEN GROUP PTE LTD",
                "8 NEW INDUSTRIAL ROAD #01-02/03 LHK 3  ",
                "536200"
            ],
            [
                "HAZEL FLORIST & GIFTS PTE LTD",
                "8 NEW IND. RD #02-02 LHK3 BLDG ",
                "536200"
            ],
            [
                "TROLLEY FUN PTE LTD",
                "NO 23 NEW IND RD #04-09 ",
                "536209"
            ],
            [
                "SRI AMBIKAS PTE LTD",
                "24 NEW INDUSTRIAL ROAD PEI FU INDUSTRIAL BLDG  ",
                "536210"
            ],
            [
                "CHERRIES",
                "NO 21  HOUGANG ST 51 #01-11 HOUGANG SHOPPING MALL ",
                "538719"
            ],
            [
                "GOOD PRICE-HG",
                "NO 21  HOUGANG ST 51 #01-31 HOUGANG GREEN SHP MALL ",
                "538719"
            ],
            [
                "LOVELLE PTE LTD",
                "NO 21  HOUGANG ST 51 #01-36 HOUGANG GREEN SHOPPING MALL",
                "538719"
            ],
            [
                "MINTON SUPERMART",
                "NO 4A  HOUGANG ST 11 #01-82 THE MINTON ",
                "538754"
            ],
            [
                "RAINBOW SUPER MART PTE LTD - BLK 174D",
                "BLK 174D  HOUGANG AVE 1 #01-1615 ",
                "539174"
            ],
            [
                "HOCK CHUAN HIANG NAM KEE",
                "BLK 19  DEFU LANE 10 #01-310 ",
                "539200"
            ],
            [
                "COOL SUPPLIES AIR-COND. & ENGRG.",
                "BLK 30  DEFU LANE 10 #02-86 ",
                "539211"
            ],
            [
                "FERRAGOLD (S) PTE LTD",
                "BLK 32 DEFU LANE 10 #04-08  ",
                "539213"
            ],
            [
                "NEW ALSAN TRADING",
                "BLK 37  DEFU LANE 10 #04-61 ",
                "539214"
            ],
            [
                "LSG TRADING",
                "NO 12  DEFU LANE 1,DEFU  ",
                "539221"
            ],
            [
                "UZPIRE PTE LTD ",
                "91 DEFU LANE 10 #04-03 SWEE HIN BULDING  TEL:6858 5630",
                "539221"
            ],
            [
                "PGI HOLDINGS PTE LTD",
                "NO 125  DEFU LANE 10 PRIME BLDG ",
                "539233"
            ],
            [
                "MERACE TRADING",
                "41 DEFU LANE 9 DEFU  ",
                "539281"
            ],
            [
                "EZ HOME PRODUCTS PTE LTD",
                "BLK 118  RIVERVALE DR #01-23 RIVERVALE PLAZA ",
                "540118"
            ],
            [
                "SENG XING LOONG PROVISION",
                "BLK 118 RIVERVALE DR #01-30  ",
                "540118"
            ],
            [
                "YAK HONG PTE LTD-237",
                "BLK 237  COMPASSVALE WALK #01-534 ",
                "540237"
            ],
            [
                "ANCHORVALE MINIMART(BRANCH)",
                "BLK 267 COMPASSVALE LINK #01-01 ",
                "540267"
            ],
            [
                "FAIR MART SUPERSTORE SENG KANG",
                "BLK 297 COMPASSVALE ST #01-01 ",
                "540297"
            ],
            [
                "URBAN GLAM PTE LTD",
                "BLK 308  ANCHORVALE RD #01-02 ",
                "540308"
            ],
            [
                "WELCOME SUPERMART PTE LTD",
                "BLK 308  ANCHORVALE RD #01-01 ",
                "540308"
            ],
            [
                "U STARS SUPERMARKET PTE LTD",
                "BLK 330 ANCHORVALE ST #01-01 ",
                "540330"
            ],
            [
                "1588 LE PTE LTD",
                "BLK 158B  RIVERVALE CRESC #01-695(TEL:6386 2382) ",
                "542158"
            ],
            [
                "VALUE-PRICE",
                "BLK 158B RIVERVALE CRSC #01-695  ",
                "542158"
            ],
            [
                "ANCHORVALE MINIMART",
                "BLK 303 ANCHORVALE LINK #01-04 ",
                "542303"
            ],
            [
                "ZONE MIINIMART",
                "BLK 205D  COMPASSVALE LANE #01-01 ",
                "544205"
            ],
            [
                "VELAN TRADING PTE LTD",
                "NO 10  SENGANG SQUARE #01-104,KOPITIAM SQUARE ",
                "544829"
            ],
            [
                "HEARTLAND MART",
                "NO 36  YIO CHU KANG RD  ",
                "545553"
            ],
            [
                "TEE SENG STORE",
                "NO 31  ROSYTH RD,YIO CHU KANG  ",
                "546191"
            ],
            [
                "GRACE LODGE",
                "NO 105  PUNGGOL RD SINGAPORE BUDDHIST WELFARE SERVICES ",
                "546636"
            ],
            [
                "SINGAPORE BUDDHIST WELFARE SERVICES",
                "NO 105  PUNGGOL RD  ",
                "546636"
            ],
            [
                "BRIGHT VISION HOSPITAL",
                "5 LOR NAPIRI #05-00 STORE OFFICE  ",
                "547530"
            ],
            [
                "KLEEN ASIA PTE LTD",
                "NO 27  LANGE RD OFF YIO CHU KANG RD (PHILLIP AVE) ",
                "547989"
            ],
            [
                "REY IM PERSONAL CARE STOREMETICS HOUSE",
                "31 JLN TANI #01-36-38 OFF HOUGANG AVE 2 ",
                "548571"
            ],
            [
                "CLOVIZ TRADING",
                "NO 188  FLOWER RD  ",
                "549408"
            ],
            [
                "YONG FU MINIMART",
                "BLK 107  SERANGOON NORTH AVE 1 #01-675 ",
                "550107"
            ],
            [
                "KIM LYE WAN MINI-MART",
                "BLK 111  SERANGOON NORTH AVE 1 #01-K1 ",
                "550111"
            ],
            [
                "GUAN ANN TANG MEDICAL HALL",
                "BLK 147  SERANGOON NORTH AVE 1 #01-435 ",
                "550147"
            ],
            [
                "KEONG HENG PROVISION",
                "BLK 151 SERANGOON NORTH AVE 2 #01-15 ",
                "550151"
            ],
            [
                "HAI CHEW HARDWARE & CO",
                "BLK 153  SERANGOON NORTH AVE 1 #01-502 ",
                "550153"
            ],
            [
                "INWI MINI MART & PROVISION SHOP",
                "BLK 204 SERANGOON CENTRAL #01-110 ",
                "550204"
            ],
            [
                "MOORTHY MINI MART (S) PTE LTD",
                "BLK 214  SERANGOON AVE 4 #01-94 ",
                "550214"
            ],
            [
                "HT MINIMART",
                "BLK 214 SERANGOON AVE 4 #01-104 ",
                "550214"
            ],
            [
                "AH YEOW PROVISION SUPPLY",
                "BLK 237  SERANGOON AVE 3 #01-120 ",
                "550237"
            ],
            [
                "GOOD PRICE CENTRE-SGN253",
                "BLK 253  SERANGOON CTR DR #01-185 ",
                "550253"
            ],
            [
                "GOOD PRICE CENTRE - SGN 254",
                "BLK 254  SERANGOON CTRL DR #01-223 ",
                "550254"
            ],
            [
                "GOODLUCK PROVISION SHOP (B264)",
                "BLK 264  SERANGOON CTL #01-217 ",
                "550264"
            ],
            [
                "MAXX COMMUNICATIONS LLP",
                "BLK 266 SERANGOON CENTRAL DR #02-255  PHONE:9852 9876",
                "550266"
            ],
            [
                "VALUE SUPER MART",
                "BLK 301  SERANGOON AVE 2 #01-338 ",
                "550301"
            ],
            [
                "PENG YU MINI MART",
                "BLK 331  SERANGOON AVE 3 #01-347 ",
                "550331"
            ],
            [
                "NASHA TRADING",
                "BLK 509 SERANGOON NTH AVE 4 #01-360  ",
                "550509"
            ],
            [
                "SIN HIN",
                "BLK 523  SERANGOON NORTH AVE 4 #01-32 ",
                "550523"
            ],
            [
                "PROMASTER ELECTRONIC ENTERPRISE",
                "BLK 539  SERANGOON NORTH AVE 4 #02-61 ",
                "550539"
            ],
            [
                "SUPER MINIMART",
                "BLK 554  SERANGOON NORTH AVE 3  #01-85 ",
                "550554"
            ],
            [
                "QXPRESS PTE LTD",
                "NO 23  SERANGOON NORTH AVE 5 #01-00 BTH CTR SINGAPORE ",
                "554530"
            ],
            [
                "BTFL PTE LTD",
                "NO 6  SERANGOON NORTH AVE 5 #02-03 ",
                "554910"
            ],
            [
                "NGHEE HUAT TRADING",
                "50,SERANGOON NORTH AVE 4 #04-18  TEL:9636 1313 ( RICK )",
                "555856"
            ],
            [
                "CHONG HOE CHINESE MEDICAL STORE P/L",
                "61 SERANGOON GAROADEN WAY SERANGOON GARDEN EST.  ",
                "555957"
            ],
            [
                "CHONG HOE HEALTH PRODUCTS CHINESE M/S",
                "71 SERANGOON GARDEN WAY SERANGOON GARDEN EST.  ",
                "555967"
            ],
            [
                "VIVA MINIMART",
                "NO 137  SERANGOON AVE 3 CHUAN PARK ",
                "556115"
            ],
            [
                "HOMELY HOMEY PTE LTD ",
                "NO 141  SERANGOON AVE 3 #01-02/03 SPRINGBLOOM CONDO ",
                "556120"
            ],
            [
                "CHUAH SENG HIN",
                "20 MAJU AVE SERANGOON GARDEN EST.  ",
                "556694"
            ],
            [
                "POORNEMA TDG (METRO MART)-CHUAN PARK",
                "NO 246  LOR CHUAN #01-03 CHUAN PARK CONDO ",
                "556743"
            ],
            [
                "POORNEMA TRADING -KC",
                "BLK 246 CLUB HOUSE #01-03 CHUAN PARK LORONG CHUAN TEL:68582705",
                "556746"
            ],
            [
                "SFERM PTE LTD",
                "23 LICHFIELD RD OFF SERANGOON GRN WAY  ",
                "556843"
            ],
            [
                "GRJ BROTHERS MARKETING PTE LTD",
                "NO 1  JLN CHULEK SERNAGOON GRD EST. ",
                "557444"
            ],
            [
                "CHOP HO HENG",
                "BLK 128  ANG MO KIO AVE 3 #01-1865 ",
                "560128"
            ],
            [
                "SPICES`N HERBS MART",
                "BLK 163 ANG MO KIO AVE 4 #01-420 ",
                "560163"
            ],
            [
                "MIKI MART",
                "BLK 163 ANG MO KIO AVE 4 #01-420  ",
                "560163"
            ],
            [
                "MAYFLOWER M/M PTE LTD",
                "BLK 163 ANG MO KIO AVE 4 #01-420  ",
                "560163"
            ],
            [
                "TONG YANN MINIMART",
                "BLK 181 ANG MO KIO AVE 5 #01-2926  ",
                "560181"
            ],
            [
                "JEMS SUPER STORE",
                "BLK 202  ANG MO KIO AVE 3 #01-1666 ",
                "560202"
            ],
            [
                "SENG YONG HUAT PROV & FRUITS SHOP",
                "BLK 202 ANG MO KIO AVE 3 #01-1676  ",
                "560202"
            ],
            [
                "THONG HING TUNG TRADITIONAL MED HALL",
                "BLK 232  ANG MO KIO AVE 3 #01-1214 ",
                "560232"
            ],
            [
                "ALEEF PROVISION SHOP",
                "BLK 252 ANG MO KIO AVE 4 #01-223  ",
                "560252"
            ],
            [
                "NEW ALEEF PROVISION",
                "BLK 256  ANG MO KIO AVE 4 #01-43 ",
                "560256"
            ],
            [
                "S.M STORE",
                "BLK 304 ANG MO KIO AVE 1 301-1135  TEL:9674 6513",
                "560304"
            ],
            [
                "AX ENTERPRISE -AMK",
                "BLK 332  ANG MO KIO AVE 1 #01-1883 ",
                "560332"
            ],
            [
                "ASIA DYNASTY ENTERPRISE",
                "BLK 332 ANG MO KIO AVE 1 #01-1883 ",
                "560332"
            ],
            [
                "CHIP HOCK",
                "BLK 332  ANG MO KIO AVE 1 #01-1885 ",
                "560332"
            ],
            [
                "ECHO MINIMART",
                "BLK 332 ANG MO KIO AVE 1 #01-1883  ",
                "560332"
            ],
            [
                "TAI SENG PTE LTD",
                "BLK 338 ANG MO KIO AVE 1  ",
                "560338"
            ],
            [
                "GOOD PRICE CENTRE-AMK339",
                "BLK 339  ANG MO KIO AVE 1 #01-1573/75 ",
                "560339"
            ],
            [
                "ENG HUAT TAY KEE",
                "BLK 407  ANG MO KIO AVE 10 #01-765 ",
                "560407"
            ],
            [
                "BAN SAN CHUAN HOE KEE MEDICAL HALL",
                "BLK 410  ANG MO KIO AVE 10 #01-819 ",
                "560410"
            ],
            [
                "FELIZ CLOSET PTE LTD",
                "410 ANG MO KIO AVE 10 #01-837  ",
                "560410"
            ],
            [
                "BK HARVEST PTE LTD",
                "BLK 416  ANG MO KIO AVE 10 #12-1003 ",
                "560416"
            ],
            [
                "LUCKY LAKI PTE LTD",
                "BLK 443 ANG MO KIO AVE 10 #01-1257  TEL:9859 6489",
                "560443"
            ],
            [
                "YEW GUAN MINIMART",
                "BLK 443  ANG MO KIO AVE 10 #01-1231 ",
                "560443"
            ],
            [
                "ONE 165",
                "BLK 443 ANG MO KIO AVE 10 #01-1257 ",
                "560443"
            ],
            [
                "MASSALAKI PRIVATE LIMITED",
                "BLK 443 AMK #01-1257  ",
                "560443"
            ],
            [
                "SEA HORSE TRADING COMPANY",
                "BLK 447  ANG MO KIO AVE 10 #01-1687 ",
                "560447"
            ],
            [
                "CHOP BAN WHATT HIN",
                "BLK 448 ANG MO KIO AVE 10 #01-1703 ",
                "560448"
            ],
            [
                "HUA MEI TRADING ENTERPRISE",
                "BLK 449 ANG MO KIO AVE 10 #01-1717 ",
                "560449"
            ],
            [
                "LITTSON CONNECTION 2",
                "BLK 449 ANG MO KIO WAVE 10 #01-1731  ",
                "560449"
            ],
            [
                "HE JI FA MINIMART",
                "BLK 451  ANG MO KIO AVE 10 #01-1753 ",
                "560451"
            ],
            [
                "FEI FEI",
                "BLK 453A ANG MO KIO AVE 10 #01-88  ",
                "560453"
            ],
            [
                "KOH HUAT HENG MINI-MART",
                "BLK 456  ANG MO KIO AVE 10 #01-1572 ",
                "560456"
            ],
            [
                "THE BOX STORE",
                "BLK 460 ANG MO KIO AVE 10 #01-1578  ",
                "560460"
            ],
            [
                "HAO GUAN MINI MART",
                "BLK 505  ANG MO KIO AVE 8 #01-2682 ",
                "560505"
            ],
            [
                "SONG HOE MINI-MARKET (1996)",
                "BLK 505  ANG MO KIO AVE 8 #01-2668 ",
                "560505"
            ],
            [
                "GOOD PRICE CENTRE-AMK 525",
                "BLK 525  ANG MO KIO  #01-2393 ",
                "560525"
            ],
            [
                "CHOO MOH HIN",
                "BLK 526 ANG MO KIO AVE 10 #01-2411  ",
                "560526"
            ],
            [
                "VALUE CHOICE TRADING",
                "BLK 526 ANG MO KIO AVE 10 #01-2411 ",
                "560526"
            ],
            [
                "HOCK LAM AIK KEE",
                "BLK 532 ANG MO KIO AVE 10 #01-2497  ",
                "560532"
            ],
            [
                "HUP SENG HWA KEE",
                "BLK 532  ANG MO KIO AVE 10 #01-2489 ",
                "560532"
            ],
            [
                "HI CONVENIENT STORE",
                "BLK 532 ANG MO KIO AVE 10 #01-2461 TEL:85002266",
                "560532"
            ],
            [
                "TUNGSAN FOOD IND. P/L -AMK",
                "BLK 554  ANG MO KIO AVE 10 #01-2034 ",
                "560554"
            ],
            [
                "YEO SOON LAI MINIMART",
                "BLK 554 ANG MO KIO AVE 10 #01-2052 ",
                "560554"
            ],
            [
                "HENG THIANG HIN",
                "BLK 555 ANG MO KIO AVE 10 #01-1972  ",
                "560555"
            ],
            [
                "MUTHU MINIMART PTE LTD",
                "BLK 555 ANG MO KIO AVE 10 #01-1938  ",
                "560555"
            ],
            [
                "VALUE PLUS MINIMART-AMK",
                "BLK 555  ANG MO KIO AVE 10 #01-1968 ",
                "560555"
            ],
            [
                "SIN SHUANG LI",
                "BLK 586 ANG MO KIO AVE 3 #01-3603  ",
                "560586"
            ],
            [
                "CHUAN CHOON MINI SUPERMARKET",
                "BLK 607  ANG MO KIO AVE 4 #01-1289 ",
                "560607"
            ],
            [
                "NAN HOE STORE",
                "BLK 608  ANG MO KIO AVE 5 #01-2787 ",
                "560608"
            ],
            [
                "TEO CHUAN KEE MINIMART PTE LTD",
                "BLK 629  ANG MO KIO AVE 4 #01-1016 ",
                "560629"
            ],
            [
                "LU KEE HO PU (GOOD NEIGHBOUR)",
                "BLK 631 ANG MO KIO AVE 4 #01-916  ",
                "560631"
            ],
            [
                "GOOD PRICE CENTRE-AMK631",
                "BLK 631  ANG MO KIO AVE 4 #01-926 ",
                "560631"
            ],
            [
                "632 FAMILY STORE",
                "BLK 632 ANG MO KIO AVE 4 #01-952 ",
                "560632"
            ],
            [
                "LIAN LEE MINI-SUPERMARKET",
                "BLK 635  ANG MO KIO AVE 6 #01-5121 ",
                "560635"
            ],
            [
                "C.K. DEPARTMENT STORE - AMK",
                "BLK 720  ANG MO KIO AVE 6 #01-4124/4126 ",
                "560720"
            ],
            [
                "RED TOMATOES SINGAPORE PTE LTD",
                "BLK 720  ANG MO KIO AVE 6 #01-4104 ",
                "560720"
            ],
            [
                "YUAN FENG PROVISION SHOP",
                "BLK 724  ANG MO KIO AVE 6 #01-94/95 ",
                "560724"
            ],
            [
                "GOOD PRICE CENTRE-AMK226",
                "BLK 226A  ANG MO KIO AVE 1 #01-637 ",
                "561226"
            ],
            [
                "WEE LEE MINI SUPERMARKET",
                "BLK 316B ANG MO KIO ST 31 #01-09  ",
                "563316"
            ],
            [
                "BUDGET CORNER MINIMART",
                "BLK 226G ANG MO KIO AVE 1 #01-687/689  ",
                "567226"
            ],
            [
                "SK CORNER",
                "BLK 226G ANG MO KIO AVE 1 #01-687  ",
                "567226"
            ],
            [
                "SIN LIAN XING",
                "NO 3 ANG MO KIO ST 62 #05-17 ",
                "569139"
            ],
            [
                "REPRODUCER PTE LTD",
                "BLK 4026  ANG MO KIO IND PARK 1 #01-259 ",
                "569637"
            ],
            [
                "YOSHINOYA (S) PTE LTD",
                "BLK 7000 ANG MO KIO AVE 5 LEVEL 4 (OFFICE BLK) ",
                "569877"
            ],
            [
                "EINCSMART",
                "NO 7030  ANG MO KIO AVE 5 #05-45 NORTHSTAR@AMK ",
                "569880"
            ],
            [
                "HEMA MINIMART",
                "BLK 22 SIN MING RD #01-240  ",
                "570022"
            ],
            [
                "NG SOON SENG PROVISION STORE",
                "BLK 22 SIM MING RD #01-218  ",
                "570022"
            ],
            [
                "SIN SOON HUAT MINIMART",
                "BLK 22   SIN MING RD #01-218 ",
                "570022"
            ],
            [
                "KOH ONN TONG MEDICAL HALL",
                "BLK 23  SIN MING RD #01-17 ",
                "570023"
            ],
            [
                "LIMRA ENTERPRISE",
                "BLK 106 BISHAN ST 12 #01-220  ",
                "570106"
            ],
            [
                "AX ENTERPRISE - BS",
                "BLK 222  BISHAN ST 23 #01-K1 ",
                "570222"
            ],
            [
                "AN HUA HOLDINGS PTE LTD",
                "BLK 282  BISHAN ST 22 $01-149 ",
                "570282"
            ],
            [
                "MORNING FRESH TRADING",
                "BLK 282  BISHAN ST 22 #01-133 ",
                "570282"
            ],
            [
                "ORANGE DEPARTMENT STORE-BS",
                "BLK 282  BISHAN ST 22 #01-143 ",
                "570282"
            ],
            [
                "LAI LAI MINI SUPERMARKET",
                "BLK 403  SIN MING AVE #01-309 ",
                "570403"
            ],
            [
                "CHAI YU TRADING",
                "BLK 445  SIN MING AVE #01-473 ",
                "570445"
            ],
            [
                "XING TEO HONG COMBINATION MEDICAL HALL",
                "BLK 150A  BISHAN ST 11 #01-163 ",
                "571150"
            ],
            [
                "YKK GENERAL WHOLESALE TRADING",
                "BLK 150A BISHAN ST 11 #01-155 TEL:82882213/81882213",
                "571150"
            ],
            [
                "CSTORE TRADING PTE LTD",
                "NO 20 SIN MING LANE #08-65C MIDVIEW CITY ",
                "573968"
            ],
            [
                "J.D. MINIMART",
                "244-D UPP THOMSON RD OFF SIN MING RD  ",
                "574369"
            ],
            [
                "FAITHSEEDS MINIMART",
                "BLK 5  SIN MING WALK #01-41 THE GARDEN@BISHAN ",
                "575576"
            ],
            [
                "ONE MINIMART",
                "NO. 5 SIN MING WALK #01-41 THE GARDENS @ BISHAN ",
                "575576"
            ],
            [
                "WAH NAM HAIR DRESSING SALON",
                "NO 6  SIN MING RD,#01-17 SIN MING PLAZA TOWER 2  ",
                "575585"
            ],
            [
                "ONE BAKERY PTE LTD",
                "NO 11 SIN MING RD #01-26  THOMSON V TWO TEL:9048 8543",
                "575629"
            ],
            [
                "IMPERIAL EXPORT & IMPORT PTE LTD",
                "9 SIN MIN IND.EST SECTOR B #01-3130 ",
                "575654"
            ],
            [
                "LIAN HUP HIN",
                "NO 1  SIN MING AVE #01-05 FLAME TREE PARK ",
                "575728"
            ],
            [
                "ENBEAU MARKETING",
                "39 JLN PEMINPIN #06-04 ZIEHL-EBM BLDG ",
                "577182"
            ],
            [
                "HP TRADING & MARKETING",
                "NO 45  JLN PEMIMPIN,#01-00H  FOO WAH IND. BULD ",
                "577197"
            ],
            [
                "GL INTER-AGO PTE LTD",
                "49 JLN PEMIMPIN #05-13 IND BUILDING  ",
                "577203"
            ],
            [
                "FABULOUS FOODS PTE LTD",
                "NO 51  JLN PEMIMPIN #06-01 MAYFAIR IND.BLDG ",
                "577206"
            ],
            [
                "TAN CHIN HOCK",
                "NO 3 LOR PISANG EMAS OFF CHUN TIN RD  ",
                "577206"
            ],
            [
                "LYE M S TRADING",
                "NO 59  JLN PEMIMPIN #04-05 ",
                "577218"
            ],
            [
                "NATURE FRESH MART PTE LTD",
                "NO 2  JLN KURAS SEMBAWANG HILLS EST. ",
                "577722"
            ],
            [
                "THE SINGAPORE ISLAND COUNTRY CLUB ",
                "NO 180 ISLAND CLUB RD  ",
                "578774"
            ],
            [
                "TOP CLEAN SYSTEM SERVICES P/L",
                "NO 122  BINCHANG RISE,BISHAN  ",
                "579961"
            ],
            [
                "JEZ MART",
                "NO 95  BT DR #01-32 THE RAINTREE CONDO",
                "587843"
            ],
            [
                "LOVABLE HOUSE MINIMART",
                "BLK 95  BUKIT DR #01-32 ",
                "587843"
            ],
            [
                "RAIN TREE MINI MART",
                "95 BUKIT DRIVE #01-32  ",
                "587843"
            ],
            [
                "FONG SHENG TRADING",
                "BLK 116  UPP BUKIT TIMAH RD #01-67 BUKIT TIMAH MKT & FC",
                "588172"
            ],
            [
                "KWEE CHOON",
                "NO 116  UPP BUKIT TIMAH RD #01-74 BUKIT TIMAH MKT & FOOD CTR",
                "588172"
            ],
            [
                "SHEKOU KAMPONG FOOD PTE LTD",
                "3 JLN BINGKA MAYFAIR PARK  ",
                "588896"
            ],
            [
                "JAMP INVESTMENTS PTE LTD",
                "BLK 989  BUKIT TIMAH RD #B1-04 MAPLEWOODS CONDO ",
                "589629"
            ],
            [
                "WIN 8 MINIMART",
                "989 BT TIMAH RD #B1-04 MAPLEWOODS CONDO ",
                "589629"
            ],
            [
                "RAW MARKET PTE LTD",
                "NO 5  BINJAI RARK  ",
                "589820"
            ],
            [
                "LIM DE LI MINIMART",
                "BLK 18  TOH YI DR #01-103 ",
                "590018"
            ],
            [
                "CAPULUS PTE LTD",
                "NO 2  TOH TUCK LINK #01-01 ",
                "596225"
            ],
            [
                "LAURELS SUPERMARKET",
                "BLK 2  PANDAN VALLEY #B1-204 ACACIA COURT - PANDAN VALLE",
                "597626"
            ],
            [
                "MR DAVID TAN",
                "NO 3  LOR PISANG EMAS  ",
                "597820"
            ],
            [
                "SEAH HAI SOON",
                "NO 33  LOR KILAT #01-03 OFF JURONG KECHIL ",
                "598132"
            ],
            [
                "KENNY GROCERY",
                "23 ENG KONG TERRACE TOH TUCK EST.  ",
                "598989"
            ],
            [
                "ENG KOON HUAT PROVISION STORE",
                "NO 25  ENG KONG TERRACE TOH TUCK EST. ",
                "598997"
            ],
            [
                "ULTRA GROCERY",
                "NO 1  BROOKVALE DR #01-05,BROOKVALE PARK ",
                "599968"
            ],
            [
                "CHIN CHU CHEONG KEE MEDICAL HALL PTE LTD",
                "BLK 37  TEBAN GARDEN RD #01-307 ",
                "600037"
            ],
            [
                "LIAN TAT PROVISION SHOP",
                "BLK 38  TEBAN GARDEN RD #01-323 ",
                "600038"
            ],
            [
                "ARCHANA PROVISION STORE PTE LTD",
                "BLK 39  TEBAN GARDEN RD #01-334 ",
                "600039"
            ],
            [
                "VINAYAGA`S FAIR PRICE PTE LTD",
                "BLK 39  TEBAN GARDENS RD  #01-330 TEL:65691382",
                "600039"
            ],
            [
                "CHENNAI TRADING & SUPERMART PTE LTD-TBG",
                "BLK 49 TEBAN GARDENS RD #01-585  ",
                "600049"
            ],
            [
                "SHAFEN SUPERMARKET & TDG (S) P L",
                "BLK 49  TEBAN GARDEN RD #01-585 ",
                "600049"
            ],
            [
                "SHAFEN SUPERMARKET & TDG (S) P L",
                "BLK 49 TEBAN GARDENS RD #01-585 ",
                "600049"
            ],
            [
                "BAO LING SUPERMART",
                "BLK 54  TEBAN GARDEN RD #01-549/550 ",
                "600054"
            ],
            [
                "HAJI SUPERMART",
                "BLK 61  TEBAN GARDEN RD #01-13 ",
                "600061"
            ],
            [
                "TEBAN ENTERPRISE",
                "BLK 61 TEBAN GARDEN RD #01-13 ",
                "600061"
            ],
            [
                "VINAYAK TREDERS PTE LTD",
                "BLK 61  TEBAN GARDEN RD #01-16  ",
                "600061"
            ],
            [
                "SRI VINAYAGA TRADING",
                "BLK 82 MACPHERSON LANE #01-11  ",
                "600082"
            ],
            [
                "A.V.N STORE",
                "BLK 104  JURONG EAST ST 13 #01-112 ",
                "600104"
            ],
            [
                "AASHIRWAD TRADING-JE",
                "BLK 104 JURONG EAST ST 13 #01-112  ",
                "600104"
            ],
            [
                "BAO SHENG MINIMART",
                "BLK 114  JURONG EAST ST 13 #01-398 ",
                "600114"
            ],
            [
                "TOPSON TRADING",
                "BLK 114  JURONG EAST 13 #01-396 ",
                "600114"
            ],
            [
                "ES BEAUTY",
                "BLK 133 JURONG GATEWAY RD #01-303  ",
                "600133"
            ],
            [
                "EASY MART ENTERPRISE LLP",
                "BLK 214  JURONG EAST ST 21 #01-439 ",
                "600214"
            ],
            [
                "KYAW KYAR TRADING & MINI MART",
                "BLK 214 #01-433 JURONG EAST ST 21 ",
                "600214"
            ],
            [
                "BONANZA STORE",
                "BLK 225  JURONG EAST ST 21 #01-799 TEL:6560 6322",
                "600225"
            ],
            [
                "HOCK GHEE SENG",
                "BLK 225  JURONG EAST ST 21 #01-803 ",
                "600225"
            ],
            [
                "BAN LONG MEDICAL HALL",
                "BLK 252  JURONG EAST ST 24 #01-165 ",
                "600252"
            ],
            [
                "HOCK KEE",
                "BLK 252 JURONG EAST ST 24 #01-133  ",
                "600252"
            ],
            [
                "WAN SHENG TANG MEDICAL HALL",
                "BLK 252  JURONG EAST ST 24 #01-169 ",
                "600252"
            ],
            [
                "T C 2K TRADING",
                "BLK 259  JURONG EAST ST 24 #01-435 ",
                "600259"
            ],
            [
                "THIRUMURUGAN DEPARTMENTAL STORE PTE LTD",
                "BLK 259 JURONG EAST ST 24 #01-445 ",
                "600259"
            ],
            [
                "PIABIA",
                "BLK 261 JURONG EAST ST 24 #01-K1 TEL: 9760 7583",
                "600261"
            ],
            [
                "EZBIZZZ",
                "262 JURONG EAST ST 24 #01-489  ",
                "600262"
            ],
            [
                "WANG WEI SHENG TRADING",
                "BLK 262 JURONG EAST ST 24 #01-489   ",
                "600262"
            ],
            [
                "YUAN FENG PTE LTD",
                "BLK 303  JURONG EAST ST 32 #01-90 TEL:92410054/66339753",
                "600303"
            ],
            [
                "MART XPRESS MINIMART",
                "BLK 318  JURONG EAST ST 31 #01-44 ",
                "600318"
            ],
            [
                "KIAN LEE HENG TRADING",
                "BLK 323 JURONG EAST ST 32 #01-K1  ",
                "600323"
            ],
            [
                "HOE GUAN MINIMART",
                "BLK 338  JURONG EAST AVE 1 #01-1642 ",
                "600338"
            ],
            [
                "KAI SOON SUPERMARKET PTE LTD",
                "BLK 345 JURONG EAST ST 31 #01-09  ",
                "600345"
            ],
            [
                "SUN MUM SAN MEDICAL HALL",
                "BLK 345 JURONG EAST ST 31 #01-21  ",
                "600345"
            ],
            [
                "GOOD PRICE CENTRE-JE",
                "BLK 346  JURONG EAST ST 31 #01-75 ",
                "600346"
            ],
            [
                "SHUN LI XIANG COSMETIC SHOP",
                "BLK 347 JURONG EAST AVE 1 #01-118  ",
                "600347"
            ],
            [
                "CHUA HIAN CHWEE SUNDRIES STORE",
                "BLK 415 PANDAN GARDEN #01-116  ",
                "600415"
            ],
            [
                "HUI CHENG PROVISION SHOP",
                "BLK 416  PANDAN GARDEN #01-127 ",
                "600416"
            ],
            [
                "CHUAN SENG HOCK",
                "BLK 416  #01-129 PANDAN GARDEN ",
                "600416"
            ],
            [
                "CHENNAI STORE",
                "BLK 217A JURONG EAST ST 21 #01-595  ",
                "601217"
            ],
            [
                "VENDAN TRADING PTE LTD",
                "BLK 217A  JURONG EAST ST 21 #01-595 TEL:68961415/91411266",
                "601217"
            ],
            [
                "TOP GUAN MINIMART",
                "BLK 282A  TOH GUAN RD #01-02 ",
                "601282"
            ],
            [
                "GREEN LAND MARKETPLACE PTE LTD",
                "BLK 177 BT BATOK WEST AVE 8 #01-249  ",
                "605177"
            ],
            [
                "JOO GUAN HIN MINIMART",
                "BLK 286E  TOH GUAN RD #01-02 ",
                "605286"
            ],
            [
                "BIG BOX SINGAPORE PTE LTD",
                "NO 1  VENTURE AVE  ",
                "608521"
            ],
            [
                "FOODJOY PTE LTD - A",
                "BLK 34  TOH GUAN RD EAST #01-25 ENTERPRISE HUB ",
                "608529"
            ],
            [
                "ASIA CONCEPTS WESTGATE PTE LTD",
                "3 GATEWAY DRIVE #03-10/11  TEL:64659668",
                "608532"
            ],
            [
                "K.K.MART PTE LTD",
                "23 PENJURU WALK #03-81 SINGAPORE 608537 ",
                "608537"
            ],
            [
                "KINGS SUPERMARKET PTE LTD ",
                "BLK 23  PENJURU WALK #03-81 ",
                "608537"
            ],
            [
                "KINGSMART PTE LTD",
                "30 PENJURU PL #01-07 JURONG PENJURU DORMITORY 2 ",
                "608557"
            ],
            [
                "KINGSMART PTE LTD (DORM 1)",
                "BLK 60  PENJURU PLACE  ",
                "608561"
            ],
            [
                "TOH GUAN MINIMART",
                "BLK 19  TOH GUAN RD EAST #01-65 TOH GUAN DORMITORY ",
                "608567"
            ],
            [
                "NGAI BEE TRADING PTE LTD-TOH GUAN",
                "BLK 42 TOH GUAN RD EAST #01-76 ENTERPRISE HUB ",
                "608583"
            ],
            [
                "BESS CHOICE",
                "48 TOH GUAN RD EAST #09-120  ENTERPRISE HUB SINGAPORE 608586",
                "608586"
            ],
            [
                "BOOKLAND & OFFICE SUPPLIES CENTRE",
                "BLK 48  TOH GUAN RD EAST #09-155 ENTERPRISE HUB ",
                "608586"
            ],
            [
                "BESS 68 IMPORT & EXPORT PTE LTD",
                "BLK 48 TOH GUAN RD EAST #09-120 ENTERPRISE HUB ",
                "608586"
            ],
            [
                "HARDWARE STORE",
                "BLK 48  TOH GUAN RD EAST #01-47,ENTERPRISE HUB ",
                "608586"
            ],
            [
                "YEE YONG SOON TRADING",
                "BLK 48  TOH GUAN RD EAST #03-119,ENTERPRISE HUB ",
                "608586"
            ],
            [
                "SHAFEN TRADING",
                "18 TOH GUAN RD EAST #01-01 CENTURION DORMITORY (WESTLIT ",
                "608591"
            ],
            [
                "K CHAN SHIPCHANDLERS",
                "NO 7  TOH GUAN RD EAST #02-10 ALPHA IND. BLDG ",
                "608599"
            ],
            [
                "TNT HARDWARE & INDUSTRIAL SUPPLIES",
                "NO 7  TOH GUAN RD EAST #05-08,ALPHA IND. BLDG ",
                "608599"
            ],
            [
                "FEDERATION FOOD INDUSTRIAL PTE LTD",
                "NO 5  PENJURU CLOSE GROUND FLOOR ",
                "608600"
            ],
            [
                "ONHOCK PROVISION COMPANY",
                "NO 61  TOH GUAN RD EAST,TOH GUAN  ",
                "608607"
            ],
            [
                "WEI LEE MARINE SUPPLIES",
                "21 TOH GUAN RD EAST #05-16 TOH GUAN CTR ",
                "608609"
            ],
            [
                "LIM SIANG HUAT PTE LTD",
                "NO 6  FISHERY PORT RD #02M TEL:6268 4144",
                "609128"
            ],
            [
                "YONG WEN FOOD (S) PTE LTD",
                "BLK 24  PENJURU RD #06-01,CWT COMMODITY HUB  ",
                "609128"
            ],
            [
                "SUNWAY SHIP SUPPLIES PTE LTD",
                "30 PENJURU ROAD #01-02  ",
                "609135"
            ],
            [
                "ELITE BRANDS PTE LTD",
                "NO 31  PENJURU LANE  BLK A #08-01 PHONE:6264 4111",
                "609198"
            ],
            [
                "UNI BRANDS PTE LTD",
                "NO 31(BLK A)  PENJURU LANE #08-01  TEL:6264 4111  ",
                "609198"
            ],
            [
                "RADHA EXPORTS PTE LTD",
                "NO 40  PANDAN RD,PANDAN  ",
                "609282"
            ],
            [
                "NG TENG FONG GENERAL HOSPITAL",
                "NO 1 JURONG EAST ST 21  ",
                "609606"
            ],
            [
                "DON THAKER CLEANING SERVICES PTE LTD",
                "NO 8  BOON LAY WAY #08-16 TRADE HUB 21 ",
                "609964"
            ],
            [
                "COUNTY ENTERPRISES",
                "NO 18  BOON LAY WAY #03-134, TRADEHUB 21 ",
                "609966"
            ],
            [
                "INTEGRATED PROPERTY MNGM P/L",
                "NO 18  BOON LAY WAY #02-146/147,TRADEHUB 21 ",
                "609966"
            ],
            [
                "HYDRO MECH ENTERPRISE",
                "BLK 151  YUNG HO RD #01-87 ",
                "610151"
            ],
            [
                "SRI PERUMAL SUPERMARKET PTE LTD",
                "BLK 163 YUNG PING ROAD  ",
                "610163"
            ],
            [
                "TAN MINIMART",
                "BLK 323 TAH CHING RD #01-62 TAMAN JURONG ",
                "610323"
            ],
            [
                "SOON HOCK MINI SUPERMARKET",
                "BLK 346  KANG CHING RD #01-115 ",
                "610346"
            ],
            [
                "AUNG PTE LTD",
                "BLK 351  CORPORATION DR #01-520 ",
                "610351"
            ],
            [
                "DAILY DEPARTMENT STORE PTE LTD (YA)",
                "BLK 362 YUNG AN ROAD #01-131  TEL:6973 9039",
                "610362"
            ],
            [
                "HONG DE PTE LTD",
                "BLK 362 YUNG AN RD #01-131  ",
                "610362"
            ],
            [
                "M/S DAILY DEPARTMENT STORE PTE LTD",
                "BLK 362 YUNG AN ROAD #01-131  ",
                "610362"
            ],
            [
                "RADHEENA GLOBAL PTE LTD",
                "BLK 362 YUNG AN RD #01-131  ",
                "610362"
            ],
            [
                "UNIVERSAL DISTRIBUTION PTE LTD-TJR",
                "BLK 399  YUNG SHENG RD #01-21 ",
                "610399"
            ],
            [
                "SINGAPORE FOOD INDUSTRIES PTE LTD",
                "NO 2  BUROH LANE  ",
                "618492"
            ],
            [
                "HUP HIN HO",
                "NO 30  JURONG PORT RD #B2-5 JLN BUROH W`HOUSE COMPLEX",
                "619103"
            ],
            [
                "JOO YONG CO. PTE LTD",
                "NO 11 JOO YEE RD   ",
                "619198"
            ],
            [
                "SRI VINAYAKA EXPORTS PTE LTD",
                "41,JALAN TEPONG JURONG FOOD HUB  ",
                "619348"
            ],
            [
                "BISMILLAH MINIMART PTE LTD",
                "5A JLN PAPAN NEW JURONG PORT TERUSAN LODGE  ",
                "619406"
            ],
            [
                "BFN GROUP PTE LTD",
                "5A  JLN PANDAN NEW JURONG PORT,TERUSAN LODGE ",
                "619406"
            ],
            [
                "SHAFEN SUPERMARKET & TRADING PTE LTD",
                "5A JALAN PAPAN NEW JURONG PORT  TERUSAN LODGE ",
                "619406"
            ],
            [
                "SHAYAAN SUPERMARKET & TRADING",
                "5A JALAN PAPAN NEW JURONG PORT TERUSAN LODGE TEL:98662217",
                "619406"
            ],
            [
                "ST PHANG NEE",
                "NO 2D  JALAN PAPAN OFF JURONG PORT RD,AVERY LODGE  ",
                "619415"
            ],
            [
                "WELLMART MANAGEMENT SERVICES PTE LTD-406",
                "NO 348  JALAN BOON LAY  ",
                "619529"
            ],
            [
                "WELLMART MANAGEMENT SERVICES PTE LTD-164",
                "NO 348  JALAN BOON LAY    ",
                "619529"
            ],
            [
                "WELLMART MANAGEMENT SERVICES PTE LTD-532",
                "NO 348  JALAN BOON LAY  ",
                "619529"
            ],
            [
                "WELLMART MANAGEMENT SERVICES PTE LTD-8",
                "NO 348  JALAN BOON LAY  ",
                "619529"
            ],
            [
                "WELLMART MANAGEMENT SERVICES PTE LTD-501",
                "NO 348  JALAN BOON LAY  ",
                "619529"
            ],
            [
                "REDMART LIMITED",
                "NO 6  FISHERY PORT RD LEVEL 7 ",
                "619747"
            ],
            [
                "AT FRESH PTE LTD",
                "BLK 14  CHIN BEE ROAD  ",
                "619824"
            ],
            [
                "CHIN SENG MOH",
                "6 CHIN BEE DR CHIN BEE  ",
                "619856"
            ],
            [
                "THONG CHEW FOOD IND.PTE LTD",
                "NO 35  CHIN BEE CRES #01-01 ",
                "619902"
            ],
            [
                "REDMART PTE LTD",
                "3 SOON LEE RD  #02-29 PIONEER JUNCTION  ",
                "627606"
            ],
            [
                "UNIQUE FOOD TRADING SERVICES LLP",
                "NO 3  SOON LEE RD  #02-29,PIONEER JUNCTION ",
                "627606"
            ],
            [
                "TEO BOON THONG TRADING",
                "NO 5  SOON LEE ST #04-09 PIONEER POINT",
                "627607"
            ],
            [
                "JURONG ISLAND MINI MART",
                "BLK 17  KIAN TECK LANE #01-65,BLUE STAR DORMITORY ",
                "627851"
            ],
            [
                "TEO SOON SENG PTE LTD",
                "NO 18  SOON LEE ROAD  ",
                "628081"
            ],
            [
                "AJMAL TRADING GROUP-41",
                "NO 41  SOON LEE RD SCAL DORMITORY ",
                "628085"
            ],
            [
                "HAYER ENGINEERING PTE LTD",
                "NO 26  SOON LEE RD  TEL:6261 0912",
                "628086"
            ],
            [
                "AJMAL TRADING GROUP PTE LTD",
                "NO 31  SOON LEE RD SOON LEE LODGE ",
                "628087"
            ],
            [
                "LI LI CHENG SUPERMARKET PTE",
                "NO 51  SOON LEE RD #01-51 SCAL RECREATION CTR ",
                "628088"
            ],
            [
                "LAMIAH ENTERPRISE PTE LTD",
                "NO 51  SOON LEE RD  #01-13 TEL:9067 1047",
                "628088"
            ],
            [
                "ACE MARINE SUPPLIES PTE LTD",
                "NO 23  PIONEER SECTOR 1 #01--01 ",
                "628431"
            ],
            [
                "ATLANTIC SUPPLIES & TRADING PTE LTD",
                "NO 28  PIONEER CRESC #03-13 WEST PK BIZ CTR ",
                "628559"
            ],
            [
                "DSP RELOCATIONS ASIA PTE LTD",
                "NO 24  KIAN TECK RD  ",
                "628775"
            ],
            [
                "MM SUNDRY SHOP PTE LTD",
                "NO 4  KIAN TECK AVE #01-03 KIAN TECK HOSTEL ",
                "628909"
            ],
            [
                "JOO ANN MINIMART",
                "26 KIAN TECK AVE #01-02 KIAN TECK DORMITORY ",
                "628920"
            ],
            [
                "SINWA (SINGAPORE) PTE LTD",
                "NO 28  JOO KOON CIRCLE  TEL:6862 6300",
                "629057"
            ],
            [
                "c/o AIK MOH PAINTS",
                "NO 74  JOO KOON CIRCLE  ",
                "629093"
            ],
            [
                "WAMAX GLOBAL PTE LTD",
                "156 GUL CIRCLE  TEL:6861 0323 ",
                "629613"
            ],
            [
                "CHUAN SENG LEONG PTE LTD",
                "1 GUL AVENUE OFF GUL CIRCLE  ",
                "629648"
            ],
            [
                "BEAUTE SPRING PTE LTD",
                "23 FIRST LOK YANG RD   ",
                "629733"
            ],
            [
                "RIC DORMITORY PTE LTD",
                "NO 8 ENTERPRISE ROAD  ",
                "629820"
            ],
            [
                "RIC DORMITORY PTE LTD",
                "8 ENTERPRISE ROAD   ",
                "629820"
            ],
            [
                "ALLSEAS MARINE SERVICES PTE LTD",
                "NO 27B  BENOI RD PIONEER LOT ",
                "629917"
            ],
            [
                "AJMAL SUPERMART PTE LTD",
                "NO 70  TUAS SOUTH AVE 1 #01-40 TEL:64671134 ",
                "637285"
            ],
            [
                "LAI LAI SUPERMART PTE LTD (TUAS)",
                "NO 70  TUAS SOUTH AVE 1 #01-39 TUAS VIEW DORMITORY ",
                "637285"
            ],
            [
                "SHAFEN SUPERMARKET-TUAS",
                "BLK 90  TUAS STH AVE 9 DORMITORY ",
                "637397"
            ],
            [
                "APAN MINIMART",
                "NO 13  TUAS SOUTH ST 5 #01-18 ",
                "637555"
            ],
            [
                "MITA GROUP 2 MINIMART",
                "13 TUAS STH ST 5 #01-16  ",
                "637555"
            ],
            [
                "TUAS SUPERMARKET",
                "13 TUAS STH ST 5 #02-01  ",
                "637555"
            ],
            [
                "YONG JOO HUAT PROVISION STORE",
                "11 TUAS STH ST 5 OFF TUAS SOUTH AVE 5  ",
                "637590"
            ],
            [
                "LI AN FOODSTUFF PTE LTD",
                "NO 75  TUAS VIEW WALK 1  ",
                "637615"
            ],
            [
                "GREEN TROPIC PRODUCTS PTE LTD",
                "NO 59  TUAS VIEW WALK 2 NEAR TUAS SOUTH AVE 8 ",
                "637629"
            ],
            [
                "VMR TRADING",
                "2 TUAS STH ST 2 OFF TUAS SOUTH AVE 5  ",
                "637895"
            ],
            [
                "SADIA SUPERMARKET &",
                "NO 14  TECH PARK CRESC OFF TUAS SOUTH AVE 4 ",
                "638118"
            ],
            [
                "FROSTS FOOD INTERNATIONAL PTE LTD",
                "24 TUAS AVE 12 OFF TUAS AVE 7  ",
                "639041"
            ],
            [
                "BEE & BEE ENTERPRISE",
                "21 TUAS AVE 3   ",
                "639417"
            ],
            [
                "THE GROCER",
                "60 NANYANG VIEW #01-01  ",
                "639673"
            ],
            [
                "M28 SUPERMART PTE LTD",
                "69R TUAS STH AVE 1 OFF TUAS SOUTH AVE 1  ",
                "639926"
            ],
            [
                "STARNET PTE LTD",
                "BLK 176  BOONLAY DR #01-358 TEL:62618902",
                "640176"
            ],
            [
                "66 SUPER STORE",
                "BLK 221  BOON LAY PLACE #01-234 ",
                "640221"
            ],
            [
                "FRESH PICK SUPERMARKET - BL221 ",
                "BLK 221 BOON LAY PLACE #01-224 ",
                "640221"
            ],
            [
                "GOOD PRICE CENTRE - BL221",
                "BLK 221  BOON LAY PLACE #01-206 ",
                "640221"
            ],
            [
                "JAYA AMBIGA TRADING PTE LTD",
                "BLK 221 BOON LAY PL #01-208  ",
                "640221"
            ],
            [
                "MONG LEE ENTERPRISE PTE LTD",
                "BLK 221  BOON LAY PLACE #01-228 ",
                "640221"
            ],
            [
                "PRIME GOODS STORE",
                "BLK 221  BOON LAY PLACE #01-224 ",
                "640221"
            ],
            [
                "WIN WIN MINI-MARTS",
                "BLK 221  BOON LAY PLACE #01-102 ",
                "640221"
            ],
            [
                "POH SOON SENG M/M-249",
                "BLK 249 JUORNG EAST ST 24 #01-100  ",
                "640249"
            ],
            [
                "GOOD PRICE CENTRE-JW276",
                "BLK 276  JURONG WEST ST 25 #01-07 ",
                "640276"
            ],
            [
                "ST STEP ONE",
                "BLK 405  JURONG WEST ST 42 #01-K1 TEL:9642 4478",
                "640405"
            ],
            [
                "NANYANG MINIMART",
                "BLK 406  JURONG WEST ST 42 #01-599 ",
                "640406"
            ],
            [
                "SIN HIAP HEE GAS & GEN.TRADING ENT.",
                "BLK 406  JURONG WEST ST 42 #01-599 ",
                "640406"
            ],
            [
                "SA BAE PTE LTD",
                "BLK 414  JURONG WEST ST 42 #01-795 ",
                "640414"
            ],
            [
                "SUN WENG SENG SUPERMARET",
                "BLK 428  JURONG WEST AVE 1 #01-250 ",
                "640428"
            ],
            [
                "SIN ENG SENG",
                "BLK 442  JURONG WEST AVE 1 #01-756 ",
                "640442"
            ],
            [
                "LIM THIONG BENG MINIMART",
                "BLK 453  JURONG WEST ST 42 #01-K1 ",
                "640453"
            ],
            [
                "GOOD PRICE HUB PTE LTD",
                "BLK 463 JURONG WEST ST 41 #01-566 TEL:6287 7831",
                "640463"
            ],
            [
                "YEN SENG HOO MEDICAL HALL",
                "BLK 463  JURONG WEST ST 41 #01-564 ",
                "640463"
            ],
            [
                "C.K. DEPARTMENT STORE - JURONG WEST",
                "BLK 495  JURONG WEST ST 41 #01-106 ",
                "640495"
            ],
            [
                "KIM SANG MEDICAL HALL-JW 495",
                "BLK 495  JURONG WEST ST 41 #01-88 ",
                "640495"
            ],
            [
                "LIM MENG HWA TRADING",
                "BLK 495  JURONG WEST ST 41 #01-100 ",
                "640495"
            ],
            [
                "CASH & CARRY BUDGET STORE",
                "BLK 498 JURONG WET ST 41 #01-482  ",
                "640498"
            ],
            [
                "POH SOON SENG MINIMART",
                "BLK 498 JURONG WEST ST 41 #01-452  ",
                "640498"
            ],
            [
                "GOODLUCK SUPERMARKET (B503)",
                "BLK 503  JURONG WEST AVE 1 ST 52 #01-849/853 ",
                "640503"
            ],
            [
                "CHOP WOON ENG SENG",
                "BLK 504  JURONG WEST ST 51 #01-229 ",
                "640504"
            ],
            [
                "JP POWER - 504",
                "BLK 504  JURONG WEST ST 51 #01-223 ",
                "640504"
            ],
            [
                "GUAN ANN CHAN MEDICAL HALL",
                "BLK 504  JURONG WEST ST 51 #01-239 ",
                "640504"
            ],
            [
                "HONG YU FINE SEASONAL PRODUCTS PTE LTD",
                "BLK 504  JURONG WEST ST 51 #01-225 ",
                "640504"
            ],
            [
                "CHOP CHIP SENG",
                "51 BT BATOK CRSC #05-07 UNITY CENTER ",
                "640507"
            ],
            [
                "CHOP CHIP SENG-JW",
                "BLK 507  JURONG WEST ST 52 #01-150 ",
                "640507"
            ],
            [
                "HAPPY SHOPPY PTE LTD",
                "BLK 517  JURONG WEST ST 52 #01-95 ",
                "640517"
            ],
            [
                "SEVEN DIAMONDS PTE LTD",
                "BLK 517 JURONG WEST ST 52 #01-95  ",
                "640517"
            ],
            [
                "HOCK SWEE SENG MINIMART",
                "BLK 526  JURONG WEST ST 52 #01-319 ",
                "640526"
            ],
            [
                "DAH SENG MINI SUPERMARKET",
                "BLK 544  JURONG WEST ST 42 #01-105 ",
                "640544"
            ],
            [
                "SPS MART PTE LTD",
                "BLK 557  JURONG WEST ST 42 #01-391B ",
                "640557"
            ],
            [
                "LI LI CHENG (BRANCH)",
                "BLK 651  JURONG WEST ST 61 #01-01 ",
                "640651"
            ],
            [
                "VENITHAS MINIMART",
                "BLK 679  JURONG WEST CTRL 1 #01-10 ",
                "640679"
            ],
            [
                "MALLIGA MINIART",
                "BLK 703 JURONG WEST ST 71 #01-108  ",
                "640703"
            ],
            [
                "JAYAM MANI PTE LTD",
                "BLK 703 JURONG WEST ST 71 #01-108  TEL:6791 1276",
                "640703"
            ],
            [
                "SHERWIN (S) PTE LTD - JW720",
                "BLK 720  JURONG WEST AVE 5 #01-K1 ",
                "640720"
            ],
            [
                "ARCHANA STORES",
                "BLK 721  JURONG WEST AVE 5 #B1-102 ",
                "640721"
            ],
            [
                "JOVAN MINIMART",
                "BLK 723  JURONG WEST AVE 5 #B1-144 ",
                "640723"
            ],
            [
                "MING HUAT MINIMARTS",
                "BLK 727  JURONG WEST AVE 5 #01-190 ",
                "640727"
            ],
            [
                "EMPRESS LIFESTYLE",
                "BLK 762 JURONG WEST ST 75 #01-328  ",
                "640762"
            ],
            [
                "FEMELLE LLP - JW 762",
                "BLK 762 JURONG WEST ST 75 #01-252 GEK POH SHPP CTR ",
                "640762"
            ],
            [
                "NANYANG MINIMART & HAIR SALON",
                "BLK 810 JURONG WEST ST 81 #01-188  ",
                "640810"
            ],
            [
                "FRESHPICK SUPERMARKET",
                "BLK 814  JURONG WEST ST 81 #01-190 ",
                "640814"
            ],
            [
                "KAH HOE MINIMART",
                "BLK 814 JURONG WEST ST 81 #B1-204  ",
                "640814"
            ],
            [
                "HONG HONG MINIMART",
                "BLK 825  JURONG WEST ST 81 #01-K1 ",
                "640825"
            ],
            [
                "KAUNG SONE PTE LTD",
                "BLK 838 JURONG WEST ST 81 #K1-01  ",
                "640838"
            ],
            [
                "SHERWIN (S) PTE LTD - JW838",
                "BLK 838 JURONG WEST ST 81 #01-K1  ",
                "640838"
            ],
            [
                "INBA TRADING PTE LTD",
                "BLK 845  JURONG WEST ST 81 #01-229 ",
                "640845"
            ],
            [
                "SOON HENG NAN DA MINIMART",
                "BLK 907  JURONG WEST ST 91 #01-197 ",
                "640907"
            ],
            [
                "NAFISA MINIMART",
                "BLK 932 #01-K2 JURONG WEST ST 92 ",
                "640932"
            ],
            [
                "GOOD HEALTH MEDICAL HALL",
                "BLK 959 JURONG WEST ST 92 #01-158  ",
                "640959"
            ],
            [
                "THE CONVENIENCE STORE",
                "BLK 959 JURONG WEST ST 92 #01-158 ",
                "640959"
            ],
            [
                "J.P POWER",
                "BLK 961 JURONG WEST ST 92 #01-200  ",
                "640961"
            ],
            [
                "WONG SIONG YE CHINESE MEDICAL HALL",
                "BLK 963  JURONG WEST ST 91 #01-326 ",
                "640963"
            ],
            [
                "ANNA SUPERMARKET",
                "BLK 601A JURONG WEST ST 62 #01-01 ",
                "641601"
            ],
            [
                "FULL MOON MINIMART",
                "BLK 666B  JURONG WEST ST 65 #01-211 ",
                "642666"
            ],
            [
                "LAKEPOINT MINIMART",
                "BLK 4  LAKEPOINT DR #01-25 LAKEPOINT CONDO ",
                "648924"
            ],
            [
                "MING JIA MINIMART",
                "BLK 109  BUKIT BATOK WEST AVE 6 #01-08 ",
                "650109"
            ],
            [
                "MIN SHUN CHIN. MH PTE LTD",
                "BLK 109 BT BATOK WEST AVE 6 #01-12  ",
                "650109"
            ],
            [
                "YEO & SON",
                "BLK 134  BUKIT BATOK WEST AVE 6 #01-449 ",
                "650134"
            ],
            [
                "ZUN LI TRADING",
                "BLK 134 BUKIT BATOK WEST AVE 6 #01-449 TEL:9758 2746",
                "650134"
            ],
            [
                "S.P. POWER",
                "BLK 157  BUKIT BATOK ST 11 #01-202 ",
                "650157"
            ],
            [
                "GOOD PRICE CENTRE-BB164",
                "BLK 164  BUKIT BATOK ST11 #01-152 ",
                "650164"
            ],
            [
                "SAKTHI STORE",
                "BLK 177 BUKIT BATOK WEST AVE 8 #01-249 ",
                "650177"
            ],
            [
                "SIM-PLY MINI MART - BB188",
                "BLK 188  BUKIT BATOK WEST AVE 6 #01-07 TEL:65632108",
                "650188"
            ],
            [
                "YONG NAM SENG",
                "BLK 207  BUKIT BATOK ST 21 #01-112 ",
                "650207"
            ],
            [
                "SING BEE & CO",
                "BLK 213  BUKIT BATOK ST 21 #01-207 ",
                "650213"
            ],
            [
                "YEW LEONG MINI-MART",
                "BLK 217 BUKIT BATOK ST 21 #01-359 ",
                "650217"
            ],
            [
                "ARCHACA PROVISION STORES PTE LTD",
                "BLK 233 BT BATOK EAST AVE 5 #01-41  ",
                "650233"
            ],
            [
                "MONG LEE MINI-MART (BP)",
                "BLK 260  BUKIT PANGJANG #01-41 ",
                "650260"
            ],
            [
                "JOO SIANG HUP KEE PROVISION",
                "265 BT BATOK EAST AVE 4 #01-385  ",
                "650265"
            ],
            [
                "LIM LEONG SOON",
                "BLK 265  BUKIT BATOK EAST AVE 4 #01-401 ",
                "650265"
            ],
            [
                "YOK CHOON PROVISION SHOP",
                "BLK 265  BUKIT BATOK EAST AVE 4 #01-403 ",
                "650265"
            ],
            [
                "ROSELLE BEAUTY ESSENTIALS",
                "BLK 272 BT BATOK EAST AVE 4 #01-58  ",
                "650272"
            ],
            [
                "HENG FOH TONG MEDICAL HALL",
                "BLK 274  BUKIT BATOK EAST AVE4 #01-92 ",
                "650274"
            ],
            [
                "BODYFAIR TRADING",
                "BLK 278  BUKIT BATOK EAST AVE 3 #01-351 ",
                "650278"
            ],
            [
                "GOODLUCK PROVISION SHOP (B278)",
                "BLK 278  BUKIT BATOK EAST AVE 3 #01-345 ",
                "650278"
            ],
            [
                "S.P. POWER-BB281",
                "BLK 281  BUKIT BATOK AVE 4 #01-307 ",
                "650281"
            ],
            [
                "KOH SENG HIN",
                "BLK 323 BUKIT BATOK ST 33 #01-112  TEL: 65622816",
                "650323"
            ],
            [
                "GOOD PRICE CENTRE-BB324-2",
                "BLK 324  BUKIT BATOK ST 33 #01-45 ",
                "650324"
            ],
            [
                "GOOD PRICE CENTRE-BB324",
                "BLK 324  BUKIT BATOK ST 33 #01-43 ",
                "650324"
            ],
            [
                "HIN WANG MINIMART",
                "BLK 324 BUKIT BATOK ST 33 #01-37  ",
                "650324"
            ],
            [
                "YI ZHONG MINI-MART",
                "BLK 324  BUKIT BATOK ST 33 #01-37 ",
                "650324"
            ],
            [
                "YZ MINIMART",
                "BLK 324 BUKIT BATOK ST 33 #01-37 ",
                "650324"
            ],
            [
                "T S CHEW TRADING",
                "BLK 347  BUKIT BATOK ST34 #01-268 ",
                "650347"
            ],
            [
                "GOLDEN STAR PROVISION STORE",
                "BLK 371  BUKIT BATOK ST 31 #01-312 ",
                "650371"
            ],
            [
                "MCP FAIRMART PTE LTD",
                "BLK 371  BUKIT BATOK ST 31 #01-324 ",
                "650371"
            ],
            [
                "S S POWER",
                "BLK 371  BUKIT BATOK ST 31 #01-316 ",
                "650371"
            ],
            [
                "SRI MURUGAN STORES PTE LTD - BT",
                "BLK 371 BUKIT BATOK ST 31 #01-322 ",
                "650371"
            ],
            [
                "BEAUTY SPECTRUM",
                "BLK 376 BUKIT BATOK ST 31 #01-124 ",
                "650376"
            ],
            [
                "CLICK N BUY - BB376",
                "376 BT BATOK ST 31 #01-124  ",
                "650376"
            ],
            [
                "SIN BIN HENG MINI MARKET",
                "BLK 413  BUKIT BATOK WEST AVE 4 #01-204 ",
                "650413"
            ],
            [
                "ONG MAH KOW SUPERMARKET",
                "BLK 507  BUKIT BATOK ST 52 #01-121/123 ",
                "650507"
            ],
            [
                "YEE HUAT MINIMART",
                "BLK 539  BUKIT BATOK ST 52 #01-573 ",
                "650539"
            ],
            [
                "FU ZHONG HUA (IMP & EXP) PTE LTD",
                "NO 1  BUKIT BATOK CRESC #07-54 (TEL:68722821) WCEGA PLAZA",
                "652064"
            ],
            [
                "AJMAL TRADE MART PTE LTD-KRJ",
                "NO 1  BUKIT BATOK CRESC #05-24 WCEGA PLAZA ",
                "658064"
            ],
            [
                "GRACE F&B MARKETING",
                "NO 21  BUKIT BATOK CRESC #18-84 WCEGA PLAZE & TOWER ",
                "658065"
            ],
            [
                "WEE CHYE HANG FOODSTUFF TDG P/L",
                "BLK 51  BUKIT BATOK CRESC #04-17,UNITY CTR ",
                "658077"
            ],
            [
                "KIAN ENG HANG FOOD IND I & E P/L",
                "20 BT BATOK CRSC #05-13 ENTERPRISE CTR ",
                "658080"
            ],
            [
                "LIM SOON POH TRADING",
                "NO 20  BUKIT BATOK CRESC #03-17/18/19 ENTERPRISE CTR WAREHOUSE",
                "658080"
            ],
            [
                "MONG LEE MINI-MART (BBWH)",
                "NO 20  BUKIT BATOK CRESC #07-11/12 ENTERPRISE CTR ,(OFF ST) ",
                "658080"
            ],
            [
                "SENG CHOON HUAT TRADING",
                "NO 20  BUKIT BATOK CRESC #01-13 ENTERPRISE CTR (OFF ST23) ",
                "658080"
            ],
            [
                "MRS SOH",
                "NO 40  PAVILION RISE  ",
                "658403"
            ],
            [
                "SMA INDUSTRIAL SERVICES",
                "BLK 2022  BUKIT BATOK ST 23 #03-128 BUKIT BATOK IND PARK A ",
                "659527"
            ],
            [
                "KOLEE SUPERMARKET",
                "540 BT BATOK ST 23 #01-46 ACADIA LODGE ",
                "659553"
            ],
            [
                "APPLEHOPS PTE LTD",
                "29 HILLVIEW AVENUE #06-01  ",
                "669561"
            ],
            [
                "DAILY DEPARTMENT STORE PTE LTD (HV)",
                "#02-04 HILL BROOKE CONDO BLK 90 HILL VIEW AVENUE  ",
                "669610"
            ],
            [
                "STIFF PTE LTD",
                "90 HILLVIEW AVENUA  HILLBROOKS #02-04 ",
                "669610"
            ],
            [
                "W.P POWER",
                "BLK 258  BUKIT PANJANG RING RD #01-42 ",
                "670258"
            ],
            [
                "AASHIRWAD TRADING-FAJAR",
                "BLK 419 FAJAR RD #01-459  ",
                "670419"
            ],
            [
                "VEL MURUGAN TRADING",
                "BLK 419 FAJAR RD  #01-459 ",
                "670419"
            ],
            [
                "GREEN`S PROVISION STORE",
                "BLK 435 BUKIT PANJANG RING RD #01-661 ",
                "670435"
            ],
            [
                "SAI TRADERS",
                "BLK 446 FAJAR RD #01-13(FAJAR MARKET) ",
                "670446"
            ],
            [
                "M28 MINIMART-SEGAR 465",
                "BLK 465  SEGAR RD #01-150 ",
                "670465"
            ],
            [
                "M28 MINIMART - SEGAR 485",
                "BLK 485  SEGAR RD #01-516 ",
                "670485"
            ],
            [
                "CUTECH GREEN VENTURES PTE LTD",
                "BLK 635C SENJA RD #01-04 ",
                "673635"
            ],
            [
                "METRO FRESH TRADING & MART PTE LTD - 635",
                "BLK 635C SENJA RD #01-04 ",
                "673635"
            ],
            [
                "KOH SENG HONG",
                "359 WOODLANDS RD YEW TEE IND. EST.  ",
                "677929"
            ],
            [
                "SOON THYE DEPARTMENTAL STORE",
                "NO 365  WOODLANDS RD YEW TEE IND EST ",
                "677932"
            ],
            [
                "NEW STAR DEPARTMENTAL CO.",
                "BLK 373 WOODLANDS RD YEW TEE IND. EST ",
                "677936"
            ],
            [
                "YI FENG ZA HUO SHANG DIAN",
                "BLK 17  DAIRY FARM RD #B1-02,DAIRY FARM ESTATE ",
                "679043"
            ],
            [
                "TECK WHYE MEDICAL HALL",
                "BLK 16  TECK WHYE LANE #01-109 ",
                "680016"
            ],
            [
                "TECK WHYE PROVISION STORE",
                "BLK 16  TECK WHYE LANE #01-121 ",
                "680016"
            ],
            [
                "UNIQUE-PRICE TRADING",
                "BLK 139  TECK WHYE LANE #01-335 ",
                "680139"
            ],
            [
                "ENG CHONG MARKET PRODUCE",
                "BLK 143  TECK WHYE LANE #01-237 ",
                "680143"
            ],
            [
                "KIM SANG MEDICAL HALL - TW",
                "144 TECK WHY LANE #01-201  ",
                "680144"
            ],
            [
                "GUAN ANN CHAN GINSENG MEDICAL SUPPLIER",
                "BLK 143  TECK WHYE LANE #01-227 ",
                "680145"
            ],
            [
                "RELIANCE PROVISION SHOP",
                "BLK 233  CHOA CHU KANG CTRL #B1-97 ",
                "680233"
            ],
            [
                "JIN HUI MINIMART",
                "BLK 253  CHOA CHU KANG AVE 1 #01-03 ",
                "680253"
            ],
            [
                "NICE MINIMART-CCK",
                "BLK 284 CHOA CHU KANG AVE 4 #B1-330  ",
                "680284"
            ],
            [
                "XINYUANXIN TRADING PTE LTD",
                "BLK 284 CHOA CHU KANG AVE 3 #B1-330 ",
                "680284"
            ],
            [
                "RELIANCE MEDIA ENTERPRISE",
                "BLK 287  CHOA CHU KANG AVE 2 #B1-203 ",
                "680287"
            ],
            [
                "BAN ENG LEE MINIMART",
                "BLK 486  CHOA CHU KANG AVE 5 #01-152 ",
                "680486"
            ],
            [
                "JUMBO SUPERMARKET",
                "BLK 517 CHAO CHU KANG ST 51 #01-30  ",
                "680517"
            ],
            [
                "RIFATH TRADERS PTE LTD",
                "BLK 517 CHOA CHU KANG ST 51 #01-30 ",
                "680517"
            ],
            [
                "PJ MINIMART",
                "BLK 532  CHOA CHU KANG ST 51 #01-51,UNIT 3A ",
                "680532"
            ],
            [
                "FORTUNE MINIMART",
                "BLK 544 CHOA CHU KANG ST 52 #01-88  ",
                "680544"
            ],
            [
                "MING WAN HENG MINIMART & TRADING",
                "BLK 660  CHOA CHU KANG CRESC #01-93 ",
                "680660"
            ],
            [
                "RELIANCE SUPERMART PTE LTD",
                "BLK 668A  CHOA CHU KANG CRESC #01-02 ",
                "680668"
            ],
            [
                "E OCEANMINIMART",
                "BLK 673  CHOA CHU KANG CRESC #01-02 ",
                "680673"
            ],
            [
                "A1 M28 MINIMART (C.C.K)",
                "BLK 678A  CHOA CHU KANG CRESC #01-02 ",
                "680678"
            ],
            [
                "RELIANCE FOODS",
                "BLK 764 CHOA CHU KANG NTH 5 #01-275  ",
                "680764"
            ],
            [
                "MWH MINIMART",
                "BLK 462A  CHOA CHU KANG AVE 4 #01-01 MULTI STOREY CAR PARK ",
                "681462"
            ],
            [
                "DOUBLE ONE MINIMART (787B)",
                "BLK 787B  CHOA CHU KANG DR #01-239 ",
                "681787"
            ],
            [
                "WENDY & NELSON",
                "24 HONG SAN WALK #B1-01 PALM GRN (CCK)  ",
                "689047"
            ],
            [
                "XIN LIAN XIN ",
                "2A HONG SAN WALK #B1-01 PLAM GARDEN  TEL:90704637",
                "689047"
            ],
            [
                "TONG XING FA SUPERMARKET",
                "BLK 410  CHOA CHU KANG AVE 3 #01-341 ",
                "690410"
            ],
            [
                "AJMAL TRADE MART PTE LTD",
                "11 JLN LEKAR OFF OLD CHOA CHU KANG  ",
                "698918"
            ],
            [
                "ST LOGISTICS PTE LTD",
                "NO 601  OLD CHOA CHU KANG RD  ",
                "699817"
            ],
            [
                "AJMAL TRADING GROUP PTE",
                "NO 1A  MURAI FARMWAY MURAI LODGE ",
                "709154"
            ],
            [
                "SHAFEN SUPERMARKET",
                "NO 1B  MURAI FARMWAY #01-04 MURAI LODGE ",
                "709155"
            ],
            [
                "SHAYAAN SUPERMARKET $ TRADING-FARMWAY",
                "NO 1B  MURAI FARMWAY #01-04 MURAI LODGE ",
                "709155"
            ],
            [
                "TOMU MINI MARKET",
                "NO 12  SUNGEI KADUT ST 6  IND EST TEL:62656206",
                "728858"
            ],
            [
                "HONG AIK PTE LTD",
                "NO 19  SELETAR WEST FARMWAY 6 SELETAR LODGE ONE ",
                "729042"
            ],
            [
                "MUDAM BROTHERS PTE.LTD",
                "NO 53  SUNGEI KADUT LOOP 1ST FLOOR,TIONG AIK IND.BLDG ",
                "729502"
            ],
            [
                "MUDAM BROTHERS PTE LTD",
                "NO 8  SUNGEI KADUT AVE  ",
                "729645"
            ],
            [
                "HH SUNDRY SHOP PTE LTD",
                "NO 23  MANDAI EST #01-21 JUNIPER LODGE ",
                "729937"
            ],
            [
                "BISMILLAH MINIMART PTE LTD-MD",
                "32 MANDAI EST OFF WOODLANDS RD  ",
                "729939"
            ],
            [
                "AL FATHA PROVISION SHOP",
                "BLK 19  MARSILING LANE #01-311 ",
                "730019"
            ],
            [
                "MARSILING 81",
                "BLK 19  MARSILING LANE #01-291 ",
                "730019"
            ],
            [
                "AKESI MINI MART",
                "BLK 35  MARSILING DRIVE #01-399 ",
                "730035"
            ],
            [
                "RAVIS SUPERMARKET-(111)",
                "BLK 111  WOODLANDS ST 13 #01-90 ",
                "730111"
            ],
            [
                "TONG & SAM MINI SUPERKET & SUPPLIER",
                "BLK 111 WOODLANS ST 13  #01-78 ",
                "730111"
            ],
            [
                "ASCENTURE PTE LTD",
                "BLK 113 WOODLANDS ST13 #12-106  ",
                "730113"
            ],
            [
                "SETHARA",
                "BLK 131 #01-190 MASILING RISE ",
                "730131"
            ],
            [
                "CHIP HUAT (UNITED) MINIMART (1996)",
                "BLK 132  MARSILING RISE #01-232 ",
                "730132"
            ],
            [
                "GOOD PRICE CENTRE-MS132",
                "BLK 132  MARSILING RISE #01-220 ",
                "730132"
            ],
            [
                "GOOD PRICE CENTRE-MS136",
                "BLK 136  MARSILING RD #01-218 ",
                "730136"
            ],
            [
                "KALAIS MINI MART",
                "BLK 136 MARSILING RD #01-2178  ",
                "730136"
            ],
            [
                "FORTUNE STORE",
                "BLK 166 WOODLANDS ST 13 #02-527 ",
                "730166"
            ],
            [
                "HENG HOCK MINIMART",
                "BLK 210  MARSILING CRESC #01-11 ",
                "730210"
            ],
            [
                "UNIVERSAL HOUSEHOLD AND HARDWARE TDG-WL",
                "BLK 302 WOODLANDS ST 31 #01-293  ",
                "730302"
            ],
            [
                "MIND OF ESSENTIAL",
                "BLK 306 WOODLANDS ST 31 #01-3181  ",
                "730306"
            ],
            [
                "ANGEL MINIMART PTE LTD",
                "BLK 326 WOODLANDS ST 32 #01-117 ",
                "730326"
            ],
            [
                "KIWI STORES PTE LTD",
                "BLK 326  WOONDLANDS ST 32 #01-121 ",
                "730326"
            ],
            [
                "VIDEKS - 326",
                "BLK 326 WOODLANDS ST 32 #01-117 ",
                "730326"
            ],
            [
                "WIN & NING ENTERPRISE",
                "BLK 326  WOODLANDS ST 32 #01-105 ",
                "730326"
            ],
            [
                "YAK HONG PTE LTD-515A",
                "BLK 515A  WOODLAND DR 14 #01-183 ",
                "730515"
            ],
            [
                "CENT TO DOLLAR",
                "BLK 548 WOODLANDS DRIVE 44 #01-26  ",
                "730548"
            ],
            [
                "ENTRUST PROVISION",
                "BLK 548  WOODLANDS DR 44 #01-50 ",
                "730548"
            ],
            [
                "ORANGE VISTA PERSONAL CARE STOREMETICS",
                "BLK 548 WOODLANDS DR 44 #01-12 VISTA POINT ",
                "730548"
            ],
            [
                "REAL BUY",
                "BLK 548  WOODLANDS DR 42 #01-24 VISTA POINT ",
                "730548"
            ],
            [
                "ZHEN TAT ENTERPRISE",
                "BLK 548  WOODLANDS DR 44 #01-36 ",
                "730548"
            ],
            [
                "C & H MINIMART",
                "BLK 605  WOODLANDS DR 42 #01-105 ",
                "730605"
            ],
            [
                "P.S.ANANTHA MINI MART",
                "BLK 626A  WOODLANDS DR 52 #01-02 ",
                "730626"
            ],
            [
                "GUAN HUAT PROVISION SHOP",
                "BLK 678A  WOODLANDS AVE 6 #01-24 ",
                "730673"
            ],
            [
                "ANYA TRADING ENTERPRISE",
                "BLK 678A  WOODLANDS AVE 6 #01-44 ",
                "730678"
            ],
            [
                "IKEA MINIMART",
                "BLK 686C WOODLANDS DR 73 #01-90  ",
                "730686"
            ],
            [
                "TIAN TIAN LE CONVENIENT STORE",
                "BLK 688  WOODLANDS DR 75 #01-02,MULTI STOREY CAR PARK ",
                "730688"
            ],
            [
                "U & ME SUPERMARKET",
                "BLK 711 WOODLANDS DR 70 #01-65 ",
                "730711"
            ],
            [
                "LAU SOON HUAT MINIMART",
                "BLK 729 WOODLAND CIRCLE #01-47  ",
                "730729"
            ],
            [
                "RAVI`S SUPER MART (740)",
                "BLK 740 WOODLANDS CIRCLE #01-413  ",
                "730740"
            ],
            [
                "TKT MINISUPERMARKET",
                "BLK 743  WOODLANDS CIRCLE #01-465 ",
                "730743"
            ],
            [
                "TONG & LEE MINI SUPERMARKET",
                "BLK 759  WOODLANDS AVE 6 #01-32 ",
                "730759"
            ],
            [
                "PANS INTERNATIONAL (SINGAPORE) PTE LTD",
                "BLK 763  WOODLANDS AVE 6 #01-70 ",
                "730763"
            ],
            [
                "EN & U SUPPLIES",
                "BLK 768  WOODLANDS AVE 6 #01-27 ",
                "730768"
            ],
            [
                "PRIME SUPERMARKET (1996) P/L-WL768",
                "BLK 768  WOODLANDS AVE 6 #01-02 ",
                "730768"
            ],
            [
                "CHATHIRAM HOLDINGS PTE LTD",
                "BLK 780  WOODLANDS CRESC #01-05 ",
                "730780"
            ],
            [
                "FORTUNE SUPERMARKET PTE LTD(WOODLANDS)",
                "BLK 780 WOODLANDS CRESC #01-01 ",
                "730780"
            ],
            [
                "DINO MINIMART",
                "BLK 791 WOODLANDS AVE6 #01-603  ",
                "730791"
            ],
            [
                "O.A TRADING & IMPREX PTE LTD",
                "BLK 791  WOODLANDS AVE 6 #01-603 ",
                "730791"
            ],
            [
                "MMART@795",
                "BLK 795  WOODLANDS DR 72 #01-13 ",
                "730795"
            ],
            [
                "101 MINIMART",
                "BLK 806 WOODLANDS ST 81 #01-101  ",
                "730806"
            ],
            [
                "RAINBOW PRINTS & TRADING",
                "BLK 806  WOODLANDS ST 81 #01-93 ",
                "730806"
            ],
            [
                "JACES PLACE",
                "BLK 849 WOODLANDS ST 82 #01-213  ",
                "730849"
            ],
            [
                "ABC MINIMART",
                "BLK 859 WOODLANDS ST 83 #01-140  ",
                "730859"
            ],
            [
                "AH HONG MINIMART",
                "BLK 880  WOODLANDS ST 82 #01-08 ",
                "730880"
            ],
            [
                "FATT LONG TRADING LLP",
                "BLK 883  WOODLANDS ST 82 #01-26/27/28,WOODLANDS NORTH PLAZA ",
                "730883"
            ],
            [
                "GOOD PRICE CENTRE-WL883",
                "BLK 883  WOODLANDS ST 82 #01-474 ",
                "730883"
            ],
            [
                "SHAFASHA PTE LTD",
                "BLK 883  WOODLANDS ST 82 #01-25 ",
                "730883"
            ],
            [
                "MANJARI MINI MART",
                "BLK 888  WOODLANDS DR 50 #01-721, 888 PLAZA ",
                "730888"
            ],
            [
                "YEONG - HENG MINIMART",
                "BLK 895B WOODLANDS DR 50 #01-24 ",
                "730895"
            ],
            [
                "FONG LAI TRADING",
                "BLK 1A  WOODLANDS CTR RD #01-84 ",
                "731001"
            ],
            [
                "GUAN CHUAN CHAN",
                "BLK 1A  WOODLANDS CTR RD #01-70 ",
                "731001"
            ],
            [
                "PURPLE TULIPS BEAUTY SHOP",
                "1A WOODLANDS CENTRE RD #01-76  ",
                "731001"
            ],
            [
                "HOE HUAT SENG PROVISION TRADING",
                "BLK 892C  WOODLANDS DR 50 #01-01 ",
                "732892"
            ],
            [
                "PHAN NEE TRADING LLP - WL",
                "NO 2  WOODLANDS SECTOR 2 #01-05 PHAN NEE WOODLAND ",
                "737723"
            ],
            [
                "ACUMEN DISTRIBUTION LLP",
                "NO 11 WOODLANDS CLOSE #01-44 ",
                "737853"
            ],
            [
                "MM SUNDRY SHOP PTE LTD",
                "BLK 27  WOODLANDS SECTOR 1 #01-70 WOODLANDS DORMITORY ",
                "738252"
            ],
            [
                "RANIS SPICE & REMPAH TRADING",
                "BLK 548  WOODLANDS DR 44 #01-05,UNIT 25/26 MARKET ",
                "738548"
            ],
            [
                "ENG KHIM TRADING",
                "14 WOODLANDS LOOP #01-1228 BIG ORANGE SELF STORAGE ",
                "738636"
            ],
            [
                "HENG LAI HENG TRADING ENT.",
                "BLK 20  WOODLANDS LINKS #01-37 WOODLANDS EAST INDEST ",
                "738733"
            ],
            [
                "LEE CHIN AIK IND. SUPPLY TDG",
                "BLK 20 WOODLANDS LINK #01-05 WOODLANDS EAST IND. EST ",
                "738733"
            ],
            [
                "UNIVERSAL DISTRIBUTION PTE LTD-MSL",
                "BLK 3 MARSILING IND. EST R OFF MARSILING RISE ",
                "739230"
            ],
            [
                "KENG HUAT DEPARTMENTAL STORE",
                "BLK 271  KRANJI RD KARANJI IND. EST. ",
                "739509"
            ],
            [
                "FORTUNE SUPERMARKET PTE LTD(SEMBAWANG)",
                "BLK 463  SEMBAWANG DR #01-02 TEL:6362 1772",
                "750463"
            ],
            [
                "HAPPY VALLEY MINIMART",
                "BLK 477  SEMBAWANG DR #01-395 ",
                "750477"
            ],
            [
                "101 EXPRESSMART PTE LTD",
                "BLK 483  ADMIRALTY LINK #01-25 ",
                "750483"
            ],
            [
                "FOREVER GREEN MINIMART",
                "BLK 483 ADMIRALTY LINK #01-25  ",
                "750483"
            ],
            [
                "SENJA MINIMART (ADMIRALTY)",
                "BLK 483 ADMIRALTY LINK #01-25 (SEMBAWANG) ",
                "750483"
            ],
            [
                "SEMBAWANG GREEN VALUE-MART",
                "BLK 483 ADMIRALTY LINK  #01-25  ",
                "750483"
            ],
            [
                "IKEA MINIMART-SEMBAWANG",
                "BLK 505  CANBERRA LINK,SEMBAWANG #01-01 ",
                "750505"
            ],
            [
                "WONG LI MINIMART",
                "BLK 832  WOODLANDS ST 83 #01-69 ",
                "750832"
            ],
            [
                "AWESOME PTE LTD",
                "BLK 590A MONTREAL LINK #01-27  ",
                "751590"
            ],
            [
                "7 SEVEN PTE LTD",
                "300 ADMIRATY   ",
                "757027"
            ],
            [
                "7 SEVEN PTE LTD",
                "300 ADMIRALTY ROAD WEST (NORTH COAST LODGE)  ",
                "757027"
            ],
            [
                "BHANDARI TRADING PTE LTD",
                "NO 200  WOODLANDS IND PARK E7 #01-05 ",
                "757177"
            ],
            [
                "UNIVERSAL HOME WARE CENTRE",
                "NO 200  WOODLANDS IND PARK E7 #01-01/04 ",
                "757177"
            ],
            [
                "BAN SENG WINE PTE LTD - 8A AD",
                "NO 8A  ADMIRALTY ST #02-01,FOOD EXCHANGE @ SINGAPORE ",
                "757437"
            ],
            [
                "UDDERS PTE LTD",
                "8A ADMIRALTY ST #03-23 FOOD XCHANGE ",
                "757437"
            ],
            [
                "SWANSTON - WAREHOUSE",
                "8 ADMIRALTY ST #04-01/02/03 ADMIRAX ",
                "757438"
            ],
            [
                "ELRICA MARKETINGS IMPORT & EXPORT",
                "NO 8B  ADMIRALTY ST #07-10 ",
                "757440"
            ],
            [
                "3C SUPERMARKET",
                "NO 51  ADMIRALITY RD WEST COCHRANE LODGE ",
                "757443"
            ],
            [
                "SADIA SUPERMARKET & TDG (S) P/L",
                "7 WOODLANDS IND. PARK E2 OFF WOODLANDS AVE 9  ",
                "757450"
            ],
            [
                "I & D TRADING COY",
                "NO 10  ADMIRALTY ST #05-88,NORTHLINK BLDG ",
                "757695"
            ],
            [
                "LN MARKETING (S) PTE LTD",
                "NO 10 ADMIRALTY ST #03-53 NORTH LINK BUILDING ",
                "757695"
            ],
            [
                "SENG HUAT HOE KEE",
                "10 ADMIRALTY ST #05-54 NORTH LINK BUILDING ",
                "757695"
            ],
            [
                "WORLD TRADING & MARKETING",
                "NO 10  ADMIRALTY ST #01-76,NORTH LINK BLDG ",
                "757695"
            ],
            [
                "GROCERIA TRADING",
                "NO 38  WOODLANDS IND. PARK E1 #02-11 ",
                "757700"
            ],
            [
                "KAYA INTERNATIONAL PTE LTD",
                "116 WOODLANDS INDUSTRIAL PK E5  ",
                "757846"
            ],
            [
                "PHAN NEE TRADING",
                "NO 49  ADMIRALITY RD WEST COCHRANE LODGE ",
                "759946"
            ],
            [
                "SUPER SUNDRIES & SPINNERS",
                "NO 50  ADMIRALTY RD WEST SEMBAWANG SHIPYARD ",
                "759956"
            ],
            [
                "KARTHIKA ENTERPRISE PTE LTD",
                "BLK 101  YISHUN AVE 5 #01-61 ",
                "760101"
            ],
            [
                "VINOTH PTE LTD",
                "BLK 101 YISHUN AVE 5 #01-61  ",
                "760101"
            ],
            [
                "C.K. DEPARTMENT STORE - YISHUN 102",
                "BLK 102  YISHUN AVE 5 #01-115 ",
                "760102"
            ],
            [
                "BUN AUN CHAN",
                "BLK 103 YISHUN RING RD #01-105  ",
                "760103"
            ],
            [
                "SRI MURUGAN STORE PTE LTD",
                "BLK 103 YISHUN RING RD #01-105 ",
                "760103"
            ],
            [
                "UMMI ALEEFA CORNER (HERBAL & FASHION)",
                "103 YISHUN RING RD #01-87  ",
                "760103"
            ],
            [
                "GO MARKET",
                "BLK 104 YISHUB RING ROAD #01-58/59/60  ",
                "760104"
            ],
            [
                "SIN SHEN LEE STORE (1)",
                "BLK 104 YISHUN RING RD #01-27  ",
                "760104"
            ],
            [
                "ORANGE DEPARTMENTAL STORE - YH",
                "BLK 106  YISHUN RING RD #01-145 ",
                "760106"
            ],
            [
                "RICHARD TAI ENTERPRISES",
                "BLK 106 YISHUN RING RD #01-161  ",
                "760106"
            ],
            [
                "GOOD SUPERMARKET PTE LTD",
                "BLK 110 YISHUN RING RD #01-379  ",
                "760110"
            ],
            [
                "LIM NAM THYE PROVISION SHOP",
                "BLK 110  YISHUN RING RD #01-377 ",
                "760110"
            ],
            [
                "NEO ENG HOCK TRADING CO.",
                "BLK 110 YISHUN RING RD #01-379  ",
                "760110"
            ],
            [
                "SIN MIN SOON GENERAL TRADING PTE LTD",
                "BLK 110 YISHUN RING RD #01-387  ",
                "760110"
            ],
            [
                "SRI MURUGAN SUPERMART PTE LTD",
                "BLK110 YISHUN RING RD #01-379  ",
                "760110"
            ],
            [
                "SADHANAS SUPERMART PTE LTD",
                "BLK 110  YISHUN RING RD #01-379 ",
                "760110"
            ],
            [
                "YONG YANG DER SHING STORE",
                "BLK 110  YISHUN RING RD  ",
                "760110"
            ],
            [
                "EPOK-EPOK INTERNATIONAL",
                "BLK 123  YISHUN ST 11 #01-503 ",
                "760123"
            ],
            [
                "WING SUN HOE MEDICAL HALL",
                "BLK 123  YISHUN ST 11 #01-499 ",
                "760123"
            ],
            [
                "UNITED SUPERMART",
                "BLK 136 MARSILING RD #01-2186 ",
                "760136"
            ],
            [
                "ASERET TRADING",
                "BLK 173 YISHUN AVE 7 #01-827 ",
                "760173"
            ],
            [
                "MY MINIMART PTE LTD",
                "BLK 174 YISHUN AVE 7 #01-829 TEL:9194 3728 ",
                "760174"
            ],
            [
                "FTF ENTERPRISE",
                "BLK 174 YISHUN AVE 7 #01-829  ",
                "760174"
            ],
            [
                "PHUA SOON LEE",
                "BLK 236  YISHUN RING RD #01-1006 ",
                "760236"
            ],
            [
                "JIN WAN LI MINIMART",
                "BLK 256  YISHUN RING RD #01-1001 ",
                "760256"
            ],
            [
                "JOYFUL MINIMART",
                "BLK 261 YISHUN ST 22 #01-135  ",
                "760261"
            ],
            [
                "TOH ENG LEE MINI-SUPERMARKET",
                "BLK 291  YISHUN ST 22 #01-347(TEL:96179007) ",
                "760291"
            ],
            [
                "C.K. DEPARTMENT STORE - YS2",
                "BLK 291  YISHUN ST 22 #01-341 ",
                "760291"
            ],
            [
                "SW GLORY INTERNATIONAL PTE LTD",
                "BLK 291  YISHUN ST 22 #01-381 ",
                "760292"
            ],
            [
                "HENG KIAT LI MINIMART",
                "BLK 310  YISHUN RING RD #01-1230 ",
                "760310"
            ],
            [
                "SARAVANA STORE PTE LTD",
                "BLK 310  YISHUN RING RD #01-1230 ",
                "760310"
            ],
            [
                "MM SUPERMART PTE LTD",
                "BLK 333C YISHUN ST 31 #01-165 ",
                "760333"
            ],
            [
                "M28 MINIMART (YS)",
                "BLK 348 YISHUN AVE 11 #01-01   ",
                "760348"
            ],
            [
                "KHANS FAMILY MART PTE LTD ",
                "BLK 365  YISHUN RING RD #01-1558 ",
                "760365"
            ],
            [
                "HIS WELLNESS & SUPPLIES",
                "BLK 414  YISHUN RING RD #01-1861 TEL:9116 6076",
                "760414"
            ],
            [
                "YONG HENG LEONG CHINESE MEDICAL HALL",
                "BLK 414  YISHUN RING RD #01-1851 ",
                "760414"
            ],
            [
                "JAYSREE MINIMART",
                "BLK 417 YISHUN AVE 11 #01-337 SINGAPORE 760417 ",
                "760417"
            ],
            [
                "PRETTY NID",
                "BLK 418 YISHUN AVE 11 #01-415  ",
                "760418"
            ],
            [
                "YIN HUA CHINESE MEDICAL HALL",
                "BLK 418  YISHUN AVE 11 #01-417 ",
                "760418"
            ],
            [
                "HENG ENG BOON MINI-MART",
                "BLK 419  YISHUN AVE 11 #01-379 ",
                "760419"
            ],
            [
                "LI LI CHENG (YISHUN) PTE LTD",
                "BLK 431  YISHUN AVE 1 #01-02 ",
                "760431"
            ],
            [
                "METRO FRESH TRADING & MART PTE LTD - YS",
                "BLK 504  YISHUN #01-04 ",
                "760504"
            ],
            [
                "VIDEKS - 590A",
                "BLK 590A MONTREAL LINK  ",
                "760590"
            ],
            [
                "DRAGONFLY MINIMART",
                "BLK 604 YISHUN ST 61 #01-323 ",
                "760604"
            ],
            [
                "ZAINAP AND ASSOCIATE ENTERPRISE PTE LTD",
                "BLK 604 YISHUN ST 61 #01-323 ",
                "760604"
            ],
            [
                "PIAK LAN HIONG RELIGIOUS GOODS",
                "BLK 605 YISHUN ST 61 #01-311 ",
                "760605"
            ],
            [
                "SIN YEE TECK MINI-MARKET",
                "BLK 619  YISHUN RING RD #01-3228 ",
                "760619"
            ],
            [
                "YI CHIN MINI SUPERMARKET",
                "BLK 632  YISHUN ST 61 #01-10 ",
                "760632"
            ],
            [
                "KIM ENG MINI SUPERMARKET",
                "BLK 103  YISHUN RING RD #01-79 ",
                "760640"
            ],
            [
                "BOON CHANG MINIMART",
                "BLK 641 YISHUN ST 61 #01-208  ",
                "760641"
            ],
            [
                "GOLDEN NATURALS PTE LTD",
                "BLK 645 YISHUN ST 61 #01-328 ",
                "760645"
            ],
            [
                "KANG MINIMART",
                "BLK 645  YISHUN ST 61 #01-322 ",
                "760645"
            ],
            [
                "KATHAYANNI SPICES HOME SERVICES PTE LTD",
                "BLK 645  YISHUN ST 61 #01-328 ",
                "760645"
            ],
            [
                "NAM HO TRADING",
                "BLK 661  YISHUN AVE 4 #01-429 ",
                "760661"
            ],
            [
                "HOCK TAI CHEONG",
                "BLK 664 YISHUN AVE 4 301-279 ",
                "760664"
            ],
            [
                "HUA HIN MINIMART",
                "BLK 716  YISHUN ST 71 #01-250 ",
                "760716"
            ],
            [
                "UP-MART TRADING",
                "BLK 717 YISHUN ST 71 #01-331 ",
                "760717"
            ],
            [
                "WEN JI FA MINIMART",
                "BLK 729  YISHUN ST 71 #01-103 ",
                "760729"
            ],
            [
                "NGEE HUAT MINI-MART",
                "BLK 731 YISHUN ST 72 #01-39  ",
                "760731"
            ],
            [
                "U MART",
                "BLK 737 YISHUN ST 72 #01-K1  ",
                "760737"
            ],
            [
                "GOOD PRICE CENTRE-YS743",
                "BLK 743  YISHUN AVE 5 #01-536 ",
                "760743"
            ],
            [
                "CHAN LIAN SENG PROVISION SHOP",
                "BLK 748 YISHUN ST 72 #01-224 ",
                "760748"
            ],
            [
                "20 FOUR 7",
                "BLK 761 YISHUN ST 72 #01-342  ",
                "760761"
            ],
            [
                "ANN TENG HENG",
                "BLK 761 YISHUN ST 72 #01-344 ",
                "760761"
            ],
            [
                "SIN WU SENG PROVISION SHOP",
                "BLK 761  YISHUN ST 72 #01-358 ",
                "760761"
            ],
            [
                "YEW HUAT MINIMART",
                "BLK 761 YISHUN ST 72 #01-342  ",
                "760761"
            ],
            [
                "3C MINIMART",
                "BLK 771  YISHUN AVE 3 #01-239 ",
                "760771"
            ],
            [
                "KAI SOON SUPERMARKET",
                "BLK 780  YISHUN RING RD #01-3546 ",
                "760780"
            ],
            [
                "C.K. DEPARTMENT STORE - YISHUN 846",
                "BLK 846  YISHUN RING RD #01-3643 ",
                "760846"
            ],
            [
                "SMART99 PTE LTD",
                "BLK 317 YISHUN AVE 9 #01-04 ",
                "763317"
            ],
            [
                "GURKHA MINIMART",
                "NO 70  VERNON PARK MPUNT VERNON CAMP ",
                "767827"
            ],
            [
                "HOME SHOPPERS",
                "2 YISHUN INDUSTRIES ST 1 #02-32 NORTHPOINT BIZHUB ",
                "768159"
            ],
            [
                "RAINBOW TRADING WHOLESALE PTE LTD",
                "2 YISHUN IND.ST 1 #01-02  ",
                "768159"
            ],
            [
                "U1 HOMEMART LLP",
                "2 YISHUN INDUSTRIES ST 1 #02-32  NORTHPOINT BIZHUB SINGAPORE 768159",
                "768159"
            ],
            [
                "UNIBOM SUPERSTORE",
                "NO 2  YISHUN INDUSTRIAL ST 1 #03-32,NORTH SPRING BIZHUB ",
                "768159"
            ],
            [
                "UNIHOM SUPERSTORE",
                "NO 2  YISHUN INDUSTRIES ST 1 #02-32,NORTHPOINT BIZHUB ",
                "768159"
            ],
            [
                "DESKRIGHT PTE LTD",
                "NO 7  YISHUN INDUSTRIAL ST 1 #04-36 NORTH SPRING BIZHUB ",
                "768162"
            ],
            [
                "COUNTER SALES",
                "BLK 9  YISHUN INDUSTRIAL ST 1  #06-70/71 NORTH SPRING BIZHUB ",
                "768163"
            ],
            [
                "PYS DISTRIBUTION PTE LTD",
                "BLK 1  YISHUN ST 23 #02-31 YS-ONE BLDG ",
                "768441"
            ],
            [
                "NICE COSMETICS & ESSENTIALS PTE LTD",
                "51 YISHUN CTL 1 #01-02 GOLDEN VILLAGE ",
                "768794"
            ],
            [
                "ALEXANDRA HEALTH PTE LTD",
                "NO 90  YISHUN CENTREL KHOO TECK PUAT HOSPITAL ",
                "768828"
            ],
            [
                "PHAN NEE TRADING LLP - YS",
                "NO 2B  YISHUN AVE 7 SIMPANG LODGE 1 ",
                "768929"
            ],
            [
                "TUAS SUPERMARKET PTE LTD",
                "2C YISHUN AVE 7 SIMPANG LODGE 2  ",
                "768930"
            ],
            [
                "PHUA LAM SEA VEGETABLE SUPPLIER",
                "NO 75  JLN MALU-MALU,SEMBAWANG  ",
                "769686"
            ],
            [
                "LEESONN SUPERMARKET",
                "11 THONG SOON AVE OFF UPP THOMSON ROAD  ",
                "787438"
            ],
            [
                "ELETEX ENTERPRISES PTE. LTD",
                "NO 94  TAGORE LANE OFF TAGORE RD ",
                "787536"
            ],
            [
                "HEALTHWORKZ PTE LTD",
                "NO 222  TAGORE LANE #04-07 TG BLDG ",
                "787603"
            ],
            [
                "SPRINGFIELD SUPPLIES & SERVICES PTE LTD",
                "NO 222  TAGORE LANE #03-10 TG BLDG ",
                "787603"
            ],
            [
                "ANG MO SUPERMARKET PTE LTD (TAGORE)",
                "NO 457  TAGORE IND. AVE SINDO IND.EST. ",
                "787826"
            ],
            [
                "SINHUA HOCK KEE TDG (S) PTE LTD",
                "NO 463  TAGORE IND. AVE OFF TAGORE LANE ",
                "787832"
            ],
            [
                "BULLION MINIMART",
                "172 LENTOR LOOP #01-01 BULLION PARK ",
                "789100"
            ],
            [
                "THE CONVI STORE-BULLION PARK",
                "NO 172  LENTOR LOOP #01-01/02,BULLION PARK ",
                "789100"
            ],
            [
                "JAYA AMBIKA TRADING PTE LTD",
                "BLK 432A  SENG KANG WEST WAY #01-01 ",
                "791432"
            ],
            [
                "NAVALINK (S) PTE LTD-SELETAR",
                "15 SELETAR WEST FARMWAY 6 FARMWAY DORMITORY  ",
                "798041"
            ],
            [
                "CHUAN HUAT GUAN DRY MARKET",
                "NO 6  JLN SELASEH (SELETAR HILLS EST. ) ",
                "808435"
            ],
            [
                "818 TRADERS",
                "4 CACTUS RD SELETAR GARDEN  ",
                "809579"
            ],
            [
                "THE CONVI STORE - GRANDE VISTA",
                "BLK 26  CACTUS DR #01-04,GRANDE VISTA ",
                "809695"
            ],
            [
                "BEGONIA PTE LTD",
                "NO 22  BEGONIA ROAD  ",
                "809810"
            ],
            [
                "ORANGE DEPARTMENT STORE - PG",
                "NO 168  PUNGGOL FIELD #01-08 PUNGGOL PLAZA ",
                "820168"
            ],
            [
                "U STARS SUPERMARKET PTE LTD - PG",
                "BLK 261 POUGGOL WAY #01-02 ",
                "820261"
            ],
            [
                "ANG MO SUPERMARKET PTE LTD (P196A)",
                "BLK 196A  PUNGGOL FIELD #01-519 ",
                "821196"
            ],
            [
                "SAIFON MINIMART PTE LTD",
                "BLK 6 BEACH RD #01-4887  ",
                "900006"
            ],
            [
                "CERTIS CISCO AVIATION SECURITY PTE LTD",
                "NO 60 AIRPORT BLVD CHANGI AIRPORT TERMINAL 2 BASEMENT #B16-114 TEL:6543 5435",
                "918155"
            ],
            [
                "AXCEL GROUP SERVICES",
                "0   ",
                "NA"
            ],
            [
                "BIZCOMPTECH PTE LTD",
                "BLK 7 JALAN BATU  #01-103  ",
                "NA"
            ],
            [
                "CHENNAI TRADING & SUPERMART PTE LTD",
                "BLK 221 BOON LAY PLACE #01-216 BOON LAY SHOPPING CENTRE",
                "NA"
            ],
            [
                "FAITH CONVENIENCE STORE",
                "BLK 111 WHAMPOA RD #01-33  ",
                "NA"
            ],
            [
                "HP MINIMART",
                "NO 1 SOON LEE STREET #01-35 PIONEER CENTRE ",
                "NA"
            ],
            [
                "JS TRANSPORTATION",
                "0   ",
                "NA"
            ],
            [
                "KWONG THONG CHEONG",
                "101 KITCHENER ROAD #02-20 JALAN BESAR PLAZA  ",
                "NA"
            ],
            [
                "KPM MINIMART PTE LTD",
                "200 HOUGANG AVE 3 #01-03  ",
                "NA"
            ],
            [
                "MUMMY`S FAIR PRICE PTE LTD",
                "41 KAKI BUKIT INDUSTRIAL TERRACE SINGAPORE",
                "NA"
            ],
            [
                "RINGOBUTSU PTE LTD",
                "BLK 414 YISHUN RING RD #01-1861  ",
                "NA"
            ],
            [
                "STAR SUPERMART PTE LTD",
                "BLK 284  CHOA CHU KANG AVE 3  #B1-330 ",
                "NA"
            ],
            [
                "DIFFERENCE ACCOUNT",
                "N/A 0  ",
                "NA"
            ],
            [
                "YI HONG MINIMART",
                "LOT 1 CANBERRA LINK SEMBAWANG EST.  ",
                "NA"
            ]
        ],
        "version": "1.0"
    },
    "version": "1.0"
}
