## Password Ages

This fetches key user information from the identity system and emits a record for each user.
The information loaded is: user name, user password age (in days), user enabled status.
This step will only work for administrators with mod-identity privilege.

### Structure
1 => N

### Input
No requirements

### Parameters
* None

### Output
The incoming record will be duplicated once for each identity known to the system, with extra fields added:

`user` - the name of the user

`passwordAgeInDays` - the number of days since the password was last changed

`enabled` - whether the identity is currently enabled

`totp2fa` - whether the identity has Time-based One Time Passsword (2FA) enabled

#### Notes
* This step only works for those with mod-identity privilege

* This step is intended to be used before Force Password Change. For example you may extract the information,
filter the records to discard those disabled accounts and those with a passwordAgeInDays <90 and then pass the 
remainder on to Force Password Change. If you schedule this chainset to run daily, it will ensure that 
users change their password at least every 90 days. 


#### See Also
* Force Password Change
