## Azure Put

This step puts bytes into an Azure blob container

### Structure
1 => 1

### Input

Each incoming record should contain bytes, a path (including filename) and a mimeType.

### Parameters

* `Container` - the name of the blob container information to use from System Settings Azure Integration.

* `Path Field` - the incoming string field holding the path to be appended to the bucket path.

* `MimeType Field` - the incoming string field holding the mimeType of the bytes.

### Output

The incoming record with an additional field 'azure-put-info' containing:

* `accountName` - The account holding the bucket

* `container` - The container name

* `path` - The consolidated path (bucket path plus incoming path)

* `length` - The number of bytes stored in Azure

If the request fails, then an `error` string is added instead

### Notes

* The container path and incoming path strings are directly concatenated. If you need a separator slash you should put it
  on the end of the container path or on the start of the incoming path string (but not both!).

### See Also

* Azure Delete

* Azure Get
 
* Azure List
