## Decrypt Bytes

This step decrypts binary data given an algorithm and a secret key.

### Structure
1 ⇒ 1

### Input
* A record with a binary field and a secret string key

### Parameters
* `Bytes Field` - Field which holds the bytes to decrypt. (string or bytes - see Notes)
* `Secret Field` - Field which holds the secret key to use in decryption (base64 string or bytes)
* `Algorithm` - The decryption algorithm to use
* `IV Field` - The field that holds the initialization vector for the cipher (utf8 string or bytes)
* `Result Field` - Field to store the decrypted binary data.

### Output
The input record with the additional result binary data where decryption was successful.

#### Notes

* The Secret Field is typically either a binary value or a Base64 encoded binary. 
  Different algorithms have different key requirements. If you want to use a memorable string, 
  then a common approach is to hash it and use the resulting bytes as the secret key, 
  you just need to ensure the hash algorithm produces the correct length of bytes.

* For convenience, this step also accepts string data in the bytes field, and converts it into bytes
based on the string being UTF-8 encoded.

* If the data field or secret key field is missing or has an invalid type, then the incoming record 
  is passed through unchanged

#### See Also

* Encrypt Bytes
