## Bits to Integer

This step converts a series of booleans (false=0, true=1) into a binary value (integer)

### Structure
1 => 1

### Input
* A record with two or more boolean fields to be combined

### Parameters

* `Input Fields` - A comma-separated list of field names

* `Output Field` - The field to store the output

### Output
The named input fields are converted, retaining the order into a series of 1s and 0s.
These are then combined to produce a single binary value, eg 101011 which is 43 as an integer.
The result field is updated with the integer value.

#### Notes

* The first field in the list is the "high" bit in the binary representation.

* Booleans are converted into bits where false => 0 and true => 1

* Different field types are converted to booleans as follows:
 
+ Numbers are converted so that 0 => 0 and anything else => 1 

+ Strings are converted so that "" => 0 and anything else => 1

* If a particular field is missing or an unhandled type (eg. timestamp), it will be treated as 0

#### See Also
* Boolean Or
* Boolean Either
* Boolean Not
* Boolean Xor
