## Formula

This step allows you to run a formula on the current record, adding the result to the record.

Formulas can act on Int32, Int64, Double, Decimal, String, DateTime (as Int64) and Boolean types.
Formulas cannot act on arrays or objects (however values inside nested objects can be used).

The result types are limited to: String, Long, Double, Boolean. 

This does not include Int32 results as operations on Int32 may produce Int64 results, 
so Int64 is always used to avoid truncation.

This does not include Decimal results as operations on Decimals and other types use Double precision.

Here's a simple example of multiplying a salary by 5%:

```
[salary] * 5 / 100.0
```

because the 100 is expressed as a double, the result will be a double (even if the salary is an integer).

### Structure
1 => 1

### Input
* No input is required

### Parameters
* `Formula` - The formula to be applied
* `Result` - The name of the field to hold the result

### Output
The input record with the result field set, or else `error` set if the formula cannot be executed.

### Notes

* See the separate documentation on Formula syntax for more details

#### See Also

* Formula Field
