## Check Rules In Chain

This step allows comparison rules to be applied to a field. 
The rules are loaded (once) from a separate chain and applied to each record in turn. 
Each rule should have this structure:

* Op - the operation, which may be:

    - < (less than)
    - \> (greater than)
    - <= (less than or equal)
    - \>= (greater than or equal)
    - = (equal)
    - == (alias for equal)
    - != (mot equal)
    - in (tests whether in an array of values)
    - exists (true if the field is present, regardless of content)
    - missing (true if the field is absent - the opposite of exists)
    - default (always true, used as a final 'else' rule)  

* Value - the value to be used in comparison, this can be of any type, eg. string, 
integer, null. There are special rules for some operations:

    - in: the Value must be an array
    - exists: the value is not used and may be omitted
    - missing: the value is not used and may be omitted
    - default: the value is not used and may be omitted

* Result - the result to set into the record if the rule matches. This can be of any type. 

Here is a sample Rule:

``
{ "Op": ">=", "Value": 18, "Result": "Adult" }
``

### Structure
1 => 1

### Input
There are no special input record requirements.

### Parameters
* `Test Field` - the field to test against the rules

* `Rule Chain` - the chain which supplies the rules to apply (in order)

* `Result Field` - the field to hold the Result of the first matching test

### Output
The input record with the Result field, when a rule is matched.

#### Notes
* Comparison order works across data types. This step follows the ordering defined by
MongoDB for consistency with aggregation pipelines.

* The exists operation will be true for a field with value null. The field does exist.
If you want to test for null then use = null or != null. The exists operation will be
false only if the field is not present.  The missing operation is the negation of the exists logic. 

#### See Also
* Check Rules In Field
