## Write State

This step writes a value into the state, so it can later be read by `Read State`.

If the named field is empty, the entire record is written into the state.

The mechanism allows you to write either individual values (eg. integers, strings, even arrays) or entire objects. 
The state persists only for this particular job. If the chain is run by two different users then each will have an 
independent state. However, avoid overusing this feature as it is effectively a "global" variable for your job.

The main use of this step is to record parameters on input into a chain, so that they don't have to be passed through
every step, particularly steps which are 1=>N. With this state mechanism you can:

```
Take input parameters
Write State (parameters)
1 => N
Process N records without worrying about the parameters
N => 1
Read State (retrieve parameters) 
```

### Structure
1 => 1

### Input
No requirements

### Parameters
* `Field` - the field from which the value will be read. This may be empty to write the entire record. 
* `Key` - the key of the value in the state.

### Output
The input record is passed through unchanged.

#### Notes
* If the field value does not exist any existing state value is removed.

* Avoid using this step within a flow of multiple records. It is hard to reason about the logic once the value
changes dynamically from record to record. Other steps may be running other parts of the chain in parallel. Therefore
if those other steps read the state, the result may not be repeatable.

#### See Also
* Read State
