## CSV Definition

This step constructs the parameters needed by the CSV File Reader. 

### Structure

1 => 1

### Inputs

No special input is required, but any fields in incoming records are preserved (upstream overrides this). 

### Parameters

* `URL` - the location of the file defined as CSV

* `Separator` - the separator used by the file. Defaults to ,

* `Qualifier` - defaults to "

* `Header` - Boolean field that states whether the first row is the header.

* `Base JSON` - This object will be used as the base for any documents constructed by the CSV Reader

### Output

* `url` - the location of the file holding the CSV data

* `separator` - the separator defined by this step

* `qualifier` - the qualifier used when field values may contain the separator character 

* `header` - whether the file has been defined to contain a header

* `base` - the base json defined by this step

#### Notes

* This is a utility step to make it easier to construct the necessary input for CSV Reader. You don't need
to use this - you can construct the same definition yourself, eg. by using a Json Record or even by reading
from MongoDB. 

* The separation between definition and use also enables you to add substitution steps in between.

* As whitespace is stripped from input fields, it is hard to specify tab separators. You can use
the special character `␉` (unicode character 0x2409) "horizontal tabulation" to represent it.

#### See Also

* CSV Reader
