## CSV Writer

This step takes incoming records and builds them into a CSV structure held in a byte array, 
suitable for writing to disk.

### Structure

N => 1

### Inputs

Incoming records to be written into CSV format

### Parameters

* `Write Header` - whether a header should be added to the CSV output
* `Columns` - the field names (in order) that should be added to the CSV
* `Separator` - the separator characters to use between fields - if none is supplied, comma will be used
* `Qualifier` - the quote marks to put around field values that use the separator, only a single character can be used, 
if none is supplied then double quotes is used
* `Newline` - whether to use Unix style (\n) line separators, or Windows style (\r\n)
* `Add BOM` - whether to add the Byte Order Marker at the start of the file (needed for Excel to read UTF-8 properly) 

### Output

A single record is output, containing the bytes of the CSV along with the rowCount (not including any header) and the mimeType (text/csv).

#### Notes

* The Write Header can be turned off so that CSV bytes can be appended without repeating headers

* The BOM will only be added if Write Header is also true

#### See Also

* CSV Reader
