## Date - Extract Component

This step extracts a component from a date field

### Structure
1 => 1

### Input
Any record with a BsonDateTime field

### Parameters
* `From Column` - The column containing the date field
* `Extract` - The Component to Extract
* `To` - The column to extract to

#### The following components are supported:
* `Year` - Extracts the year as an integer
* `Year String` - Extracts the year as a string
* `Month` - Extracts the month in numeric form
* `Month (Padded 0)` - Extracts the month as a string of two digits, eg. June = "06"
* `Month Short Name` - Extracts the 3-letter version of the month's name
* `Month Name` - Extracts the Full Month Name
* `Day` - Extracts the day of the month as an integer
* `Day (Padded 0)` - Extracts the day of the month as a string of two digits, eg 7 => "07"
* `Day of Week (Sunday=0)` - Extracts the day of the week, Sunday = 0, Monday = 1 etc.
* `Quarter` - Extracts the Quarter Number as an integer
* `Quarter Tag` - Extracts the Quarter number prefixed with "Q"

### Output
For date `2019-02-28`, the extractions are shown below:


| Component        | Extracted Value | Column Type |
|------------------|-----------------|-------------|
| Year             | 2019            | Int         |
| Year String      | 2019            | String      |
| Month            | 2               | Int         |
| Month (Padded 0) | 02              | String      |
| Month Short Name | Feb             | String      |
| Month Name       | February        | String      |
| Day              | 28              | Int         |
| Day (Padded 0)   | 28              | String      |
| Day of Week      | 4               | Int         |
| Quarter          | 1               | Int         |
| Quarter Tag      | Q1              | String      |

#### Notes
* Invalid values will not generate anything
* If `From Column` is identical to `To` the value will be replaced

#### See Also
* Timestamp - Extract Component
* Time - Extract Component
