## File Writer

This step takes a bytes field from each incoming record and appends them all to create a file on disk

### Structure

N => 1

### Inputs

Every record must contain `bytes`

### Parameters

* `File Name` - The path where the file is to be written to

### Output

* `count` - The number of files created

* `length` - The total length of the file

* `elapsedTime` - The time taken to build and write the file

* `_error` - This string field will be added if the operation fails, with details of the issue

#### Notes

* The default access rights only allow for writing files to `./data/out`, this can be changed in the config.

* Multiple records are appended into a single output file. However, the file is emptied before the first record
is added, so this step does not append to any pre-existing content.

#### See Also

* Zip Writer

* File Field Writer
