## Add Alert

This step allows you to send an Alert back to the browser, 
for example to let the user know an action has been performed.

### Structure
1 ⇒ 1

### Input
* No input is required

### Parameters
* `Alert Id` - The alert value to set (the default id in Form is "alert1", "alert2" etc.)
* `Alert Type` - Choose from info, quick-info, warn or error. The default Ambience info message is visible
  for five seconds, quick-info is only visible for two seconds, useful when you don't want to distract the user.
  (We often use it for auto-save).
* `Alert Message` - The message to show - this can include substitutions from elsewhere in the record, eg:
"You typed $\{elxPublic.text-input1\}."
to insert the value from something already added to elxPublic. 

### Output
The input record with an alert object set into elxPublic in the format that the Form runtime will display it.

### Notes
The alert includes an "until" field which is auto-generated based on the current timestamp. 
This is used by the form to prevent repeated showing of the same alert. 
The "until" value is a 64bit long (epoch milliseconds) set to 10 seconds in the future at the point the step is run. 
In the browser only alerts where the "until" time has not been reached are shown. 
You should not set the alert early in the ETL process, in case the ETL takes a long time to run, 
instead add this step close to the end. 
(You can of course edit/alter the until time yourself in later steps.)

#### See Also
