## Extract Form Labels

This step extracts the current form ids and labels from a report, to support construction of reports which
want to use the "friendly" labels rather than the internal ids for fields. 

### Structure
1 => 1

### Input
The incoming record should contain a string field holding either the form name or id.

### Parameters
* `Form Field` - The string field to read and use as either the _id or name of the form.

### Output

The input is passed through with an array field `formLabels` added, containing the ids and labels of the matched form.
If the form cannot be found, or no form field is provided, an empty array will be returned.

### Notes

* If the form field value looks like a UUID (exactly 36 characters, with dashes after 8, then 4, then 4, then 4, then 12 chars) 
  like this: `f681cbf4-d325-42e6-bf6d-b6163f1fc86c` the match will be done against _id, else it will be done against name.

* If the output array is empty, check the job log for an error - eg. Missing form field, form not found etc.
