## JDBC Inserter

This step allows the inserting of new records into a JDBC database.

The step will extract all fields which match column names in the table being appended to and 
attempt to insert the record.  

Successful inserts (where all constraints are satisfied) and failures can be passed into 
different chains for later processing. The output of those chains will become the output of this step.
In the absence of any success/failure chains, the step will output a single summary record, containing the 
success/failure count and elapsed time.

### Structure
1 => 0..N or N => 1 if no success/failure chains are identified

### Input
* Each input record contains the fields needed to insert one row in the table. (Other fields, which don't match the 
table schema will be ignored.)

### Parameters
* `Database` - The connection pool name that identifies which database to work with
* `Table` - The table to which records will be inserted
* `Success Chain` - The (optional) chain to call (passing the current record) when an insert has been successful
* `Failure Chain` - The (optional) chain to call (passing the current record) when an insert failed
* `Log Every` - The number of records at which the system should log progress

### Output

Either a summary containing

* `successCount` - The number of records successfully processed

* `failureCount` - The number of records that failed

* `elapsedTime` - The time (in milliseconds) spent running this step

or else the output from the success chain / failure chain if either or both of those were provided.

### Notes

A failure is an SQL Exception, for example where an inserted value fails a constraint 
- for example a string is too long or a value is the wrong type. 

### See Also

* JDBC Updater
