## JWTEncoder

This step encodes a set of claims into a JWT token in the form <header>.<claims>\[.<signature>\] using an
algorithm of your choice.

The correct secret/private key (if required) needs to be provided in the record, either in string or binary form.

### Structure
1 ⇒ 1

### Input
A record with a nested claims object and optionally a secret/private key field

### Parameters
* `Algorithm` - The algorithm to use in signing the token.
 
* `Secret Field` - The field holding the string or bytes from which the secret or private key can be extracted - depending on the algorithm chosen.

* `Payload Field` - The field holding the claims payload (nested object) for encoding
  
* `Output Field` = The field into which the encoded JWT token string will be written.

### Output
The incoming record is passed through with the addition of the `Output Field` holding the JWT.

### Example
```
// generate a new key for RS256 signing
openssl genrsa -out key.pem 2048

// extract the public key
openssl rsa -in key.pem -outform PEM -pubout -out public.pem

// convert the private key to pkcs8
openssl pkcs8 -topk8 -nocrypt -in key.pem -out private.pkcs8

// now load private.pkcs8 to encode and public.pem to decode
```

#### Notes
* With HMAC algorithms, like HS256, a string can be used as a secret key to encode/decode the JWT. 
  Alternatively you can pass in bytes which are expected to be an AES SecretKeySpec.
 
* With Asymmetric algorithms, like RS256, the code will accept a string or bytes representing a private key
  in RSA PKCS8EncodedKeySpec form. This is often the contents of a file starting: "-----BEGIN PRIVATE KEY-----"

* If the RSA Private key starts: "-----BEGIN RSA PRIVATE KEY-----" then it is a PKCS1 file and needs 
  to be converted to PKCS8 first - see the example above. 

#### See Also

* JWT Decoder
