## MongoDB Date Accumulator

This step provides quick aggregations of pre-computed date ranges. 
Prior to using this step, it is assumed that a collection has been prepared with pre-computed 
values keyed by YMD, YM and Y. For example:

```
2020-05-01   27
2020-05-02   33
2020-05      60
2020-06      70
2020        130
```

The format of YMD, YM, and Y values must be exactly as shown above. The order doesn't matter.

Given any from..to range of dates, this step will compute the minimum values to be summed to produce
the result. The collection will then be queried for these values and the result provided. 

For example:
```
from = "2020-01-28"
to = "2020-04-03"
values summed are: "2020-01-28", "2020-01-29", 
  "2020-01-30", "2020-01-31", "2020-02", 
  "2020-03", "2020-04-01", "2020-04-02", 
  "2020-04-03"
```
Partial months are summed by days, complete months by a single value, eg "2020-02".

Another example:
```
from = "2020-01-28"
to = "2022-03-03"
values summed are: "2020-01-28", "2020-01-29", 
  "2020-01-30", "2020-01-31", "2020-02", "2020-03", 
  "2020-04", "2020-05", "2020-06", "2020-07", 
  "2020-08", "2020-09", "2020-10", "2020-11", 
  "2020-12", "2021", "2022-01", "2022-02", 
  "2022-03-01", "2022-03-02", "2022-03-03"
```
In this case as the range spans complete years, the pre-computed result for "2021" 
can be used to avoid 12 month sums or 365 day sums.


### Structure
1 => 1

### Input
A `From` string field and a `To` string field, both in yyyy-MM-dd format

### Parameters

* `Database` - the MongoDB database holding the collection

* `Collection` - the collection to add the index to

* `From Field` - the name of the incoming string field holding the from date in yyyy-MM-dd

* `To Field` - the name of the incoming string field holding the to date in yyyy-MM-dd

* `Cltn. Key` - the key of the precomputed collection, which holds YMD, YM and Y summaries.

* `Cltn. Value` - the value of the precomputed collection which will be summed across the from..to range.

* `Result Field` - the numeric field holding the result of the summation across the given from..to range.


### Output

All records are passed through with the addition of a result field

#### Notes

* If the input range is invalid for any reason, either due to `from` > `to` or an 
  invalid date string, eg 2020-03-41 then the result will be 0.
  
* The system does not check whether the data is internally consistent, eg. adding all days in March
equals the March total.

#### See Also
