## MongoDB Aggregation Definition

This step is a helper to construct the correct record structure for configuring a MongoDB aggregation.
It does not perform the aggregation, it just defines one (providing a chooser for selection etc.). 
You can still add other steps after which manipulate the definition, eg. to make the collection name dynamic.

### Structure
1 => 1

### Input
Any record structure allowed

### Parameters

* `Database` - the MongoDB database holding the collection to read from

* `Collection` - the collection to read

* `Aggregation Pipeline` - the aggregation pipeline array as a string (default "\[\]")


### Output
A single output record for each input record containing:

* `pool` - the name of the MongoDB database

* `collection` - the name of the collection

* `aggregation` - the string holding the aggregation pipeline

#### Notes
* This step just constructs the three fields based on choices made in the dialog

* This step is usually followed by the MongoDB Reader which does the work, however other steps may be
  added in between to customise the structure.

* The aggregation is a string rather than an actual array because MongoDB cannot store aggregation
  pipelines because they have field names beginning with $ which is disallowed.

#### See Also

* MongoDB Definition
