## MongoDB Create Index (Once)

This step creates an index in a MongoDB collection. An index only needs to be created once, but may be
used within a chain which iterates through multiple records. Therefore, the create index is constrained
to only happen when the first incoming record is received, before that record is passed on. 

If no records are received, the index is created when the upstream record flow terminates.

### Structure
1 => 1

### Input
No input requirements

### Parameters

* `Database` - the MongoDB database holding the collection

* `Collection` - the collection to add the index to

* `Index JSON` - the structure of the index to add (see MongoDB documentation)

* `Options` - the index options (see Notes below and MongoDB documentation)


### Output

All records are passed through unchanged 

#### Notes

The Options record can contain:
* background (boolean)
* unique (boolean)
* name(string)
* sparse(boolean)
* expireAfterSeconds (long)
* version (int)
* weights (nested object)
* defaultLanguage (string)
* languageOverride (string)
* textVersion (int)
* bits (int)
* min (double)
* max (double)
* bucketSize (double)
* storageEngine (nested object)
* partialFilterExpression (nested object)
* collation (nested object)

#### See Also

* MongoDB Drop Index (Once)
