## MongoDB Decrypt

This step decrypts selected fields in all MongoDB records in a collection. 
Only string fields encrypted by the MongoDB Encrypt step can be decrypted.

### Structure
1 => 1

### Input

The incoming record supplies a collection name, an array of fields and a secret string to use as the decryption key.

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection Field` - the field holding the name of the collection to act on

* `Fields Array` - the field holding an array of strings, which are the field names to decrypt

* `Secret Field` - the field holding the secret string to use as the decryption key

### Output

A single record is output holding the count of records processed and the elapsed time in milliseconds.

#### Notes
* Only string fields can be decrypted
 
* Any missing fields are silently ignored
 
* The field _elxEncrypted added during encryption is removed during decryption
 
* The value in the secret field can be an {enc:...} encrypted secret from the Secrets API

#### See Also

* MongoDB Encrypt
