## MongoDB Deep Clone

This step performs a deep clone on a record. That means it scans the record for foreign keys, 
locates the records with the corresponding primary keys in a set of collections, deep clones them
(which gives them new primary keys) and adds a clone of the original record with the new keys
replacing the old. This is a recursive deep clone, so if the referenced records also reference others,
then (providing they are in the same set of collections), those others will be deep cloned too.

### Structure
1 => 1

### Input
A record holding a field with the id of the record to deep clone.

### Parameters

* `Database` - the MongoDB database holding all the collections to act on

* `Collection` - the collection holding the record to deep clone

* `Key Field` - the field in the incoming collection holding the _id of the record in `Collection` to deep clone

* `Scope` - the list of collections the deep clone can traverse while building the cloned structure


### Output

The incoming record is passed through with two new fields added:

* `deep-clone-status`: A true/false value

* `deep-clone`: The _id of the new deep cloned record, only if status = true

* `deep-clone-error`: A string describing the error, only if status = false

#### Notes

* A field is considered a foreign key if it is either a) an ObjectId or b) a UUID (String) in the format like
  "141abf90-c796-44c3-b801-bc2a690d2dc2" - ie. with the same length and the '-' chars in the correct positions.
 
* The logic is recursive, but it does not check cyclic links. You should not use this step if there is a cycle of
  references - for example A -> B -> C -> A. The step will log an error if the depth of recursion exceeds
  exceeds `ambience.etl.mongodb.deep-clone-limit` (10 by default)

#### See Also


