## MongoDB Drop UUID Collection

This step drops a MongoDB collection identified by an incoming collection name. The collection will only be dropped if 
the name is a valid UUID, ie. it is 36 characters long and contains dashes at the expected locations, for example:

```
4cba47b8-4531-4c55-bdbf-6078bf5abc8d
```

Dropping collections is obviously dangerous. This step is intended for short-lived temporary collections, where it is 
recommended that you use a UUID for the name, to avoid clashes should the same ETL chain be run concurrently. 
The pattern is to generate a UUID, use it to populate a temporary collection, perform operations (eg. aggregations, updates etc.)
on it and then delete it when the processed results have been extracted.

### Structure
1 => 1

### Input

Each input record should contain a string field holding the name of the collection to drop. This must be a UUID string

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection Field` - the string field used to identify the collection to drop

### Output

Incoming records are passed through unchanged

#### Notes
* This step drops the collection only if the name is a UUID. If the collection field holds a string that isn't a UUID, a
  warning is written to the log and the collection is not altered.

#### See Also

* MongoDB Delete All (Once)

* MongoDB Delete Where
